/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import groovy.lang.Closure;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.FeatureSpec;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JavaResolutionConsistency;
import org.gradle.api.plugins.internal.DefaultJavaFeatureSpec;
import org.gradle.api.plugins.internal.JavaConfigurationVariantMapping;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.jvm.DefaultModularitySpec;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;

public class DefaultJavaPluginExtension
implements JavaPluginExtension {
    private static final Pattern VALID_FEATURE_NAME = Pattern.compile("[a-zA-Z0-9]+");
    private final SourceSetContainer sourceSets;
    private final JavaToolchainSpecInternal toolchainSpec;
    private final ObjectFactory objectFactory;
    private final ModularitySpec modularity;
    private final JavaToolchainSpec toolchain;
    private final ProjectInternal project;
    private final DirectoryProperty docsDir;
    private final DirectoryProperty testResultsDir;
    private final DirectoryProperty testReportDir;
    private JavaVersion srcCompat;
    private JavaVersion targetCompat;
    private boolean autoTargetJvm = true;

    @Inject
    public DefaultJavaPluginExtension(ProjectInternal project, SourceSetContainer sourceSets, DefaultToolchainSpec toolchainSpec) {
        this.docsDir = project.getObjects().directoryProperty();
        this.testResultsDir = project.getObjects().directoryProperty();
        this.testReportDir = project.getObjects().directoryProperty();
        this.project = project;
        this.sourceSets = sourceSets;
        this.toolchainSpec = toolchainSpec;
        this.objectFactory = project.getObjects();
        this.modularity = (ModularitySpec)this.objectFactory.newInstance(DefaultModularitySpec.class, new Object[0]);
        this.toolchain = toolchainSpec;
        this.configureDefaults();
    }

    private void configureDefaults() {
        this.docsDir.convention(this.project.getLayout().getBuildDirectory().dir("docs"));
        this.testResultsDir.convention(this.project.getLayout().getBuildDirectory().dir("test-results"));
        this.testReportDir.convention(((ReportingExtension)this.project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory().dir("tests"));
    }

    @Override
    public Object sourceSets(Closure closure) {
        return this.sourceSets.configure(closure);
    }

    @Override
    public DirectoryProperty getDocsDir() {
        return this.docsDir;
    }

    @Override
    public DirectoryProperty getTestResultsDir() {
        return this.testResultsDir;
    }

    @Override
    public DirectoryProperty getTestReportDir() {
        return this.testReportDir;
    }

    @Override
    public JavaVersion getSourceCompatibility() {
        if (this.srcCompat != null) {
            return this.srcCompat;
        }
        if (this.toolchainSpec != null && this.toolchainSpec.isConfigured()) {
            return JavaVersion.toVersion((Object)((JavaLanguageVersion)this.toolchainSpec.getLanguageVersion().get()).toString());
        }
        return JavaVersion.current();
    }

    public JavaVersion getRawSourceCompatibility() {
        return this.srcCompat;
    }

    @Override
    public void setSourceCompatibility(Object value) {
        this.setSourceCompatibility(JavaVersion.toVersion((Object)value));
    }

    @Override
    public void setSourceCompatibility(JavaVersion value) {
        this.srcCompat = value;
    }

    @Override
    public JavaVersion getTargetCompatibility() {
        return this.targetCompat != null ? this.targetCompat : this.getSourceCompatibility();
    }

    public JavaVersion getRawTargetCompatibility() {
        return this.targetCompat;
    }

    @Override
    public void setTargetCompatibility(Object value) {
        this.setTargetCompatibility(JavaVersion.toVersion((Object)value));
    }

    @Override
    public void setTargetCompatibility(JavaVersion value) {
        this.targetCompat = value;
    }

    @Override
    public Manifest manifest() {
        return this.manifest((Action<? super Manifest>)Actions.doNothing());
    }

    @Override
    public Manifest manifest(Closure closure) {
        return (Manifest)ConfigureUtil.configure((Closure)closure, (Object)this.createManifest());
    }

    @Override
    public Manifest manifest(Action<? super Manifest> action) {
        Manifest manifest = this.createManifest();
        action.execute((Object)manifest);
        return manifest;
    }

    private Manifest createManifest() {
        return new DefaultManifest((PathToFileResolver)this.project.getFileResolver());
    }

    @Override
    public SourceSetContainer getSourceSets() {
        return this.sourceSets;
    }

    @Override
    public void disableAutoTargetJvm() {
        this.autoTargetJvm = false;
    }

    @Override
    public boolean getAutoTargetJvmDisabled() {
        return !this.autoTargetJvm;
    }

    @Override
    public void registerFeature(String name, Action<? super FeatureSpec> configureAction) {
        DefaultJavaFeatureSpec spec = new DefaultJavaFeatureSpec(DefaultJavaPluginExtension.validateFeatureName(name), this.project);
        configureAction.execute((Object)spec);
        JvmFeatureInternal feature = spec.create();
        JvmSoftwareComponentInternal component = this.getSingleJavaComponent();
        if (component != null) {
            Configuration sourcesElements;
            component.getFeatures().add((Object)feature);
            AdhocComponentWithVariants adhocComponent = (AdhocComponentWithVariants)component;
            Configuration javadocElements = feature.getJavadocElementsConfiguration();
            if (javadocElements != null) {
                adhocComponent.addVariantsFromConfiguration(javadocElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
            }
            if ((sourcesElements = feature.getSourcesElementsConfiguration()) != null) {
                adhocComponent.addVariantsFromConfiguration(sourcesElements, (Action)new JavaConfigurationVariantMapping("runtime", true));
            }
            if (spec.isPublished()) {
                adhocComponent.addVariantsFromConfiguration(feature.getApiElementsConfiguration(), (Action)new JavaConfigurationVariantMapping("compile", true, feature.getCompileClasspathConfiguration()));
                adhocComponent.addVariantsFromConfiguration(feature.getRuntimeElementsConfiguration(), (Action)new JavaConfigurationVariantMapping("runtime", true, feature.getRuntimeClasspathConfiguration()));
            }
        }
    }

    @Nullable
    private JvmSoftwareComponentInternal getSingleJavaComponent() {
        NamedDomainObjectSet jvmComponents = this.project.getComponents().withType(JvmSoftwareComponentInternal.class);
        if (jvmComponents.size() > 1) {
            String componentNames = CollectionUtils.join((String)", ", (Iterable)jvmComponents.getNames());
            throw new InvalidUserCodeException("Cannot register feature because multiple JVM components are present. The following components were found: " + componentNames);
        }
        if (!jvmComponents.isEmpty()) {
            return (JvmSoftwareComponentInternal)jvmComponents.iterator().next();
        }
        return null;
    }

    @Override
    public void withJavadocJar() {
        this.maybeEmitMissingJavaComponentDeprecation("withJavadocJar()");
        if (DefaultJavaPluginExtension.isJavaComponentPresent(this.project)) {
            this.project.getComponents().withType(JvmSoftwareComponentInternal.class).configureEach(JvmSoftwareComponentInternal::withJavadocJar);
        } else {
            SourceSet main = (SourceSet)this.getSourceSets().getByName("main");
            JvmPluginsHelper.createDocumentationVariantWithArtifact(main.getJavadocElementsConfigurationName(), null, "javadoc", Collections.emptySet(), main.getJavadocJarTaskName(), this.project.getTasks().named(main.getJavadocTaskName()), this.project);
        }
    }

    @Override
    public void withSourcesJar() {
        this.maybeEmitMissingJavaComponentDeprecation("withSourcesJar()");
        if (DefaultJavaPluginExtension.isJavaComponentPresent(this.project)) {
            this.project.getComponents().withType(JvmSoftwareComponentInternal.class).configureEach(JvmSoftwareComponentInternal::withSourcesJar);
        } else {
            SourceSet main = (SourceSet)this.getSourceSets().getByName("main");
            JvmPluginsHelper.createDocumentationVariantWithArtifact(main.getSourcesElementsConfigurationName(), null, "sources", Collections.emptySet(), main.getSourcesJarTaskName(), main.getAllSource(), this.project);
        }
    }

    @Override
    public ModularitySpec getModularity() {
        return this.modularity;
    }

    @Override
    public JavaToolchainSpec getToolchain() {
        return this.toolchain;
    }

    @Override
    public JavaToolchainSpec toolchain(Action<? super JavaToolchainSpec> action) {
        action.execute((Object)this.toolchain);
        return this.toolchain;
    }

    @Override
    public void consistentResolution(Action<? super JavaResolutionConsistency> action) {
        this.maybeEmitMissingJavaComponentDeprecation("consistentResolution(Action)");
        SoftwareComponentContainer components = this.project.getComponents();
        RoleBasedConfigurationContainerInternal configurations = this.project.getConfigurations();
        SourceSetContainer sourceSets = this.getSourceSets();
        action.execute(this.project.getObjects().newInstance(DefaultJavaResolutionConsistency.class, new Object[]{components, sourceSets, configurations}));
    }

    private static String validateFeatureName(String name) {
        if (!VALID_FEATURE_NAME.matcher(name).matches()) {
            throw new InvalidUserDataException("Invalid feature name '" + name + "'. Must match " + VALID_FEATURE_NAME.pattern());
        }
        return name;
    }

    private static boolean isJavaComponentPresent(ProjectInternal project) {
        return project.getComponents().stream().anyMatch(JvmSoftwareComponentInternal.class::isInstance);
    }

    private void maybeEmitMissingJavaComponentDeprecation(String name) {
        if (!DefaultJavaPluginExtension.isJavaComponentPresent(this.project)) {
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)(name + " was called without the presence of the java component.")).withAdvice("Apply a JVM component plugin such as: java-library, application, groovy, or scala")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "java_extension_without_java_component")).nagUser();
        }
    }

    public static class DefaultJavaResolutionConsistency
    implements JavaResolutionConsistency {
        private final SoftwareComponentContainer components;
        private final SourceSetContainer sourceSets;
        private final ConfigurationContainer configurations;
        private final ProjectInternal project;

        @Inject
        public DefaultJavaResolutionConsistency(SoftwareComponentContainer components, SourceSetContainer sourceSets, ConfigurationContainer configurations, ProjectInternal project) {
            this.components = components;
            this.sourceSets = sourceSets;
            this.configurations = configurations;
            this.project = project;
        }

        public void useCompileClasspathVersions() {
            this.sourceSets.configureEach(this::applyCompileClasspathConsistency);
            this.components.withType(JvmSoftwareComponentInternal.class).configureEach(JvmSoftwareComponentInternal::useCompileClasspathConsistency);
            if (!DefaultJavaPluginExtension.isJavaComponentPresent(this.project)) {
                SourceSet mainSourceSet = (SourceSet)this.sourceSets.getByName("main");
                SourceSet testSourceSet = (SourceSet)this.sourceSets.getByName("test");
                Configuration mainCompileClasspath = this.findConfiguration(mainSourceSet.getCompileClasspathConfigurationName());
                Configuration testCompileClasspath = this.findConfiguration(testSourceSet.getCompileClasspathConfigurationName());
                testCompileClasspath.shouldResolveConsistentlyWith(mainCompileClasspath);
            }
        }

        public void useRuntimeClasspathVersions() {
            this.sourceSets.configureEach(this::applyRuntimeClasspathConsistency);
            this.components.withType(JvmSoftwareComponentInternal.class).configureEach(JvmSoftwareComponentInternal::useRuntimeClasspathConsistency);
            if (!DefaultJavaPluginExtension.isJavaComponentPresent(this.project)) {
                SourceSet mainSourceSet = (SourceSet)this.sourceSets.getByName("main");
                SourceSet testSourceSet = (SourceSet)this.sourceSets.getByName("test");
                Configuration mainRuntimeClasspath = this.findConfiguration(mainSourceSet.getRuntimeClasspathConfigurationName());
                Configuration testRuntimeClasspath = this.findConfiguration(testSourceSet.getRuntimeClasspathConfigurationName());
                testRuntimeClasspath.shouldResolveConsistentlyWith(mainRuntimeClasspath);
            }
        }

        private void applyCompileClasspathConsistency(SourceSet sourceSet) {
            Configuration compileClasspath = this.findConfiguration(sourceSet.getCompileClasspathConfigurationName());
            Configuration runtimeClasspath = this.findConfiguration(sourceSet.getRuntimeClasspathConfigurationName());
            runtimeClasspath.shouldResolveConsistentlyWith(compileClasspath);
        }

        private void applyRuntimeClasspathConsistency(SourceSet sourceSet) {
            Configuration compileClasspath = this.findConfiguration(sourceSet.getCompileClasspathConfigurationName());
            Configuration runtimeClasspath = this.findConfiguration(sourceSet.getRuntimeClasspathConfigurationName());
            compileClasspath.shouldResolveConsistentlyWith(runtimeClasspath);
        }

        private Configuration findConfiguration(String configName) {
            return this.configurations.getByName(configName);
        }
    }
}

