/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.logging.LoggingManager;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.remote.MessagingServer;
import org.gradle.process.internal.JavaExecHandleFactory;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.worker.DefaultMultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.DefaultSingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.DefaultWorkerProcessBuilder;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.RequestHandler;
import org.gradle.process.internal.worker.SingleRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.process.internal.worker.child.ApplicationClassesInSystemClassLoaderWorkerImplementationFactory;

public class DefaultWorkerProcessFactory
implements WorkerProcessFactory {
    private final LoggingManager loggingManager;
    private final MessagingServer server;
    private final IdGenerator<Long> idGenerator;
    private final JavaExecHandleFactory execHandleFactory;
    private final JvmVersionDetector jvmVersionDetector;
    private final OutputEventListener outputEventListener;
    private final ApplicationClassesInSystemClassLoaderWorkerImplementationFactory workerImplementationFactory;
    private final MemoryManager memoryManager;
    private int connectTimeoutSeconds = 120;

    public DefaultWorkerProcessFactory(LoggingManager loggingManager, MessagingServer server, ClassPathRegistry classPathRegistry, IdGenerator<Long> idGenerator, File gradleUserHomeDir, TemporaryFileProvider temporaryFileProvider, JavaExecHandleFactory execHandleFactory, JvmVersionDetector jvmVersionDetector, OutputEventListener outputEventListener, MemoryManager memoryManager) {
        this.loggingManager = loggingManager;
        this.server = server;
        this.idGenerator = idGenerator;
        this.execHandleFactory = execHandleFactory;
        this.jvmVersionDetector = jvmVersionDetector;
        this.outputEventListener = outputEventListener;
        this.workerImplementationFactory = new ApplicationClassesInSystemClassLoaderWorkerImplementationFactory(classPathRegistry, temporaryFileProvider, gradleUserHomeDir);
        this.memoryManager = memoryManager;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Override
    public WorkerProcessBuilder create(Action<? super WorkerProcessContext> workerAction) {
        DefaultWorkerProcessBuilder builder = this.newWorkerProcessBuilder();
        builder.worker(workerAction);
        builder.setImplementationClasspath(ClasspathUtil.getClasspath((ClassLoader)workerAction.getClass().getClassLoader()).getAsURLs());
        return builder;
    }

    @Override
    public <IN, OUT> SingleRequestWorkerProcessBuilder<IN, OUT> singleRequestWorker(Class<? extends RequestHandler<? super IN, ? extends OUT>> workerImplementation) {
        return new DefaultSingleRequestWorkerProcessBuilder(workerImplementation, this.newWorkerProcessBuilder(), this.outputEventListener);
    }

    @Override
    public <IN, OUT> MultiRequestWorkerProcessBuilder<IN, OUT> multiRequestWorker(Class<? extends RequestHandler<? super IN, ? extends OUT>> workerImplementation) {
        return new DefaultMultiRequestWorkerProcessBuilder(workerImplementation, this.newWorkerProcessBuilder(), this.outputEventListener);
    }

    private DefaultWorkerProcessBuilder newWorkerProcessBuilder() {
        DefaultWorkerProcessBuilder builder = new DefaultWorkerProcessBuilder(this.execHandleFactory, this.server, this.idGenerator, this.workerImplementationFactory, this.outputEventListener, this.memoryManager, this.jvmVersionDetector);
        builder.setLogLevel(this.loggingManager.getLevel());
        builder.setConnectTimeoutSeconds(this.connectTimeoutSeconds);
        return builder;
    }
}

