/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.FileDependencyArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VariantResolvingArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.DefaultVariantArtifactResolver;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class ResolvedArtifactsGraphVisitor
implements DependencyGraphVisitor {
    private int nextId;
    private final Long2ObjectMap<ArtifactsForNode> artifactsByNodeId = new Long2ObjectOpenHashMap();
    private final DependencyArtifactsVisitor artifactResults;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final VariantArtifactResolver variantResolver;
    private final GraphVariantSelector graphVariantSelector;
    private final AttributesSchemaInternal consumerSchema;

    public ResolvedArtifactsGraphVisitor(DependencyArtifactsVisitor artifactsBuilder, ArtifactTypeRegistry artifactTypeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, ArtifactResolver artifactResolver, ResolvedVariantCache resolvedVariantCache, GraphVariantSelector graphVariantSelector, AttributesSchemaInternal consumerSchema) {
        this.artifactResults = artifactsBuilder;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.variantResolver = new DefaultVariantArtifactResolver(artifactResolver, artifactTypeRegistry, resolvedVariantCache);
        this.graphVariantSelector = graphVariantSelector;
        this.consumerSchema = consumerSchema;
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        this.artifactResults.visitNode(node);
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        boolean hasTransitiveIncomingEdge = false;
        for (DependencyGraphEdge dependencyGraphEdge : node.getIncomingEdges()) {
            hasTransitiveIncomingEdge |= dependencyGraphEdge.isTransitive();
            if (!dependencyGraphEdge.contributesArtifacts()) continue;
            DependencyGraphNode parent = dependencyGraphEdge.getFrom();
            ArtifactsForNode artifacts = this.resolveVariantArtifacts(dependencyGraphEdge, node);
            this.artifactResults.visitArtifacts(parent, node, artifacts.artifactSetId, artifacts.artifactSet);
        }
        if (node.isRoot() || hasTransitiveIncomingEdge) {
            for (LocalFileDependencyMetadata localFileDependencyMetadata : node.getOutgoingFileEdges()) {
                int id;
                ++this.nextId;
                this.artifactResults.visitArtifacts(node, localFileDependencyMetadata, id, (ArtifactSet)new FileDependencyArtifactSet(localFileDependencyMetadata, this.artifactTypeRegistry, this.calculatedValueContainerFactory));
            }
        }
    }

    @Override
    public void finish(RootGraphNode root) {
        this.artifactResults.finishArtifacts(root);
        this.artifactsByNodeId.clear();
    }

    private ArtifactsForNode resolveVariantArtifacts(DependencyGraphEdge dependency, DependencyGraphNode toNode) {
        ComponentGraphResolveState component = toNode.getOwner().getResolveState();
        VariantGraphResolveState variant = toNode.getResolveState();
        if (!dependency.getDependencyMetadata().getArtifacts().isEmpty() || !dependency.getAttributes().isEmpty() || dependency.getExclusions().mayExcludeArtifacts()) {
            int id = this.nextId++;
            return new ArtifactsForNode(id, new VariantResolvingArtifactSet(this.variantResolver, component, variant, dependency, this.graphVariantSelector, this.consumerSchema));
        }
        return (ArtifactsForNode)this.artifactsByNodeId.computeIfAbsent(toNode.getNodeId().longValue(), value -> {
            int id = this.nextId++;
            return new ArtifactsForNode(id, new VariantResolvingArtifactSet(this.variantResolver, component, variant, dependency, this.graphVariantSelector, this.consumerSchema));
        });
    }

    private static class ArtifactsForNode {
        private final int artifactSetId;
        private final ArtifactSet artifactSet;

        ArtifactsForNode(int artifactSetId, ArtifactSet artifactSet) {
            this.artifactSetId = artifactSetId;
            this.artifactSet = artifactSet;
        }
    }
}

