/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyContainerInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.util.Path;

class TasksFromDependentProjects
implements TaskDependencyContainerInternal {
    private final String taskName;
    private final String configurationName;
    private final TaskDependencyContainerInternal taskDependencyDelegate;

    public TasksFromDependentProjects(String taskName, String configurationName, TaskDependencyFactory taskDependencyFactory) {
        this(taskName, configurationName, new TaskDependencyChecker(), taskDependencyFactory);
    }

    public TasksFromDependentProjects(String taskName, String configurationName, TaskDependencyChecker checker, TaskDependencyFactory taskDependencyFactory) {
        this.taskName = taskName;
        this.configurationName = configurationName;
        this.taskDependencyDelegate = taskDependencyFactory.visitingDependencies(context -> {
            Project thisProject = context.getTask().getProject();
            Set tasksWithName = thisProject.getRootProject().getTasksByName(taskName, true);
            for (Task nextTask : tasksWithName) {
                boolean isDependency;
                if (context.getTask() == nextTask || !(isDependency = checker.isDependent(thisProject, configurationName, nextTask.getProject()))) continue;
                context.add((Object)nextTask);
            }
        });
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.taskDependencyDelegate.visitDependencies(context);
    }

    public Set<? extends Task> getDependencies(@Nullable Task task) {
        return this.taskDependencyDelegate.getDependencies(task);
    }

    public Set<? extends Task> getDependenciesForInternalUse(@Nullable Task task) {
        return this.taskDependencyDelegate.getDependenciesForInternalUse(task);
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    static class TaskDependencyChecker {
        TaskDependencyChecker() {
        }

        boolean isDependent(Project originProject, String configurationName, Project candidateProject) {
            Configuration configuration = (Configuration)candidateProject.getConfigurations().findByName(configurationName);
            if (configuration == null) {
                return false;
            }
            Path identityPath = ((ProjectInternal)originProject).getIdentityPath();
            return TaskDependencyChecker.doesConfigurationDependOnProject(configuration, identityPath);
        }

        private static boolean doesConfigurationDependOnProject(Configuration configuration, Path identityPath) {
            DomainObjectSet projectDependencies = configuration.getAllDependencies().withType(ProjectDependency.class);
            for (ProjectDependency projectDependency : projectDependencies) {
                Path dependencyIdentityPath = ((ProjectDependencyInternal)projectDependency).getIdentityPath();
                if (!dependencyIdentityPath.equals((Object)identityPath)) continue;
                return true;
            }
            return false;
        }
    }
}

