/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.model.annotations;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.properties.annotations.AbstractPropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.util.internal.TextUtil;

abstract class AbstractInputPropertyAnnotationHandler
extends AbstractPropertyAnnotationHandler {
    private static final String UNSUPPORTED_VALUE_TYPE = "UNSUPPORTED_VALUE_TYPE";

    protected AbstractInputPropertyAnnotationHandler(Class<? extends Annotation> annotationType, ImmutableSet<Class<? extends Annotation>> allowedModifiers) {
        super(annotationType, PropertyAnnotationHandler.Kind.INPUT, allowedModifiers);
    }

    protected static void validateUnsupportedInputPropertyValueTypes(PropertyMetadata propertyMetadata, TypeValidationContext validationContext, Class<? extends Annotation> annotationType) {
        AbstractInputPropertyAnnotationHandler.validateUnsupportedPropertyValueType(annotationType, AbstractInputPropertyAnnotationHandler.unpackValueTypesOf(propertyMetadata), propertyMetadata, validationContext, ResolvedArtifactResult.class, "Extract artifact metadata and annotate with @Input", "Extract artifact files and annotate with @InputFiles");
    }

    private static void validateUnsupportedPropertyValueType(Class<? extends Annotation> annotationType, List<Class<?>> valueTypes, PropertyMetadata propertyMetadata, TypeValidationContext validationContext, Class<?> unsupportedType, String ... possibleSolutions) {
        if (valueTypes.stream().anyMatch(unsupportedType::isAssignableFrom)) {
            validationContext.visitPropertyProblem(problem -> {
                InternalProblemSpec describedProblem = problem.forProperty(propertyMetadata.getPropertyName()).id(TextUtil.screamingSnakeToKebabCase((String)UNSUPPORTED_VALUE_TYPE), "Unsupported value type", GradleCoreProblemGroup.validation().property()).contextualLabel(String.format("has @%s annotation used on property of type '%s'", annotationType.getSimpleName(), TypeOf.typeOf((Type)propertyMetadata.getDeclaredType().getType()).getSimpleName())).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)UNSUPPORTED_VALUE_TYPE.toLowerCase(Locale.ROOT))).severity(Severity.ERROR).details(String.format("%s is not supported on task properties annotated with @%s", unsupportedType.getSimpleName(), annotationType.getSimpleName()));
                for (String possibleSolution : possibleSolutions) {
                    describedProblem.solution(possibleSolution);
                }
            });
        }
    }

    protected static List<Class<?>> unpackValueTypesOf(PropertyMetadata propertyMetadata) {
        ArrayList unpackedValueTypes = new ArrayList();
        Class returnType = propertyMetadata.getDeclaredType().getRawType();
        if (Provider.class.isAssignableFrom(returnType)) {
            List typeArguments = TypeOf.typeOf((Type)propertyMetadata.getDeclaredType().getType()).getActualTypeArguments();
            for (TypeOf typeArgument : typeArguments) {
                unpackedValueTypes.add(typeArgument.getConcreteClass());
            }
        } else {
            unpackedValueTypes.add(returnType);
        }
        return unpackedValueTypes;
    }
}

