/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter;

import java.lang.ref.SoftReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchemaFactory;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.model.ModelContainer;

public class DefaultRootComponentMetadataBuilder
implements RootComponentMetadataBuilder,
HoldsProjectState {
    private final DomainObjectContext owner;
    private final DependencyMetaDataProvider componentIdentity;
    private final ConfigurationsProvider configurationsProvider;
    private final AttributesSchemaInternal schema;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final LocalComponentGraphResolveStateFactory localResolveStateFactory;
    private final ImmutableAttributesSchemaFactory attributesSchemaFactory;
    private final Factory factory;
    private final MetadataHolder holder;

    private DefaultRootComponentMetadataBuilder(DomainObjectContext owner, DependencyMetaDataProvider componentIdentity, ConfigurationsProvider configurationsProvider, AttributesSchemaInternal schema, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalComponentGraphResolveStateFactory localResolveStateFactory, ImmutableAttributesSchemaFactory attributesSchemaFactory, Factory factory) {
        this.owner = owner;
        this.componentIdentity = componentIdentity;
        this.configurationsProvider = configurationsProvider;
        this.schema = schema;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.localResolveStateFactory = localResolveStateFactory;
        this.attributesSchemaFactory = attributesSchemaFactory;
        this.factory = factory;
        this.holder = new MetadataHolder();
    }

    @Override
    public RootComponentMetadataBuilder.RootComponentState toRootComponent(final String configurationName) {
        Module module = this.componentIdentity.getModule();
        final String status = module.getStatus();
        final ComponentIdentifier componentIdentifier = module.getComponentId();
        final ModuleVersionIdentifier moduleVersionId = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        final ImmutableAttributesSchema immutableSchema = this.attributesSchemaFactory.create(this.schema);
        return new RootComponentMetadataBuilder.RootComponentState(){

            @Override
            public LocalComponentGraphResolveState getRootComponent() {
                return DefaultRootComponentMetadataBuilder.this.getComponentState(DefaultRootComponentMetadataBuilder.this.owner, componentIdentifier, moduleVersionId, status, immutableSchema);
            }

            @Override
            public VariantGraphResolveState getRootVariant() {
                LocalVariantGraphResolveState rootVariant = this.getRootComponent().getConfigurationLegacy(configurationName);
                if (rootVariant == null) {
                    throw new IllegalArgumentException(String.format("Expected root variant '%s' to be present in %s", configurationName, componentIdentifier));
                }
                return rootVariant;
            }

            @Override
            public ComponentIdentifier getComponentIdentifier() {
                return componentIdentifier;
            }

            @Override
            public ModuleVersionIdentifier getModuleVersionIdentifier() {
                return moduleVersionId;
            }
        };
    }

    @Override
    public DependencyMetaDataProvider getComponentIdentity() {
        return this.componentIdentity;
    }

    private LocalComponentGraphResolveState getComponentState(DomainObjectContext domainObjectContext, ComponentIdentifier componentIdentifier, ModuleVersionIdentifier moduleVersionIdentifier, String status, ImmutableAttributesSchema schema) {
        LocalComponentGraphResolveState result;
        LocalComponentGraphResolveState state = this.holder.tryCached(componentIdentifier);
        if (state != null) {
            return state;
        }
        ModelContainer model = domainObjectContext.getModel();
        if (this.shouldCacheResolutionState()) {
            result = this.localResolveStateFactory.stateFor(model, componentIdentifier, moduleVersionIdentifier, this.configurationsProvider, status, schema);
            this.holder.cache(result, true);
        } else {
            result = this.localResolveStateFactory.adHocStateFor(model, componentIdentifier, moduleVersionIdentifier, this.configurationsProvider, status, schema);
            this.holder.cache(result, false);
        }
        return result;
    }

    private boolean shouldCacheResolutionState() {
        return !this.configurationsProvider.isFixedSize() || this.configurationsProvider.size() > 1;
    }

    @Override
    public RootComponentMetadataBuilder newBuilder(DependencyMetaDataProvider identity, ConfigurationsProvider provider) {
        return this.factory.create(this.owner, provider, identity, this.schema);
    }

    @Override
    public MutationValidator getValidator() {
        return this.holder;
    }

    public void discardAll() {
        this.holder.discard();
    }

    public static class Factory {
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
        private final LocalComponentGraphResolveStateFactory localResolveStateFactory;
        private final ImmutableAttributesSchemaFactory attributesSchemaFactory;

        @Inject
        public Factory(ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalComponentGraphResolveStateFactory localResolveStateFactory, ImmutableAttributesSchemaFactory attributesSchemaFactory) {
            this.moduleIdentifierFactory = moduleIdentifierFactory;
            this.localResolveStateFactory = localResolveStateFactory;
            this.attributesSchemaFactory = attributesSchemaFactory;
        }

        public RootComponentMetadataBuilder create(DomainObjectContext owner, ConfigurationsProvider configurationsProvider, DependencyMetaDataProvider componentIdentity, AttributesSchemaInternal schema) {
            return new DefaultRootComponentMetadataBuilder(owner, componentIdentity, configurationsProvider, schema, this.moduleIdentifierFactory, this.localResolveStateFactory, this.attributesSchemaFactory, this);
        }
    }

    private static class MetadataHolder
    implements MutationValidator {
        @Nullable
        private SoftReference<LocalComponentGraphResolveState> reference;
        @Nullable
        private LocalComponentGraphResolveState cachedValue;

        private MetadataHolder() {
        }

        @Override
        public void validateMutation(MutationValidator.MutationType type) {
            LocalComponentGraphResolveState value;
            if (type != MutationValidator.MutationType.STRATEGY && (value = this.currentValue()) != null) {
                value.reevaluate();
            }
        }

        @Nullable
        LocalComponentGraphResolveState tryCached(ComponentIdentifier id) {
            LocalComponentGraphResolveState value = this.currentValue();
            assert (value == null || value.getId().equals(id));
            return value;
        }

        @Nullable
        private LocalComponentGraphResolveState currentValue() {
            if (this.reference != null) {
                return this.reference.get();
            }
            return this.cachedValue;
        }

        public void discard() {
            this.reference = null;
            this.cachedValue = null;
        }

        public void cache(LocalComponentGraphResolveState state, boolean useStrongReference) {
            if (useStrongReference) {
                this.reference = null;
                this.cachedValue = state;
            } else {
                this.reference = new SoftReference<LocalComponentGraphResolveState>(state);
                this.cachedValue = null;
            }
        }
    }
}

