/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.GradlePomModuleDescriptorBuilder;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;

public class DefaultMutableMavenModuleResolveMetadata
extends AbstractMutableModuleComponentResolveMetadata
implements MutableMavenModuleResolveMetadata {
    private final NamedObjectInstantiator objectInstantiator;
    private String packaging = "jar";
    private boolean relocated;
    private String snapshotTimestamp;
    private final ImmutableList<MavenDependencyDescriptor> dependencies;
    private final ImmutableMap<String, Configuration> configurationDefinitions;

    public DefaultMutableMavenModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier, Collection<MavenDependencyDescriptor> dependencies, ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator objectInstantiator, ImmutableAttributesSchema schema) {
        super(attributesFactory, id, componentIdentifier, schema);
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.objectInstantiator = objectInstantiator;
        this.configurationDefinitions = GradlePomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS;
    }

    public DefaultMutableMavenModuleResolveMetadata(ModuleVersionIdentifier id, ModuleComponentIdentifier componentIdentifier, Collection<MavenDependencyDescriptor> dependencies, ImmutableAttributesFactory attributesFactory, NamedObjectInstantiator objectInstantiator, ImmutableAttributesSchema schema, ImmutableMap<String, Configuration> configurationDefinitions) {
        super(attributesFactory, id, componentIdentifier, schema);
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.objectInstantiator = objectInstantiator;
        this.configurationDefinitions = configurationDefinitions;
    }

    DefaultMutableMavenModuleResolveMetadata(MavenModuleResolveMetadata metadata, NamedObjectInstantiator objectInstantiator) {
        super(metadata);
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.dependencies = metadata.getDependencies();
        this.objectInstantiator = objectInstantiator;
        this.configurationDefinitions = GradlePomModuleDescriptorBuilder.MAVEN2_CONFIGURATIONS;
    }

    @Override
    public MavenModuleResolveMetadata asImmutable() {
        return new DefaultMavenModuleResolveMetadata(this);
    }

    @Override
    protected ImmutableMap<String, Configuration> getConfigurationDefinitions() {
        return this.configurationDefinitions;
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public void setSnapshotTimestamp(@Nullable String snapshotTimestamp) {
        this.snapshotTimestamp = snapshotTimestamp;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public void setRelocated(boolean relocated) {
        this.relocated = relocated;
    }

    @Override
    @Nonnull
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public void setPackaging(@Nonnull String packaging) {
        this.packaging = packaging;
    }

    @Override
    public boolean isPomPackaging() {
        return "pom".equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return DefaultMavenModuleResolveMetadata.JAR_PACKAGINGS.contains(this.packaging);
    }

    @Override
    public ImmutableList<MavenDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    NamedObjectInstantiator getObjectInstantiator() {
        return this.objectInstantiator;
    }
}

