/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;

public final class VisibilityUtil {
    private static final String[] visibilityModifiers = new String[]{"private", "packageLocal", "protected", "public"};

    @PsiModifier.ModifierConstant
    @NotNull
    public static String getVisibilityModifier(PsiModifierList list) {
        if (list == null) {
            return "packageLocal";
        }
        for (String modifier : visibilityModifiers) {
            if (!list.hasModifierProperty(modifier)) continue;
            String string2 = modifier;
            if (string2 == null) {
                VisibilityUtil.$$$reportNull$$$0(0);
            }
            return string2;
        }
        return "packageLocal";
    }

    @NotNull
    @Nls
    public static String toPresentableText(@PsiModifier.ModifierConstant @NotNull String modifier) {
        if (modifier == null) {
            VisibilityUtil.$$$reportNull$$$0(4);
        }
        String string2 = JavaPsiBundle.visibilityPresentation(modifier);
        if (string2 == null) {
            VisibilityUtil.$$$reportNull$$$0(5);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/VisibilityUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityModifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVisibility";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityModifier";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/VisibilityUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibilityString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVisibilityStringToDisplay";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setVisibility";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

