/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import groovy.util.Node;
import groovy.util.NodeList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.Container;
import org.gradle.plugins.ide.eclipse.model.FileReference;
import org.gradle.plugins.ide.eclipse.model.Library;
import org.gradle.plugins.ide.eclipse.model.Output;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.Variable;
import org.gradle.plugins.ide.eclipse.model.internal.FileReferenceFactory;
import org.gradle.plugins.ide.internal.generator.XmlPersistableConfigurationObject;

public class Classpath
extends XmlPersistableConfigurationObject {
    private final FileReferenceFactory fileReferenceFactory;
    private List<ClasspathEntry> entries = new ArrayList<ClasspathEntry>();

    public Classpath(XmlTransformer xmlTransformer, FileReferenceFactory fileReferenceFactory) {
        super(xmlTransformer);
        this.fileReferenceFactory = fileReferenceFactory;
    }

    public Classpath(FileReferenceFactory fileReferenceFactory) {
        this(new XmlTransformer(), fileReferenceFactory);
    }

    public Classpath() {
        this(new FileReferenceFactory());
    }

    public List<ClasspathEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ClasspathEntry> entries) {
        this.entries = entries;
    }

    @Override
    protected String getDefaultResourceName() {
        return "defaultClasspath.xml";
    }

    @Override
    protected void load(Node xml) {
        for (Object e : (NodeList)xml.get("classpathentry")) {
            Node entryNode = (Node)e;
            Object kind = entryNode.attribute((Object)"kind");
            if ("src".equals(kind)) {
                String path = (String)entryNode.attribute((Object)"path");
                this.entries.add(path.startsWith("/") ? new ProjectDependency(entryNode) : new SourceFolder(entryNode));
                continue;
            }
            if ("var".equals(kind)) {
                this.entries.add(new Variable(entryNode, this.fileReferenceFactory));
                continue;
            }
            if ("con".equals(kind)) {
                this.entries.add(new Container(entryNode));
                continue;
            }
            if ("lib".equals(kind)) {
                this.entries.add(new Library(entryNode, this.fileReferenceFactory));
                continue;
            }
            if (!"output".equals(kind)) continue;
            this.entries.add(new Output(entryNode));
        }
    }

    public Object configure(List<?> newEntries) {
        List newSourceFolders = newEntries.stream().filter(SourceFolder.class::isInstance).map(SourceFolder.class::cast).collect(Collectors.toList());
        Set updatedEntries = this.entries.stream().filter(entry -> this.shouldKeepEntry(newSourceFolders, (ClasspathEntry)entry)).collect(Collectors.toCollection(LinkedHashSet::new));
        updatedEntries.addAll(newEntries);
        this.entries = Lists.newArrayList((Iterable)updatedEntries);
        return this.entries;
    }

    private boolean shouldKeepEntry(List<SourceFolder> newEntries, ClasspathEntry entry) {
        return !this.isDependency(entry) && !this.isJreContainer(entry) && !this.isOutputLocation(entry) && !Classpath.isExistingEntryDuplicate(newEntries, entry);
    }

    private static boolean isExistingEntryDuplicate(List<SourceFolder> newSourceFolders, ClasspathEntry existingEntry) {
        if (!(existingEntry instanceof SourceFolder)) {
            return false;
        }
        SourceFolder sourceFolder = (SourceFolder)existingEntry;
        return newSourceFolders.stream().anyMatch(newSourceFolder -> Objects.equal((Object)sourceFolder.getKind(), (Object)newSourceFolder.getKind()) && Objects.equal((Object)sourceFolder.getPath(), (Object)newSourceFolder.getPath()) && Objects.equal(sourceFolder.getExcludes(), newSourceFolder.getExcludes()) && Objects.equal(sourceFolder.getIncludes(), newSourceFolder.getIncludes()));
    }

    @Override
    protected void store(Node xml) {
        NodeList classpathEntryNodes = (NodeList)xml.get("classpathentry");
        for (Object classpathEntry : classpathEntryNodes) {
            xml.remove((Node)classpathEntry);
        }
        for (ClasspathEntry entry : Classpath.filterDuplicateProjectDependencies(this.entries)) {
            entry.appendNode(xml);
        }
    }

    private static List<ClasspathEntry> filterDuplicateProjectDependencies(List<ClasspathEntry> entries) {
        ArrayList<ClasspathEntry> filtered = new ArrayList<ClasspathEntry>(entries.size());
        HashSet<String> paths = new HashSet<String>();
        for (ClasspathEntry entry : entries) {
            if (entry instanceof ProjectDependency) {
                String path = ((ProjectDependency)entry).getPath();
                if (paths.contains(path)) continue;
                paths.add(path);
                filtered.add(entry);
                continue;
            }
            filtered.add(entry);
        }
        return filtered;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classpath classpath = (Classpath)o;
        return Objects.equal(this.entries, classpath.entries);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entries});
    }

    public String toString() {
        return "Classpath{entries=" + this.entries + "}";
    }

    private boolean isDependency(ClasspathEntry entry) {
        return entry instanceof ProjectDependency || entry instanceof AbstractLibrary;
    }

    private boolean isJreContainer(ClasspathEntry entry) {
        return entry instanceof Container && ((Container)entry).getPath().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER");
    }

    private boolean isOutputLocation(ClasspathEntry entry) {
        return entry instanceof Output;
    }

    public FileReference fileReference(Object reference) {
        if (reference instanceof File) {
            return this.fileReferenceFactory.fromFile((File)reference);
        }
        if (reference instanceof String) {
            return this.fileReferenceFactory.fromVariablePath((String)reference);
        }
        String type = reference == null ? "null" : reference.getClass().getName();
        throw new RuntimeException("File reference can only be created from File or String instances but " + type + " was passed");
    }
}

