/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.problems.internal.DefaultFileLocation;
import org.gradle.api.problems.internal.DefaultLineInFileLocation;
import org.gradle.api.problems.internal.DefaultOffsetInFileLocation;
import org.gradle.api.problems.internal.DefaultPluginIdLocation;
import org.gradle.api.problems.internal.DefaultProblemCategory;
import org.gradle.api.problems.internal.DefaultProblemReport;
import org.gradle.api.problems.internal.DefaultTaskPathLocation;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.FileLocation;
import org.gradle.api.problems.internal.LineInFileLocation;
import org.gradle.api.problems.internal.OffsetInFileLocation;
import org.gradle.api.problems.internal.ProblemCategory;
import org.gradle.api.problems.internal.ProblemLocation;
import org.gradle.api.problems.internal.ProblemReport;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.plugin.devel.tasks.internal.ProblemReportAdapterFactory;

@Nonnull
public class ValidationProblemSerialization {
    private static final GsonBuilder GSON_BUILDER = ValidationProblemSerialization.createGsonBuilder();

    public static List<? extends ProblemReport> parseMessageList(String lines) {
        Gson gson = GSON_BUILDER.create();
        Type type = new TypeToken<List<DefaultProblemReport>>(){}.getType();
        return (List)gson.fromJson(lines, type);
    }

    public static GsonBuilder createGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ProblemReportAdapterFactory());
        gsonBuilder.registerTypeHierarchyAdapter(DocLink.class, (Object)new DocLinkAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(ProblemLocation.class, (Object)new LocationAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(ProblemCategory.class, (Object)new ProblemCategoryAdapter());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new ThrowableAdapterFactory());
        return gsonBuilder;
    }

    public static Stream<String> toPlainMessage(List<? extends ProblemReport> problems) {
        return problems.stream().map(problem -> problem.getDefinition().getSeverity() + ": " + TypeValidationProblemRenderer.renderMinimalInformationAbout((ProblemReport)problem));
    }

    private static class LocationAdapter
    extends TypeAdapter<ProblemLocation> {
        private LocationAdapter() {
        }

        public void write(JsonWriter out, ProblemLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            if (value instanceof DefaultFileLocation) {
                new FileLocationAdapter().write(out, (FileLocation)((DefaultFileLocation)value));
                return;
            }
            if (value instanceof DefaultPluginIdLocation) {
                new PluginIdLocationAdapter().write(out, (DefaultPluginIdLocation)value);
                return;
            }
            if (value instanceof DefaultTaskPathLocation) {
                new TaskLocationAdapter().write(out, (DefaultTaskPathLocation)value);
            }
        }

        public ProblemLocation read(JsonReader in) throws IOException {
            if (in.hasNext()) {
                in.beginObject();
                try {
                    String type = null;
                    String name = in.nextName();
                    if (name.equals("type")) {
                        type = in.nextString();
                    }
                    if (type == null) {
                        throw new JsonParseException("type must not be null");
                    }
                    switch (type) {
                        case "file": {
                            FileLocation fileLocation = FileLocationAdapter.readObject(in);
                            return fileLocation;
                        }
                        case "pluginId": {
                            DefaultPluginIdLocation defaultPluginIdLocation = PluginIdLocationAdapter.readObject(in);
                            return defaultPluginIdLocation;
                        }
                        case "task": {
                            DefaultTaskPathLocation defaultTaskPathLocation = TaskLocationAdapter.readObject(in);
                            return defaultTaskPathLocation;
                        }
                    }
                    throw new JsonParseException("Unknown type: " + type);
                }
                finally {
                    in.endObject();
                }
            }
            return null;
        }
    }

    public static class ProblemCategoryAdapter
    extends TypeAdapter<ProblemCategory> {
        public void write(JsonWriter out, @Nullable ProblemCategory value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("namespace").value(value.getNamespace());
            out.name("category").value(value.getCategory());
            out.name("subcategories").beginArray();
            for (String sc : value.getSubcategories()) {
                out.value(sc);
            }
            out.endArray();
            out.endObject();
        }

        public ProblemCategory read(JsonReader in) throws IOException {
            in.beginObject();
            String namespace = null;
            String category = null;
            ArrayList<String> subcategories = new ArrayList<String>();
            block10: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "namespace": {
                        namespace = in.nextString();
                        continue block10;
                    }
                    case "category": {
                        category = in.nextString();
                        continue block10;
                    }
                    case "subcategories": {
                        in.beginArray();
                        while (in.hasNext()) {
                            subcategories.add(in.nextString());
                        }
                        in.endArray();
                        continue block10;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return DefaultProblemCategory.create(namespace, category, (String[])subcategories.toArray(new String[0]));
        }
    }

    public static class DocLinkAdapter
    extends TypeAdapter<DocLink> {
        public void write(JsonWriter out, @Nullable DocLink value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("url").value(value.getUrl());
            out.name("consultDocumentationMessage").value(value.getConsultDocumentationMessage());
            out.endObject();
        }

        public DocLink read(JsonReader in) throws IOException {
            in.beginObject();
            String url = null;
            String consultDocumentationMessage = null;
            block8: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "url": {
                        url = in.nextString();
                        continue block8;
                    }
                    case "consultDocumentationMessage": {
                        consultDocumentationMessage = in.nextString();
                        continue block8;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            final String finalUrl = url;
            final String finalConsultDocumentationMessage = consultDocumentationMessage;
            return new DocLink(){

                public String getUrl() {
                    return finalUrl;
                }

                public String getConsultDocumentationMessage() {
                    return finalConsultDocumentationMessage;
                }
            };
        }
    }

    public static class TaskLocationAdapter
    extends TypeAdapter<DefaultTaskPathLocation> {
        public void write(JsonWriter out, @Nullable DefaultTaskPathLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            out.name("type").value("task");
            out.name("buildTreePath").value(value.getBuildTreePath());
            out.endObject();
        }

        public DefaultTaskPathLocation read(JsonReader in) throws IOException {
            in.beginObject();
            DefaultTaskPathLocation buildTreePath = TaskLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(buildTreePath, "buildTreePath must not be null");
            return buildTreePath;
        }

        @Nonnull
        private static DefaultTaskPathLocation readObject(JsonReader in) throws IOException {
            String buildTreePath = null;
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("buildTreePath")) {
                    buildTreePath = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            return new DefaultTaskPathLocation(buildTreePath);
        }
    }

    public static class PluginIdLocationAdapter
    extends TypeAdapter<DefaultPluginIdLocation> {
        public void write(JsonWriter out, @Nullable DefaultPluginIdLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            out.name("type").value("pluginId");
            out.name("pluginId").value(value.getPluginId());
            out.endObject();
        }

        public DefaultPluginIdLocation read(JsonReader in) throws IOException {
            in.beginObject();
            DefaultPluginIdLocation problemLocation = PluginIdLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(problemLocation, "pluginId must not be null");
            return problemLocation;
        }

        private static DefaultPluginIdLocation readObject(JsonReader in) throws IOException {
            String pluginId = null;
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("pluginId")) {
                    pluginId = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            return new DefaultPluginIdLocation(pluginId);
        }
    }

    public static class FileLocationAdapter
    extends TypeAdapter<FileLocation> {
        public void write(JsonWriter out, @Nullable FileLocation value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            out.name("type").value("file");
            out.name("path").value(value.getPath());
            if (value instanceof LineInFileLocation) {
                out.name("subtype").value("lineInFile");
                LineInFileLocation l = (LineInFileLocation)value;
                out.name("line").value((long)l.getLine());
                out.name("column").value((long)l.getColumn());
                out.name("length").value((long)l.getLength());
            } else if (value instanceof OffsetInFileLocation) {
                out.name("subtype").value("offsetInFile");
                OffsetInFileLocation l = (OffsetInFileLocation)value;
                out.name("offset").value((long)l.getOffset());
                out.name("length").value((long)l.getLength());
            } else {
                out.name("subtype").value("file");
            }
            out.endObject();
        }

        public FileLocation read(JsonReader in) throws IOException {
            in.beginObject();
            FileLocation fileLocation = FileLocationAdapter.readObject(in);
            in.endObject();
            Objects.requireNonNull(fileLocation, "path must not be null");
            return fileLocation;
        }

        @Nonnull
        private static FileLocation readObject(JsonReader in) throws IOException {
            String subtype = null;
            String path = null;
            Integer offset = null;
            Integer line = null;
            Integer column = null;
            Integer length = null;
            block16: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "subtype": {
                        subtype = in.nextString();
                        continue block16;
                    }
                    case "path": {
                        path = in.nextString();
                        continue block16;
                    }
                    case "offset": {
                        offset = in.nextInt();
                        continue block16;
                    }
                    case "line": {
                        line = in.nextInt();
                        continue block16;
                    }
                    case "column": {
                        column = in.nextInt();
                        continue block16;
                    }
                    case "length": {
                        length = in.nextInt();
                        continue block16;
                    }
                }
                in.skipValue();
            }
            if (subtype.equals("lineInFile")) {
                return DefaultLineInFileLocation.from(path, line, column, length);
            }
            if (subtype.equals("offsetInFile")) {
                return DefaultOffsetInFileLocation.from(path, (int)offset, (int)length);
            }
            return DefaultFileLocation.from(path);
        }
    }

    public static class ThrowableTypeAdapter
    extends TypeAdapter<Throwable> {
        private final TypeToken<Throwable> typeToken;

        public ThrowableTypeAdapter(TypeToken<Throwable> typeToken) {
            this.typeToken = typeToken;
        }

        @Nullable
        public Throwable read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            String message = null;
            Throwable cause = null;
            block11: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "message": {
                        message = in.nextString();
                        continue block11;
                    }
                    case "cause": {
                        cause = this.read(in);
                        continue block11;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            try {
                Constructor constructor;
                if (message == null && cause == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(new Class[0]);
                    return (Throwable)constructor.newInstance(new Object[0]);
                }
                if (message == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(Throwable.class);
                    return (Throwable)constructor.newInstance(cause);
                }
                if (cause == null) {
                    constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class);
                    return (Throwable)constructor.newInstance(message);
                }
                constructor = this.typeToken.getRawType().getDeclaredConstructor(String.class, Throwable.class);
                return (Throwable)constructor.newInstance(message, cause);
            }
            catch (NoSuchMethodException e) {
                if (message == null && cause == null) {
                    return new RuntimeException();
                }
                if (message == null) {
                    return new RuntimeException(cause);
                }
                if (cause == null) {
                    return new RuntimeException(message);
                }
                return new RuntimeException(message, cause);
            }
            catch (Exception e) {
                throw new JsonParseException((Throwable)e);
            }
        }

        public void write(JsonWriter out, @Nullable Throwable throwable) throws IOException {
            if (throwable == null) {
                out.nullValue();
            } else if (throwable.getMessage() == null && throwable.getCause() != null) {
                this.write(out, throwable.getCause());
            } else {
                out.beginObject();
                if (throwable.getMessage() != null) {
                    out.name("message");
                    out.value(throwable.getMessage());
                }
                if (ThrowableTypeAdapter.shouldWriteCause(throwable)) {
                    out.name("cause");
                    this.write(out, throwable.getCause());
                }
                out.endObject();
            }
        }

        private static boolean shouldWriteCause(Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause == null || cause.getMessage() == null || cause == throwable) {
                return false;
            }
            return throwable.getMessage() == null || !throwable.getMessage().contains(cause.getMessage());
        }
    }

    public static class ThrowableAdapterFactory
    implements TypeAdapterFactory {
        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Throwable.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new ThrowableTypeAdapter(typeToken);
        }
    }
}

