/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import java.io.File;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.tasks.properties.DirectoryTreeOutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.OutputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.PropertyValidationContext;
import org.gradle.api.internal.tasks.properties.ValidationAction;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.properties.InputFilePropertyType;
import org.gradle.internal.typeconversion.UnsupportedNotationException;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.internal.TextUtil;

public enum ValidationActions implements ValidationAction
{
    NO_OP("file collection"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
        }

        @Override
        public void validate(String propertyName, Supplier<Object> propertyValue, PropertyValidationContext context) {
        }
    }
    ,
    INPUT_FILE_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            File file = ValidationActions.toFile(context, value);
            if (!file.exists()) {
                ValidationActions.reportMissingInput(context, "File", propertyName, file);
            } else if (!file.isFile()) {
                ValidationActions.reportUnexpectedInputKind(context, "File", propertyName, file);
            }
        }
    }
    ,
    INPUT_DIRECTORY_VALIDATOR("directory"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            File directory = ValidationActions.toDirectory(context, value);
            if (!directory.exists()) {
                ValidationActions.reportMissingInput(context, "Directory", propertyName, directory);
            } else if (!directory.isDirectory()) {
                ValidationActions.reportUnexpectedInputKind(context, "Directory", propertyName, directory);
            }
        }
    }
    ,
    OUTPUT_DIRECTORY_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            File directory = ValidationActions.toFile(context, value);
            ValidationActions.validateNotInReservedFileSystemLocation(propertyName, context, directory);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    ValidationActions.reportCannotWriteToDirectory(propertyName, context, directory, "'" + directory + "' is not a directory");
                }
            } else {
                for (File candidate = directory.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    ValidationActions.reportCannotWriteToDirectory(propertyName, context, candidate, "'" + directory + "' ancestor '" + candidate + "' is not a directory");
                    return;
                }
            }
        }
    }
    ,
    OUTPUT_FILE_VALIDATOR("file"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            block2: {
                File file;
                block1: {
                    file = ValidationActions.toFile(context, value);
                    ValidationActions.validateNotInReservedFileSystemLocation(propertyName, context, file);
                    if (!file.exists()) break block1;
                    if (!file.isDirectory()) break block2;
                    ValidationActions.reportCannotWriteFileToDirectory(propertyName, context, file);
                    break block2;
                }
                for (File candidate = file.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    ValidationActions.reportCannotCreateParentDirectories(propertyName, context, file, candidate);
                    break;
                }
            }
        }
    }
    ,
    OUTPUT_FILE_TREE_VALIDATOR("directory"){

        @Override
        public void doValidate(String propertyName, Object value, PropertyValidationContext context) {
            File directory = ValidationActions.toFile(context, value);
            ValidationActions.validateNotInReservedFileSystemLocation(propertyName, context, directory);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    ValidationActions.reportFileTreeWithFileRoot(propertyName, context, directory);
                }
            } else {
                for (File candidate = directory.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    ValidationActions.reportCannotWriteToDirectory(propertyName, context, candidate, "'" + directory + "' ancestor '" + candidate + "' is not a directory");
                    return;
                }
            }
        }
    };

    private static final String INPUT_FILE_DOES_NOT_EXIST = "INPUT_FILE_DOES_NOT_EXIST";
    private static final String UNEXPECTED_INPUT_FILE_TYPE = "UNEXPECTED_INPUT_FILE_TYPE";
    private static final String CANNOT_WRITE_OUTPUT = "CANNOT_WRITE_OUTPUT";
    private static final String CANNOT_WRITE_TO_RESERVED_LOCATION = "CANNOT_WRITE_TO_RESERVED_LOCATION";
    private final String targetType;
    private static final String UNSUPPORTED_NOTATION = "UNSUPPORTED_NOTATION";

    public static ValidationAction inputValidationActionFor(InputFilePropertyType type) {
        switch (type) {
            case FILE: {
                return INPUT_FILE_VALIDATOR;
            }
            case DIRECTORY: {
                return INPUT_DIRECTORY_VALIDATOR;
            }
            case FILES: {
                return NO_OP;
            }
        }
        throw new AssertionError((Object)("Unknown input property type " + type));
    }

    public static ValidationAction outputValidationActionFor(OutputFilePropertySpec spec) {
        if (spec instanceof DirectoryTreeOutputFilePropertySpec) {
            return OUTPUT_FILE_TREE_VALIDATOR;
        }
        switch (spec.getOutputType()) {
            case FILE: {
                return OUTPUT_FILE_VALIDATOR;
            }
            case DIRECTORY: {
                return OUTPUT_DIRECTORY_VALIDATOR;
            }
        }
        throw new AssertionError((Object)("Unknown tree type " + spec));
    }

    private static void reportMissingInput(PropertyValidationContext context, String kind, String propertyName, File input) {
        context.visitPropertyProblem(problem -> {
            String lowerKind = kind.toLowerCase();
            problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)INPUT_FILE_DOES_NOT_EXIST), "Input file does not exist", GradleCoreProblemGroup.validation().property()).contextualLabel("specifies " + lowerKind + " '" + input + "' which doesn't exist").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)INPUT_FILE_DOES_NOT_EXIST.toLowerCase())).severity(Severity.ERROR).details("An input file was expected to be present but it doesn't exist").solution("Make sure the " + lowerKind + " exists before the task is called").solution("Make sure that the task which produces the " + lowerKind + " is declared as an input");
        });
    }

    private static void reportUnexpectedInputKind(PropertyValidationContext context, String kind, String propertyName, File input) {
        context.visitPropertyProblem(problem -> {
            String lowerKind = kind.toLowerCase();
            problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)UNEXPECTED_INPUT_FILE_TYPE), "Unexpected input file type", GradleCoreProblemGroup.validation().property()).contextualLabel(lowerKind + " '" + input + "' is not a " + lowerKind).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"unexpected_input_file_type")).severity(Severity.ERROR).details("Expected an input to be a " + lowerKind + " but it was a " + ValidationActions.actualKindOf(input)).solution("Use a " + lowerKind + " as an input").solution("Declare the input as a " + ValidationActions.actualKindOf(input) + " instead");
        });
    }

    private static void reportCannotWriteToDirectory(String propertyName, PropertyValidationContext context, File directory, String cause) {
        context.visitPropertyProblem(problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)CANNOT_WRITE_OUTPUT), "Property not writeable", GradleCoreProblemGroup.validation().property()).contextualLabel("is not writable because " + cause).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)CANNOT_WRITE_OUTPUT.toLowerCase())).severity(Severity.ERROR).details("Expected '" + directory + "' to be a directory but it's a " + ValidationActions.actualKindOf(directory)).solution("Make sure that the '" + propertyName + "' is configured to a directory"));
    }

    private static void reportFileTreeWithFileRoot(String propertyName, PropertyValidationContext context, File directory) {
        context.visitPropertyProblem(problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)CANNOT_WRITE_OUTPUT), "Property is not writable", GradleCoreProblemGroup.validation().property()).contextualLabel("is not writable because '" + directory + "' is not a directory").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)CANNOT_WRITE_OUTPUT.toLowerCase())).severity(Severity.ERROR).details("Expected the root of the file tree '" + directory + "' to be a directory but it's a " + ValidationActions.actualKindOf(directory)).solution("Make sure that the root of the file tree '" + propertyName + "' is configured to a directory"));
    }

    private static void reportCannotWriteFileToDirectory(String propertyName, PropertyValidationContext context, File file) {
        context.visitPropertyProblem(problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)CANNOT_WRITE_OUTPUT), "Property is not writable", GradleCoreProblemGroup.validation().property()).contextualLabel("is not writable because '" + file + "' is not a file").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)CANNOT_WRITE_OUTPUT.toLowerCase())).details("Cannot write a file to a location pointing at a directory").severity(Severity.ERROR).solution("Configure '" + propertyName + "' to point to a file, not a directory").solution("Annotate '" + propertyName + "' with @OutputDirectory instead of @OutputFiles"));
    }

    private static void reportCannotCreateParentDirectories(String propertyName, PropertyValidationContext context, File file, File ancestor) {
        context.visitPropertyProblem(problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)CANNOT_WRITE_OUTPUT), "Property is not writable", GradleCoreProblemGroup.validation().property()).contextualLabel("is not writable because '" + file + "' ancestor '" + ancestor + "' is not a directory").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)CANNOT_WRITE_OUTPUT.toLowerCase())).severity(Severity.ERROR).details("Cannot create parent directories that are existing as file").solution("Configure '" + propertyName + "' to point to the correct location"));
    }

    private static String actualKindOf(File input) {
        if (input.isFile()) {
            return "file";
        }
        if (input.isDirectory()) {
            return "directory";
        }
        return "unexpected file type";
    }

    private static void validateNotInReservedFileSystemLocation(String propertyName, PropertyValidationContext context, File location) {
        if (context.isInReservedFileSystemLocation(location)) {
            context.visitPropertyProblem(problem -> problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)CANNOT_WRITE_TO_RESERVED_LOCATION), "Cannot write to reserved location", GradleCoreProblemGroup.validation().property()).contextualLabel("points to '" + location + "' which is managed by Gradle").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)CANNOT_WRITE_TO_RESERVED_LOCATION.toLowerCase())).severity(Severity.ERROR).details("Trying to write an output to a read-only location which is for Gradle internal use only").solution("Select a different output location"));
        }
    }

    private ValidationActions(String targetType) {
        this.targetType = targetType;
    }

    protected abstract void doValidate(String var1, Object var2, PropertyValidationContext var3);

    @Override
    public void validate(String propertyName, Supplier<Object> value, PropertyValidationContext context) {
        try {
            this.doValidate(propertyName, value.get(), context);
        }
        catch (UnsupportedNotationException unsupportedNotationException) {
            ValidationActions.reportUnsupportedValue(propertyName, context, this.targetType, value.get(), unsupportedNotationException.getCandidates());
        }
    }

    private static void reportUnsupportedValue(String propertyName, PropertyValidationContext context, String targetType, Object value, Collection<String> candidates) {
        context.visitPropertyProblem(problem -> {
            InternalProblemSpec describedProblem = problem.forProperty(propertyName).id(TextUtil.screamingSnakeToKebabCase((String)UNSUPPORTED_NOTATION), "Property has unsupported value", GradleCoreProblemGroup.validation().property()).contextualLabel("has unsupported value '" + value + "'").documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)UNSUPPORTED_NOTATION.toLowerCase())).severity(Severity.ERROR).details("Type '" + ValidationActions.typeOf(value) + "' cannot be converted to a " + targetType);
            if (candidates.isEmpty()) {
                describedProblem.solution("Use a value of type '" + targetType + "'");
            } else {
                candidates.forEach(arg_0 -> ValidationActions.lambda$reportUnsupportedValue$7((ProblemSpec)describedProblem, arg_0));
            }
        });
    }

    private static String typeOf(@Nullable Object instance) {
        if (instance == null) {
            return Object.class.getSimpleName();
        }
        if (instance instanceof GeneratedSubclass) {
            return ModelType.of((Class)((GeneratedSubclass)instance).publicType()).getDisplayName();
        }
        return ModelType.typeOf((Object)instance).getDisplayName();
    }

    private static String toCandidateSolution(String conversionCandidate) {
        String result = StringUtils.uncapitalize((String)conversionCandidate);
        if (result.endsWith(".")) {
            result = result.substring(0, result.lastIndexOf("."));
        }
        return "Use " + result;
    }

    private static File toDirectory(PropertyValidationContext context, Object value) {
        if (value instanceof ConfigurableFileTree) {
            return ((ConfigurableFileTree)value).getDir();
        }
        return ValidationActions.toFile(context, value);
    }

    private static File toFile(PropertyValidationContext context, Object value) {
        return context.getFileResolver().resolve(value);
    }

    private static /* synthetic */ void lambda$reportUnsupportedValue$7(ProblemSpec describedProblem, String candidate) {
        describedProblem.solution(ValidationActions.toCandidateSolution(candidate));
    }
}

