/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.context;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.gradle.api.internal.specs.ExplainingSpec;
import org.gradle.internal.jvm.Jvm;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.context.DaemonRequestContext;

public class DaemonCompatibilitySpec
implements ExplainingSpec<DaemonContext> {
    private final DaemonRequestContext desiredContext;

    public DaemonCompatibilitySpec(DaemonRequestContext desiredContext) {
        this.desiredContext = desiredContext;
    }

    public boolean isSatisfiedBy(DaemonContext potentialContext) {
        return this.whyUnsatisfied(potentialContext) == null;
    }

    public String whyUnsatisfied(DaemonContext context) {
        if (!this.jvmCompatible(context)) {
            return "JVM is incompatible.\n" + this.description(context);
        }
        if (!this.daemonOptsMatch(context)) {
            return "At least one daemon option is different.\n" + this.description(context);
        }
        if (!this.priorityMatches(context)) {
            return "Process priority is different.\n" + this.description(context);
        }
        if (!this.agentStatusMatches(context)) {
            return "Agent status is different.\n" + this.description(context);
        }
        if (!this.nativeServicesModeMatches(context)) {
            return "Native services mode is different.\n" + this.description(context);
        }
        return null;
    }

    private String description(DaemonContext context) {
        return "Wanted: " + this + "\nActual: " + context + "\n";
    }

    private boolean daemonOptsMatch(DaemonContext potentialContext) {
        return potentialContext.getDaemonOpts().containsAll(this.desiredContext.getDaemonOpts()) && potentialContext.getDaemonOpts().size() == this.desiredContext.getDaemonOpts().size();
    }

    private boolean jvmCompatible(DaemonContext potentialContext) {
        if (this.desiredContext.getJvmCriteria() != null) {
            return this.desiredContext.getJvmCriteria().isCompatibleWith(potentialContext.getJavaVersion());
        }
        try {
            File potentialJavaHome = potentialContext.getJavaHome();
            if (potentialJavaHome.exists()) {
                File potentialJava = Jvm.forHome(potentialJavaHome).getJavaExecutable();
                File desiredJava = this.desiredContext.getJavaHome().getJavaExecutable();
                return Files.isSameFile(potentialJava.toPath(), desiredJava.toPath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean priorityMatches(DaemonContext context) {
        return this.desiredContext.getPriority() == context.getPriority();
    }

    private boolean agentStatusMatches(DaemonContext context) {
        return this.desiredContext.shouldApplyInstrumentationAgent() == context.shouldApplyInstrumentationAgent();
    }

    private boolean nativeServicesModeMatches(DaemonContext context) {
        return this.desiredContext.getNativeServicesMode() == context.getNativeServicesMode();
    }

    public String toString() {
        return this.desiredContext.toString();
    }
}

