/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;

public class ResolveExceptionContextualizer {
    private final DomainObjectContext domainObjectContext;
    private final DocumentationRegistry documentationRegistry;

    public ResolveExceptionContextualizer(DomainObjectContext domainObjectContext, DocumentationRegistry documentationRegistry) {
        this.domainObjectContext = domainObjectContext;
        this.documentationRegistry = documentationRegistry;
    }

    @Nullable
    public ResolveException mapFailures(Collection<Throwable> failures, String contextDisplayName, String type) {
        if (failures.isEmpty()) {
            return null;
        }
        if (failures.size() > 1) {
            return new DefaultLenientConfiguration.ArtifactResolveException(type, contextDisplayName, failures);
        }
        Throwable failure = failures.iterator().next();
        return this.mapFailure(failure, type, contextDisplayName);
    }

    public ResolveException contextualize(Throwable e, ResolveContext resolveContext) {
        return this.mapFailure(e, "dependencies", resolveContext.getResolutionHost().getDisplayName());
    }

    private ResolveException mapFailure(Throwable failure, String type, String contextDisplayName) {
        Collection<Throwable> causes = failure instanceof ResolveException ? ((ResolveException)failure).getCauses() : Collections.singleton(failure);
        ResolveException detected = this.detectRepositoryOverride(contextDisplayName, causes);
        if (detected != null) {
            return detected;
        }
        if (failure instanceof ResolveException) {
            return (ResolveException)failure;
        }
        return new DefaultLenientConfiguration.ArtifactResolveException(type, contextDisplayName, Collections.singleton(failure));
    }

    @Nullable
    private ResolveException detectRepositoryOverride(String contextDisplayName, Collection<? extends Throwable> causes) {
        try {
            boolean ignoresSettingsRepositories = false;
            if (this.domainObjectContext instanceof ProjectInternal) {
                ProjectInternal project = (ProjectInternal)this.domainObjectContext;
                ignoresSettingsRepositories = !project.getRepositories().isEmpty() && !project.getGradle().getSettings().getDependencyResolutionManagement().getRepositories().isEmpty();
            }
            boolean hasModuleNotFound = causes.stream().anyMatch(ModuleVersionNotFoundException.class::isInstance);
            if (ignoresSettingsRepositories && hasModuleNotFound) {
                return new ResolveExceptionWithHints(contextDisplayName, causes, "The project declares repositories, effectively ignoring the repositories you have declared in the settings.\nYou can figure out how project repositories are declared by configuring your build to fail on project repositories.\n" + this.documentationRegistry.getDocumentationRecommendationFor("information", "declaring_repositories", "sub:fail_build_on_project_repositories"));
            }
            return null;
        }
        catch (Throwable e) {
            return new ResolveException(contextDisplayName, (Iterable)ImmutableList.builder().addAll(causes).add((Object)e).build());
        }
    }

    public static class ResolveExceptionWithHints
    extends ResolveException
    implements ResolutionProvider {
        private final List<String> resolutions;

        public ResolveExceptionWithHints(String resolveContext, Iterable<? extends Throwable> causes, String resolution) {
            super(resolveContext, causes);
            this.resolutions = ImmutableList.of((Object)resolution);
        }

        public List<String> getResolutions() {
            return this.resolutions;
        }
    }
}

