/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.IOException;
import org.gradle.api.NonNullApi;
import org.gradle.internal.serialize.Encoder;

@NonNullApi
public class EncoderExtensions {
    public static void writeLengthPrefixedShorts(Encoder encoder, short[] array) throws IOException {
        encoder.writeInt(array.length);
        EncoderExtensions.writeShorts(encoder, array);
    }

    public static void writeShorts(Encoder encoder, short[] array) throws IOException {
        for (short e : array) {
            encoder.writeShort(e);
        }
    }

    public static void writeLengthPrefixedInts(Encoder encoder, int[] array) throws IOException {
        encoder.writeInt(array.length);
        EncoderExtensions.writeInts(encoder, array);
    }

    public static void writeInts(Encoder encoder, int[] array) throws IOException {
        for (int e : array) {
            encoder.writeInt(e);
        }
    }

    public static void writeLengthPrefixedLongs(Encoder encoder, long[] array) throws IOException {
        encoder.writeInt(array.length);
        EncoderExtensions.writeLongs(encoder, array);
    }

    public static void writeLongs(Encoder encoder, long[] array) throws IOException {
        for (long e : array) {
            encoder.writeLong(e);
        }
    }

    public static void writeLengthPrefixedFloats(Encoder encoder, float[] array) throws IOException {
        encoder.writeInt(array.length);
        EncoderExtensions.writeFloats(encoder, array);
    }

    public static void writeFloats(Encoder encoder, float[] array) throws IOException {
        for (float e : array) {
            encoder.writeFloat(e);
        }
    }

    public static void writeLengthPrefixedDoubles(Encoder encoder, double[] array) throws IOException {
        encoder.writeInt(array.length);
        EncoderExtensions.writeDoubles(encoder, array);
    }

    public static void writeDoubles(Encoder encoder, double[] array) throws IOException {
        for (double e : array) {
            encoder.writeDouble(e);
        }
    }

    public static void writeLengthPrefixedChars(Encoder encoder, char[] array) throws IOException {
        encoder.writeInt(array.length);
        EncoderExtensions.writeChars(encoder, array);
    }

    public static void writeChars(Encoder encoder, char[] array) throws IOException {
        for (char e : array) {
            encoder.writeInt(e);
        }
    }

    public static void writeLengthPrefixedBooleans(Encoder encoder, boolean[] array) throws IOException {
        encoder.writeInt(array.length);
        EncoderExtensions.writeBooleans(encoder, array);
    }

    private static void writeBooleans(Encoder encoder, boolean[] array) throws IOException {
        for (boolean e : array) {
            encoder.writeBoolean(e);
        }
    }
}

