/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.internal.execution.FileCollectionFingerprinter;
import org.gradle.internal.execution.FileCollectionFingerprinterRegistry;
import org.gradle.internal.execution.FileNormalizationSpec;
import org.gradle.internal.execution.impl.FingerprinterRegistration;

public class DefaultFileCollectionFingerprinterRegistry
implements FileCollectionFingerprinterRegistry {
    private final Map<FileNormalizationSpec, FileCollectionFingerprinter> fingerprinters;

    public DefaultFileCollectionFingerprinterRegistry(Collection<FingerprinterRegistration> registrations) {
        this.fingerprinters = ImmutableMap.copyOf(this.entriesFrom(registrations));
    }

    private List<Map.Entry<FileNormalizationSpec, FileCollectionFingerprinter>> entriesFrom(Collection<FingerprinterRegistration> registrations) {
        return (List)registrations.stream().map(registration -> Maps.immutableEntry((Object)registration.getSpec(), (Object)registration.getFingerprinter())).collect(ImmutableList.toImmutableList());
    }

    @Override
    public FileCollectionFingerprinter getFingerprinter(FileNormalizationSpec spec) {
        FileCollectionFingerprinter fingerprinter = this.fingerprinters.get(spec);
        if (fingerprinter == null) {
            throw new IllegalStateException(String.format("No fingerprinter registered with '%s' normalization, directory sensitivity '%s' and line ending normalization '%s'", spec.getNormalizer(), spec.getDirectorySensitivity().name(), spec.getLineEndingNormalization()));
        }
        return fingerprinter;
    }
}

