/* daemon_interface.c generated by valac 0.56.17, the Vala compiler
 * generated from daemon_interface.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2019-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "pamac.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PAMAC_TYPE_DAEMON (pamac_daemon_get_type ())
#define PAMAC_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_DAEMON, PamacDaemon))
#define PAMAC_IS_DAEMON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_DAEMON))
#define PAMAC_DAEMON_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_DAEMON, PamacDaemonIface))

typedef struct _PamacDaemon PamacDaemon;
typedef struct _PamacDaemonIface PamacDaemonIface;

#define PAMAC_TYPE_DAEMON_PROXY (pamac_daemon_proxy_get_type ())
enum  {
	PAMAC_DAEMON_EMIT_ACTION_SIGNAL,
	PAMAC_DAEMON_EMIT_ACTION_PROGRESS_SIGNAL,
	PAMAC_DAEMON_EMIT_DOWNLOAD_PROGRESS_SIGNAL,
	PAMAC_DAEMON_EMIT_HOOK_PROGRESS_SIGNAL,
	PAMAC_DAEMON_EMIT_SCRIPT_OUTPUT_SIGNAL,
	PAMAC_DAEMON_EMIT_WARNING_SIGNAL,
	PAMAC_DAEMON_EMIT_ERROR_SIGNAL,
	PAMAC_DAEMON_IMPORTANT_DETAILS_OUTPOUT_SIGNAL,
	PAMAC_DAEMON_START_DOWNLOADING_SIGNAL,
	PAMAC_DAEMON_STOP_DOWNLOADING_SIGNAL,
	PAMAC_DAEMON_SET_PKGREASON_FINISHED_SIGNAL,
	PAMAC_DAEMON_START_WAITING_SIGNAL,
	PAMAC_DAEMON_STOP_WAITING_SIGNAL,
	PAMAC_DAEMON_DOWNLOAD_PKGS_FINISHED_SIGNAL,
	PAMAC_DAEMON_TRANS_REFRESH_FINISHED_SIGNAL,
	PAMAC_DAEMON_TRANS_REFRESH_FILES_FINISHED_SIGNAL,
	PAMAC_DAEMON_TRANS_REFRESH_AUR_FINISHED_SIGNAL,
	PAMAC_DAEMON_TRANS_RUN_FINISHED_SIGNAL,
	PAMAC_DAEMON_DOWNLOAD_UPDATES_FINISHED_SIGNAL,
	PAMAC_DAEMON_GET_AUTHORIZATION_FINISHED_SIGNAL,
	PAMAC_DAEMON_WRITE_ALPM_CONFIG_FINISHED_SIGNAL,
	PAMAC_DAEMON_WRITE_PAMAC_CONFIG_FINISHED_SIGNAL,
	PAMAC_DAEMON_GENERATE_MIRRORS_LIST_DATA_SIGNAL,
	PAMAC_DAEMON_GENERATE_MIRRORS_LIST_FINISHED_SIGNAL,
	PAMAC_DAEMON_CLEAN_CACHE_FINISHED_SIGNAL,
	PAMAC_DAEMON_CLEAN_BUILD_FILES_FINISHED_SIGNAL,
	PAMAC_DAEMON_SNAP_TRANS_RUN_FINISHED_SIGNAL,
	PAMAC_DAEMON_SNAP_SWITCH_CHANNEL_FINISHED_SIGNAL,
	PAMAC_DAEMON_FLATPAK_TRANS_RUN_FINISHED_SIGNAL,
	PAMAC_DAEMON_NUM_SIGNALS
};
static guint pamac_daemon_signals[PAMAC_DAEMON_NUM_SIGNALS] = {0};
typedef GDBusProxy PamacDaemonProxy;
typedef GDBusProxyClass PamacDaemonProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _PamacDaemonIface {
	GTypeInterface parent_iface;
	gchar* (*get_sender) (PamacDaemon* self, GError** error);
	gchar* (*get_lockfile) (PamacDaemon* self, GError** error);
	void (*set_environment_variables) (PamacDaemon* self, GHashTable* variables, GError** error);
	void (*start_get_authorization) (PamacDaemon* self, GError** error);
	void (*remove_authorization) (PamacDaemon* self, GError** error);
	void (*start_write_alpm_config) (PamacDaemon* self, GHashTable* new_alpm_conf, GError** error);
	void (*start_write_pamac_config) (PamacDaemon* self, GHashTable* new_pamac_conf, GError** error);
	void (*start_generate_mirrors_list) (PamacDaemon* self, const gchar* country, GError** error);
	void (*start_clean_cache) (PamacDaemon* self, gchar** filenames, gint filenames_length1, GError** error);
	void (*start_clean_build_files) (PamacDaemon* self, const gchar* aur_build_dir, GError** error);
	void (*start_set_pkgreason) (PamacDaemon* self, const gchar* pkgname, guint reason, GError** error);
	void (*start_download_updates) (PamacDaemon* self, GError** error);
	void (*start_download_pkgs) (PamacDaemon* self, gchar** urls, gint urls_length1, GError** error);
	void (*start_trans_refresh) (PamacDaemon* self, gboolean force, GError** error);
	void (*start_trans_refresh_files) (PamacDaemon* self, gboolean force, GError** error);
	void (*start_trans_refresh_aur) (PamacDaemon* self, gboolean force, GError** error);
	void (*start_trans_run) (PamacDaemon* self, gboolean sysupgrade, gboolean enable_downgrade, gboolean simple_install, gboolean keep_built_pkgs, gint trans_flags, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, gchar** to_load_local, gint to_load_local_length1, gchar** to_load_remote, gint to_load_remote_length1, gchar** to_install_as_dep, gint to_install_as_dep_length1, gchar** ignorepkgs, gint ignorepkgs_length1, gchar** overwrite_files, gint overwrite_files_length1, GError** error);
	void (*trans_cancel) (PamacDaemon* self, GError** error);
	void (*quit) (PamacDaemon* self, GError** error);
	void (*start_snap_trans_run) (PamacDaemon* self, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, GError** error);
	void (*start_snap_switch_channel) (PamacDaemon* self, const gchar* snap_name, const gchar* channel, GError** error);
	void (*start_flatpak_trans_run) (PamacDaemon* self, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, gchar** to_upgrade, gint to_upgrade_length1, GError** error);
};

VALA_EXTERN GType pamac_daemon_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pamac_daemon_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType pamac_daemon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* pamac_daemon_get_sender (PamacDaemon* self,
                                GError** error);
VALA_EXTERN gchar* pamac_daemon_get_lockfile (PamacDaemon* self,
                                  GError** error);
VALA_EXTERN void pamac_daemon_set_environment_variables (PamacDaemon* self,
                                             GHashTable* variables,
                                             GError** error);
VALA_EXTERN void pamac_daemon_start_get_authorization (PamacDaemon* self,
                                           GError** error);
VALA_EXTERN void pamac_daemon_remove_authorization (PamacDaemon* self,
                                        GError** error);
VALA_EXTERN void pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                           GHashTable* new_alpm_conf,
                                           GError** error);
VALA_EXTERN void pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                            GHashTable* new_pamac_conf,
                                            GError** error);
VALA_EXTERN void pamac_daemon_start_generate_mirrors_list (PamacDaemon* self,
                                               const gchar* country,
                                               GError** error);
VALA_EXTERN void pamac_daemon_start_clean_cache (PamacDaemon* self,
                                     gchar** filenames,
                                     gint filenames_length1,
                                     GError** error);
VALA_EXTERN void pamac_daemon_start_clean_build_files (PamacDaemon* self,
                                           const gchar* aur_build_dir,
                                           GError** error);
VALA_EXTERN void pamac_daemon_start_set_pkgreason (PamacDaemon* self,
                                       const gchar* pkgname,
                                       guint reason,
                                       GError** error);
VALA_EXTERN void pamac_daemon_start_download_updates (PamacDaemon* self,
                                          GError** error);
VALA_EXTERN void pamac_daemon_start_download_pkgs (PamacDaemon* self,
                                       gchar** urls,
                                       gint urls_length1,
                                       GError** error);
VALA_EXTERN void pamac_daemon_start_trans_refresh (PamacDaemon* self,
                                       gboolean force,
                                       GError** error);
VALA_EXTERN void pamac_daemon_start_trans_refresh_files (PamacDaemon* self,
                                             gboolean force,
                                             GError** error);
VALA_EXTERN void pamac_daemon_start_trans_refresh_aur (PamacDaemon* self,
                                           gboolean force,
                                           GError** error);
VALA_EXTERN void pamac_daemon_start_trans_run (PamacDaemon* self,
                                   gboolean sysupgrade,
                                   gboolean enable_downgrade,
                                   gboolean simple_install,
                                   gboolean keep_built_pkgs,
                                   gint trans_flags,
                                   gchar** to_install,
                                   gint to_install_length1,
                                   gchar** to_remove,
                                   gint to_remove_length1,
                                   gchar** to_load_local,
                                   gint to_load_local_length1,
                                   gchar** to_load_remote,
                                   gint to_load_remote_length1,
                                   gchar** to_install_as_dep,
                                   gint to_install_as_dep_length1,
                                   gchar** ignorepkgs,
                                   gint ignorepkgs_length1,
                                   gchar** overwrite_files,
                                   gint overwrite_files_length1,
                                   GError** error);
VALA_EXTERN void pamac_daemon_trans_cancel (PamacDaemon* self,
                                GError** error);
VALA_EXTERN void pamac_daemon_quit (PamacDaemon* self,
                        GError** error);
VALA_EXTERN void pamac_daemon_start_snap_trans_run (PamacDaemon* self,
                                        gchar** to_install,
                                        gint to_install_length1,
                                        gchar** to_remove,
                                        gint to_remove_length1,
                                        GError** error);
VALA_EXTERN void pamac_daemon_start_snap_switch_channel (PamacDaemon* self,
                                             const gchar* snap_name,
                                             const gchar* channel,
                                             GError** error);
VALA_EXTERN void pamac_daemon_start_flatpak_trans_run (PamacDaemon* self,
                                           gchar** to_install,
                                           gint to_install_length1,
                                           gchar** to_remove,
                                           gint to_remove_length1,
                                           gchar** to_upgrade,
                                           gint to_upgrade_length1,
                                           GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                GValue * return_value,
                                                                guint n_param_values,
                                                                const GValue * param_values,
                                                                gpointer invocation_hint,
                                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                       GValue * return_value,
                                                                       guint n_param_values,
                                                                       const GValue * param_values,
                                                                       gpointer invocation_hint,
                                                                       gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING_BOXED_INT (GClosure * closure,
                                                            GValue * return_value,
                                                            guint n_param_values,
                                                            const GValue * param_values,
                                                            gpointer invocation_hint,
                                                            gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_INT (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data);
static GType pamac_daemon_get_type_once (void);
static void pamac_daemon_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters);
static void _dbus_handle_pamac_daemon_emit_action (PamacDaemon* self,
                                            GVariant* parameters);
static void _dbus_handle_pamac_daemon_emit_action_progress (PamacDaemon* self,
                                                     GVariant* parameters);
static void _dbus_handle_pamac_daemon_emit_download_progress (PamacDaemon* self,
                                                       GVariant* parameters);
static void _dbus_handle_pamac_daemon_emit_hook_progress (PamacDaemon* self,
                                                   GVariant* parameters);
static void _dbus_handle_pamac_daemon_emit_script_output (PamacDaemon* self,
                                                   GVariant* parameters);
static void _dbus_handle_pamac_daemon_emit_warning (PamacDaemon* self,
                                             GVariant* parameters);
static void _dbus_handle_pamac_daemon_emit_error (PamacDaemon* self,
                                           GVariant* parameters);
static void _dbus_handle_pamac_daemon_important_details_outpout (PamacDaemon* self,
                                                          GVariant* parameters);
static void _dbus_handle_pamac_daemon_start_downloading (PamacDaemon* self,
                                                  GVariant* parameters);
static void _dbus_handle_pamac_daemon_stop_downloading (PamacDaemon* self,
                                                 GVariant* parameters);
static void _dbus_handle_pamac_daemon_set_pkgreason_finished (PamacDaemon* self,
                                                       GVariant* parameters);
static void _dbus_handle_pamac_daemon_start_waiting (PamacDaemon* self,
                                              GVariant* parameters);
static void _dbus_handle_pamac_daemon_stop_waiting (PamacDaemon* self,
                                             GVariant* parameters);
static void _dbus_handle_pamac_daemon_download_pkgs_finished (PamacDaemon* self,
                                                       GVariant* parameters);
static void _dbus_handle_pamac_daemon_trans_refresh_finished (PamacDaemon* self,
                                                       GVariant* parameters);
static void _dbus_handle_pamac_daemon_trans_refresh_files_finished (PamacDaemon* self,
                                                             GVariant* parameters);
static void _dbus_handle_pamac_daemon_trans_refresh_aur_finished (PamacDaemon* self,
                                                           GVariant* parameters);
static void _dbus_handle_pamac_daemon_trans_run_finished (PamacDaemon* self,
                                                   GVariant* parameters);
static void _dbus_handle_pamac_daemon_download_updates_finished (PamacDaemon* self,
                                                          GVariant* parameters);
static void _dbus_handle_pamac_daemon_get_authorization_finished (PamacDaemon* self,
                                                           GVariant* parameters);
static void _dbus_handle_pamac_daemon_write_alpm_config_finished (PamacDaemon* self,
                                                           GVariant* parameters);
static void _dbus_handle_pamac_daemon_write_pamac_config_finished (PamacDaemon* self,
                                                            GVariant* parameters);
static void _dbus_handle_pamac_daemon_generate_mirrors_list_data (PamacDaemon* self,
                                                           GVariant* parameters);
static void _dbus_handle_pamac_daemon_generate_mirrors_list_finished (PamacDaemon* self,
                                                               GVariant* parameters);
static void _dbus_handle_pamac_daemon_clean_cache_finished (PamacDaemon* self,
                                                     GVariant* parameters);
static void _dbus_handle_pamac_daemon_clean_build_files_finished (PamacDaemon* self,
                                                           GVariant* parameters);
static void _dbus_handle_pamac_daemon_snap_trans_run_finished (PamacDaemon* self,
                                                        GVariant* parameters);
static void _dbus_handle_pamac_daemon_snap_switch_channel_finished (PamacDaemon* self,
                                                             GVariant* parameters);
static void _dbus_handle_pamac_daemon_flatpak_trans_run_finished (PamacDaemon* self,
                                                           GVariant* parameters);
static gchar* pamac_daemon_proxy_get_sender (PamacDaemon* self,
                                      GError** error);
static gchar* pamac_daemon_proxy_get_lockfile (PamacDaemon* self,
                                        GError** error);
static void pamac_daemon_proxy_set_environment_variables (PamacDaemon* self,
                                                   GHashTable* variables,
                                                   GError** error);
static void pamac_daemon_proxy_start_get_authorization (PamacDaemon* self,
                                                 GError** error);
static void pamac_daemon_proxy_remove_authorization (PamacDaemon* self,
                                              GError** error);
static void pamac_daemon_proxy_start_write_alpm_config (PamacDaemon* self,
                                                 GHashTable* new_alpm_conf,
                                                 GError** error);
static void pamac_daemon_proxy_start_write_pamac_config (PamacDaemon* self,
                                                  GHashTable* new_pamac_conf,
                                                  GError** error);
static void pamac_daemon_proxy_start_generate_mirrors_list (PamacDaemon* self,
                                                     const gchar* country,
                                                     GError** error);
static void pamac_daemon_proxy_start_clean_cache (PamacDaemon* self,
                                           gchar** filenames,
                                           gint filenames_length1,
                                           GError** error);
static void pamac_daemon_proxy_start_clean_build_files (PamacDaemon* self,
                                                 const gchar* aur_build_dir,
                                                 GError** error);
static void pamac_daemon_proxy_start_set_pkgreason (PamacDaemon* self,
                                             const gchar* pkgname,
                                             guint reason,
                                             GError** error);
static void pamac_daemon_proxy_start_download_updates (PamacDaemon* self,
                                                GError** error);
static void pamac_daemon_proxy_start_download_pkgs (PamacDaemon* self,
                                             gchar** urls,
                                             gint urls_length1,
                                             GError** error);
static void pamac_daemon_proxy_start_trans_refresh (PamacDaemon* self,
                                             gboolean force,
                                             GError** error);
static void pamac_daemon_proxy_start_trans_refresh_files (PamacDaemon* self,
                                                   gboolean force,
                                                   GError** error);
static void pamac_daemon_proxy_start_trans_refresh_aur (PamacDaemon* self,
                                                 gboolean force,
                                                 GError** error);
static void pamac_daemon_proxy_start_trans_run (PamacDaemon* self,
                                         gboolean sysupgrade,
                                         gboolean enable_downgrade,
                                         gboolean simple_install,
                                         gboolean keep_built_pkgs,
                                         gint trans_flags,
                                         gchar** to_install,
                                         gint to_install_length1,
                                         gchar** to_remove,
                                         gint to_remove_length1,
                                         gchar** to_load_local,
                                         gint to_load_local_length1,
                                         gchar** to_load_remote,
                                         gint to_load_remote_length1,
                                         gchar** to_install_as_dep,
                                         gint to_install_as_dep_length1,
                                         gchar** ignorepkgs,
                                         gint ignorepkgs_length1,
                                         gchar** overwrite_files,
                                         gint overwrite_files_length1,
                                         GError** error);
static void pamac_daemon_proxy_trans_cancel (PamacDaemon* self,
                                      GError** error);
static void pamac_daemon_proxy_quit (PamacDaemon* self,
                              GError** error);
static void pamac_daemon_proxy_start_snap_trans_run (PamacDaemon* self,
                                              gchar** to_install,
                                              gint to_install_length1,
                                              gchar** to_remove,
                                              gint to_remove_length1,
                                              GError** error);
static void pamac_daemon_proxy_start_snap_switch_channel (PamacDaemon* self,
                                                   const gchar* snap_name,
                                                   const gchar* channel,
                                                   GError** error);
static void pamac_daemon_proxy_start_flatpak_trans_run (PamacDaemon* self,
                                                 gchar** to_install,
                                                 gint to_install_length1,
                                                 gchar** to_remove,
                                                 gint to_remove_length1,
                                                 gchar** to_upgrade,
                                                 gint to_upgrade_length1,
                                                 GError** error);
static void pamac_daemon_proxy_pamac_daemon_interface_init (PamacDaemonIface* iface);
static void _dbus_pamac_daemon_get_sender (PamacDaemon* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_get_lockfile (PamacDaemon* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_set_environment_variables (PamacDaemon* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_get_authorization (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_remove_authorization (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_generate_mirrors_list (PamacDaemon* self,
                                                     GVariant* _parameters_,
                                                     GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_clean_cache (PamacDaemon* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_clean_build_files (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_set_pkgreason (PamacDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_download_updates (PamacDaemon* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_download_pkgs (PamacDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_trans_refresh (PamacDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_trans_refresh_files (PamacDaemon* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_trans_refresh_aur (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_trans_run (PamacDaemon* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_trans_cancel (PamacDaemon* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_quit (PamacDaemon* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_snap_trans_run (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_snap_switch_channel (PamacDaemon* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void _dbus_pamac_daemon_start_flatpak_trans_run (PamacDaemon* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void pamac_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data);
static GVariant* pamac_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GError** error,
                                                    gpointer user_data);
static gboolean pamac_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* property_name,
                                                   GVariant* value,
                                                   GError** error,
                                                   gpointer user_data);
static void _dbus_pamac_daemon_emit_action (GObject* _sender,
                                     const gchar* sender,
                                     const gchar* action,
                                     gpointer* _data);
static void _dbus_pamac_daemon_emit_action_progress (GObject* _sender,
                                              const gchar* sender,
                                              const gchar* action,
                                              const gchar* status,
                                              gdouble progress,
                                              gpointer* _data);
static void _dbus_pamac_daemon_emit_download_progress (GObject* _sender,
                                                const gchar* sender,
                                                const gchar* action,
                                                const gchar* status,
                                                gdouble progress,
                                                gpointer* _data);
static void _dbus_pamac_daemon_emit_hook_progress (GObject* _sender,
                                            const gchar* sender,
                                            const gchar* action,
                                            const gchar* details,
                                            const gchar* status,
                                            gdouble progress,
                                            gpointer* _data);
static void _dbus_pamac_daemon_emit_script_output (GObject* _sender,
                                            const gchar* sender,
                                            const gchar* message,
                                            gpointer* _data);
static void _dbus_pamac_daemon_emit_warning (GObject* _sender,
                                      const gchar* sender,
                                      const gchar* message,
                                      gpointer* _data);
static void _dbus_pamac_daemon_emit_error (GObject* _sender,
                                    const gchar* sender,
                                    const gchar* message,
                                    gchar** details,
                                    gint details_length1,
                                    gpointer* _data);
static void _dbus_pamac_daemon_important_details_outpout (GObject* _sender,
                                                   const gchar* sender,
                                                   gboolean must_show,
                                                   gpointer* _data);
static void _dbus_pamac_daemon_start_downloading (GObject* _sender,
                                           const gchar* sender,
                                           gpointer* _data);
static void _dbus_pamac_daemon_stop_downloading (GObject* _sender,
                                          const gchar* sender,
                                          gpointer* _data);
static void _dbus_pamac_daemon_set_pkgreason_finished (GObject* _sender,
                                                const gchar* sender,
                                                gboolean success,
                                                gpointer* _data);
static void _dbus_pamac_daemon_start_waiting (GObject* _sender,
                                       const gchar* sender,
                                       gpointer* _data);
static void _dbus_pamac_daemon_stop_waiting (GObject* _sender,
                                      const gchar* sender,
                                      gpointer* _data);
static void _dbus_pamac_daemon_download_pkgs_finished (GObject* _sender,
                                                const gchar* sender,
                                                gchar** dload_paths,
                                                gint dload_paths_length1,
                                                gpointer* _data);
static void _dbus_pamac_daemon_trans_refresh_finished (GObject* _sender,
                                                const gchar* sender,
                                                gboolean success,
                                                gpointer* _data);
static void _dbus_pamac_daemon_trans_refresh_files_finished (GObject* _sender,
                                                      const gchar* sender,
                                                      gboolean success,
                                                      gpointer* _data);
static void _dbus_pamac_daemon_trans_refresh_aur_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gboolean success,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_trans_run_finished (GObject* _sender,
                                            const gchar* sender,
                                            gboolean success,
                                            gpointer* _data);
static void _dbus_pamac_daemon_download_updates_finished (GObject* _sender,
                                                   const gchar* sender,
                                                   gboolean success,
                                                   gpointer* _data);
static void _dbus_pamac_daemon_get_authorization_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gboolean authorized,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_write_alpm_config_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_write_pamac_config_finished (GObject* _sender,
                                                     const gchar* sender,
                                                     gpointer* _data);
static void _dbus_pamac_daemon_generate_mirrors_list_data (GObject* _sender,
                                                    const gchar* sender,
                                                    const gchar* line,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_generate_mirrors_list_finished (GObject* _sender,
                                                        const gchar* sender,
                                                        gpointer* _data);
static void _dbus_pamac_daemon_clean_cache_finished (GObject* _sender,
                                              const gchar* sender,
                                              gboolean success,
                                              gpointer* _data);
static void _dbus_pamac_daemon_clean_build_files_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gboolean success,
                                                    gpointer* _data);
static void _dbus_pamac_daemon_snap_trans_run_finished (GObject* _sender,
                                                 const gchar* sender,
                                                 gboolean success,
                                                 gpointer* _data);
static void _dbus_pamac_daemon_snap_switch_channel_finished (GObject* _sender,
                                                      const gchar* sender,
                                                      gboolean success,
                                                      gpointer* _data);
static void _dbus_pamac_daemon_flatpak_trans_run_finished (GObject* _sender,
                                                    const gchar* sender,
                                                    gboolean success,
                                                    gpointer* _data);
static void _pamac_daemon_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _pamac_daemon_dbus_arg_info_get_sender_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_sender_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_sender_out[] = {&_pamac_daemon_dbus_arg_info_get_sender_result, NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_get_sender = {-1, "GetSender", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_sender_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_sender_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_get_lockfile_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_lockfile_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_lockfile_out[] = {&_pamac_daemon_dbus_arg_info_get_lockfile_result, NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_get_lockfile = {-1, "GetLockfile", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_lockfile_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_lockfile_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_set_environment_variables_variables = {-1, "variables", "a{ss}", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_set_environment_variables_in[] = {&_pamac_daemon_dbus_arg_info_set_environment_variables_variables, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_set_environment_variables_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_set_environment_variables = {-1, "SetEnvironmentVariables", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_set_environment_variables_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_set_environment_variables_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_get_authorization_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_get_authorization_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_get_authorization = {-1, "StartGetAuthorization", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_get_authorization_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_get_authorization_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_remove_authorization_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_remove_authorization_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_remove_authorization = {-1, "RemoveAuthorization", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_remove_authorization_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_remove_authorization_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_write_alpm_config_new_alpm_conf = {-1, "new_alpm_conf", "a{sv}", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_write_alpm_config_in[] = {&_pamac_daemon_dbus_arg_info_start_write_alpm_config_new_alpm_conf, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_write_alpm_config_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_write_alpm_config = {-1, "StartWriteAlpmConfig", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_write_alpm_config_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_write_alpm_config_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_write_pamac_config_new_pamac_conf = {-1, "new_pamac_conf", "a{sv}", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_write_pamac_config_in[] = {&_pamac_daemon_dbus_arg_info_start_write_pamac_config_new_pamac_conf, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_write_pamac_config_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_write_pamac_config = {-1, "StartWritePamacConfig", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_write_pamac_config_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_write_pamac_config_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_generate_mirrors_list_country = {-1, "country", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_generate_mirrors_list_in[] = {&_pamac_daemon_dbus_arg_info_start_generate_mirrors_list_country, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_generate_mirrors_list_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_generate_mirrors_list = {-1, "StartGenerateMirrorsList", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_generate_mirrors_list_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_generate_mirrors_list_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_clean_cache_filenames = {-1, "filenames", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_clean_cache_in[] = {&_pamac_daemon_dbus_arg_info_start_clean_cache_filenames, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_clean_cache_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_clean_cache = {-1, "StartCleanCache", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_clean_cache_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_clean_cache_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_clean_build_files_aur_build_dir = {-1, "aur_build_dir", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_clean_build_files_in[] = {&_pamac_daemon_dbus_arg_info_start_clean_build_files_aur_build_dir, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_clean_build_files_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_clean_build_files = {-1, "StartCleanBuildFiles", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_clean_build_files_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_clean_build_files_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_set_pkgreason_pkgname = {-1, "pkgname", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_set_pkgreason_reason = {-1, "reason", "u", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_set_pkgreason_in[] = {&_pamac_daemon_dbus_arg_info_start_set_pkgreason_pkgname, &_pamac_daemon_dbus_arg_info_start_set_pkgreason_reason, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_set_pkgreason_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_set_pkgreason = {-1, "StartSetPkgreason", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_set_pkgreason_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_set_pkgreason_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_download_updates_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_download_updates_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_download_updates = {-1, "StartDownloadUpdates", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_download_updates_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_download_updates_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_download_pkgs_urls = {-1, "urls", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_download_pkgs_in[] = {&_pamac_daemon_dbus_arg_info_start_download_pkgs_urls, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_download_pkgs_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_download_pkgs = {-1, "StartDownloadPkgs", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_download_pkgs_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_download_pkgs_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_refresh_force = {-1, "force", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_in[] = {&_pamac_daemon_dbus_arg_info_start_trans_refresh_force, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_trans_refresh = {-1, "StartTransRefresh", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_refresh_files_force = {-1, "force", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_files_in[] = {&_pamac_daemon_dbus_arg_info_start_trans_refresh_files_force, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_files_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_trans_refresh_files = {-1, "StartTransRefreshFiles", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_files_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_files_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_refresh_aur_force = {-1, "force", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_aur_in[] = {&_pamac_daemon_dbus_arg_info_start_trans_refresh_aur_force, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_refresh_aur_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_trans_refresh_aur = {-1, "StartTransRefreshAur", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_aur_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_refresh_aur_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_sysupgrade = {-1, "sysupgrade", "b", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_enable_downgrade = {-1, "enable_downgrade", "b", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_simple_install = {-1, "simple_install", "b", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_keep_built_pkgs = {-1, "keep_built_pkgs", "b", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_trans_flags = {-1, "trans_flags", "i", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_install = {-1, "to_install", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_remove = {-1, "to_remove", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_load_local = {-1, "to_load_local", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_load_remote = {-1, "to_load_remote", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_to_install_as_dep = {-1, "to_install_as_dep", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_ignorepkgs = {-1, "ignorepkgs", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_trans_run_overwrite_files = {-1, "overwrite_files", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_run_in[] = {&_pamac_daemon_dbus_arg_info_start_trans_run_sysupgrade, &_pamac_daemon_dbus_arg_info_start_trans_run_enable_downgrade, &_pamac_daemon_dbus_arg_info_start_trans_run_simple_install, &_pamac_daemon_dbus_arg_info_start_trans_run_keep_built_pkgs, &_pamac_daemon_dbus_arg_info_start_trans_run_trans_flags, &_pamac_daemon_dbus_arg_info_start_trans_run_to_install, &_pamac_daemon_dbus_arg_info_start_trans_run_to_remove, &_pamac_daemon_dbus_arg_info_start_trans_run_to_load_local, &_pamac_daemon_dbus_arg_info_start_trans_run_to_load_remote, &_pamac_daemon_dbus_arg_info_start_trans_run_to_install_as_dep, &_pamac_daemon_dbus_arg_info_start_trans_run_ignorepkgs, &_pamac_daemon_dbus_arg_info_start_trans_run_overwrite_files, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_trans_run_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_trans_run = {-1, "StartTransRun", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_run_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_trans_run_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_cancel_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_cancel_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_trans_cancel = {-1, "TransCancel", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_cancel_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_cancel_out), NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_quit_in[] = {NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_quit_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_quit = {-1, "Quit", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_quit_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_quit_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_snap_trans_run_to_install = {-1, "to_install", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_snap_trans_run_to_remove = {-1, "to_remove", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_snap_trans_run_in[] = {&_pamac_daemon_dbus_arg_info_start_snap_trans_run_to_install, &_pamac_daemon_dbus_arg_info_start_snap_trans_run_to_remove, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_snap_trans_run_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_snap_trans_run = {-1, "StartSnapTransRun", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_snap_trans_run_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_snap_trans_run_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_snap_switch_channel_snap_name = {-1, "snap_name", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_snap_switch_channel_channel = {-1, "channel", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_snap_switch_channel_in[] = {&_pamac_daemon_dbus_arg_info_start_snap_switch_channel_snap_name, &_pamac_daemon_dbus_arg_info_start_snap_switch_channel_channel, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_snap_switch_channel_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_snap_switch_channel = {-1, "StartSnapSwitchChannel", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_snap_switch_channel_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_snap_switch_channel_out), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_install = {-1, "to_install", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_remove = {-1, "to_remove", "as", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_upgrade = {-1, "to_upgrade", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_in[] = {&_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_install, &_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_remove, &_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_to_upgrade, NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_flatpak_trans_run_out[] = {NULL};
static const GDBusMethodInfo _pamac_daemon_dbus_method_info_start_flatpak_trans_run = {-1, "StartFlatpakTransRun", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_in), (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_flatpak_trans_run_out), NULL};
static const GDBusMethodInfo * const _pamac_daemon_dbus_method_info[] = {&_pamac_daemon_dbus_method_info_get_sender, &_pamac_daemon_dbus_method_info_get_lockfile, &_pamac_daemon_dbus_method_info_set_environment_variables, &_pamac_daemon_dbus_method_info_start_get_authorization, &_pamac_daemon_dbus_method_info_remove_authorization, &_pamac_daemon_dbus_method_info_start_write_alpm_config, &_pamac_daemon_dbus_method_info_start_write_pamac_config, &_pamac_daemon_dbus_method_info_start_generate_mirrors_list, &_pamac_daemon_dbus_method_info_start_clean_cache, &_pamac_daemon_dbus_method_info_start_clean_build_files, &_pamac_daemon_dbus_method_info_start_set_pkgreason, &_pamac_daemon_dbus_method_info_start_download_updates, &_pamac_daemon_dbus_method_info_start_download_pkgs, &_pamac_daemon_dbus_method_info_start_trans_refresh, &_pamac_daemon_dbus_method_info_start_trans_refresh_files, &_pamac_daemon_dbus_method_info_start_trans_refresh_aur, &_pamac_daemon_dbus_method_info_start_trans_run, &_pamac_daemon_dbus_method_info_trans_cancel, &_pamac_daemon_dbus_method_info_quit, &_pamac_daemon_dbus_method_info_start_snap_trans_run, &_pamac_daemon_dbus_method_info_start_snap_switch_channel, &_pamac_daemon_dbus_method_info_start_flatpak_trans_run, NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_action = {-1, "action", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_action[] = {&_pamac_daemon_dbus_arg_info_emit_action_sender, &_pamac_daemon_dbus_arg_info_emit_action_action, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_action = {-1, "EmitAction", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_action), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_progress_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_progress_action = {-1, "action", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_progress_status = {-1, "status", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_action_progress_progress = {-1, "progress", "d", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_action_progress[] = {&_pamac_daemon_dbus_arg_info_emit_action_progress_sender, &_pamac_daemon_dbus_arg_info_emit_action_progress_action, &_pamac_daemon_dbus_arg_info_emit_action_progress_status, &_pamac_daemon_dbus_arg_info_emit_action_progress_progress, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_action_progress = {-1, "EmitActionProgress", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_action_progress), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_download_progress_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_download_progress_action = {-1, "action", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_download_progress_status = {-1, "status", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_download_progress_progress = {-1, "progress", "d", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_download_progress[] = {&_pamac_daemon_dbus_arg_info_emit_download_progress_sender, &_pamac_daemon_dbus_arg_info_emit_download_progress_action, &_pamac_daemon_dbus_arg_info_emit_download_progress_status, &_pamac_daemon_dbus_arg_info_emit_download_progress_progress, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_download_progress = {-1, "EmitDownloadProgress", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_download_progress), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_action = {-1, "action", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_details = {-1, "details", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_status = {-1, "status", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_hook_progress_progress = {-1, "progress", "d", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_hook_progress[] = {&_pamac_daemon_dbus_arg_info_emit_hook_progress_sender, &_pamac_daemon_dbus_arg_info_emit_hook_progress_action, &_pamac_daemon_dbus_arg_info_emit_hook_progress_details, &_pamac_daemon_dbus_arg_info_emit_hook_progress_status, &_pamac_daemon_dbus_arg_info_emit_hook_progress_progress, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_hook_progress = {-1, "EmitHookProgress", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_hook_progress), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_script_output_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_script_output_message = {-1, "message", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_script_output[] = {&_pamac_daemon_dbus_arg_info_emit_script_output_sender, &_pamac_daemon_dbus_arg_info_emit_script_output_message, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_script_output = {-1, "EmitScriptOutput", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_script_output), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_warning_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_warning_message = {-1, "message", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_warning[] = {&_pamac_daemon_dbus_arg_info_emit_warning_sender, &_pamac_daemon_dbus_arg_info_emit_warning_message, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_warning = {-1, "EmitWarning", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_warning), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_error_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_error_message = {-1, "message", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_emit_error_details = {-1, "details", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_emit_error[] = {&_pamac_daemon_dbus_arg_info_emit_error_sender, &_pamac_daemon_dbus_arg_info_emit_error_message, &_pamac_daemon_dbus_arg_info_emit_error_details, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_emit_error = {-1, "EmitError", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_emit_error), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_important_details_outpout_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_important_details_outpout_must_show = {-1, "must_show", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_important_details_outpout[] = {&_pamac_daemon_dbus_arg_info_important_details_outpout_sender, &_pamac_daemon_dbus_arg_info_important_details_outpout_must_show, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_important_details_outpout = {-1, "ImportantDetailsOutpout", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_important_details_outpout), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_downloading_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_downloading[] = {&_pamac_daemon_dbus_arg_info_start_downloading_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_start_downloading = {-1, "StartDownloading", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_downloading), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_stop_downloading_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_stop_downloading[] = {&_pamac_daemon_dbus_arg_info_stop_downloading_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_stop_downloading = {-1, "StopDownloading", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_stop_downloading), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_set_pkgreason_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_set_pkgreason_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_set_pkgreason_finished[] = {&_pamac_daemon_dbus_arg_info_set_pkgreason_finished_sender, &_pamac_daemon_dbus_arg_info_set_pkgreason_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_set_pkgreason_finished = {-1, "SetPkgreasonFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_set_pkgreason_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_start_waiting_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_start_waiting[] = {&_pamac_daemon_dbus_arg_info_start_waiting_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_start_waiting = {-1, "StartWaiting", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_start_waiting), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_stop_waiting_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_stop_waiting[] = {&_pamac_daemon_dbus_arg_info_stop_waiting_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_stop_waiting = {-1, "StopWaiting", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_stop_waiting), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_download_pkgs_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_download_pkgs_finished_dload_paths = {-1, "dload_paths", "as", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_download_pkgs_finished[] = {&_pamac_daemon_dbus_arg_info_download_pkgs_finished_sender, &_pamac_daemon_dbus_arg_info_download_pkgs_finished_dload_paths, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_download_pkgs_finished = {-1, "DownloadPkgsFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_download_pkgs_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_refresh_finished[] = {&_pamac_daemon_dbus_arg_info_trans_refresh_finished_sender, &_pamac_daemon_dbus_arg_info_trans_refresh_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_trans_refresh_finished = {-1, "TransRefreshFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_refresh_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_files_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_files_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_refresh_files_finished[] = {&_pamac_daemon_dbus_arg_info_trans_refresh_files_finished_sender, &_pamac_daemon_dbus_arg_info_trans_refresh_files_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_trans_refresh_files_finished = {-1, "TransRefreshFilesFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_refresh_files_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_aur_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_refresh_aur_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_refresh_aur_finished[] = {&_pamac_daemon_dbus_arg_info_trans_refresh_aur_finished_sender, &_pamac_daemon_dbus_arg_info_trans_refresh_aur_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_trans_refresh_aur_finished = {-1, "TransRefreshAurFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_refresh_aur_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_run_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_trans_run_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_trans_run_finished[] = {&_pamac_daemon_dbus_arg_info_trans_run_finished_sender, &_pamac_daemon_dbus_arg_info_trans_run_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_trans_run_finished = {-1, "TransRunFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_trans_run_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_download_updates_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_download_updates_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_download_updates_finished[] = {&_pamac_daemon_dbus_arg_info_download_updates_finished_sender, &_pamac_daemon_dbus_arg_info_download_updates_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_download_updates_finished = {-1, "DownloadUpdatesFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_download_updates_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_get_authorization_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_get_authorization_finished_authorized = {-1, "authorized", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_get_authorization_finished[] = {&_pamac_daemon_dbus_arg_info_get_authorization_finished_sender, &_pamac_daemon_dbus_arg_info_get_authorization_finished_authorized, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_get_authorization_finished = {-1, "GetAuthorizationFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_get_authorization_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_write_alpm_config_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_write_alpm_config_finished[] = {&_pamac_daemon_dbus_arg_info_write_alpm_config_finished_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_write_alpm_config_finished = {-1, "WriteAlpmConfigFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_write_alpm_config_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_write_pamac_config_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_write_pamac_config_finished[] = {&_pamac_daemon_dbus_arg_info_write_pamac_config_finished_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_write_pamac_config_finished = {-1, "WritePamacConfigFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_write_pamac_config_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_generate_mirrors_list_data_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_generate_mirrors_list_data_line = {-1, "line", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_generate_mirrors_list_data[] = {&_pamac_daemon_dbus_arg_info_generate_mirrors_list_data_sender, &_pamac_daemon_dbus_arg_info_generate_mirrors_list_data_line, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_generate_mirrors_list_data = {-1, "GenerateMirrorsListData", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_generate_mirrors_list_data), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_generate_mirrors_list_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_generate_mirrors_list_finished[] = {&_pamac_daemon_dbus_arg_info_generate_mirrors_list_finished_sender, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_generate_mirrors_list_finished = {-1, "GenerateMirrorsListFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_generate_mirrors_list_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_clean_cache_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_clean_cache_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_clean_cache_finished[] = {&_pamac_daemon_dbus_arg_info_clean_cache_finished_sender, &_pamac_daemon_dbus_arg_info_clean_cache_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_clean_cache_finished = {-1, "CleanCacheFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_clean_cache_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_clean_build_files_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_clean_build_files_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_clean_build_files_finished[] = {&_pamac_daemon_dbus_arg_info_clean_build_files_finished_sender, &_pamac_daemon_dbus_arg_info_clean_build_files_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_clean_build_files_finished = {-1, "CleanBuildFilesFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_clean_build_files_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_snap_trans_run_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_snap_trans_run_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_snap_trans_run_finished[] = {&_pamac_daemon_dbus_arg_info_snap_trans_run_finished_sender, &_pamac_daemon_dbus_arg_info_snap_trans_run_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_snap_trans_run_finished = {-1, "SnapTransRunFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_snap_trans_run_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_snap_switch_channel_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_snap_switch_channel_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_snap_switch_channel_finished[] = {&_pamac_daemon_dbus_arg_info_snap_switch_channel_finished_sender, &_pamac_daemon_dbus_arg_info_snap_switch_channel_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_snap_switch_channel_finished = {-1, "SnapSwitchChannelFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_snap_switch_channel_finished), NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_flatpak_trans_run_finished_sender = {-1, "sender", "s", NULL};
static const GDBusArgInfo _pamac_daemon_dbus_arg_info_flatpak_trans_run_finished_success = {-1, "success", "b", NULL};
static const GDBusArgInfo * const _pamac_daemon_dbus_arg_info_flatpak_trans_run_finished[] = {&_pamac_daemon_dbus_arg_info_flatpak_trans_run_finished_sender, &_pamac_daemon_dbus_arg_info_flatpak_trans_run_finished_success, NULL};
static const GDBusSignalInfo _pamac_daemon_dbus_signal_info_flatpak_trans_run_finished = {-1, "FlatpakTransRunFinished", (GDBusArgInfo **) (&_pamac_daemon_dbus_arg_info_flatpak_trans_run_finished), NULL};
static const GDBusSignalInfo * const _pamac_daemon_dbus_signal_info[] = {&_pamac_daemon_dbus_signal_info_emit_action, &_pamac_daemon_dbus_signal_info_emit_action_progress, &_pamac_daemon_dbus_signal_info_emit_download_progress, &_pamac_daemon_dbus_signal_info_emit_hook_progress, &_pamac_daemon_dbus_signal_info_emit_script_output, &_pamac_daemon_dbus_signal_info_emit_warning, &_pamac_daemon_dbus_signal_info_emit_error, &_pamac_daemon_dbus_signal_info_important_details_outpout, &_pamac_daemon_dbus_signal_info_start_downloading, &_pamac_daemon_dbus_signal_info_stop_downloading, &_pamac_daemon_dbus_signal_info_set_pkgreason_finished, &_pamac_daemon_dbus_signal_info_start_waiting, &_pamac_daemon_dbus_signal_info_stop_waiting, &_pamac_daemon_dbus_signal_info_download_pkgs_finished, &_pamac_daemon_dbus_signal_info_trans_refresh_finished, &_pamac_daemon_dbus_signal_info_trans_refresh_files_finished, &_pamac_daemon_dbus_signal_info_trans_refresh_aur_finished, &_pamac_daemon_dbus_signal_info_trans_run_finished, &_pamac_daemon_dbus_signal_info_download_updates_finished, &_pamac_daemon_dbus_signal_info_get_authorization_finished, &_pamac_daemon_dbus_signal_info_write_alpm_config_finished, &_pamac_daemon_dbus_signal_info_write_pamac_config_finished, &_pamac_daemon_dbus_signal_info_generate_mirrors_list_data, &_pamac_daemon_dbus_signal_info_generate_mirrors_list_finished, &_pamac_daemon_dbus_signal_info_clean_cache_finished, &_pamac_daemon_dbus_signal_info_clean_build_files_finished, &_pamac_daemon_dbus_signal_info_snap_trans_run_finished, &_pamac_daemon_dbus_signal_info_snap_switch_channel_finished, &_pamac_daemon_dbus_signal_info_flatpak_trans_run_finished, NULL};
static const GDBusPropertyInfo * const _pamac_daemon_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pamac_daemon_dbus_interface_info = {-1, "org.manjaro.pamac.daemon", (GDBusMethodInfo **) (&_pamac_daemon_dbus_method_info), (GDBusSignalInfo **) (&_pamac_daemon_dbus_signal_info), (GDBusPropertyInfo **) (&_pamac_daemon_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pamac_daemon_dbus_interface_vtable = {pamac_daemon_dbus_interface_method_call, pamac_daemon_dbus_interface_get_property, pamac_daemon_dbus_interface_set_property};

gchar*
pamac_daemon_get_sender (PamacDaemon* self,
                         GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->get_sender) {
		return _iface_->get_sender (self, error);
	}
	return NULL;
}

gchar*
pamac_daemon_get_lockfile (PamacDaemon* self,
                           GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->get_lockfile) {
		return _iface_->get_lockfile (self, error);
	}
	return NULL;
}

void
pamac_daemon_set_environment_variables (PamacDaemon* self,
                                        GHashTable* variables,
                                        GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->set_environment_variables) {
		_iface_->set_environment_variables (self, variables, error);
	}
}

void
pamac_daemon_start_get_authorization (PamacDaemon* self,
                                      GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_get_authorization) {
		_iface_->start_get_authorization (self, error);
	}
}

void
pamac_daemon_remove_authorization (PamacDaemon* self,
                                   GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->remove_authorization) {
		_iface_->remove_authorization (self, error);
	}
}

void
pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                      GHashTable* new_alpm_conf,
                                      GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_write_alpm_config) {
		_iface_->start_write_alpm_config (self, new_alpm_conf, error);
	}
}

void
pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                       GHashTable* new_pamac_conf,
                                       GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_write_pamac_config) {
		_iface_->start_write_pamac_config (self, new_pamac_conf, error);
	}
}

void
pamac_daemon_start_generate_mirrors_list (PamacDaemon* self,
                                          const gchar* country,
                                          GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_generate_mirrors_list) {
		_iface_->start_generate_mirrors_list (self, country, error);
	}
}

void
pamac_daemon_start_clean_cache (PamacDaemon* self,
                                gchar** filenames,
                                gint filenames_length1,
                                GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_clean_cache) {
		_iface_->start_clean_cache (self, filenames, filenames_length1, error);
	}
}

void
pamac_daemon_start_clean_build_files (PamacDaemon* self,
                                      const gchar* aur_build_dir,
                                      GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_clean_build_files) {
		_iface_->start_clean_build_files (self, aur_build_dir, error);
	}
}

void
pamac_daemon_start_set_pkgreason (PamacDaemon* self,
                                  const gchar* pkgname,
                                  guint reason,
                                  GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_set_pkgreason) {
		_iface_->start_set_pkgreason (self, pkgname, reason, error);
	}
}

void
pamac_daemon_start_download_updates (PamacDaemon* self,
                                     GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_download_updates) {
		_iface_->start_download_updates (self, error);
	}
}

void
pamac_daemon_start_download_pkgs (PamacDaemon* self,
                                  gchar** urls,
                                  gint urls_length1,
                                  GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_download_pkgs) {
		_iface_->start_download_pkgs (self, urls, urls_length1, error);
	}
}

void
pamac_daemon_start_trans_refresh (PamacDaemon* self,
                                  gboolean force,
                                  GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_trans_refresh) {
		_iface_->start_trans_refresh (self, force, error);
	}
}

void
pamac_daemon_start_trans_refresh_files (PamacDaemon* self,
                                        gboolean force,
                                        GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_trans_refresh_files) {
		_iface_->start_trans_refresh_files (self, force, error);
	}
}

void
pamac_daemon_start_trans_refresh_aur (PamacDaemon* self,
                                      gboolean force,
                                      GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_trans_refresh_aur) {
		_iface_->start_trans_refresh_aur (self, force, error);
	}
}

void
pamac_daemon_start_trans_run (PamacDaemon* self,
                              gboolean sysupgrade,
                              gboolean enable_downgrade,
                              gboolean simple_install,
                              gboolean keep_built_pkgs,
                              gint trans_flags,
                              gchar** to_install,
                              gint to_install_length1,
                              gchar** to_remove,
                              gint to_remove_length1,
                              gchar** to_load_local,
                              gint to_load_local_length1,
                              gchar** to_load_remote,
                              gint to_load_remote_length1,
                              gchar** to_install_as_dep,
                              gint to_install_as_dep_length1,
                              gchar** ignorepkgs,
                              gint ignorepkgs_length1,
                              gchar** overwrite_files,
                              gint overwrite_files_length1,
                              GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_trans_run) {
		_iface_->start_trans_run (self, sysupgrade, enable_downgrade, simple_install, keep_built_pkgs, trans_flags, to_install, to_install_length1, to_remove, to_remove_length1, to_load_local, to_load_local_length1, to_load_remote, to_load_remote_length1, to_install_as_dep, to_install_as_dep_length1, ignorepkgs, ignorepkgs_length1, overwrite_files, overwrite_files_length1, error);
	}
}

void
pamac_daemon_trans_cancel (PamacDaemon* self,
                           GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->trans_cancel) {
		_iface_->trans_cancel (self, error);
	}
}

void
pamac_daemon_quit (PamacDaemon* self,
                   GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->quit) {
		_iface_->quit (self, error);
	}
}

void
pamac_daemon_start_snap_trans_run (PamacDaemon* self,
                                   gchar** to_install,
                                   gint to_install_length1,
                                   gchar** to_remove,
                                   gint to_remove_length1,
                                   GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_snap_trans_run) {
		_iface_->start_snap_trans_run (self, to_install, to_install_length1, to_remove, to_remove_length1, error);
	}
}

void
pamac_daemon_start_snap_switch_channel (PamacDaemon* self,
                                        const gchar* snap_name,
                                        const gchar* channel,
                                        GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_snap_switch_channel) {
		_iface_->start_snap_switch_channel (self, snap_name, channel, error);
	}
}

void
pamac_daemon_start_flatpak_trans_run (PamacDaemon* self,
                                      gchar** to_install,
                                      gint to_install_length1,
                                      gchar** to_remove,
                                      gint to_remove_length1,
                                      gchar** to_upgrade,
                                      gint to_upgrade_length1,
                                      GError** error)
{
	PamacDaemonIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PAMAC_DAEMON_GET_INTERFACE (self);
	if (_iface_->start_flatpak_trans_run) {
		_iface_->start_flatpak_trans_run (self, to_install, to_install_length1, to_remove, to_remove_length1, to_upgrade, to_upgrade_length1, error);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gdouble arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_double (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE (GClosure * closure,
                                                                  GValue * return_value,
                                                                  guint n_param_values,
                                                                  const GValue * param_values,
                                                                  gpointer invocation_hint,
                                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, const char* arg_4, gdouble arg_5, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING_STRING_DOUBLE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_double (param_values + 5), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_BOXED_INT (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_BOXED_INT) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__STRING_BOXED_INT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_INT) (gpointer data1, const char* arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
pamac_daemon_default_init (PamacDaemonIface * iface,
                           gpointer iface_data)
{
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_SIGNAL] = g_signal_new ("emit-action", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_ACTION_PROGRESS_SIGNAL] = g_signal_new ("emit-action-progress", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_DOWNLOAD_PROGRESS_SIGNAL] = g_signal_new ("emit-download-progress", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_HOOK_PROGRESS_SIGNAL] = g_signal_new ("emit-hook-progress", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING_STRING_DOUBLE, G_TYPE_NONE, 5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_DOUBLE);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_SCRIPT_OUTPUT_SIGNAL] = g_signal_new ("emit-script-output", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_WARNING_SIGNAL] = g_signal_new ("emit-warning", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_EMIT_ERROR_SIGNAL] = g_signal_new ("emit-error", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_INT);
	pamac_daemon_signals[PAMAC_DAEMON_IMPORTANT_DETAILS_OUTPOUT_SIGNAL] = g_signal_new ("important-details-outpout", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_START_DOWNLOADING_SIGNAL] = g_signal_new ("start-downloading", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_STOP_DOWNLOADING_SIGNAL] = g_signal_new ("stop-downloading", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_SET_PKGREASON_FINISHED_SIGNAL] = g_signal_new ("set-pkgreason-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_START_WAITING_SIGNAL] = g_signal_new ("start-waiting", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_STOP_WAITING_SIGNAL] = g_signal_new ("stop-waiting", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_PKGS_FINISHED_SIGNAL] = g_signal_new ("download-pkgs-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_INT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_INT);
	pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FINISHED_SIGNAL] = g_signal_new ("trans-refresh-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_FILES_FINISHED_SIGNAL] = g_signal_new ("trans-refresh-files-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_TRANS_REFRESH_AUR_FINISHED_SIGNAL] = g_signal_new ("trans-refresh-aur-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_TRANS_RUN_FINISHED_SIGNAL] = g_signal_new ("trans-run-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_DOWNLOAD_UPDATES_FINISHED_SIGNAL] = g_signal_new ("download-updates-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_GET_AUTHORIZATION_FINISHED_SIGNAL] = g_signal_new ("get-authorization-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_WRITE_ALPM_CONFIG_FINISHED_SIGNAL] = g_signal_new ("write-alpm-config-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_WRITE_PAMAC_CONFIG_FINISHED_SIGNAL] = g_signal_new ("write-pamac-config-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_GENERATE_MIRRORS_LIST_DATA_SIGNAL] = g_signal_new ("generate-mirrors-list-data", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_GENERATE_MIRRORS_LIST_FINISHED_SIGNAL] = g_signal_new ("generate-mirrors-list-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	pamac_daemon_signals[PAMAC_DAEMON_CLEAN_CACHE_FINISHED_SIGNAL] = g_signal_new ("clean-cache-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_CLEAN_BUILD_FILES_FINISHED_SIGNAL] = g_signal_new ("clean-build-files-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_SNAP_TRANS_RUN_FINISHED_SIGNAL] = g_signal_new ("snap-trans-run-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_SNAP_SWITCH_CHANNEL_FINISHED_SIGNAL] = g_signal_new ("snap-switch-channel-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	pamac_daemon_signals[PAMAC_DAEMON_FLATPAK_TRANS_RUN_FINISHED_SIGNAL] = g_signal_new ("flatpak-trans-run-finished", PAMAC_TYPE_DAEMON, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
}

static GType
pamac_daemon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacDaemonIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_daemon_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pamac_daemon_type_id;
	pamac_daemon_type_id = g_type_register_static (G_TYPE_INTERFACE, "PamacDaemon", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pamac_daemon_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (pamac_daemon_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pamac_daemon_proxy_get_type);
	g_type_set_qdata (pamac_daemon_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.manjaro.pamac.daemon");
	g_type_set_qdata (pamac_daemon_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_pamac_daemon_dbus_interface_info));
	g_type_set_qdata (pamac_daemon_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pamac_daemon_register_object);
	return pamac_daemon_type_id;
}

GType
pamac_daemon_get_type (void)
{
	static volatile gsize pamac_daemon_type_id__once = 0;
	if (g_once_init_enter (&pamac_daemon_type_id__once)) {
		GType pamac_daemon_type_id;
		pamac_daemon_type_id = pamac_daemon_get_type_once ();
		g_once_init_leave (&pamac_daemon_type_id__once, pamac_daemon_type_id);
	}
	return pamac_daemon_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PamacDaemonProxy, pamac_daemon_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PAMAC_TYPE_DAEMON, pamac_daemon_proxy_pamac_daemon_interface_init) )
static void
pamac_daemon_proxy_class_init (PamacDaemonProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = pamac_daemon_proxy_g_signal;
}

static void
_dbus_handle_pamac_daemon_emit_action (PamacDaemon* self,
                                       GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp0_;
	gchar* action = NULL;
	GVariant* _tmp1_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	g_signal_emit_by_name (self, "emit-action", sender, action);
	_g_free0 (sender);
	_g_free0 (action);
}

static void
_dbus_handle_pamac_daemon_emit_action_progress (PamacDaemon* self,
                                                GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp2_;
	gchar* action = NULL;
	GVariant* _tmp3_;
	gchar* status = NULL;
	GVariant* _tmp4_;
	gdouble progress = 0.0;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	status = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	progress = g_variant_get_double (_tmp5_);
	g_variant_unref (_tmp5_);
	g_signal_emit_by_name (self, "emit-action-progress", sender, action, status, progress);
	_g_free0 (sender);
	_g_free0 (action);
	_g_free0 (status);
}

static void
_dbus_handle_pamac_daemon_emit_download_progress (PamacDaemon* self,
                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp6_;
	gchar* action = NULL;
	GVariant* _tmp7_;
	gchar* status = NULL;
	GVariant* _tmp8_;
	gdouble progress = 0.0;
	GVariant* _tmp9_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	status = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	progress = g_variant_get_double (_tmp9_);
	g_variant_unref (_tmp9_);
	g_signal_emit_by_name (self, "emit-download-progress", sender, action, status, progress);
	_g_free0 (sender);
	_g_free0 (action);
	_g_free0 (status);
}

static void
_dbus_handle_pamac_daemon_emit_hook_progress (PamacDaemon* self,
                                              GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp10_;
	gchar* action = NULL;
	GVariant* _tmp11_;
	gchar* details = NULL;
	GVariant* _tmp12_;
	gchar* status = NULL;
	GVariant* _tmp13_;
	gdouble progress = 0.0;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp10_, NULL);
	g_variant_unref (_tmp10_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_dup_string (_tmp11_, NULL);
	g_variant_unref (_tmp11_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	details = g_variant_dup_string (_tmp12_, NULL);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	status = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	progress = g_variant_get_double (_tmp14_);
	g_variant_unref (_tmp14_);
	g_signal_emit_by_name (self, "emit-hook-progress", sender, action, details, status, progress);
	_g_free0 (sender);
	_g_free0 (action);
	_g_free0 (details);
	_g_free0 (status);
}

static void
_dbus_handle_pamac_daemon_emit_script_output (PamacDaemon* self,
                                              GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp15_;
	gchar* message = NULL;
	GVariant* _tmp16_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	message = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	g_signal_emit_by_name (self, "emit-script-output", sender, message);
	_g_free0 (sender);
	_g_free0 (message);
}

static void
_dbus_handle_pamac_daemon_emit_warning (PamacDaemon* self,
                                        GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp17_;
	gchar* message = NULL;
	GVariant* _tmp18_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp17_, NULL);
	g_variant_unref (_tmp17_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	message = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	g_signal_emit_by_name (self, "emit-warning", sender, message);
	_g_free0 (sender);
	_g_free0 (message);
}

static void
_dbus_handle_pamac_daemon_emit_error (PamacDaemon* self,
                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp19_;
	gchar* message = NULL;
	GVariant* _tmp20_;
	gchar** details = NULL;
	gint details_length1;
	GVariant* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length;
	gint _tmp22__size;
	gint _tmp22__length1;
	GVariantIter _tmp23_;
	GVariant* _tmp24_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp19_, NULL);
	g_variant_unref (_tmp19_);
	_tmp20_ = g_variant_iter_next_value (&_arguments_iter);
	message = g_variant_dup_string (_tmp20_, NULL);
	g_variant_unref (_tmp20_);
	details_length1 = 0;
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp22_ = g_new (gchar*, 5);
	_tmp22__length = 0;
	_tmp22__size = 4;
	_tmp22__length1 = 0;
	g_variant_iter_init (&_tmp23_, _tmp21_);
	for (; (_tmp24_ = g_variant_iter_next_value (&_tmp23_)) != NULL; _tmp22__length1++) {
		if (_tmp22__size == _tmp22__length) {
			_tmp22__size = 2 * _tmp22__size;
			_tmp22_ = g_renew (gchar*, _tmp22_, _tmp22__size + 1);
		}
		_tmp22_[_tmp22__length++] = g_variant_dup_string (_tmp24_, NULL);
		g_variant_unref (_tmp24_);
	}
	details_length1 = _tmp22__length1;
	_tmp22_[_tmp22__length] = NULL;
	details = _tmp22_;
	g_variant_unref (_tmp21_);
	g_signal_emit_by_name (self, "emit-error", sender, message, details, details_length1);
	_g_free0 (sender);
	_g_free0 (message);
	details = (_vala_array_free (details, details_length1, (GDestroyNotify) g_free), NULL);
}

static void
_dbus_handle_pamac_daemon_important_details_outpout (PamacDaemon* self,
                                                     GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp25_;
	gboolean must_show = FALSE;
	GVariant* _tmp26_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp25_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp25_, NULL);
	g_variant_unref (_tmp25_);
	_tmp26_ = g_variant_iter_next_value (&_arguments_iter);
	must_show = g_variant_get_boolean (_tmp26_);
	g_variant_unref (_tmp26_);
	g_signal_emit_by_name (self, "important-details-outpout", sender, must_show);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_start_downloading (PamacDaemon* self,
                                             GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp27_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	g_signal_emit_by_name (self, "start-downloading", sender);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_stop_downloading (PamacDaemon* self,
                                            GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp28_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	g_signal_emit_by_name (self, "stop-downloading", sender);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_set_pkgreason_finished (PamacDaemon* self,
                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp29_;
	gboolean success = FALSE;
	GVariant* _tmp30_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp29_, NULL);
	g_variant_unref (_tmp29_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp30_);
	g_variant_unref (_tmp30_);
	g_signal_emit_by_name (self, "set-pkgreason-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_start_waiting (PamacDaemon* self,
                                         GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp31_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp31_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp31_, NULL);
	g_variant_unref (_tmp31_);
	g_signal_emit_by_name (self, "start-waiting", sender);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_stop_waiting (PamacDaemon* self,
                                        GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp32_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp32_, NULL);
	g_variant_unref (_tmp32_);
	g_signal_emit_by_name (self, "stop-waiting", sender);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_download_pkgs_finished (PamacDaemon* self,
                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp33_;
	gchar** dload_paths = NULL;
	gint dload_paths_length1;
	GVariant* _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length;
	gint _tmp35__size;
	gint _tmp35__length1;
	GVariantIter _tmp36_;
	GVariant* _tmp37_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp33_, NULL);
	g_variant_unref (_tmp33_);
	dload_paths_length1 = 0;
	_tmp34_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp35_ = g_new (gchar*, 5);
	_tmp35__length = 0;
	_tmp35__size = 4;
	_tmp35__length1 = 0;
	g_variant_iter_init (&_tmp36_, _tmp34_);
	for (; (_tmp37_ = g_variant_iter_next_value (&_tmp36_)) != NULL; _tmp35__length1++) {
		if (_tmp35__size == _tmp35__length) {
			_tmp35__size = 2 * _tmp35__size;
			_tmp35_ = g_renew (gchar*, _tmp35_, _tmp35__size + 1);
		}
		_tmp35_[_tmp35__length++] = g_variant_dup_string (_tmp37_, NULL);
		g_variant_unref (_tmp37_);
	}
	dload_paths_length1 = _tmp35__length1;
	_tmp35_[_tmp35__length] = NULL;
	dload_paths = _tmp35_;
	g_variant_unref (_tmp34_);
	g_signal_emit_by_name (self, "download-pkgs-finished", sender, dload_paths, dload_paths_length1);
	_g_free0 (sender);
	dload_paths = (_vala_array_free (dload_paths, dload_paths_length1, (GDestroyNotify) g_free), NULL);
}

static void
_dbus_handle_pamac_daemon_trans_refresh_finished (PamacDaemon* self,
                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp38_;
	gboolean success = FALSE;
	GVariant* _tmp39_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp38_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp38_, NULL);
	g_variant_unref (_tmp38_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp39_);
	g_variant_unref (_tmp39_);
	g_signal_emit_by_name (self, "trans-refresh-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_trans_refresh_files_finished (PamacDaemon* self,
                                                        GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp40_;
	gboolean success = FALSE;
	GVariant* _tmp41_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp40_, NULL);
	g_variant_unref (_tmp40_);
	_tmp41_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp41_);
	g_variant_unref (_tmp41_);
	g_signal_emit_by_name (self, "trans-refresh-files-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_trans_refresh_aur_finished (PamacDaemon* self,
                                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp42_;
	gboolean success = FALSE;
	GVariant* _tmp43_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp42_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp42_, NULL);
	g_variant_unref (_tmp42_);
	_tmp43_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp43_);
	g_variant_unref (_tmp43_);
	g_signal_emit_by_name (self, "trans-refresh-aur-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_trans_run_finished (PamacDaemon* self,
                                              GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp44_;
	gboolean success = FALSE;
	GVariant* _tmp45_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp44_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp44_, NULL);
	g_variant_unref (_tmp44_);
	_tmp45_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp45_);
	g_variant_unref (_tmp45_);
	g_signal_emit_by_name (self, "trans-run-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_download_updates_finished (PamacDaemon* self,
                                                     GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp46_;
	gboolean success = FALSE;
	GVariant* _tmp47_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp46_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp46_, NULL);
	g_variant_unref (_tmp46_);
	_tmp47_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp47_);
	g_variant_unref (_tmp47_);
	g_signal_emit_by_name (self, "download-updates-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_get_authorization_finished (PamacDaemon* self,
                                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp48_;
	gboolean authorized = FALSE;
	GVariant* _tmp49_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp48_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp48_, NULL);
	g_variant_unref (_tmp48_);
	_tmp49_ = g_variant_iter_next_value (&_arguments_iter);
	authorized = g_variant_get_boolean (_tmp49_);
	g_variant_unref (_tmp49_);
	g_signal_emit_by_name (self, "get-authorization-finished", sender, authorized);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_write_alpm_config_finished (PamacDaemon* self,
                                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp50_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp50_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp50_, NULL);
	g_variant_unref (_tmp50_);
	g_signal_emit_by_name (self, "write-alpm-config-finished", sender);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_write_pamac_config_finished (PamacDaemon* self,
                                                       GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp51_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp51_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp51_, NULL);
	g_variant_unref (_tmp51_);
	g_signal_emit_by_name (self, "write-pamac-config-finished", sender);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_generate_mirrors_list_data (PamacDaemon* self,
                                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp52_;
	gchar* line = NULL;
	GVariant* _tmp53_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp52_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp52_, NULL);
	g_variant_unref (_tmp52_);
	_tmp53_ = g_variant_iter_next_value (&_arguments_iter);
	line = g_variant_dup_string (_tmp53_, NULL);
	g_variant_unref (_tmp53_);
	g_signal_emit_by_name (self, "generate-mirrors-list-data", sender, line);
	_g_free0 (sender);
	_g_free0 (line);
}

static void
_dbus_handle_pamac_daemon_generate_mirrors_list_finished (PamacDaemon* self,
                                                          GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp54_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp54_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp54_, NULL);
	g_variant_unref (_tmp54_);
	g_signal_emit_by_name (self, "generate-mirrors-list-finished", sender);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_clean_cache_finished (PamacDaemon* self,
                                                GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp55_;
	gboolean success = FALSE;
	GVariant* _tmp56_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp55_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp55_, NULL);
	g_variant_unref (_tmp55_);
	_tmp56_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp56_);
	g_variant_unref (_tmp56_);
	g_signal_emit_by_name (self, "clean-cache-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_clean_build_files_finished (PamacDaemon* self,
                                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp57_;
	gboolean success = FALSE;
	GVariant* _tmp58_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp57_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp57_, NULL);
	g_variant_unref (_tmp57_);
	_tmp58_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp58_);
	g_variant_unref (_tmp58_);
	g_signal_emit_by_name (self, "clean-build-files-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_snap_trans_run_finished (PamacDaemon* self,
                                                   GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp59_;
	gboolean success = FALSE;
	GVariant* _tmp60_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp59_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp59_, NULL);
	g_variant_unref (_tmp59_);
	_tmp60_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp60_);
	g_variant_unref (_tmp60_);
	g_signal_emit_by_name (self, "snap-trans-run-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_snap_switch_channel_finished (PamacDaemon* self,
                                                        GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp61_;
	gboolean success = FALSE;
	GVariant* _tmp62_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp61_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp61_, NULL);
	g_variant_unref (_tmp61_);
	_tmp62_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp62_);
	g_variant_unref (_tmp62_);
	g_signal_emit_by_name (self, "snap-switch-channel-finished", sender, success);
	_g_free0 (sender);
}

static void
_dbus_handle_pamac_daemon_flatpak_trans_run_finished (PamacDaemon* self,
                                                      GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gchar* sender = NULL;
	GVariant* _tmp63_;
	gboolean success = FALSE;
	GVariant* _tmp64_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp63_ = g_variant_iter_next_value (&_arguments_iter);
	sender = g_variant_dup_string (_tmp63_, NULL);
	g_variant_unref (_tmp63_);
	_tmp64_ = g_variant_iter_next_value (&_arguments_iter);
	success = g_variant_get_boolean (_tmp64_);
	g_variant_unref (_tmp64_);
	g_signal_emit_by_name (self, "flatpak-trans-run-finished", sender, success);
	_g_free0 (sender);
}

static void
pamac_daemon_proxy_g_signal (GDBusProxy* proxy,
                             const gchar* sender_name,
                             const gchar* signal_name,
                             GVariant* parameters)
{
	if (strcmp (signal_name, "EmitAction") == 0) {
		_dbus_handle_pamac_daemon_emit_action ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "EmitActionProgress") == 0) {
		_dbus_handle_pamac_daemon_emit_action_progress ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "EmitDownloadProgress") == 0) {
		_dbus_handle_pamac_daemon_emit_download_progress ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "EmitHookProgress") == 0) {
		_dbus_handle_pamac_daemon_emit_hook_progress ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "EmitScriptOutput") == 0) {
		_dbus_handle_pamac_daemon_emit_script_output ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "EmitWarning") == 0) {
		_dbus_handle_pamac_daemon_emit_warning ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "EmitError") == 0) {
		_dbus_handle_pamac_daemon_emit_error ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "ImportantDetailsOutpout") == 0) {
		_dbus_handle_pamac_daemon_important_details_outpout ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "StartDownloading") == 0) {
		_dbus_handle_pamac_daemon_start_downloading ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "StopDownloading") == 0) {
		_dbus_handle_pamac_daemon_stop_downloading ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "SetPkgreasonFinished") == 0) {
		_dbus_handle_pamac_daemon_set_pkgreason_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "StartWaiting") == 0) {
		_dbus_handle_pamac_daemon_start_waiting ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "StopWaiting") == 0) {
		_dbus_handle_pamac_daemon_stop_waiting ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "DownloadPkgsFinished") == 0) {
		_dbus_handle_pamac_daemon_download_pkgs_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "TransRefreshFinished") == 0) {
		_dbus_handle_pamac_daemon_trans_refresh_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "TransRefreshFilesFinished") == 0) {
		_dbus_handle_pamac_daemon_trans_refresh_files_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "TransRefreshAurFinished") == 0) {
		_dbus_handle_pamac_daemon_trans_refresh_aur_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "TransRunFinished") == 0) {
		_dbus_handle_pamac_daemon_trans_run_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "DownloadUpdatesFinished") == 0) {
		_dbus_handle_pamac_daemon_download_updates_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "GetAuthorizationFinished") == 0) {
		_dbus_handle_pamac_daemon_get_authorization_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "WriteAlpmConfigFinished") == 0) {
		_dbus_handle_pamac_daemon_write_alpm_config_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "WritePamacConfigFinished") == 0) {
		_dbus_handle_pamac_daemon_write_pamac_config_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "GenerateMirrorsListData") == 0) {
		_dbus_handle_pamac_daemon_generate_mirrors_list_data ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "GenerateMirrorsListFinished") == 0) {
		_dbus_handle_pamac_daemon_generate_mirrors_list_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "CleanCacheFinished") == 0) {
		_dbus_handle_pamac_daemon_clean_cache_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "CleanBuildFilesFinished") == 0) {
		_dbus_handle_pamac_daemon_clean_build_files_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "SnapTransRunFinished") == 0) {
		_dbus_handle_pamac_daemon_snap_trans_run_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "SnapSwitchChannelFinished") == 0) {
		_dbus_handle_pamac_daemon_snap_switch_channel_finished ((PamacDaemon*) proxy, parameters);
	} else if (strcmp (signal_name, "FlatpakTransRunFinished") == 0) {
		_dbus_handle_pamac_daemon_flatpak_trans_run_finished ((PamacDaemon*) proxy, parameters);
	}
}

static void
pamac_daemon_proxy_init (PamacDaemonProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_pamac_daemon_dbus_interface_info));
}

static gchar*
pamac_daemon_proxy_get_sender (PamacDaemon* self,
                               GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp65_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "GetSender");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp65_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp65_, NULL);
	g_variant_unref (_tmp65_);
	g_object_unref (_reply_message);
	return _result;
}

static gchar*
pamac_daemon_proxy_get_lockfile (PamacDaemon* self,
                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp66_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "GetLockfile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp66_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp66_, NULL);
	g_variant_unref (_tmp66_);
	g_object_unref (_reply_message);
	return _result;
}

static void
pamac_daemon_proxy_set_environment_variables (PamacDaemon* self,
                                              GHashTable* variables,
                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp67_;
	GHashTableIter _tmp68_;
	gpointer _tmp69_;
	gpointer _tmp70_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "SetEnvironmentVariables");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp68_, variables);
	g_variant_builder_init (&_tmp67_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp68_, &_tmp69_, &_tmp70_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp69_;
		_value = (gchar*) _tmp70_;
		g_variant_builder_add (&_tmp67_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp67_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_get_authorization (PamacDaemon* self,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartGetAuthorization");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_remove_authorization (PamacDaemon* self,
                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "RemoveAuthorization");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_write_alpm_config (PamacDaemon* self,
                                            GHashTable* new_alpm_conf,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp71_;
	GHashTableIter _tmp72_;
	gpointer _tmp73_;
	gpointer _tmp74_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartWriteAlpmConfig");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp72_, new_alpm_conf);
	g_variant_builder_init (&_tmp71_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp72_, &_tmp73_, &_tmp74_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp73_;
		_value = (GVariant*) _tmp74_;
		g_variant_builder_add (&_tmp71_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp71_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_write_pamac_config (PamacDaemon* self,
                                             GHashTable* new_pamac_conf,
                                             GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp75_;
	GHashTableIter _tmp76_;
	gpointer _tmp77_;
	gpointer _tmp78_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartWritePamacConfig");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp76_, new_pamac_conf);
	g_variant_builder_init (&_tmp75_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp76_, &_tmp77_, &_tmp78_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp77_;
		_value = (GVariant*) _tmp78_;
		g_variant_builder_add (&_tmp75_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp75_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_generate_mirrors_list (PamacDaemon* self,
                                                const gchar* country,
                                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartGenerateMirrorsList");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (country));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_clean_cache (PamacDaemon* self,
                                      gchar** filenames,
                                      gint filenames_length1,
                                      GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp79_;
	GVariantBuilder _tmp80_;
	gint _tmp81_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartCleanCache");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp79_ = filenames;
	g_variant_builder_init (&_tmp80_, G_VARIANT_TYPE ("as"));
	for (_tmp81_ = 0; _tmp81_ < filenames_length1; _tmp81_++) {
		g_variant_builder_add_value (&_tmp80_, g_variant_new_string (*_tmp79_));
		_tmp79_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp80_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_clean_build_files (PamacDaemon* self,
                                            const gchar* aur_build_dir,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartCleanBuildFiles");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (aur_build_dir));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_set_pkgreason (PamacDaemon* self,
                                        const gchar* pkgname,
                                        guint reason,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartSetPkgreason");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (pkgname));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_download_updates (PamacDaemon* self,
                                           GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartDownloadUpdates");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_download_pkgs (PamacDaemon* self,
                                        gchar** urls,
                                        gint urls_length1,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp82_;
	GVariantBuilder _tmp83_;
	gint _tmp84_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartDownloadPkgs");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp82_ = urls;
	g_variant_builder_init (&_tmp83_, G_VARIANT_TYPE ("as"));
	for (_tmp84_ = 0; _tmp84_ < urls_length1; _tmp84_++) {
		g_variant_builder_add_value (&_tmp83_, g_variant_new_string (*_tmp82_));
		_tmp82_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp83_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_trans_refresh (PamacDaemon* self,
                                        gboolean force,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartTransRefresh");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (force));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_trans_refresh_files (PamacDaemon* self,
                                              gboolean force,
                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartTransRefreshFiles");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (force));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_trans_refresh_aur (PamacDaemon* self,
                                            gboolean force,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartTransRefreshAur");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (force));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_trans_run (PamacDaemon* self,
                                    gboolean sysupgrade,
                                    gboolean enable_downgrade,
                                    gboolean simple_install,
                                    gboolean keep_built_pkgs,
                                    gint trans_flags,
                                    gchar** to_install,
                                    gint to_install_length1,
                                    gchar** to_remove,
                                    gint to_remove_length1,
                                    gchar** to_load_local,
                                    gint to_load_local_length1,
                                    gchar** to_load_remote,
                                    gint to_load_remote_length1,
                                    gchar** to_install_as_dep,
                                    gint to_install_as_dep_length1,
                                    gchar** ignorepkgs,
                                    gint ignorepkgs_length1,
                                    gchar** overwrite_files,
                                    gint overwrite_files_length1,
                                    GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp85_;
	GVariantBuilder _tmp86_;
	gint _tmp87_;
	gchar** _tmp88_;
	GVariantBuilder _tmp89_;
	gint _tmp90_;
	gchar** _tmp91_;
	GVariantBuilder _tmp92_;
	gint _tmp93_;
	gchar** _tmp94_;
	GVariantBuilder _tmp95_;
	gint _tmp96_;
	gchar** _tmp97_;
	GVariantBuilder _tmp98_;
	gint _tmp99_;
	gchar** _tmp100_;
	GVariantBuilder _tmp101_;
	gint _tmp102_;
	gchar** _tmp103_;
	GVariantBuilder _tmp104_;
	gint _tmp105_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartTransRun");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (sysupgrade));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (enable_downgrade));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (simple_install));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (keep_built_pkgs));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (trans_flags));
	_tmp85_ = to_install;
	g_variant_builder_init (&_tmp86_, G_VARIANT_TYPE ("as"));
	for (_tmp87_ = 0; _tmp87_ < to_install_length1; _tmp87_++) {
		g_variant_builder_add_value (&_tmp86_, g_variant_new_string (*_tmp85_));
		_tmp85_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp86_));
	_tmp88_ = to_remove;
	g_variant_builder_init (&_tmp89_, G_VARIANT_TYPE ("as"));
	for (_tmp90_ = 0; _tmp90_ < to_remove_length1; _tmp90_++) {
		g_variant_builder_add_value (&_tmp89_, g_variant_new_string (*_tmp88_));
		_tmp88_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp89_));
	_tmp91_ = to_load_local;
	g_variant_builder_init (&_tmp92_, G_VARIANT_TYPE ("as"));
	for (_tmp93_ = 0; _tmp93_ < to_load_local_length1; _tmp93_++) {
		g_variant_builder_add_value (&_tmp92_, g_variant_new_string (*_tmp91_));
		_tmp91_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp92_));
	_tmp94_ = to_load_remote;
	g_variant_builder_init (&_tmp95_, G_VARIANT_TYPE ("as"));
	for (_tmp96_ = 0; _tmp96_ < to_load_remote_length1; _tmp96_++) {
		g_variant_builder_add_value (&_tmp95_, g_variant_new_string (*_tmp94_));
		_tmp94_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp95_));
	_tmp97_ = to_install_as_dep;
	g_variant_builder_init (&_tmp98_, G_VARIANT_TYPE ("as"));
	for (_tmp99_ = 0; _tmp99_ < to_install_as_dep_length1; _tmp99_++) {
		g_variant_builder_add_value (&_tmp98_, g_variant_new_string (*_tmp97_));
		_tmp97_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp98_));
	_tmp100_ = ignorepkgs;
	g_variant_builder_init (&_tmp101_, G_VARIANT_TYPE ("as"));
	for (_tmp102_ = 0; _tmp102_ < ignorepkgs_length1; _tmp102_++) {
		g_variant_builder_add_value (&_tmp101_, g_variant_new_string (*_tmp100_));
		_tmp100_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp101_));
	_tmp103_ = overwrite_files;
	g_variant_builder_init (&_tmp104_, G_VARIANT_TYPE ("as"));
	for (_tmp105_ = 0; _tmp105_ < overwrite_files_length1; _tmp105_++) {
		g_variant_builder_add_value (&_tmp104_, g_variant_new_string (*_tmp103_));
		_tmp103_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp104_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_trans_cancel (PamacDaemon* self,
                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "TransCancel");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_quit (PamacDaemon* self,
                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "Quit");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
	g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, error);
	g_object_unref (_message);
}

static void
pamac_daemon_proxy_start_snap_trans_run (PamacDaemon* self,
                                         gchar** to_install,
                                         gint to_install_length1,
                                         gchar** to_remove,
                                         gint to_remove_length1,
                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp106_;
	GVariantBuilder _tmp107_;
	gint _tmp108_;
	gchar** _tmp109_;
	GVariantBuilder _tmp110_;
	gint _tmp111_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartSnapTransRun");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp106_ = to_install;
	g_variant_builder_init (&_tmp107_, G_VARIANT_TYPE ("as"));
	for (_tmp108_ = 0; _tmp108_ < to_install_length1; _tmp108_++) {
		g_variant_builder_add_value (&_tmp107_, g_variant_new_string (*_tmp106_));
		_tmp106_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp107_));
	_tmp109_ = to_remove;
	g_variant_builder_init (&_tmp110_, G_VARIANT_TYPE ("as"));
	for (_tmp111_ = 0; _tmp111_ < to_remove_length1; _tmp111_++) {
		g_variant_builder_add_value (&_tmp110_, g_variant_new_string (*_tmp109_));
		_tmp109_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp110_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_snap_switch_channel (PamacDaemon* self,
                                              const gchar* snap_name,
                                              const gchar* channel,
                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartSnapSwitchChannel");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (snap_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (channel));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_start_flatpak_trans_run (PamacDaemon* self,
                                            gchar** to_install,
                                            gint to_install_length1,
                                            gchar** to_remove,
                                            gint to_remove_length1,
                                            gchar** to_upgrade,
                                            gint to_upgrade_length1,
                                            GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp112_;
	GVariantBuilder _tmp113_;
	gint _tmp114_;
	gchar** _tmp115_;
	GVariantBuilder _tmp116_;
	gint _tmp117_;
	gchar** _tmp118_;
	GVariantBuilder _tmp119_;
	gint _tmp120_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.manjaro.pamac.daemon", "StartFlatpakTransRun");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp112_ = to_install;
	g_variant_builder_init (&_tmp113_, G_VARIANT_TYPE ("as"));
	for (_tmp114_ = 0; _tmp114_ < to_install_length1; _tmp114_++) {
		g_variant_builder_add_value (&_tmp113_, g_variant_new_string (*_tmp112_));
		_tmp112_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp113_));
	_tmp115_ = to_remove;
	g_variant_builder_init (&_tmp116_, G_VARIANT_TYPE ("as"));
	for (_tmp117_ = 0; _tmp117_ < to_remove_length1; _tmp117_++) {
		g_variant_builder_add_value (&_tmp116_, g_variant_new_string (*_tmp115_));
		_tmp115_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp116_));
	_tmp118_ = to_upgrade;
	g_variant_builder_init (&_tmp119_, G_VARIANT_TYPE ("as"));
	for (_tmp120_ = 0; _tmp120_ < to_upgrade_length1; _tmp120_++) {
		g_variant_builder_add_value (&_tmp119_, g_variant_new_string (*_tmp118_));
		_tmp118_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp119_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pamac_daemon_proxy_pamac_daemon_interface_init (PamacDaemonIface* iface)
{
	iface->get_sender = pamac_daemon_proxy_get_sender;
	iface->get_lockfile = pamac_daemon_proxy_get_lockfile;
	iface->set_environment_variables = pamac_daemon_proxy_set_environment_variables;
	iface->start_get_authorization = pamac_daemon_proxy_start_get_authorization;
	iface->remove_authorization = pamac_daemon_proxy_remove_authorization;
	iface->start_write_alpm_config = pamac_daemon_proxy_start_write_alpm_config;
	iface->start_write_pamac_config = pamac_daemon_proxy_start_write_pamac_config;
	iface->start_generate_mirrors_list = pamac_daemon_proxy_start_generate_mirrors_list;
	iface->start_clean_cache = pamac_daemon_proxy_start_clean_cache;
	iface->start_clean_build_files = pamac_daemon_proxy_start_clean_build_files;
	iface->start_set_pkgreason = pamac_daemon_proxy_start_set_pkgreason;
	iface->start_download_updates = pamac_daemon_proxy_start_download_updates;
	iface->start_download_pkgs = pamac_daemon_proxy_start_download_pkgs;
	iface->start_trans_refresh = pamac_daemon_proxy_start_trans_refresh;
	iface->start_trans_refresh_files = pamac_daemon_proxy_start_trans_refresh_files;
	iface->start_trans_refresh_aur = pamac_daemon_proxy_start_trans_refresh_aur;
	iface->start_trans_run = pamac_daemon_proxy_start_trans_run;
	iface->trans_cancel = pamac_daemon_proxy_trans_cancel;
	iface->quit = pamac_daemon_proxy_quit;
	iface->start_snap_trans_run = pamac_daemon_proxy_start_snap_trans_run;
	iface->start_snap_switch_channel = pamac_daemon_proxy_start_snap_switch_channel;
	iface->start_flatpak_trans_run = pamac_daemon_proxy_start_flatpak_trans_run;
}

static void
_dbus_pamac_daemon_get_sender (PamacDaemon* self,
                               GVariant* _parameters_,
                               GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = pamac_daemon_get_sender (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_get_lockfile (PamacDaemon* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = pamac_daemon_get_lockfile (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_set_environment_variables (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* variables = NULL;
	GVariant* _tmp121_;
	GHashTable* _tmp122_;
	GVariantIter _tmp123_;
	GVariant* _tmp124_;
	GVariant* _tmp125_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp121_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp122_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_variant_iter_init (&_tmp123_, _tmp121_);
	while (g_variant_iter_loop (&_tmp123_, "{?*}", &_tmp124_, &_tmp125_)) {
		g_hash_table_insert (_tmp122_, g_variant_dup_string (_tmp124_, NULL), g_variant_dup_string (_tmp125_, NULL));
	}
	variables = _tmp122_;
	g_variant_unref (_tmp121_);
	pamac_daemon_set_environment_variables (self, variables, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (variables);
	;
}

static void
_dbus_pamac_daemon_start_get_authorization (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_start_get_authorization (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_remove_authorization (PamacDaemon* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_remove_authorization (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_write_alpm_config (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* new_alpm_conf = NULL;
	GVariant* _tmp126_;
	GHashTable* _tmp127_;
	GVariantIter _tmp128_;
	GVariant* _tmp129_;
	GVariant* _tmp130_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp126_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp127_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp128_, _tmp126_);
	while (g_variant_iter_loop (&_tmp128_, "{?*}", &_tmp129_, &_tmp130_)) {
		g_hash_table_insert (_tmp127_, g_variant_dup_string (_tmp129_, NULL), g_variant_get_variant (_tmp130_));
	}
	new_alpm_conf = _tmp127_;
	g_variant_unref (_tmp126_);
	pamac_daemon_start_write_alpm_config (self, new_alpm_conf, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (new_alpm_conf);
	;
}

static void
_dbus_pamac_daemon_start_write_pamac_config (PamacDaemon* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* new_pamac_conf = NULL;
	GVariant* _tmp131_;
	GHashTable* _tmp132_;
	GVariantIter _tmp133_;
	GVariant* _tmp134_;
	GVariant* _tmp135_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp131_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp132_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp133_, _tmp131_);
	while (g_variant_iter_loop (&_tmp133_, "{?*}", &_tmp134_, &_tmp135_)) {
		g_hash_table_insert (_tmp132_, g_variant_dup_string (_tmp134_, NULL), g_variant_get_variant (_tmp135_));
	}
	new_pamac_conf = _tmp132_;
	g_variant_unref (_tmp131_);
	pamac_daemon_start_write_pamac_config (self, new_pamac_conf, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_hash_table_unref0 (new_pamac_conf);
	;
}

static void
_dbus_pamac_daemon_start_generate_mirrors_list (PamacDaemon* self,
                                                GVariant* _parameters_,
                                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* country = NULL;
	GVariant* _tmp136_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp136_ = g_variant_iter_next_value (&_arguments_iter);
	country = g_variant_dup_string (_tmp136_, NULL);
	g_variant_unref (_tmp136_);
	pamac_daemon_start_generate_mirrors_list (self, country, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (country);
	;
}

static void
_dbus_pamac_daemon_start_clean_cache (PamacDaemon* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** filenames = NULL;
	gint filenames_length1 = 0;
	GVariant* _tmp137_;
	gchar** _tmp138_;
	gint _tmp138__length;
	gint _tmp138__size;
	gint _tmp138__length1;
	GVariantIter _tmp139_;
	GVariant* _tmp140_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp137_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp138_ = g_new (gchar*, 5);
	_tmp138__length = 0;
	_tmp138__size = 4;
	_tmp138__length1 = 0;
	g_variant_iter_init (&_tmp139_, _tmp137_);
	for (; (_tmp140_ = g_variant_iter_next_value (&_tmp139_)) != NULL; _tmp138__length1++) {
		if (_tmp138__size == _tmp138__length) {
			_tmp138__size = 2 * _tmp138__size;
			_tmp138_ = g_renew (gchar*, _tmp138_, _tmp138__size + 1);
		}
		_tmp138_[_tmp138__length++] = g_variant_dup_string (_tmp140_, NULL);
		g_variant_unref (_tmp140_);
	}
	filenames_length1 = _tmp138__length1;
	_tmp138_[_tmp138__length] = NULL;
	filenames = _tmp138_;
	g_variant_unref (_tmp137_);
	pamac_daemon_start_clean_cache (self, filenames, filenames_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_start_clean_build_files (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* aur_build_dir = NULL;
	GVariant* _tmp141_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp141_ = g_variant_iter_next_value (&_arguments_iter);
	aur_build_dir = g_variant_dup_string (_tmp141_, NULL);
	g_variant_unref (_tmp141_);
	pamac_daemon_start_clean_build_files (self, aur_build_dir, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (aur_build_dir);
	;
}

static void
_dbus_pamac_daemon_start_set_pkgreason (PamacDaemon* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* pkgname = NULL;
	GVariant* _tmp142_;
	guint reason = 0U;
	GVariant* _tmp143_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp142_ = g_variant_iter_next_value (&_arguments_iter);
	pkgname = g_variant_dup_string (_tmp142_, NULL);
	g_variant_unref (_tmp142_);
	_tmp143_ = g_variant_iter_next_value (&_arguments_iter);
	reason = g_variant_get_uint32 (_tmp143_);
	g_variant_unref (_tmp143_);
	pamac_daemon_start_set_pkgreason (self, pkgname, reason, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (pkgname);
	;
}

static void
_dbus_pamac_daemon_start_download_updates (PamacDaemon* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_start_download_updates (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_download_pkgs (PamacDaemon* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** urls = NULL;
	gint urls_length1 = 0;
	GVariant* _tmp144_;
	gchar** _tmp145_;
	gint _tmp145__length;
	gint _tmp145__size;
	gint _tmp145__length1;
	GVariantIter _tmp146_;
	GVariant* _tmp147_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp144_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp145_ = g_new (gchar*, 5);
	_tmp145__length = 0;
	_tmp145__size = 4;
	_tmp145__length1 = 0;
	g_variant_iter_init (&_tmp146_, _tmp144_);
	for (; (_tmp147_ = g_variant_iter_next_value (&_tmp146_)) != NULL; _tmp145__length1++) {
		if (_tmp145__size == _tmp145__length) {
			_tmp145__size = 2 * _tmp145__size;
			_tmp145_ = g_renew (gchar*, _tmp145_, _tmp145__size + 1);
		}
		_tmp145_[_tmp145__length++] = g_variant_dup_string (_tmp147_, NULL);
		g_variant_unref (_tmp147_);
	}
	urls_length1 = _tmp145__length1;
	_tmp145_[_tmp145__length] = NULL;
	urls = _tmp145_;
	g_variant_unref (_tmp144_);
	pamac_daemon_start_download_pkgs (self, urls, urls_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_start_trans_refresh (PamacDaemon* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean force = FALSE;
	GVariant* _tmp148_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp148_ = g_variant_iter_next_value (&_arguments_iter);
	force = g_variant_get_boolean (_tmp148_);
	g_variant_unref (_tmp148_);
	pamac_daemon_start_trans_refresh (self, force, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_trans_refresh_files (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean force = FALSE;
	GVariant* _tmp149_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp149_ = g_variant_iter_next_value (&_arguments_iter);
	force = g_variant_get_boolean (_tmp149_);
	g_variant_unref (_tmp149_);
	pamac_daemon_start_trans_refresh_files (self, force, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_trans_refresh_aur (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean force = FALSE;
	GVariant* _tmp150_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp150_ = g_variant_iter_next_value (&_arguments_iter);
	force = g_variant_get_boolean (_tmp150_);
	g_variant_unref (_tmp150_);
	pamac_daemon_start_trans_refresh_aur (self, force, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_start_trans_run (PamacDaemon* self,
                                    GVariant* _parameters_,
                                    GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean sysupgrade = FALSE;
	GVariant* _tmp151_;
	gboolean enable_downgrade = FALSE;
	GVariant* _tmp152_;
	gboolean simple_install = FALSE;
	GVariant* _tmp153_;
	gboolean keep_built_pkgs = FALSE;
	GVariant* _tmp154_;
	gint trans_flags = 0;
	GVariant* _tmp155_;
	gchar** to_install = NULL;
	gint to_install_length1 = 0;
	GVariant* _tmp156_;
	gchar** _tmp157_;
	gint _tmp157__length;
	gint _tmp157__size;
	gint _tmp157__length1;
	GVariantIter _tmp158_;
	GVariant* _tmp159_;
	gchar** to_remove = NULL;
	gint to_remove_length1 = 0;
	GVariant* _tmp160_;
	gchar** _tmp161_;
	gint _tmp161__length;
	gint _tmp161__size;
	gint _tmp161__length1;
	GVariantIter _tmp162_;
	GVariant* _tmp163_;
	gchar** to_load_local = NULL;
	gint to_load_local_length1 = 0;
	GVariant* _tmp164_;
	gchar** _tmp165_;
	gint _tmp165__length;
	gint _tmp165__size;
	gint _tmp165__length1;
	GVariantIter _tmp166_;
	GVariant* _tmp167_;
	gchar** to_load_remote = NULL;
	gint to_load_remote_length1 = 0;
	GVariant* _tmp168_;
	gchar** _tmp169_;
	gint _tmp169__length;
	gint _tmp169__size;
	gint _tmp169__length1;
	GVariantIter _tmp170_;
	GVariant* _tmp171_;
	gchar** to_install_as_dep = NULL;
	gint to_install_as_dep_length1 = 0;
	GVariant* _tmp172_;
	gchar** _tmp173_;
	gint _tmp173__length;
	gint _tmp173__size;
	gint _tmp173__length1;
	GVariantIter _tmp174_;
	GVariant* _tmp175_;
	gchar** ignorepkgs = NULL;
	gint ignorepkgs_length1 = 0;
	GVariant* _tmp176_;
	gchar** _tmp177_;
	gint _tmp177__length;
	gint _tmp177__size;
	gint _tmp177__length1;
	GVariantIter _tmp178_;
	GVariant* _tmp179_;
	gchar** overwrite_files = NULL;
	gint overwrite_files_length1 = 0;
	GVariant* _tmp180_;
	gchar** _tmp181_;
	gint _tmp181__length;
	gint _tmp181__size;
	gint _tmp181__length1;
	GVariantIter _tmp182_;
	GVariant* _tmp183_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp151_ = g_variant_iter_next_value (&_arguments_iter);
	sysupgrade = g_variant_get_boolean (_tmp151_);
	g_variant_unref (_tmp151_);
	_tmp152_ = g_variant_iter_next_value (&_arguments_iter);
	enable_downgrade = g_variant_get_boolean (_tmp152_);
	g_variant_unref (_tmp152_);
	_tmp153_ = g_variant_iter_next_value (&_arguments_iter);
	simple_install = g_variant_get_boolean (_tmp153_);
	g_variant_unref (_tmp153_);
	_tmp154_ = g_variant_iter_next_value (&_arguments_iter);
	keep_built_pkgs = g_variant_get_boolean (_tmp154_);
	g_variant_unref (_tmp154_);
	_tmp155_ = g_variant_iter_next_value (&_arguments_iter);
	trans_flags = g_variant_get_int32 (_tmp155_);
	g_variant_unref (_tmp155_);
	_tmp156_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp157_ = g_new (gchar*, 5);
	_tmp157__length = 0;
	_tmp157__size = 4;
	_tmp157__length1 = 0;
	g_variant_iter_init (&_tmp158_, _tmp156_);
	for (; (_tmp159_ = g_variant_iter_next_value (&_tmp158_)) != NULL; _tmp157__length1++) {
		if (_tmp157__size == _tmp157__length) {
			_tmp157__size = 2 * _tmp157__size;
			_tmp157_ = g_renew (gchar*, _tmp157_, _tmp157__size + 1);
		}
		_tmp157_[_tmp157__length++] = g_variant_dup_string (_tmp159_, NULL);
		g_variant_unref (_tmp159_);
	}
	to_install_length1 = _tmp157__length1;
	_tmp157_[_tmp157__length] = NULL;
	to_install = _tmp157_;
	g_variant_unref (_tmp156_);
	_tmp160_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp161_ = g_new (gchar*, 5);
	_tmp161__length = 0;
	_tmp161__size = 4;
	_tmp161__length1 = 0;
	g_variant_iter_init (&_tmp162_, _tmp160_);
	for (; (_tmp163_ = g_variant_iter_next_value (&_tmp162_)) != NULL; _tmp161__length1++) {
		if (_tmp161__size == _tmp161__length) {
			_tmp161__size = 2 * _tmp161__size;
			_tmp161_ = g_renew (gchar*, _tmp161_, _tmp161__size + 1);
		}
		_tmp161_[_tmp161__length++] = g_variant_dup_string (_tmp163_, NULL);
		g_variant_unref (_tmp163_);
	}
	to_remove_length1 = _tmp161__length1;
	_tmp161_[_tmp161__length] = NULL;
	to_remove = _tmp161_;
	g_variant_unref (_tmp160_);
	_tmp164_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp165_ = g_new (gchar*, 5);
	_tmp165__length = 0;
	_tmp165__size = 4;
	_tmp165__length1 = 0;
	g_variant_iter_init (&_tmp166_, _tmp164_);
	for (; (_tmp167_ = g_variant_iter_next_value (&_tmp166_)) != NULL; _tmp165__length1++) {
		if (_tmp165__size == _tmp165__length) {
			_tmp165__size = 2 * _tmp165__size;
			_tmp165_ = g_renew (gchar*, _tmp165_, _tmp165__size + 1);
		}
		_tmp165_[_tmp165__length++] = g_variant_dup_string (_tmp167_, NULL);
		g_variant_unref (_tmp167_);
	}
	to_load_local_length1 = _tmp165__length1;
	_tmp165_[_tmp165__length] = NULL;
	to_load_local = _tmp165_;
	g_variant_unref (_tmp164_);
	_tmp168_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp169_ = g_new (gchar*, 5);
	_tmp169__length = 0;
	_tmp169__size = 4;
	_tmp169__length1 = 0;
	g_variant_iter_init (&_tmp170_, _tmp168_);
	for (; (_tmp171_ = g_variant_iter_next_value (&_tmp170_)) != NULL; _tmp169__length1++) {
		if (_tmp169__size == _tmp169__length) {
			_tmp169__size = 2 * _tmp169__size;
			_tmp169_ = g_renew (gchar*, _tmp169_, _tmp169__size + 1);
		}
		_tmp169_[_tmp169__length++] = g_variant_dup_string (_tmp171_, NULL);
		g_variant_unref (_tmp171_);
	}
	to_load_remote_length1 = _tmp169__length1;
	_tmp169_[_tmp169__length] = NULL;
	to_load_remote = _tmp169_;
	g_variant_unref (_tmp168_);
	_tmp172_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp173_ = g_new (gchar*, 5);
	_tmp173__length = 0;
	_tmp173__size = 4;
	_tmp173__length1 = 0;
	g_variant_iter_init (&_tmp174_, _tmp172_);
	for (; (_tmp175_ = g_variant_iter_next_value (&_tmp174_)) != NULL; _tmp173__length1++) {
		if (_tmp173__size == _tmp173__length) {
			_tmp173__size = 2 * _tmp173__size;
			_tmp173_ = g_renew (gchar*, _tmp173_, _tmp173__size + 1);
		}
		_tmp173_[_tmp173__length++] = g_variant_dup_string (_tmp175_, NULL);
		g_variant_unref (_tmp175_);
	}
	to_install_as_dep_length1 = _tmp173__length1;
	_tmp173_[_tmp173__length] = NULL;
	to_install_as_dep = _tmp173_;
	g_variant_unref (_tmp172_);
	_tmp176_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp177_ = g_new (gchar*, 5);
	_tmp177__length = 0;
	_tmp177__size = 4;
	_tmp177__length1 = 0;
	g_variant_iter_init (&_tmp178_, _tmp176_);
	for (; (_tmp179_ = g_variant_iter_next_value (&_tmp178_)) != NULL; _tmp177__length1++) {
		if (_tmp177__size == _tmp177__length) {
			_tmp177__size = 2 * _tmp177__size;
			_tmp177_ = g_renew (gchar*, _tmp177_, _tmp177__size + 1);
		}
		_tmp177_[_tmp177__length++] = g_variant_dup_string (_tmp179_, NULL);
		g_variant_unref (_tmp179_);
	}
	ignorepkgs_length1 = _tmp177__length1;
	_tmp177_[_tmp177__length] = NULL;
	ignorepkgs = _tmp177_;
	g_variant_unref (_tmp176_);
	_tmp180_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp181_ = g_new (gchar*, 5);
	_tmp181__length = 0;
	_tmp181__size = 4;
	_tmp181__length1 = 0;
	g_variant_iter_init (&_tmp182_, _tmp180_);
	for (; (_tmp183_ = g_variant_iter_next_value (&_tmp182_)) != NULL; _tmp181__length1++) {
		if (_tmp181__size == _tmp181__length) {
			_tmp181__size = 2 * _tmp181__size;
			_tmp181_ = g_renew (gchar*, _tmp181_, _tmp181__size + 1);
		}
		_tmp181_[_tmp181__length++] = g_variant_dup_string (_tmp183_, NULL);
		g_variant_unref (_tmp183_);
	}
	overwrite_files_length1 = _tmp181__length1;
	_tmp181_[_tmp181__length] = NULL;
	overwrite_files = _tmp181_;
	g_variant_unref (_tmp180_);
	pamac_daemon_start_trans_run (self, sysupgrade, enable_downgrade, simple_install, keep_built_pkgs, trans_flags, to_install, to_install_length1, to_remove, to_remove_length1, to_load_local, to_load_local_length1, to_load_remote, to_load_remote_length1, to_install_as_dep, to_install_as_dep_length1, ignorepkgs, ignorepkgs_length1, overwrite_files, overwrite_files_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	to_install = (_vala_array_free (to_install, to_install_length1, (GDestroyNotify) g_free), NULL);
	to_remove = (_vala_array_free (to_remove, to_remove_length1, (GDestroyNotify) g_free), NULL);
	to_load_local = (_vala_array_free (to_load_local, to_load_local_length1, (GDestroyNotify) g_free), NULL);
	to_load_remote = (_vala_array_free (to_load_remote, to_load_remote_length1, (GDestroyNotify) g_free), NULL);
	to_install_as_dep = (_vala_array_free (to_install_as_dep, to_install_as_dep_length1, (GDestroyNotify) g_free), NULL);
	ignorepkgs = (_vala_array_free (ignorepkgs, ignorepkgs_length1, (GDestroyNotify) g_free), NULL);
	overwrite_files = (_vala_array_free (overwrite_files, overwrite_files_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_trans_cancel (PamacDaemon* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_trans_cancel (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_pamac_daemon_quit (PamacDaemon* self,
                         GVariant* _parameters_,
                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	pamac_daemon_quit (self, &error);
}

static void
_dbus_pamac_daemon_start_snap_trans_run (PamacDaemon* self,
                                         GVariant* _parameters_,
                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** to_install = NULL;
	gint to_install_length1 = 0;
	GVariant* _tmp184_;
	gchar** _tmp185_;
	gint _tmp185__length;
	gint _tmp185__size;
	gint _tmp185__length1;
	GVariantIter _tmp186_;
	GVariant* _tmp187_;
	gchar** to_remove = NULL;
	gint to_remove_length1 = 0;
	GVariant* _tmp188_;
	gchar** _tmp189_;
	gint _tmp189__length;
	gint _tmp189__size;
	gint _tmp189__length1;
	GVariantIter _tmp190_;
	GVariant* _tmp191_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp184_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp185_ = g_new (gchar*, 5);
	_tmp185__length = 0;
	_tmp185__size = 4;
	_tmp185__length1 = 0;
	g_variant_iter_init (&_tmp186_, _tmp184_);
	for (; (_tmp187_ = g_variant_iter_next_value (&_tmp186_)) != NULL; _tmp185__length1++) {
		if (_tmp185__size == _tmp185__length) {
			_tmp185__size = 2 * _tmp185__size;
			_tmp185_ = g_renew (gchar*, _tmp185_, _tmp185__size + 1);
		}
		_tmp185_[_tmp185__length++] = g_variant_dup_string (_tmp187_, NULL);
		g_variant_unref (_tmp187_);
	}
	to_install_length1 = _tmp185__length1;
	_tmp185_[_tmp185__length] = NULL;
	to_install = _tmp185_;
	g_variant_unref (_tmp184_);
	_tmp188_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp189_ = g_new (gchar*, 5);
	_tmp189__length = 0;
	_tmp189__size = 4;
	_tmp189__length1 = 0;
	g_variant_iter_init (&_tmp190_, _tmp188_);
	for (; (_tmp191_ = g_variant_iter_next_value (&_tmp190_)) != NULL; _tmp189__length1++) {
		if (_tmp189__size == _tmp189__length) {
			_tmp189__size = 2 * _tmp189__size;
			_tmp189_ = g_renew (gchar*, _tmp189_, _tmp189__size + 1);
		}
		_tmp189_[_tmp189__length++] = g_variant_dup_string (_tmp191_, NULL);
		g_variant_unref (_tmp191_);
	}
	to_remove_length1 = _tmp189__length1;
	_tmp189_[_tmp189__length] = NULL;
	to_remove = _tmp189_;
	g_variant_unref (_tmp188_);
	pamac_daemon_start_snap_trans_run (self, to_install, to_install_length1, to_remove, to_remove_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	to_install = (_vala_array_free (to_install, to_install_length1, (GDestroyNotify) g_free), NULL);
	to_remove = (_vala_array_free (to_remove, to_remove_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
_dbus_pamac_daemon_start_snap_switch_channel (PamacDaemon* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* snap_name = NULL;
	GVariant* _tmp192_;
	gchar* channel = NULL;
	GVariant* _tmp193_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp192_ = g_variant_iter_next_value (&_arguments_iter);
	snap_name = g_variant_dup_string (_tmp192_, NULL);
	g_variant_unref (_tmp192_);
	_tmp193_ = g_variant_iter_next_value (&_arguments_iter);
	channel = g_variant_dup_string (_tmp193_, NULL);
	g_variant_unref (_tmp193_);
	pamac_daemon_start_snap_switch_channel (self, snap_name, channel, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (snap_name);
	_g_free0 (channel);
	;
}

static void
_dbus_pamac_daemon_start_flatpak_trans_run (PamacDaemon* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** to_install = NULL;
	gint to_install_length1 = 0;
	GVariant* _tmp194_;
	gchar** _tmp195_;
	gint _tmp195__length;
	gint _tmp195__size;
	gint _tmp195__length1;
	GVariantIter _tmp196_;
	GVariant* _tmp197_;
	gchar** to_remove = NULL;
	gint to_remove_length1 = 0;
	GVariant* _tmp198_;
	gchar** _tmp199_;
	gint _tmp199__length;
	gint _tmp199__size;
	gint _tmp199__length1;
	GVariantIter _tmp200_;
	GVariant* _tmp201_;
	gchar** to_upgrade = NULL;
	gint to_upgrade_length1 = 0;
	GVariant* _tmp202_;
	gchar** _tmp203_;
	gint _tmp203__length;
	gint _tmp203__size;
	gint _tmp203__length1;
	GVariantIter _tmp204_;
	GVariant* _tmp205_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp194_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp195_ = g_new (gchar*, 5);
	_tmp195__length = 0;
	_tmp195__size = 4;
	_tmp195__length1 = 0;
	g_variant_iter_init (&_tmp196_, _tmp194_);
	for (; (_tmp197_ = g_variant_iter_next_value (&_tmp196_)) != NULL; _tmp195__length1++) {
		if (_tmp195__size == _tmp195__length) {
			_tmp195__size = 2 * _tmp195__size;
			_tmp195_ = g_renew (gchar*, _tmp195_, _tmp195__size + 1);
		}
		_tmp195_[_tmp195__length++] = g_variant_dup_string (_tmp197_, NULL);
		g_variant_unref (_tmp197_);
	}
	to_install_length1 = _tmp195__length1;
	_tmp195_[_tmp195__length] = NULL;
	to_install = _tmp195_;
	g_variant_unref (_tmp194_);
	_tmp198_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp199_ = g_new (gchar*, 5);
	_tmp199__length = 0;
	_tmp199__size = 4;
	_tmp199__length1 = 0;
	g_variant_iter_init (&_tmp200_, _tmp198_);
	for (; (_tmp201_ = g_variant_iter_next_value (&_tmp200_)) != NULL; _tmp199__length1++) {
		if (_tmp199__size == _tmp199__length) {
			_tmp199__size = 2 * _tmp199__size;
			_tmp199_ = g_renew (gchar*, _tmp199_, _tmp199__size + 1);
		}
		_tmp199_[_tmp199__length++] = g_variant_dup_string (_tmp201_, NULL);
		g_variant_unref (_tmp201_);
	}
	to_remove_length1 = _tmp199__length1;
	_tmp199_[_tmp199__length] = NULL;
	to_remove = _tmp199_;
	g_variant_unref (_tmp198_);
	_tmp202_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp203_ = g_new (gchar*, 5);
	_tmp203__length = 0;
	_tmp203__size = 4;
	_tmp203__length1 = 0;
	g_variant_iter_init (&_tmp204_, _tmp202_);
	for (; (_tmp205_ = g_variant_iter_next_value (&_tmp204_)) != NULL; _tmp203__length1++) {
		if (_tmp203__size == _tmp203__length) {
			_tmp203__size = 2 * _tmp203__size;
			_tmp203_ = g_renew (gchar*, _tmp203_, _tmp203__size + 1);
		}
		_tmp203_[_tmp203__length++] = g_variant_dup_string (_tmp205_, NULL);
		g_variant_unref (_tmp205_);
	}
	to_upgrade_length1 = _tmp203__length1;
	_tmp203_[_tmp203__length] = NULL;
	to_upgrade = _tmp203_;
	g_variant_unref (_tmp202_);
	pamac_daemon_start_flatpak_trans_run (self, to_install, to_install_length1, to_remove, to_remove_length1, to_upgrade, to_upgrade_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	to_install = (_vala_array_free (to_install, to_install_length1, (GDestroyNotify) g_free), NULL);
	to_remove = (_vala_array_free (to_remove, to_remove_length1, (GDestroyNotify) g_free), NULL);
	to_upgrade = (_vala_array_free (to_upgrade, to_upgrade_length1, (GDestroyNotify) g_free), NULL);
	;
}

static void
pamac_daemon_dbus_interface_method_call (GDBusConnection* connection,
                                         const gchar* sender,
                                         const gchar* object_path,
                                         const gchar* interface_name,
                                         const gchar* method_name,
                                         GVariant* parameters,
                                         GDBusMethodInvocation* invocation,
                                         gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetSender") == 0) {
		_dbus_pamac_daemon_get_sender (object, parameters, invocation);
	} else if (strcmp (method_name, "GetLockfile") == 0) {
		_dbus_pamac_daemon_get_lockfile (object, parameters, invocation);
	} else if (strcmp (method_name, "SetEnvironmentVariables") == 0) {
		_dbus_pamac_daemon_set_environment_variables (object, parameters, invocation);
	} else if (strcmp (method_name, "StartGetAuthorization") == 0) {
		_dbus_pamac_daemon_start_get_authorization (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveAuthorization") == 0) {
		_dbus_pamac_daemon_remove_authorization (object, parameters, invocation);
	} else if (strcmp (method_name, "StartWriteAlpmConfig") == 0) {
		_dbus_pamac_daemon_start_write_alpm_config (object, parameters, invocation);
	} else if (strcmp (method_name, "StartWritePamacConfig") == 0) {
		_dbus_pamac_daemon_start_write_pamac_config (object, parameters, invocation);
	} else if (strcmp (method_name, "StartGenerateMirrorsList") == 0) {
		_dbus_pamac_daemon_start_generate_mirrors_list (object, parameters, invocation);
	} else if (strcmp (method_name, "StartCleanCache") == 0) {
		_dbus_pamac_daemon_start_clean_cache (object, parameters, invocation);
	} else if (strcmp (method_name, "StartCleanBuildFiles") == 0) {
		_dbus_pamac_daemon_start_clean_build_files (object, parameters, invocation);
	} else if (strcmp (method_name, "StartSetPkgreason") == 0) {
		_dbus_pamac_daemon_start_set_pkgreason (object, parameters, invocation);
	} else if (strcmp (method_name, "StartDownloadUpdates") == 0) {
		_dbus_pamac_daemon_start_download_updates (object, parameters, invocation);
	} else if (strcmp (method_name, "StartDownloadPkgs") == 0) {
		_dbus_pamac_daemon_start_download_pkgs (object, parameters, invocation);
	} else if (strcmp (method_name, "StartTransRefresh") == 0) {
		_dbus_pamac_daemon_start_trans_refresh (object, parameters, invocation);
	} else if (strcmp (method_name, "StartTransRefreshFiles") == 0) {
		_dbus_pamac_daemon_start_trans_refresh_files (object, parameters, invocation);
	} else if (strcmp (method_name, "StartTransRefreshAur") == 0) {
		_dbus_pamac_daemon_start_trans_refresh_aur (object, parameters, invocation);
	} else if (strcmp (method_name, "StartTransRun") == 0) {
		_dbus_pamac_daemon_start_trans_run (object, parameters, invocation);
	} else if (strcmp (method_name, "TransCancel") == 0) {
		_dbus_pamac_daemon_trans_cancel (object, parameters, invocation);
	} else if (strcmp (method_name, "Quit") == 0) {
		_dbus_pamac_daemon_quit (object, parameters, invocation);
	} else if (strcmp (method_name, "StartSnapTransRun") == 0) {
		_dbus_pamac_daemon_start_snap_trans_run (object, parameters, invocation);
	} else if (strcmp (method_name, "StartSnapSwitchChannel") == 0) {
		_dbus_pamac_daemon_start_snap_switch_channel (object, parameters, invocation);
	} else if (strcmp (method_name, "StartFlatpakTransRun") == 0) {
		_dbus_pamac_daemon_start_flatpak_trans_run (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
pamac_daemon_dbus_interface_get_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
pamac_daemon_dbus_interface_set_property (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* property_name,
                                          GVariant* value,
                                          GError** error,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_pamac_daemon_emit_action (GObject* _sender,
                                const gchar* sender,
                                const gchar* action,
                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitAction", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_action_progress (GObject* _sender,
                                         const gchar* sender,
                                         const gchar* action,
                                         const gchar* status,
                                         gdouble progress,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitActionProgress", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_download_progress (GObject* _sender,
                                           const gchar* sender,
                                           const gchar* action,
                                           const gchar* status,
                                           gdouble progress,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitDownloadProgress", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_hook_progress (GObject* _sender,
                                       const gchar* sender,
                                       const gchar* action,
                                       const gchar* details,
                                       const gchar* status,
                                       gdouble progress,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (action));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (details));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (status));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (progress));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitHookProgress", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_script_output (GObject* _sender,
                                       const gchar* sender,
                                       const gchar* message,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (message));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitScriptOutput", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_warning (GObject* _sender,
                                 const gchar* sender,
                                 const gchar* message,
                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (message));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitWarning", _arguments, NULL);
}

static void
_dbus_pamac_daemon_emit_error (GObject* _sender,
                               const gchar* sender,
                               const gchar* message,
                               gchar** details,
                               gint details_length1,
                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp206_;
	GVariantBuilder _tmp207_;
	gint _tmp208_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (message));
	_tmp206_ = details;
	g_variant_builder_init (&_tmp207_, G_VARIANT_TYPE ("as"));
	for (_tmp208_ = 0; _tmp208_ < details_length1; _tmp208_++) {
		g_variant_builder_add_value (&_tmp207_, g_variant_new_string (*_tmp206_));
		_tmp206_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp207_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "EmitError", _arguments, NULL);
}

static void
_dbus_pamac_daemon_important_details_outpout (GObject* _sender,
                                              const gchar* sender,
                                              gboolean must_show,
                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (must_show));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "ImportantDetailsOutpout", _arguments, NULL);
}

static void
_dbus_pamac_daemon_start_downloading (GObject* _sender,
                                      const gchar* sender,
                                      gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "StartDownloading", _arguments, NULL);
}

static void
_dbus_pamac_daemon_stop_downloading (GObject* _sender,
                                     const gchar* sender,
                                     gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "StopDownloading", _arguments, NULL);
}

static void
_dbus_pamac_daemon_set_pkgreason_finished (GObject* _sender,
                                           const gchar* sender,
                                           gboolean success,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "SetPkgreasonFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_start_waiting (GObject* _sender,
                                  const gchar* sender,
                                  gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "StartWaiting", _arguments, NULL);
}

static void
_dbus_pamac_daemon_stop_waiting (GObject* _sender,
                                 const gchar* sender,
                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "StopWaiting", _arguments, NULL);
}

static void
_dbus_pamac_daemon_download_pkgs_finished (GObject* _sender,
                                           const gchar* sender,
                                           gchar** dload_paths,
                                           gint dload_paths_length1,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp209_;
	GVariantBuilder _tmp210_;
	gint _tmp211_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_tmp209_ = dload_paths;
	g_variant_builder_init (&_tmp210_, G_VARIANT_TYPE ("as"));
	for (_tmp211_ = 0; _tmp211_ < dload_paths_length1; _tmp211_++) {
		g_variant_builder_add_value (&_tmp210_, g_variant_new_string (*_tmp209_));
		_tmp209_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp210_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "DownloadPkgsFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_trans_refresh_finished (GObject* _sender,
                                           const gchar* sender,
                                           gboolean success,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "TransRefreshFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_trans_refresh_files_finished (GObject* _sender,
                                                 const gchar* sender,
                                                 gboolean success,
                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "TransRefreshFilesFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_trans_refresh_aur_finished (GObject* _sender,
                                               const gchar* sender,
                                               gboolean success,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "TransRefreshAurFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_trans_run_finished (GObject* _sender,
                                       const gchar* sender,
                                       gboolean success,
                                       gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "TransRunFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_download_updates_finished (GObject* _sender,
                                              const gchar* sender,
                                              gboolean success,
                                              gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "DownloadUpdatesFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_get_authorization_finished (GObject* _sender,
                                               const gchar* sender,
                                               gboolean authorized,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (authorized));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "GetAuthorizationFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_write_alpm_config_finished (GObject* _sender,
                                               const gchar* sender,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "WriteAlpmConfigFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_write_pamac_config_finished (GObject* _sender,
                                                const gchar* sender,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "WritePamacConfigFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_generate_mirrors_list_data (GObject* _sender,
                                               const gchar* sender,
                                               const gchar* line,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (line));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "GenerateMirrorsListData", _arguments, NULL);
}

static void
_dbus_pamac_daemon_generate_mirrors_list_finished (GObject* _sender,
                                                   const gchar* sender,
                                                   gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "GenerateMirrorsListFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_clean_cache_finished (GObject* _sender,
                                         const gchar* sender,
                                         gboolean success,
                                         gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "CleanCacheFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_clean_build_files_finished (GObject* _sender,
                                               const gchar* sender,
                                               gboolean success,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "CleanBuildFilesFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_snap_trans_run_finished (GObject* _sender,
                                            const gchar* sender,
                                            gboolean success,
                                            gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "SnapTransRunFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_snap_switch_channel_finished (GObject* _sender,
                                                 const gchar* sender,
                                                 gboolean success,
                                                 gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "SnapSwitchChannelFinished", _arguments, NULL);
}

static void
_dbus_pamac_daemon_flatpak_trans_run_finished (GObject* _sender,
                                               const gchar* sender,
                                               gboolean success,
                                               gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (sender));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (success));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.manjaro.pamac.daemon", "FlatpakTransRunFinished", _arguments, NULL);
}

guint
pamac_daemon_register_object (gpointer object,
                              GDBusConnection* connection,
                              const gchar* path,
                              GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pamac_daemon_dbus_interface_info), &_pamac_daemon_dbus_interface_vtable, data, _pamac_daemon_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "emit-action", (GCallback) _dbus_pamac_daemon_emit_action, data);
	g_signal_connect (object, "emit-action-progress", (GCallback) _dbus_pamac_daemon_emit_action_progress, data);
	g_signal_connect (object, "emit-download-progress", (GCallback) _dbus_pamac_daemon_emit_download_progress, data);
	g_signal_connect (object, "emit-hook-progress", (GCallback) _dbus_pamac_daemon_emit_hook_progress, data);
	g_signal_connect (object, "emit-script-output", (GCallback) _dbus_pamac_daemon_emit_script_output, data);
	g_signal_connect (object, "emit-warning", (GCallback) _dbus_pamac_daemon_emit_warning, data);
	g_signal_connect (object, "emit-error", (GCallback) _dbus_pamac_daemon_emit_error, data);
	g_signal_connect (object, "important-details-outpout", (GCallback) _dbus_pamac_daemon_important_details_outpout, data);
	g_signal_connect (object, "start-downloading", (GCallback) _dbus_pamac_daemon_start_downloading, data);
	g_signal_connect (object, "stop-downloading", (GCallback) _dbus_pamac_daemon_stop_downloading, data);
	g_signal_connect (object, "set-pkgreason-finished", (GCallback) _dbus_pamac_daemon_set_pkgreason_finished, data);
	g_signal_connect (object, "start-waiting", (GCallback) _dbus_pamac_daemon_start_waiting, data);
	g_signal_connect (object, "stop-waiting", (GCallback) _dbus_pamac_daemon_stop_waiting, data);
	g_signal_connect (object, "download-pkgs-finished", (GCallback) _dbus_pamac_daemon_download_pkgs_finished, data);
	g_signal_connect (object, "trans-refresh-finished", (GCallback) _dbus_pamac_daemon_trans_refresh_finished, data);
	g_signal_connect (object, "trans-refresh-files-finished", (GCallback) _dbus_pamac_daemon_trans_refresh_files_finished, data);
	g_signal_connect (object, "trans-refresh-aur-finished", (GCallback) _dbus_pamac_daemon_trans_refresh_aur_finished, data);
	g_signal_connect (object, "trans-run-finished", (GCallback) _dbus_pamac_daemon_trans_run_finished, data);
	g_signal_connect (object, "download-updates-finished", (GCallback) _dbus_pamac_daemon_download_updates_finished, data);
	g_signal_connect (object, "get-authorization-finished", (GCallback) _dbus_pamac_daemon_get_authorization_finished, data);
	g_signal_connect (object, "write-alpm-config-finished", (GCallback) _dbus_pamac_daemon_write_alpm_config_finished, data);
	g_signal_connect (object, "write-pamac-config-finished", (GCallback) _dbus_pamac_daemon_write_pamac_config_finished, data);
	g_signal_connect (object, "generate-mirrors-list-data", (GCallback) _dbus_pamac_daemon_generate_mirrors_list_data, data);
	g_signal_connect (object, "generate-mirrors-list-finished", (GCallback) _dbus_pamac_daemon_generate_mirrors_list_finished, data);
	g_signal_connect (object, "clean-cache-finished", (GCallback) _dbus_pamac_daemon_clean_cache_finished, data);
	g_signal_connect (object, "clean-build-files-finished", (GCallback) _dbus_pamac_daemon_clean_build_files_finished, data);
	g_signal_connect (object, "snap-trans-run-finished", (GCallback) _dbus_pamac_daemon_snap_trans_run_finished, data);
	g_signal_connect (object, "snap-switch-channel-finished", (GCallback) _dbus_pamac_daemon_snap_switch_channel_finished, data);
	g_signal_connect (object, "flatpak-trans-run-finished", (GCallback) _dbus_pamac_daemon_flatpak_trans_run_finished, data);
	return result;
}

static void
_pamac_daemon_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_action, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_action_progress, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_download_progress, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_hook_progress, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_script_output, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_warning, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_emit_error, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_important_details_outpout, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_start_downloading, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_stop_downloading, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_set_pkgreason_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_start_waiting, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_stop_waiting, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_download_pkgs_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_trans_refresh_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_trans_refresh_files_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_trans_refresh_aur_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_trans_run_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_download_updates_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_get_authorization_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_write_alpm_config_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_write_pamac_config_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_generate_mirrors_list_data, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_generate_mirrors_list_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_clean_cache_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_clean_build_files_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_snap_trans_run_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_snap_switch_channel_finished, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pamac_daemon_flatpak_trans_run_finished, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

