# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class InlineObject17(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'start_position': 'int',
        'insert_after_position': 'int',
        'reorder_length': 'int'
    }

    attribute_map = {
        'start_position': 'startPosition',
        'insert_after_position': 'insertAfterPosition',
        'reorder_length': 'reorderLength'
    }

    def __init__(self, start_position=None, insert_after_position=None, reorder_length=None, local_vars_configuration=None):  # noqa: E501
        """InlineObject17 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._start_position = None
        self._insert_after_position = None
        self._reorder_length = None
        self.discriminator = None

        self.start_position = start_position
        self.insert_after_position = insert_after_position
        if reorder_length is not None:
            self.reorder_length = reorder_length

    @property
    def start_position(self):
        """Gets the start_position of this InlineObject17.  # noqa: E501

        Start position of the element to reorder  # noqa: E501

        :return: The start_position of this InlineObject17.  # noqa: E501
        :rtype: int
        """
        return self._start_position

    @start_position.setter
    def start_position(self, start_position):
        """Sets the start_position of this InlineObject17.

        Start position of the element to reorder  # noqa: E501

        :param start_position: The start_position of this InlineObject17.  # noqa: E501
        :type start_position: int
        """
        if self.local_vars_configuration.client_side_validation and start_position is None:  # noqa: E501
            raise ValueError("Invalid value for `start_position`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                start_position is not None and start_position < 1):  # noqa: E501
            raise ValueError("Invalid value for `start_position`, must be a value greater than or equal to `1`")  # noqa: E501

        self._start_position = start_position

    @property
    def insert_after_position(self):
        """Gets the insert_after_position of this InlineObject17.  # noqa: E501

        New position for the block to reorder, to add the block before the first element  # noqa: E501

        :return: The insert_after_position of this InlineObject17.  # noqa: E501
        :rtype: int
        """
        return self._insert_after_position

    @insert_after_position.setter
    def insert_after_position(self, insert_after_position):
        """Sets the insert_after_position of this InlineObject17.

        New position for the block to reorder, to add the block before the first element  # noqa: E501

        :param insert_after_position: The insert_after_position of this InlineObject17.  # noqa: E501
        :type insert_after_position: int
        """
        if self.local_vars_configuration.client_side_validation and insert_after_position is None:  # noqa: E501
            raise ValueError("Invalid value for `insert_after_position`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                insert_after_position is not None and insert_after_position < 0):  # noqa: E501
            raise ValueError("Invalid value for `insert_after_position`, must be a value greater than or equal to `0`")  # noqa: E501

        self._insert_after_position = insert_after_position

    @property
    def reorder_length(self):
        """Gets the reorder_length of this InlineObject17.  # noqa: E501

        How many element from `startPosition` to reorder  # noqa: E501

        :return: The reorder_length of this InlineObject17.  # noqa: E501
        :rtype: int
        """
        return self._reorder_length

    @reorder_length.setter
    def reorder_length(self, reorder_length):
        """Sets the reorder_length of this InlineObject17.

        How many element from `startPosition` to reorder  # noqa: E501

        :param reorder_length: The reorder_length of this InlineObject17.  # noqa: E501
        :type reorder_length: int
        """
        if (self.local_vars_configuration.client_side_validation and
                reorder_length is not None and reorder_length < 1):  # noqa: E501
            raise ValueError("Invalid value for `reorder_length`, must be a value greater than or equal to `1`")  # noqa: E501

        self._reorder_length = reorder_length

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InlineObject17):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InlineObject17):
            return True

        return self.to_dict() != other.to_dict()
