/**
 * penguins-eggs - Refactored distros.ts
 * class: distro.ts
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IDistro } from '../interfaces/index.js';
/**
 * Main Distro class - Refactored
 */
declare class Distro implements IDistro {
    bugReportUrl: string;
    codenameId: string;
    codenameLikeId: string;
    distroId: string;
    distroLike: string;
    familyId: string;
    homeUrl: string;
    isCalamaresAvailable: boolean;
    liveMediumPath: string;
    releaseId: string;
    squashfs: string;
    supportUrl: string;
    syslinuxPath: string;
    usrLibPath: string;
    /**
     * Constructor - Now much cleaner and focused
     */
    constructor();
    /**
     * Initialize with default values
     */
    private initializeDefaults;
    /**
     * Main configuration logic
     */
    private configure;
    /**
     * Apply family-based configuration
     */
    private applyFamilyConfig;
    /**
     * Apply custom configuration from derivatives
     */
    private applyCustomConfig;
    /**
     * Apply codename-specific configurations
     */
    private applyCodenameConfig;
    /**
     * Handle unknown distribution
     */
    private handleUnknownDistro;
}
export default Distro;
