/**
 * ./src/classes/families/alpine.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
/**
 * Alpine
 * @remarks all the utilities
 */
export default class Alpine {
    static packs4calamares: string[];
    /**
     * Alpine: calamaresInstall
     */
    static calamaresInstall(verbose?: boolean): Promise<void>;
    /**
     *
     * calamaresPolicies
     */
    static calamaresPolicies(verbose?: boolean): Promise<void>;
    /**
     * Alpine: calamaresRemove
     */
    static calamaresRemove(verbose?: boolean): Promise<boolean>;
    /**
     * Alpine: isInstalledWayland
     * @returns true if wayland is installed
     */
    static isInstalledWayland(): boolean;
    /**
     * Alpine: isInstalledXorg
     * @returns true if xorg is installed
     */
    static isInstalledXorg(): boolean;
    /**
     * Alpine: packageInstall
     * Install the package packageName
     * @param packageName {string} Pacchetto Debian da installare
     * @returns {boolean} True if success
     */
    static packageInstall(packageName: string): Promise<boolean>;
    /**
     * Alpine: packageIsInstalled OK
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static packageIsInstalled(packageName: string): boolean;
    /**
     * Alpine: packagePacmanAvailable
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static packagePacmanAvailable(packageName: string): Promise<boolean>;
}
