/**
 * ./src/classes/pxe.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IDhcpOptions, ITftpOptions } from '../interfaces/i-pxe.js';
import Settings from './settings.js';
/**
 * Pxe:
 */
export default class Pxe {
    bootLabel: string;
    echo: {};
    eggRoot: string;
    initrdImg: string;
    isos: string[];
    nest: string;
    pxeRoot: string;
    settings: Settings;
    verbose: boolean;
    vmlinuz: string;
    /**
     * constructor
     * @param nest
     * @param pxeRoot
     */
    constructor(nest?: string, pxeRoot?: string);
    /**
     * build
     */
    build(): Promise<void>;
    /**
     *
     * @param dhcpOptions
     */
    dhcpStart(dhcpOptions: IDhcpOptions): void;
    /**
     * fertilization()
     *
     * cuckoo's nest
     */
    fertilization(): Promise<void>;
    /**
     * start http server for images
     *
     */
    httpStart(): Promise<void>;
    /**
     * start tftp
     */
    tftpStart(tftpOptions: ITftpOptions): Promise<void>;
    /**
     * Il resto PRIVATO
     */
    /**
     * configure PXE bios
     */
    private bios;
    /**
     * configure PXE http server
     */
    private http;
    /**
     *
     */
    private ipxe;
    /**
     *
     * @param cmd
     */
    private tryCatch;
}
