/**
 * penguins-eggs
 *
 * Kernel management utilities
 * Handle vmlinuz and initramfs detection across different distributions
 */
/**
 * Kernel utilities for managing vmlinuz and initramfs paths
 */
export default class Kernel {
    /**
     * Ricava path per vmlinuz
     *
     * Normalmente cerca BOOT_IMAGE nei parametri del kernel
     * BOOT_IMAGE=/boot/vmlinuz-5.16.0-3-amd64 root=UUID=... ro quiet splash
     *
     * Se non è presente, come nel caso di Franco, cerca initrd e ricostruisce vmlinuz
     * ro root=UUID=... initrd=boot\initrd.img-5.15.0-0.bpo.3-amd64
     *
     * @param kernel - Versione specifica del kernel (opzionale)
     * @returns Path al file vmlinuz
     */
    static vmlinuz(kernel?: string): string;
    /**
     * Ricava path per initramfs/initrd
     *
     * @param kernel - Versione del kernel
     * @returns Path al file initramfs
     */
    static initramfs(kernel?: string): string;
    /**
     * Rileva automaticamente il kernel dai moduli disponibili
     */
    private static detectKernelFromModules;
    /**
     * Ottiene il path per un kernel specifico
     */
    private static getSpecificKernelPath;
    /**
     * Trova la directory dei moduli del kernel
     */
    private static getKernelModulesPath;
    /**
     * Ottiene la lista dei kernel disponibili, ordinati
     */
    private static getAvailableKernels;
    /**
     * Gestisce il rilevamento del kernel per Arch Linux
     */
    private static getArchLinuxKernelPath;
    /**
     * Gestisce il path del kernel per Manjaro
     */
    private static getManjaroKernelPath;
    /**
     * Gestisce il path del kernel standard per Arch Linux
     */
    private static getStandardArchKernelPath;
    /**
     * Gestisce il kernel specifico per Arch Linux
     */
    private static getArchLinuxSpecificKernel;
    /**
     * Gestisce initramfs per Arch Linux
     */
    private static getArchInitramfs;
    /**
     * Lista i kernel disponibili in /boot per debugging
     */
    private static listAvailableKernels;
    /**
     * Lista gli initramfs disponibili in /boot per debugging
     */
    private static listAvailableInitramfs;
    /**
     * Ottiene informazioni sul kernel corrente
     */
    static getCurrentKernelInfo(): {
        version: string;
        vmlinuz: string;
        initramfs: string;
    };
}
