/**
 * ./src/classes/utils.d/package-info.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * Package information and installation mode detection utilities
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
export default class PackageInfo {
    /**
     * return the name of the package: penguins-eggs
     * @returns penguins-eggs
     */
    static getPackageName(): string;
    /**
     * return the short name of the package: eggs
     * @returns eggs
     */
    static getFriendName(): string;
    /**
     * return the version of the package
     * @returns version example 8.0.0
     */
    static getPackageVersion(): string;
    /**
     * Get author name
     */
    static getAuthorName(): string;
    /**
     * Controlla se è un pacchetto deb
     * /usr/lib/penguins-eggs/bin/node
     */
    static isPackage(): boolean;
    /**
     * Controlla se è un pacchetto sorgente
     */
    static isSources(): boolean;
    /**
     * Controlla se è un pacchetto npm
     */
    static isNpmPackage(): boolean;
    /**
     *
     */
    static rootPenguin(): string;
    /**
     *
     * @returns wardrobe
     */
    static wardrobe(): Promise<string>;
    /**
     * Return the primary user's name
     */
    static getPrimaryUser(): Promise<string>;
}
