/**
 * ./src/classes/utils.d/snapshot.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * Snapshot management utilities - ISO, prefixes, volid
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
export default class Snapshot {
    /**
     * Restituisce il prefisso della iso
     * @param distroId
     * @param codenameId
     */
    static snapshotPrefix(distroId: string, codenameId: string): string;
    /**
     * Count the eggs present in the nest
     * @returns {number} Numero degli snapshot presenti
     */
    static getSnapshotCount(snapshot_dir?: string): number;
    /**
     * Get the syze of the snapshot
     * @returns {string} grandezza dello snapshot in Byte
     */
    static getSnapshotSize(snapshot_dir?: string): number;
    /**
     *
     * @param prefix
     * @param backup
     * @returns
     */
    static getPrefix(prefix: string, backup?: boolean): string;
    /**
     *
     * @param volid
     */
    static getVolid(volid?: string): string;
    /**
     * Return postfix
     * @param basename
     * @returns eggName
     */
    static getPostfix(): string;
}
