/**
 * ./src/classes/utils.d/system.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * System detection utilities - init systems, containers, live/installed detection
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
export default class System {
    /**
     * Detect if running inside a container (Docker or LXC)
     */
    static isContainer(): boolean;
    /**
     * Check if the system uses Systemd
     */
    static isSystemd(): boolean;
    /**
     * Check if the system uses SysVinit
     */
    static isSysvinit(): boolean;
    /**
     * Check if the system uses OpenRC
     */
    static isOpenRc(): boolean;
    /**
     * Return true if live system
     * @returns {boolean} isLive
     */
    static isLive(): boolean;
    /**
     * Ritorna vero se path è un mountpoint
     * @param path
     */
    static isMountpoint(path?: string): boolean;
    /**
     *
     * @param device
     * @returns
     */
    static isBlockDevice(device?: string): boolean;
    /**
     * return true if eggs run as root
     * @returns isRoot
     */
    static isRoot(command?: string): boolean;
    /**
     * Occore vedere un modo per creare machine-id dove non esiste
     */
    static machineId(): string;
    /**
     * Return the Debian version
     * @returns {number} Versione di Debian
     */
    static getDebianVersion(): number;
    /**
     * Extimate the linuxfs dimension
     * probably is better to rename it as
     * getLiveSpaceRootNeed
     * @returns {number} Byte
     */
    static getLiveRootSpace(type?: string): number;
}
