/**
 * ./src/commands/calamares.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { Command } from '@oclif/core';
import Incubator from '../classes/incubation/incubator.js';
import Settings from '../classes/settings.js';
import { IRemix } from '../interfaces/index.js';
export default class Calamares extends Command {
    static description: string;
    static examples: string[];
    static flags: {
        help: import("@oclif/core/interfaces").BooleanFlag<void>;
        install: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        nointeractive: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        policies: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        release: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        remove: import("@oclif/core/interfaces").BooleanFlag<boolean>;
        theme: import("@oclif/core/interfaces").OptionFlag<string | undefined, import("@oclif/core/interfaces").CustomOptions>;
        verbose: import("@oclif/core/interfaces").BooleanFlag<boolean>;
    };
    incubator: Incubator;
    remix: IRemix;
    settings: Settings;
    run(): Promise<void>;
}
