/**
 * ./src/components/keyboard.tsx
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import Title from './title.js';
import Steps from './steps.js';
import { Text, Box } from 'ink';
import yaml from 'js-yaml';
import fs from 'fs';
// pjson
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const pjson = require('../../../package.json');
export default function Keyboard({ keyboardModel = '', keyboardLayout = '', keyboardVariant = '', keyboardOptions = '' }) {
    let productName = "";
    let version = "";
    let configRoot = '/etc/penguins-eggs.d/krill/';
    if (fs.existsSync('/etc/calamares/settings.conf')) {
        configRoot = '/etc/calamares/';
    }
    const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf-8'));
    const branding = settings.branding;
    const calamares = yaml.load(fs.readFileSync(configRoot + 'branding/' + branding + '/branding.desc', 'utf-8'));
    productName = calamares.strings.productName;
    version = calamares.strings.version;
    /**
    * totale width=75
    * step width=15
    * finestra with=59
    */
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { width: 75, height: 11, borderStyle: "round", flexDirection: "column" },
            React.createElement(Box, { flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 3 }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Model: "),
                            React.createElement(Text, { color: "cyan" }, keyboardModel)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Layout: "),
                            React.createElement(Text, { color: "cyan" }, keyboardLayout)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Variant: "),
                            React.createElement(Text, { color: "cyan" }, keyboardVariant)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Options: "),
                            React.createElement(Text, { color: "cyan" }, keyboardOptions))))))));
}
