/**
 * ./src/components/steps.tsx
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import { Text, Box } from 'ink';
export default function Steps({ step = 1 }) {
    let activeWelcome = false;
    let activeLocation = false;
    let activeKeyboard = false;
    let activePartitions = false;
    let activeUsers = false;
    let activeNetwork = false;
    let activeSummary = false;
    let activeInstall = false;
    let activeFinish = false;
    if (step === 1) {
        activeWelcome = true;
    }
    else if (step === 2) {
        activeLocation = true;
    }
    else if (step === 3) {
        activeKeyboard = true;
    }
    else if (step === 4) {
        activePartitions = true;
    }
    else if (step === 5) {
        activeUsers = true;
    }
    else if (step === 6) {
        activeNetwork = true;
    }
    else if (step === 7) {
        activeSummary = true;
    }
    else if (step === 8) {
        activeInstall = true;
    }
    else if (step === 9) {
        activeFinish = true;
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Box, { width: 13, height: 9, flexDirection: "column" },
            React.createElement(WelcomeTab, { active: activeWelcome }),
            React.createElement(LocationTab, { active: activeLocation }),
            React.createElement(KeyboardTab, { active: activeKeyboard }),
            React.createElement(PartitionTab, { active: activePartitions }),
            React.createElement(UsersTab, { active: activeUsers }),
            React.createElement(NetworkTab, { active: activeNetwork }),
            React.createElement(SummaryTab, { active: activeSummary }),
            React.createElement(InstallTab, { active: activeInstall }),
            React.createElement(FinishTab, { active: activeFinish }))));
}
function WelcomeTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Welcome    "));
}
function LocationTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Location   "));
}
function KeyboardTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Keyboard   "));
}
function PartitionTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Partitions "));
}
function UsersTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Users      "));
}
function NetworkTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Network    "));
}
function SummaryTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Summary    "));
}
function InstallTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Install    "));
}
function FinishTab({ active = false }) {
    let backgroundColor = 'white';
    let color = 'black';
    if (active) {
        backgroundColor = 'black';
        color = 'white';
    }
    return React.createElement(Box, null,
        React.createElement(Text, { color: color, backgroundColor: backgroundColor }, " Finish     "));
}
