/**
 * ./src/lib/get_netmask.ts
 * penguins-eggs v.10.0.0 / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import inquirer from 'inquirer';
export default async function getNetmask(initial) {
    return new Promise((resolve) => {
        const questions = [
            {
                default: initial,
                message: 'What is netmask of this computer? ',
                name: 'netmask',
                type: 'input'
            }
        ];
        inquirer.prompt(questions).then((options) => {
            resolve(options.netmask);
        });
    });
}
