import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteMonitoringSubscriptionCommand, se_DeleteMonitoringSubscriptionCommand, } from "../protocols/Aws_restXml";
export { $Command };
export class DeleteMonitoringSubscriptionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "DeleteMonitoringSubscription", {})
    .n("CloudFrontClient", "DeleteMonitoringSubscriptionCommand")
    .f(void 0, void 0)
    .ser(se_DeleteMonitoringSubscriptionCommand)
    .de(de_DeleteMonitoringSubscriptionCommand)
    .build() {
}
