import { loadRestXmlErrorCode, parseXmlBody as parseBody, parseXmlErrorBody as parseErrorBody } from "@aws-sdk/core";
import { XmlNode as __XmlNode } from "@aws-sdk/xml-builder";
import { requestBuilder as rb } from "@smithy/core";
import { collectBody, decorateServiceException as __decorateServiceException, expectNonNull as __expectNonNull, expectObject as __expectObject, expectString as __expectString, getArrayIfSingleItem as __getArrayIfSingleItem, isSerializableHeaderValue, map, parseBoolean as __parseBoolean, parseRfc3339DateTimeWithOffset as __parseRfc3339DateTimeWithOffset, strictParseFloat as __strictParseFloat, strictParseInt32 as __strictParseInt32, strictParseLong as __strictParseLong, withBaseException, } from "@smithy/smithy-client";
import { CloudFrontServiceException as __BaseException } from "../models/CloudFrontServiceException";
import { AccessDenied, BatchTooLarge, CachePolicyAlreadyExists, CachePolicyInUse, CannotChangeImmutablePublicKeyFields, CannotDeleteEntityWhileInUse, CannotUpdateEntityWhileInUse, CloudFrontOriginAccessIdentityAlreadyExists, CNAMEAlreadyExists, ContinuousDeploymentPolicyAlreadyExists, ContinuousDeploymentPolicyInUse, DistributionAlreadyExists, EntityAlreadyExists, EntityLimitExceeded, EntityNotFound, EntitySizeLimitExceeded, FieldLevelEncryptionConfigAlreadyExists, FieldLevelEncryptionProfileAlreadyExists, FieldLevelEncryptionProfileSizeExceeded, FunctionAlreadyExists, FunctionSizeLimitExceeded, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior, IllegalOriginAccessConfiguration, IllegalUpdate, InconsistentQuantities, InvalidArgument, InvalidAssociation, InvalidDefaultRootObject, InvalidDomainNameForOriginAccessControl, InvalidErrorCode, InvalidForwardCookies, InvalidFunctionAssociation, InvalidGeoRestrictionParameter, InvalidHeadersForS3Origin, InvalidIfMatchVersion, InvalidLambdaFunctionAssociation, InvalidLocationCode, InvalidMinimumProtocolVersion, InvalidOrigin, InvalidOriginAccessControl, InvalidOriginAccessIdentity, InvalidOriginKeepaliveTimeout, InvalidOriginReadTimeout, InvalidProtocolSettings, InvalidQueryStringParameters, InvalidRelativePath, InvalidRequiredProtocol, InvalidResponseCode, InvalidTagging, InvalidTTLOrder, InvalidViewerCertificate, InvalidWebACLId, KeyGroupAlreadyExists, MissingBody, MonitoringSubscriptionAlreadyExists, NoSuchCachePolicy, NoSuchContinuousDeploymentPolicy, NoSuchDistribution, NoSuchFieldLevelEncryptionConfig, NoSuchFieldLevelEncryptionProfile, NoSuchOrigin, NoSuchOriginRequestPolicy, NoSuchPublicKey, NoSuchRealtimeLogConfig, NoSuchResponseHeadersPolicy, OriginAccessControlAlreadyExists, PreconditionFailed, QueryArgProfileEmpty, RealtimeLogConfigOwnerMismatch, StagingDistributionInUse, TooManyCacheBehaviors, TooManyCachePolicies, TooManyCertificates, TooManyCloudFrontOriginAccessIdentities, TooManyContinuousDeploymentPolicies, TooManyCookieNamesInWhiteList, TooManyCookiesInCachePolicy, TooManyDistributionCNAMEs, TooManyDistributions, TooManyDistributionsAssociatedToCachePolicy, TooManyDistributionsAssociatedToFieldLevelEncryptionConfig, TooManyDistributionsAssociatedToKeyGroup, TooManyDistributionsAssociatedToOriginAccessControl, TooManyDistributionsAssociatedToOriginRequestPolicy, TooManyDistributionsAssociatedToResponseHeadersPolicy, TooManyDistributionsWithFunctionAssociations, TooManyDistributionsWithLambdaAssociations, TooManyDistributionsWithSingleFunctionARN, TooManyFieldLevelEncryptionConfigs, TooManyFieldLevelEncryptionContentTypeProfiles, TooManyFieldLevelEncryptionEncryptionEntities, TooManyFieldLevelEncryptionFieldPatterns, TooManyFieldLevelEncryptionProfiles, TooManyFieldLevelEncryptionQueryArgProfiles, TooManyFunctionAssociations, TooManyFunctions, TooManyHeadersInCachePolicy, TooManyHeadersInForwardedValues, TooManyInvalidationsInProgress, TooManyKeyGroups, TooManyKeyGroupsAssociatedToDistribution, TooManyLambdaFunctionAssociations, TooManyOriginCustomHeaders, TooManyOriginGroupsPerDistribution, TooManyOrigins, TooManyPublicKeysInKeyGroup, TooManyQueryStringParameters, TooManyQueryStringsInCachePolicy, TooManyTrustedSigners, TrustedKeyGroupDoesNotExist, TrustedSignerDoesNotExist, UnsupportedOperation, } from "../models/models_0";
import { CloudFrontOriginAccessIdentityInUse, DistributionNotDisabled, FieldLevelEncryptionConfigInUse, FieldLevelEncryptionProfileInUse, FunctionInUse, IllegalDelete, NoSuchCloudFrontOriginAccessIdentity, NoSuchFunctionExists, NoSuchInvalidation, NoSuchMonitoringSubscription, NoSuchOriginAccessControl, NoSuchResource, NoSuchStreamingDistribution, OriginAccessControlInUse, OriginRequestPolicyAlreadyExists, OriginRequestPolicyInUse, PublicKeyAlreadyExists, PublicKeyInUse, RealtimeLogConfigAlreadyExists, RealtimeLogConfigInUse, ResourceInUse, ResourceNotDisabled, ResponseHeadersPolicyAlreadyExists, ResponseHeadersPolicyInUse, StreamingDistributionAlreadyExists, StreamingDistributionNotDisabled, TooLongCSPInResponseHeadersPolicy, TooManyCookiesInOriginRequestPolicy, TooManyCustomHeadersInResponseHeadersPolicy, TooManyHeadersInOriginRequestPolicy, TooManyOriginAccessControls, TooManyOriginRequestPolicies, TooManyPublicKeys, TooManyQueryStringsInOriginRequestPolicy, TooManyRealtimeLogConfigs, TooManyRemoveHeadersInResponseHeadersPolicy, TooManyResponseHeadersPolicies, TooManyStreamingDistributionCNAMEs, TooManyStreamingDistributions, } from "../models/models_1";
import { TestFunctionFailed, } from "../models/models_2";
export const se_AssociateAliasCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution/{TargetDistributionId}/associate-alias");
    b.p("TargetDistributionId", () => input.TargetDistributionId, "{TargetDistributionId}", false);
    const query = map({
        [_A]: [, __expectNonNull(input[_A], `Alias`)],
    });
    let body;
    b.m("PUT").h(headers).q(query).b(body);
    return b.build();
};
export const se_AssociateDistributionTenantWebACLCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution-tenant/{Id}/associate-web-acl");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    body = _ve;
    const bn = new __XmlNode(_ADTWACLR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_WACLA] != null) {
        bn.c(__XmlNode.of(_s, input[_WACLA]).n(_WACLA));
    }
    body += bn.toString();
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_AssociateDistributionWebACLCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution/{Id}/associate-web-acl");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    body = _ve;
    const bn = new __XmlNode(_ADWACLR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_WACLA] != null) {
        bn.c(__XmlNode.of(_s, input[_WACLA]).n(_WACLA));
    }
    body += bn.toString();
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_CopyDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_st]: [() => isSerializableHeaderValue(input[_S]), () => input[_S].toString()],
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution/{PrimaryDistributionId}/copy");
    b.p("PrimaryDistributionId", () => input.PrimaryDistributionId, "{PrimaryDistributionId}", false);
    let body;
    body = _ve;
    const bn = new __XmlNode(_CDR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_CR] != null) {
        bn.c(__XmlNode.of(_s, input[_CR]).n(_CR));
    }
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateAnycastIpListCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/anycast-ip-list");
    let body;
    body = _ve;
    const bn = new __XmlNode(_CAILR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_IC] != null) {
        bn.c(__XmlNode.of(_i, String(input[_IC])).n(_IC));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_AILN, input[_N]).n(_N));
    }
    if (input[_T] != null) {
        bn.c(se_Tags(input[_T], context).n(_T));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateCachePolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/cache-policy");
    let body;
    let contents;
    if (input.CachePolicyConfig !== undefined) {
        contents = se_CachePolicyConfig(input.CachePolicyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateCloudFrontOriginAccessIdentityCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/origin-access-identity/cloudfront");
    let body;
    let contents;
    if (input.CloudFrontOriginAccessIdentityConfig !== undefined) {
        contents = se_CloudFrontOriginAccessIdentityConfig(input.CloudFrontOriginAccessIdentityConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateConnectionGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/connection-group");
    let body;
    body = _ve;
    const bn = new __XmlNode(_CCGR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_AILI] != null) {
        bn.c(__XmlNode.of(_s, input[_AILI]).n(_AILI));
    }
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_IE] != null) {
        bn.c(__XmlNode.of(_b, String(input[_IE])).n(_IE));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_T] != null) {
        bn.c(se_Tags(input[_T], context).n(_T));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateContinuousDeploymentPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/continuous-deployment-policy");
    let body;
    let contents;
    if (input.ContinuousDeploymentPolicyConfig !== undefined) {
        contents = se_ContinuousDeploymentPolicyConfig(input.ContinuousDeploymentPolicyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distribution");
    let body;
    let contents;
    if (input.DistributionConfig !== undefined) {
        contents = se_DistributionConfig(input.DistributionConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateDistributionTenantCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distribution-tenant");
    let body;
    body = _ve;
    const bn = new __XmlNode(_CDTR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_CGI] != null) {
        bn.c(__XmlNode.of(_s, input[_CGI]).n(_CGI));
    }
    if (input[_C] != null) {
        bn.c(se_Customizations(input[_C], context).n(_C));
    }
    if (input[_DI] != null) {
        bn.c(__XmlNode.of(_s, input[_DI]).n(_DI));
    }
    bn.lc(input, "Domains", "Domains", () => se_DomainList(input[_D], context));
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_MCR] != null) {
        bn.c(se_ManagedCertificateRequest(input[_MCR], context).n(_MCR));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    bn.lc(input, "Parameters", "Parameters", () => se_Parameters(input[_P], context));
    if (input[_T] != null) {
        bn.c(se_Tags(input[_T], context).n(_T));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateDistributionWithTagsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distribution");
    const query = map({
        [_WT]: [, ""],
    });
    let body;
    let contents;
    if (input.DistributionConfigWithTags !== undefined) {
        contents = se_DistributionConfigWithTags(input.DistributionConfigWithTags, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).q(query).b(body);
    return b.build();
};
export const se_CreateFieldLevelEncryptionConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/field-level-encryption");
    let body;
    let contents;
    if (input.FieldLevelEncryptionConfig !== undefined) {
        contents = se_FieldLevelEncryptionConfig(input.FieldLevelEncryptionConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateFieldLevelEncryptionProfileCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/field-level-encryption-profile");
    let body;
    let contents;
    if (input.FieldLevelEncryptionProfileConfig !== undefined) {
        contents = se_FieldLevelEncryptionProfileConfig(input.FieldLevelEncryptionProfileConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateFunctionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/function");
    let body;
    body = _ve;
    const bn = new __XmlNode(_CFR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_FC] != null) {
        bn.c(__XmlNode.of(_FB, context.base64Encoder(input[_FC])).n(_FC));
    }
    if (input[_FCu] != null) {
        bn.c(se_FunctionConfig(input[_FCu], context).n(_FCu));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_FN, input[_N]).n(_N));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateInvalidationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distribution/{DistributionId}/invalidation");
    b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
    let body;
    let contents;
    if (input.InvalidationBatch !== undefined) {
        contents = se_InvalidationBatch(input.InvalidationBatch, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateInvalidationForDistributionTenantCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distribution-tenant/{Id}/invalidation");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.InvalidationBatch !== undefined) {
        contents = se_InvalidationBatch(input.InvalidationBatch, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateKeyGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/key-group");
    let body;
    let contents;
    if (input.KeyGroupConfig !== undefined) {
        contents = se_KeyGroupConfig(input.KeyGroupConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateKeyValueStoreCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/key-value-store");
    let body;
    body = _ve;
    const bn = new __XmlNode(_CKVSR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_KVSC, input[_Co]).n(_Co));
    }
    if (input[_IS] != null) {
        bn.c(se_ImportSource(input[_IS], context).n(_IS));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_KVSN, input[_N]).n(_N));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateMonitoringSubscriptionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distributions/{DistributionId}/monitoring-subscription");
    b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
    let body;
    let contents;
    if (input.MonitoringSubscription !== undefined) {
        contents = se_MonitoringSubscription(input.MonitoringSubscription, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateOriginAccessControlCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/origin-access-control");
    let body;
    let contents;
    if (input.OriginAccessControlConfig !== undefined) {
        contents = se_OriginAccessControlConfig(input.OriginAccessControlConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateOriginRequestPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/origin-request-policy");
    let body;
    let contents;
    if (input.OriginRequestPolicyConfig !== undefined) {
        contents = se_OriginRequestPolicyConfig(input.OriginRequestPolicyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreatePublicKeyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/public-key");
    let body;
    let contents;
    if (input.PublicKeyConfig !== undefined) {
        contents = se_PublicKeyConfig(input.PublicKeyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateRealtimeLogConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/realtime-log-config");
    let body;
    body = _ve;
    const bn = new __XmlNode(_CRLCR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    bn.lc(input, "EndPoints", "EndPoints", () => se_EndPointList(input[_EP], context));
    bn.lc(input, "Fields", "Fields", () => se_FieldList(input[_F], context));
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_SR] != null) {
        bn.c(__XmlNode.of(_l, String(input[_SR])).n(_SR));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateResponseHeadersPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/response-headers-policy");
    let body;
    let contents;
    if (input.ResponseHeadersPolicyConfig !== undefined) {
        contents = se_ResponseHeadersPolicyConfig(input.ResponseHeadersPolicyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateStreamingDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/streaming-distribution");
    let body;
    let contents;
    if (input.StreamingDistributionConfig !== undefined) {
        contents = se_StreamingDistributionConfig(input.StreamingDistributionConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_CreateStreamingDistributionWithTagsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/streaming-distribution");
    const query = map({
        [_WT]: [, ""],
    });
    let body;
    let contents;
    if (input.StreamingDistributionConfigWithTags !== undefined) {
        contents = se_StreamingDistributionConfigWithTags(input.StreamingDistributionConfigWithTags, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).q(query).b(body);
    return b.build();
};
export const se_CreateVpcOriginCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/vpc-origin");
    let body;
    body = _ve;
    const bn = new __XmlNode(_CVOR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_T] != null) {
        bn.c(se_Tags(input[_T], context).n(_T));
    }
    if (input[_VOEC] != null) {
        bn.c(se_VpcOriginEndpointConfig(input[_VOEC], context).n(_VOEC));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_DeleteAnycastIpListCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/anycast-ip-list/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteCachePolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/cache-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteCloudFrontOriginAccessIdentityCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/origin-access-identity/cloudfront/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteConnectionGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/connection-group/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteContinuousDeploymentPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/continuous-deployment-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteDistributionTenantCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution-tenant/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteFieldLevelEncryptionConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/field-level-encryption/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteFieldLevelEncryptionProfileCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/field-level-encryption-profile/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteFunctionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/function/{Name}");
    b.p("Name", () => input.Name, "{Name}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteKeyGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/key-group/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteKeyValueStoreCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/key-value-store/{Name}");
    b.p("Name", () => input.Name, "{Name}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteMonitoringSubscriptionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributions/{DistributionId}/monitoring-subscription");
    b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteOriginAccessControlCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/origin-access-control/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteOriginRequestPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/origin-request-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeletePublicKeyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/public-key/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteRealtimeLogConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/delete-realtime-log-config");
    let body;
    body = _ve;
    const bn = new __XmlNode(_DRLCR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_ARN] != null) {
        bn.c(__XmlNode.of(_s, input[_ARN]).n(_ARN));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_DeleteResponseHeadersPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/response-headers-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteStreamingDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/streaming-distribution/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DeleteVpcOriginCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/vpc-origin/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("DELETE").h(headers).b(body);
    return b.build();
};
export const se_DescribeFunctionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/function/{Name}/describe");
    b.p("Name", () => input.Name, "{Name}", false);
    const query = map({
        [_St]: [, input[_St]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_DescribeKeyValueStoreCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/key-value-store/{Name}");
    b.p("Name", () => input.Name, "{Name}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_DisassociateDistributionTenantWebACLCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution-tenant/{Id}/disassociate-web-acl");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_DisassociateDistributionWebACLCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution/{Id}/disassociate-web-acl");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_GetAnycastIpListCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/anycast-ip-list/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetCachePolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/cache-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetCachePolicyConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/cache-policy/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetCloudFrontOriginAccessIdentityCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-access-identity/cloudfront/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetCloudFrontOriginAccessIdentityConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-access-identity/cloudfront/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetConnectionGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/connection-group/{Identifier}");
    b.p("Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetConnectionGroupByRoutingEndpointCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/connection-group");
    const query = map({
        [_RE]: [, __expectNonNull(input[_RE], `RoutingEndpoint`)],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_GetContinuousDeploymentPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/continuous-deployment-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetContinuousDeploymentPolicyConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/continuous-deployment-policy/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetDistributionConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetDistributionTenantCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution-tenant/{Identifier}");
    b.p("Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetDistributionTenantByDomainCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution-tenant");
    const query = map({
        [_d]: [, __expectNonNull(input[_Do], `Domain`)],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_GetFieldLevelEncryptionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/field-level-encryption/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetFieldLevelEncryptionConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/field-level-encryption/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetFieldLevelEncryptionProfileCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/field-level-encryption-profile/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetFieldLevelEncryptionProfileConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/field-level-encryption-profile/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetFunctionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/function/{Name}");
    b.p("Name", () => input.Name, "{Name}", false);
    const query = map({
        [_St]: [, input[_St]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_GetInvalidationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution/{DistributionId}/invalidation/{Id}");
    b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetInvalidationForDistributionTenantCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution-tenant/{DistributionTenantId}/invalidation/{Id}");
    b.p("DistributionTenantId", () => input.DistributionTenantId, "{DistributionTenantId}", false);
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetKeyGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/key-group/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetKeyGroupConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/key-group/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetManagedCertificateDetailsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/managed-certificate/{Identifier}");
    b.p("Identifier", () => input.Identifier, "{Identifier}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetMonitoringSubscriptionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributions/{DistributionId}/monitoring-subscription");
    b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetOriginAccessControlCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-access-control/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetOriginAccessControlConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-access-control/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetOriginRequestPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-request-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetOriginRequestPolicyConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-request-policy/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetPublicKeyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/public-key/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetPublicKeyConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/public-key/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetRealtimeLogConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/get-realtime-log-config");
    let body;
    body = _ve;
    const bn = new __XmlNode(_GRLCR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_ARN] != null) {
        bn.c(__XmlNode.of(_s, input[_ARN]).n(_ARN));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_GetResponseHeadersPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/response-headers-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetResponseHeadersPolicyConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/response-headers-policy/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetStreamingDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/streaming-distribution/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetStreamingDistributionConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/streaming-distribution/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_GetVpcOriginCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/vpc-origin/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    b.m("GET").h(headers).b(body);
    return b.build();
};
export const se_ListAnycastIpListsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/anycast-ip-list");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListCachePoliciesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/cache-policy");
    const query = map({
        [_Ty]: [, input[_Ty]],
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListCloudFrontOriginAccessIdentitiesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-access-identity/cloudfront");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListConflictingAliasesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/conflicting-alias");
    const query = map({
        [_DI]: [, __expectNonNull(input[_DI], `DistributionId`)],
        [_A]: [, __expectNonNull(input[_A], `Alias`)],
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListConnectionGroupsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/connection-groups");
    let body;
    body = _ve;
    const bn = new __XmlNode(_LCGR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_AF] != null) {
        bn.c(se_ConnectionGroupAssociationFilter(input[_AF], context).n(_AF));
    }
    if (input[_M] != null) {
        bn.c(__XmlNode.of(_s, input[_M]).n(_M));
    }
    if (input[_MI] != null) {
        bn.c(__XmlNode.of(_i, String(input[_MI])).n(_MI));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_ListContinuousDeploymentPoliciesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/continuous-deployment-policy");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsByAnycastIpListIdCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributionsByAnycastIpListId/{AnycastIpListId}");
    b.p("AnycastIpListId", () => input.AnycastIpListId, "{AnycastIpListId}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsByCachePolicyIdCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributionsByCachePolicyId/{CachePolicyId}");
    b.p("CachePolicyId", () => input.CachePolicyId, "{CachePolicyId}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsByConnectionModeCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributionsByConnectionMode/{ConnectionMode}");
    b.p("ConnectionMode", () => input.ConnectionMode, "{ConnectionMode}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsByKeyGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributionsByKeyGroupId/{KeyGroupId}");
    b.p("KeyGroupId", () => input.KeyGroupId, "{KeyGroupId}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsByOriginRequestPolicyIdCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributionsByOriginRequestPolicyId/{OriginRequestPolicyId}");
    b.p("OriginRequestPolicyId", () => input.OriginRequestPolicyId, "{OriginRequestPolicyId}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsByRealtimeLogConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distributionsByRealtimeLogConfig");
    let body;
    body = _ve;
    const bn = new __XmlNode(_LDBRLCR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_M] != null) {
        bn.c(__XmlNode.of(_s, input[_M]).n(_M));
    }
    if (input[_MI] != null) {
        bn.c(__XmlNode.of(_i, String(input[_MI])).n(_MI));
    }
    if (input[_RLCA] != null) {
        bn.c(__XmlNode.of(_s, input[_RLCA]).n(_RLCA));
    }
    if (input[_RLCN] != null) {
        bn.c(__XmlNode.of(_s, input[_RLCN]).n(_RLCN));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_ListDistributionsByResponseHeadersPolicyIdCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributionsByResponseHeadersPolicyId/{ResponseHeadersPolicyId}");
    b.p("ResponseHeadersPolicyId", () => input.ResponseHeadersPolicyId, "{ResponseHeadersPolicyId}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsByVpcOriginIdCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributionsByVpcOriginId/{VpcOriginId}");
    b.p("VpcOriginId", () => input.VpcOriginId, "{VpcOriginId}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionsByWebACLIdCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distributionsByWebACLId/{WebACLId}");
    b.p("WebACLId", () => input.WebACLId, "{WebACLId}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListDistributionTenantsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distribution-tenants");
    let body;
    body = _ve;
    const bn = new __XmlNode(_LDTR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_AF] != null) {
        bn.c(se_DistributionTenantAssociationFilter(input[_AF], context).n(_AF));
    }
    if (input[_M] != null) {
        bn.c(__XmlNode.of(_s, input[_M]).n(_M));
    }
    if (input[_MI] != null) {
        bn.c(__XmlNode.of(_i, String(input[_MI])).n(_MI));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_ListDistributionTenantsByCustomizationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/distribution-tenants-by-customization");
    let body;
    body = _ve;
    const bn = new __XmlNode(_LDTBCR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_CA] != null) {
        bn.c(__XmlNode.of(_s, input[_CA]).n(_CA));
    }
    if (input[_M] != null) {
        bn.c(__XmlNode.of(_s, input[_M]).n(_M));
    }
    if (input[_MI] != null) {
        bn.c(__XmlNode.of(_i, String(input[_MI])).n(_MI));
    }
    if (input[_WACLA] != null) {
        bn.c(__XmlNode.of(_s, input[_WACLA]).n(_WACLA));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_ListDomainConflictsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/domain-conflicts");
    let body;
    body = _ve;
    const bn = new __XmlNode(_LDCR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_Do] != null) {
        bn.c(__XmlNode.of(_s, input[_Do]).n(_Do));
    }
    if (input[_DCVR] != null) {
        bn.c(se_DistributionResourceId(input[_DCVR], context).n(_DCVR));
    }
    if (input[_M] != null) {
        bn.c(__XmlNode.of(_s, input[_M]).n(_M));
    }
    if (input[_MI] != null) {
        bn.c(__XmlNode.of(_i, String(input[_MI])).n(_MI));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_ListFieldLevelEncryptionConfigsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/field-level-encryption");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListFieldLevelEncryptionProfilesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/field-level-encryption-profile");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListFunctionsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/function");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
        [_St]: [, input[_St]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListInvalidationsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution/{DistributionId}/invalidation");
    b.p("DistributionId", () => input.DistributionId, "{DistributionId}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListInvalidationsForDistributionTenantCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/distribution-tenant/{Id}/invalidation");
    b.p("Id", () => input.Id, "{Id}", false);
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListKeyGroupsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/key-group");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListKeyValueStoresCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/key-value-store");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
        [_Sta]: [, input[_Sta]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListOriginAccessControlsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-access-control");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListOriginRequestPoliciesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/origin-request-policy");
    const query = map({
        [_Ty]: [, input[_Ty]],
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListPublicKeysCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/public-key");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListRealtimeLogConfigsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/realtime-log-config");
    const query = map({
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
        [_M]: [, input[_M]],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListResponseHeadersPoliciesCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/response-headers-policy");
    const query = map({
        [_Ty]: [, input[_Ty]],
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListStreamingDistributionsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/streaming-distribution");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/tagging");
    const query = map({
        [_R]: [, __expectNonNull(input[_R], `Resource`)],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_ListVpcOriginsCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {};
    b.bp("/2020-05-31/vpc-origin");
    const query = map({
        [_M]: [, input[_M]],
        [_MI]: [() => input.MaxItems !== void 0, () => input[_MI].toString()],
    });
    let body;
    b.m("GET").h(headers).q(query).b(body);
    return b.build();
};
export const se_PublishFunctionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/function/{Name}/publish");
    b.p("Name", () => input.Name, "{Name}", false);
    let body;
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_TagResourceCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/tagging");
    const query = map({
        [_O]: [, "Tag"],
        [_R]: [, __expectNonNull(input[_R], `Resource`)],
    });
    let body;
    let contents;
    if (input.Tags !== undefined) {
        contents = se_Tags(input.Tags, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).q(query).b(body);
    return b.build();
};
export const se_TestFunctionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/function/{Name}/test");
    b.p("Name", () => input.Name, "{Name}", false);
    let body;
    body = _ve;
    const bn = new __XmlNode(_TFR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_EO] != null) {
        bn.c(__XmlNode.of(_FEO, context.base64Encoder(input[_EO])).n(_EO));
    }
    if (input[_St] != null) {
        bn.c(__XmlNode.of(_FS, input[_St]).n(_St));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UntagResourceCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/tagging");
    const query = map({
        [_O]: [, "Untag"],
        [_R]: [, __expectNonNull(input[_R], `Resource`)],
    });
    let body;
    let contents;
    if (input.TagKeys !== undefined) {
        contents = se_TagKeys(input.TagKeys, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("POST").h(headers).q(query).b(body);
    return b.build();
};
export const se_UpdateCachePolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/cache-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.CachePolicyConfig !== undefined) {
        contents = se_CachePolicyConfig(input.CachePolicyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateCloudFrontOriginAccessIdentityCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/origin-access-identity/cloudfront/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.CloudFrontOriginAccessIdentityConfig !== undefined) {
        contents = se_CloudFrontOriginAccessIdentityConfig(input.CloudFrontOriginAccessIdentityConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateConnectionGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/connection-group/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    body = _ve;
    const bn = new __XmlNode(_UCGR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_AILI] != null) {
        bn.c(__XmlNode.of(_s, input[_AILI]).n(_AILI));
    }
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_IE] != null) {
        bn.c(__XmlNode.of(_b, String(input[_IE])).n(_IE));
    }
    body += bn.toString();
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateContinuousDeploymentPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/continuous-deployment-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.ContinuousDeploymentPolicyConfig !== undefined) {
        contents = se_ContinuousDeploymentPolicyConfig(input.ContinuousDeploymentPolicyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.DistributionConfig !== undefined) {
        contents = se_DistributionConfig(input.DistributionConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateDistributionTenantCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution-tenant/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    body = _ve;
    const bn = new __XmlNode(_UDTR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_CGI] != null) {
        bn.c(__XmlNode.of(_s, input[_CGI]).n(_CGI));
    }
    if (input[_C] != null) {
        bn.c(se_Customizations(input[_C], context).n(_C));
    }
    if (input[_DI] != null) {
        bn.c(__XmlNode.of(_s, input[_DI]).n(_DI));
    }
    bn.lc(input, "Domains", "Domains", () => se_DomainList(input[_D], context));
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_MCR] != null) {
        bn.c(se_ManagedCertificateRequest(input[_MCR], context).n(_MCR));
    }
    bn.lc(input, "Parameters", "Parameters", () => se_Parameters(input[_P], context));
    body += bn.toString();
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateDistributionWithStagingConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/distribution/{Id}/promote-staging-config");
    b.p("Id", () => input.Id, "{Id}", false);
    const query = map({
        [_SDI]: [, input[_SDI]],
    });
    let body;
    b.m("PUT").h(headers).q(query).b(body);
    return b.build();
};
export const se_UpdateDomainAssociationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/domain-association");
    let body;
    body = _ve;
    const bn = new __XmlNode(_UDAR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_Do] != null) {
        bn.c(__XmlNode.of(_s, input[_Do]).n(_Do));
    }
    if (input[_TR] != null) {
        bn.c(se_DistributionResourceId(input[_TR], context).n(_TR));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const se_UpdateFieldLevelEncryptionConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/field-level-encryption/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.FieldLevelEncryptionConfig !== undefined) {
        contents = se_FieldLevelEncryptionConfig(input.FieldLevelEncryptionConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateFieldLevelEncryptionProfileCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/field-level-encryption-profile/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.FieldLevelEncryptionProfileConfig !== undefined) {
        contents = se_FieldLevelEncryptionProfileConfig(input.FieldLevelEncryptionProfileConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateFunctionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/function/{Name}");
    b.p("Name", () => input.Name, "{Name}", false);
    let body;
    body = _ve;
    const bn = new __XmlNode(_UFR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_FC] != null) {
        bn.c(__XmlNode.of(_FB, context.base64Encoder(input[_FC])).n(_FC));
    }
    if (input[_FCu] != null) {
        bn.c(se_FunctionConfig(input[_FCu], context).n(_FCu));
    }
    body += bn.toString();
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateKeyGroupCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/key-group/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.KeyGroupConfig !== undefined) {
        contents = se_KeyGroupConfig(input.KeyGroupConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateKeyValueStoreCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/key-value-store/{Name}");
    b.p("Name", () => input.Name, "{Name}", false);
    let body;
    body = _ve;
    const bn = new __XmlNode(_UKVSR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_KVSC, input[_Co]).n(_Co));
    }
    body += bn.toString();
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateOriginAccessControlCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/origin-access-control/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.OriginAccessControlConfig !== undefined) {
        contents = se_OriginAccessControlConfig(input.OriginAccessControlConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateOriginRequestPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/origin-request-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.OriginRequestPolicyConfig !== undefined) {
        contents = se_OriginRequestPolicyConfig(input.OriginRequestPolicyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdatePublicKeyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/public-key/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.PublicKeyConfig !== undefined) {
        contents = se_PublicKeyConfig(input.PublicKeyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateRealtimeLogConfigCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/realtime-log-config");
    let body;
    body = _ve;
    const bn = new __XmlNode(_URLCR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_ARN] != null) {
        bn.c(__XmlNode.of(_s, input[_ARN]).n(_ARN));
    }
    bn.lc(input, "EndPoints", "EndPoints", () => se_EndPointList(input[_EP], context));
    bn.lc(input, "Fields", "Fields", () => se_FieldList(input[_F], context));
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_SR] != null) {
        bn.c(__XmlNode.of(_l, String(input[_SR])).n(_SR));
    }
    body += bn.toString();
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateResponseHeadersPolicyCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/response-headers-policy/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.ResponseHeadersPolicyConfig !== undefined) {
        contents = se_ResponseHeadersPolicyConfig(input.ResponseHeadersPolicyConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateStreamingDistributionCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/streaming-distribution/{Id}/config");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.StreamingDistributionConfig !== undefined) {
        contents = se_StreamingDistributionConfig(input.StreamingDistributionConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_UpdateVpcOriginCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = map({}, isSerializableHeaderValue, {
        "content-type": "application/xml",
        [_im]: input[_IM],
    });
    b.bp("/2020-05-31/vpc-origin/{Id}");
    b.p("Id", () => input.Id, "{Id}", false);
    let body;
    let contents;
    if (input.VpcOriginEndpointConfig !== undefined) {
        contents = se_VpcOriginEndpointConfig(input.VpcOriginEndpointConfig, context);
        body = _ve;
        contents.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
        body += contents.toString();
    }
    b.m("PUT").h(headers).b(body);
    return b.build();
};
export const se_VerifyDnsConfigurationCommand = async (input, context) => {
    const b = rb(input, context);
    const headers = {
        "content-type": "application/xml",
    };
    b.bp("/2020-05-31/verify-dns-configuration");
    let body;
    body = _ve;
    const bn = new __XmlNode(_VDCR);
    bn.a("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");
    if (input[_Do] != null) {
        bn.c(__XmlNode.of(_s, input[_Do]).n(_Do));
    }
    if (input[_I] != null) {
        bn.c(__XmlNode.of(_s, input[_I]).n(_I));
    }
    body += bn.toString();
    b.m("POST").h(headers).b(body);
    return b.build();
};
export const de_AssociateAliasCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_AssociateDistributionTenantWebACLCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data[_Id] != null) {
        contents[_Id] = __expectString(data[_Id]);
    }
    if (data[_WACLA] != null) {
        contents[_WACLA] = __expectString(data[_WACLA]);
    }
    return contents;
};
export const de_AssociateDistributionWebACLCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data[_Id] != null) {
        contents[_Id] = __expectString(data[_Id]);
    }
    if (data[_WACLA] != null) {
        contents[_WACLA] = __expectString(data[_WACLA]);
    }
    return contents;
};
export const de_CopyDistributionCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Distribution = de_Distribution(data, context);
    return contents;
};
export const de_CreateAnycastIpListCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.AnycastIpList = de_AnycastIpList(data, context);
    return contents;
};
export const de_CreateCachePolicyCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CachePolicy = de_CachePolicy(data, context);
    return contents;
};
export const de_CreateCloudFrontOriginAccessIdentityCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CloudFrontOriginAccessIdentity = de_CloudFrontOriginAccessIdentity(data, context);
    return contents;
};
export const de_CreateConnectionGroupCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ConnectionGroup = de_ConnectionGroup(data, context);
    return contents;
};
export const de_CreateContinuousDeploymentPolicyCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ContinuousDeploymentPolicy = de_ContinuousDeploymentPolicy(data, context);
    return contents;
};
export const de_CreateDistributionCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Distribution = de_Distribution(data, context);
    return contents;
};
export const de_CreateDistributionTenantCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionTenant = de_DistributionTenant(data, context);
    return contents;
};
export const de_CreateDistributionWithTagsCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Distribution = de_Distribution(data, context);
    return contents;
};
export const de_CreateFieldLevelEncryptionConfigCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryption = de_FieldLevelEncryption(data, context);
    return contents;
};
export const de_CreateFieldLevelEncryptionProfileCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryptionProfile = de_FieldLevelEncryptionProfile(data, context);
    return contents;
};
export const de_CreateFunctionCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FunctionSummary = de_FunctionSummary(data, context);
    return contents;
};
export const de_CreateInvalidationCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Invalidation = de_Invalidation(data, context);
    return contents;
};
export const de_CreateInvalidationForDistributionTenantCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Invalidation = de_Invalidation(data, context);
    return contents;
};
export const de_CreateKeyGroupCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyGroup = de_KeyGroup(data, context);
    return contents;
};
export const de_CreateKeyValueStoreCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
        [_L]: [, output.headers[_lo]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyValueStore = de_KeyValueStore(data, context);
    return contents;
};
export const de_CreateMonitoringSubscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.MonitoringSubscription = de_MonitoringSubscription(data, context);
    return contents;
};
export const de_CreateOriginAccessControlCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginAccessControl = de_OriginAccessControl(data, context);
    return contents;
};
export const de_CreateOriginRequestPolicyCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginRequestPolicy = de_OriginRequestPolicy(data, context);
    return contents;
};
export const de_CreatePublicKeyCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.PublicKey = de_PublicKey(data, context);
    return contents;
};
export const de_CreateRealtimeLogConfigCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data[_RLC] != null) {
        contents[_RLC] = de_RealtimeLogConfig(data[_RLC], context);
    }
    return contents;
};
export const de_CreateResponseHeadersPolicyCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ResponseHeadersPolicy = de_ResponseHeadersPolicy(data, context);
    return contents;
};
export const de_CreateStreamingDistributionCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.StreamingDistribution = de_StreamingDistribution(data, context);
    return contents;
};
export const de_CreateStreamingDistributionWithTagsCommand = async (output, context) => {
    if (output.statusCode !== 201 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.StreamingDistribution = de_StreamingDistribution(data, context);
    return contents;
};
export const de_CreateVpcOriginCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_L]: [, output.headers[_lo]],
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.VpcOrigin = de_VpcOrigin(data, context);
    return contents;
};
export const de_DeleteAnycastIpListCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteCachePolicyCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteCloudFrontOriginAccessIdentityCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteConnectionGroupCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteContinuousDeploymentPolicyCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteDistributionCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteDistributionTenantCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteFieldLevelEncryptionConfigCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteFieldLevelEncryptionProfileCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteFunctionCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteKeyGroupCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteKeyValueStoreCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteMonitoringSubscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteOriginAccessControlCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteOriginRequestPolicyCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeletePublicKeyCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteRealtimeLogConfigCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteResponseHeadersPolicyCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteStreamingDistributionCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_DeleteVpcOriginCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.VpcOrigin = de_VpcOrigin(data, context);
    return contents;
};
export const de_DescribeFunctionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FunctionSummary = de_FunctionSummary(data, context);
    return contents;
};
export const de_DescribeKeyValueStoreCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyValueStore = de_KeyValueStore(data, context);
    return contents;
};
export const de_DisassociateDistributionTenantWebACLCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data[_Id] != null) {
        contents[_Id] = __expectString(data[_Id]);
    }
    return contents;
};
export const de_DisassociateDistributionWebACLCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data[_Id] != null) {
        contents[_Id] = __expectString(data[_Id]);
    }
    return contents;
};
export const de_GetAnycastIpListCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.AnycastIpList = de_AnycastIpList(data, context);
    return contents;
};
export const de_GetCachePolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CachePolicy = de_CachePolicy(data, context);
    return contents;
};
export const de_GetCachePolicyConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CachePolicyConfig = de_CachePolicyConfig(data, context);
    return contents;
};
export const de_GetCloudFrontOriginAccessIdentityCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CloudFrontOriginAccessIdentity = de_CloudFrontOriginAccessIdentity(data, context);
    return contents;
};
export const de_GetCloudFrontOriginAccessIdentityConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CloudFrontOriginAccessIdentityConfig = de_CloudFrontOriginAccessIdentityConfig(data, context);
    return contents;
};
export const de_GetConnectionGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ConnectionGroup = de_ConnectionGroup(data, context);
    return contents;
};
export const de_GetConnectionGroupByRoutingEndpointCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ConnectionGroup = de_ConnectionGroup(data, context);
    return contents;
};
export const de_GetContinuousDeploymentPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ContinuousDeploymentPolicy = de_ContinuousDeploymentPolicy(data, context);
    return contents;
};
export const de_GetContinuousDeploymentPolicyConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ContinuousDeploymentPolicyConfig = de_ContinuousDeploymentPolicyConfig(data, context);
    return contents;
};
export const de_GetDistributionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Distribution = de_Distribution(data, context);
    return contents;
};
export const de_GetDistributionConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionConfig = de_DistributionConfig(data, context);
    return contents;
};
export const de_GetDistributionTenantCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionTenant = de_DistributionTenant(data, context);
    return contents;
};
export const de_GetDistributionTenantByDomainCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionTenant = de_DistributionTenant(data, context);
    return contents;
};
export const de_GetFieldLevelEncryptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryption = de_FieldLevelEncryption(data, context);
    return contents;
};
export const de_GetFieldLevelEncryptionConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryptionConfig = de_FieldLevelEncryptionConfig(data, context);
    return contents;
};
export const de_GetFieldLevelEncryptionProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryptionProfile = de_FieldLevelEncryptionProfile(data, context);
    return contents;
};
export const de_GetFieldLevelEncryptionProfileConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryptionProfileConfig = de_FieldLevelEncryptionProfileConfig(data, context);
    return contents;
};
export const de_GetFunctionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
        [_CT]: [, output.headers[_ct]],
    });
    const data = await collectBody(output.body, context);
    contents.FunctionCode = data;
    return contents;
};
export const de_GetInvalidationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Invalidation = de_Invalidation(data, context);
    return contents;
};
export const de_GetInvalidationForDistributionTenantCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Invalidation = de_Invalidation(data, context);
    return contents;
};
export const de_GetKeyGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyGroup = de_KeyGroup(data, context);
    return contents;
};
export const de_GetKeyGroupConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyGroupConfig = de_KeyGroupConfig(data, context);
    return contents;
};
export const de_GetManagedCertificateDetailsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ManagedCertificateDetails = de_ManagedCertificateDetails(data, context);
    return contents;
};
export const de_GetMonitoringSubscriptionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.MonitoringSubscription = de_MonitoringSubscription(data, context);
    return contents;
};
export const de_GetOriginAccessControlCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginAccessControl = de_OriginAccessControl(data, context);
    return contents;
};
export const de_GetOriginAccessControlConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginAccessControlConfig = de_OriginAccessControlConfig(data, context);
    return contents;
};
export const de_GetOriginRequestPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginRequestPolicy = de_OriginRequestPolicy(data, context);
    return contents;
};
export const de_GetOriginRequestPolicyConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginRequestPolicyConfig = de_OriginRequestPolicyConfig(data, context);
    return contents;
};
export const de_GetPublicKeyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.PublicKey = de_PublicKey(data, context);
    return contents;
};
export const de_GetPublicKeyConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.PublicKeyConfig = de_PublicKeyConfig(data, context);
    return contents;
};
export const de_GetRealtimeLogConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data[_RLC] != null) {
        contents[_RLC] = de_RealtimeLogConfig(data[_RLC], context);
    }
    return contents;
};
export const de_GetResponseHeadersPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ResponseHeadersPolicy = de_ResponseHeadersPolicy(data, context);
    return contents;
};
export const de_GetResponseHeadersPolicyConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ResponseHeadersPolicyConfig = de_ResponseHeadersPolicyConfig(data, context);
    return contents;
};
export const de_GetStreamingDistributionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.StreamingDistribution = de_StreamingDistribution(data, context);
    return contents;
};
export const de_GetStreamingDistributionConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.StreamingDistributionConfig = de_StreamingDistributionConfig(data, context);
    return contents;
};
export const de_GetVpcOriginCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.VpcOrigin = de_VpcOrigin(data, context);
    return contents;
};
export const de_ListAnycastIpListsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.AnycastIpLists = de_AnycastIpListCollection(data, context);
    return contents;
};
export const de_ListCachePoliciesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CachePolicyList = de_CachePolicyList(data, context);
    return contents;
};
export const de_ListCloudFrontOriginAccessIdentitiesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CloudFrontOriginAccessIdentityList = de_CloudFrontOriginAccessIdentityList(data, context);
    return contents;
};
export const de_ListConflictingAliasesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ConflictingAliasesList = de_ConflictingAliasesList(data, context);
    return contents;
};
export const de_ListConnectionGroupsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.ConnectionGroups === "") {
        contents[_CG] = [];
    }
    else if (data[_CG] != null && data[_CG][_CGS] != null) {
        contents[_CG] = de_ConnectionGroupSummaryList(__getArrayIfSingleItem(data[_CG][_CGS]), context);
    }
    if (data[_NM] != null) {
        contents[_NM] = __expectString(data[_NM]);
    }
    return contents;
};
export const de_ListContinuousDeploymentPoliciesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ContinuousDeploymentPolicyList = de_ContinuousDeploymentPolicyList(data, context);
    return contents;
};
export const de_ListDistributionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionList = de_DistributionList(data, context);
    return contents;
};
export const de_ListDistributionsByAnycastIpListIdCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionList = de_DistributionList(data, context);
    return contents;
};
export const de_ListDistributionsByCachePolicyIdCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionIdList = de_DistributionIdList(data, context);
    return contents;
};
export const de_ListDistributionsByConnectionModeCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionList = de_DistributionList(data, context);
    return contents;
};
export const de_ListDistributionsByKeyGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionIdList = de_DistributionIdList(data, context);
    return contents;
};
export const de_ListDistributionsByOriginRequestPolicyIdCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionIdList = de_DistributionIdList(data, context);
    return contents;
};
export const de_ListDistributionsByRealtimeLogConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionList = de_DistributionList(data, context);
    return contents;
};
export const de_ListDistributionsByResponseHeadersPolicyIdCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionIdList = de_DistributionIdList(data, context);
    return contents;
};
export const de_ListDistributionsByVpcOriginIdCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionIdList = de_DistributionIdList(data, context);
    return contents;
};
export const de_ListDistributionsByWebACLIdCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionList = de_DistributionList(data, context);
    return contents;
};
export const de_ListDistributionTenantsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.DistributionTenantList === "") {
        contents[_DTL] = [];
    }
    else if (data[_DTL] != null && data[_DTL][_DTS] != null) {
        contents[_DTL] = de_DistributionTenantList(__getArrayIfSingleItem(data[_DTL][_DTS]), context);
    }
    if (data[_NM] != null) {
        contents[_NM] = __expectString(data[_NM]);
    }
    return contents;
};
export const de_ListDistributionTenantsByCustomizationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.DistributionTenantList === "") {
        contents[_DTL] = [];
    }
    else if (data[_DTL] != null && data[_DTL][_DTS] != null) {
        contents[_DTL] = de_DistributionTenantList(__getArrayIfSingleItem(data[_DTL][_DTS]), context);
    }
    if (data[_NM] != null) {
        contents[_NM] = __expectString(data[_NM]);
    }
    return contents;
};
export const de_ListDomainConflictsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.DomainConflicts === "") {
        contents[_DC] = [];
    }
    else if (data[_DC] != null && data[_DC][_DC] != null) {
        contents[_DC] = de_DomainConflictsList(__getArrayIfSingleItem(data[_DC][_DC]), context);
    }
    if (data[_NM] != null) {
        contents[_NM] = __expectString(data[_NM]);
    }
    return contents;
};
export const de_ListFieldLevelEncryptionConfigsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryptionList = de_FieldLevelEncryptionList(data, context);
    return contents;
};
export const de_ListFieldLevelEncryptionProfilesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryptionProfileList = de_FieldLevelEncryptionProfileList(data, context);
    return contents;
};
export const de_ListFunctionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FunctionList = de_FunctionList(data, context);
    return contents;
};
export const de_ListInvalidationsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.InvalidationList = de_InvalidationList(data, context);
    return contents;
};
export const de_ListInvalidationsForDistributionTenantCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.InvalidationList = de_InvalidationList(data, context);
    return contents;
};
export const de_ListKeyGroupsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyGroupList = de_KeyGroupList(data, context);
    return contents;
};
export const de_ListKeyValueStoresCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyValueStoreList = de_KeyValueStoreList(data, context);
    return contents;
};
export const de_ListOriginAccessControlsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginAccessControlList = de_OriginAccessControlList(data, context);
    return contents;
};
export const de_ListOriginRequestPoliciesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginRequestPolicyList = de_OriginRequestPolicyList(data, context);
    return contents;
};
export const de_ListPublicKeysCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.PublicKeyList = de_PublicKeyList(data, context);
    return contents;
};
export const de_ListRealtimeLogConfigsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.RealtimeLogConfigs = de_RealtimeLogConfigs(data, context);
    return contents;
};
export const de_ListResponseHeadersPoliciesCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ResponseHeadersPolicyList = de_ResponseHeadersPolicyList(data, context);
    return contents;
};
export const de_ListStreamingDistributionsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.StreamingDistributionList = de_StreamingDistributionList(data, context);
    return contents;
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Tags = de_Tags(data, context);
    return contents;
};
export const de_ListVpcOriginsCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.VpcOriginList = de_VpcOriginList(data, context);
    return contents;
};
export const de_PublishFunctionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FunctionSummary = de_FunctionSummary(data, context);
    return contents;
};
export const de_TagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_TestFunctionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.TestResult = de_TestResult(data, context);
    return contents;
};
export const de_UntagResourceCommand = async (output, context) => {
    if (output.statusCode !== 204 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    await collectBody(output.body, context);
    return contents;
};
export const de_UpdateCachePolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CachePolicy = de_CachePolicy(data, context);
    return contents;
};
export const de_UpdateCloudFrontOriginAccessIdentityCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.CloudFrontOriginAccessIdentity = de_CloudFrontOriginAccessIdentity(data, context);
    return contents;
};
export const de_UpdateConnectionGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ConnectionGroup = de_ConnectionGroup(data, context);
    return contents;
};
export const de_UpdateContinuousDeploymentPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ContinuousDeploymentPolicy = de_ContinuousDeploymentPolicy(data, context);
    return contents;
};
export const de_UpdateDistributionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Distribution = de_Distribution(data, context);
    return contents;
};
export const de_UpdateDistributionTenantCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.DistributionTenant = de_DistributionTenant(data, context);
    return contents;
};
export const de_UpdateDistributionWithStagingConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.Distribution = de_Distribution(data, context);
    return contents;
};
export const de_UpdateDomainAssociationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data[_Do] != null) {
        contents[_Do] = __expectString(data[_Do]);
    }
    if (data[_RI] != null) {
        contents[_RI] = __expectString(data[_RI]);
    }
    return contents;
};
export const de_UpdateFieldLevelEncryptionConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryption = de_FieldLevelEncryption(data, context);
    return contents;
};
export const de_UpdateFieldLevelEncryptionProfileCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FieldLevelEncryptionProfile = de_FieldLevelEncryptionProfile(data, context);
    return contents;
};
export const de_UpdateFunctionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_et]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.FunctionSummary = de_FunctionSummary(data, context);
    return contents;
};
export const de_UpdateKeyGroupCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyGroup = de_KeyGroup(data, context);
    return contents;
};
export const de_UpdateKeyValueStoreCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.KeyValueStore = de_KeyValueStore(data, context);
    return contents;
};
export const de_UpdateOriginAccessControlCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginAccessControl = de_OriginAccessControl(data, context);
    return contents;
};
export const de_UpdateOriginRequestPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.OriginRequestPolicy = de_OriginRequestPolicy(data, context);
    return contents;
};
export const de_UpdatePublicKeyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.PublicKey = de_PublicKey(data, context);
    return contents;
};
export const de_UpdateRealtimeLogConfigCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data[_RLC] != null) {
        contents[_RLC] = de_RealtimeLogConfig(data[_RLC], context);
    }
    return contents;
};
export const de_UpdateResponseHeadersPolicyCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.ResponseHeadersPolicy = de_ResponseHeadersPolicy(data, context);
    return contents;
};
export const de_UpdateStreamingDistributionCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.StreamingDistribution = de_StreamingDistribution(data, context);
    return contents;
};
export const de_UpdateVpcOriginCommand = async (output, context) => {
    if (output.statusCode !== 202 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
        [_ET]: [, output.headers[_e]],
    });
    const data = __expectObject(await parseBody(output.body, context));
    contents.VpcOrigin = de_VpcOrigin(data, context);
    return contents;
};
export const de_VerifyDnsConfigurationCommand = async (output, context) => {
    if (output.statusCode !== 200 && output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const contents = map({
        $metadata: deserializeMetadata(output),
    });
    const data = __expectNonNull(__expectObject(await parseBody(output.body, context)), "body");
    if (data.DnsConfigurationList === "") {
        contents[_DCL] = [];
    }
    else if (data[_DCL] != null && data[_DCL][_DCn] != null) {
        contents[_DCL] = de_DnsConfigurationList(__getArrayIfSingleItem(data[_DCL][_DCn]), context);
    }
    return contents;
};
const de_CommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadRestXmlErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "AccessDenied":
        case "com.amazonaws.cloudfront#AccessDenied":
            throw await de_AccessDeniedRes(parsedOutput, context);
        case "IllegalUpdate":
        case "com.amazonaws.cloudfront#IllegalUpdate":
            throw await de_IllegalUpdateRes(parsedOutput, context);
        case "InvalidArgument":
        case "com.amazonaws.cloudfront#InvalidArgument":
            throw await de_InvalidArgumentRes(parsedOutput, context);
        case "NoSuchDistribution":
        case "com.amazonaws.cloudfront#NoSuchDistribution":
            throw await de_NoSuchDistributionRes(parsedOutput, context);
        case "TooManyDistributionCNAMEs":
        case "com.amazonaws.cloudfront#TooManyDistributionCNAMEs":
            throw await de_TooManyDistributionCNAMEsRes(parsedOutput, context);
        case "EntityNotFound":
        case "com.amazonaws.cloudfront#EntityNotFound":
            throw await de_EntityNotFoundRes(parsedOutput, context);
        case "InvalidIfMatchVersion":
        case "com.amazonaws.cloudfront#InvalidIfMatchVersion":
            throw await de_InvalidIfMatchVersionRes(parsedOutput, context);
        case "PreconditionFailed":
        case "com.amazonaws.cloudfront#PreconditionFailed":
            throw await de_PreconditionFailedRes(parsedOutput, context);
        case "CNAMEAlreadyExists":
        case "com.amazonaws.cloudfront#CNAMEAlreadyExists":
            throw await de_CNAMEAlreadyExistsRes(parsedOutput, context);
        case "DistributionAlreadyExists":
        case "com.amazonaws.cloudfront#DistributionAlreadyExists":
            throw await de_DistributionAlreadyExistsRes(parsedOutput, context);
        case "IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior":
        case "com.amazonaws.cloudfront#IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior":
            throw await de_IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorRes(parsedOutput, context);
        case "InconsistentQuantities":
        case "com.amazonaws.cloudfront#InconsistentQuantities":
            throw await de_InconsistentQuantitiesRes(parsedOutput, context);
        case "InvalidDefaultRootObject":
        case "com.amazonaws.cloudfront#InvalidDefaultRootObject":
            throw await de_InvalidDefaultRootObjectRes(parsedOutput, context);
        case "InvalidErrorCode":
        case "com.amazonaws.cloudfront#InvalidErrorCode":
            throw await de_InvalidErrorCodeRes(parsedOutput, context);
        case "InvalidForwardCookies":
        case "com.amazonaws.cloudfront#InvalidForwardCookies":
            throw await de_InvalidForwardCookiesRes(parsedOutput, context);
        case "InvalidFunctionAssociation":
        case "com.amazonaws.cloudfront#InvalidFunctionAssociation":
            throw await de_InvalidFunctionAssociationRes(parsedOutput, context);
        case "InvalidGeoRestrictionParameter":
        case "com.amazonaws.cloudfront#InvalidGeoRestrictionParameter":
            throw await de_InvalidGeoRestrictionParameterRes(parsedOutput, context);
        case "InvalidHeadersForS3Origin":
        case "com.amazonaws.cloudfront#InvalidHeadersForS3Origin":
            throw await de_InvalidHeadersForS3OriginRes(parsedOutput, context);
        case "InvalidLambdaFunctionAssociation":
        case "com.amazonaws.cloudfront#InvalidLambdaFunctionAssociation":
            throw await de_InvalidLambdaFunctionAssociationRes(parsedOutput, context);
        case "InvalidLocationCode":
        case "com.amazonaws.cloudfront#InvalidLocationCode":
            throw await de_InvalidLocationCodeRes(parsedOutput, context);
        case "InvalidMinimumProtocolVersion":
        case "com.amazonaws.cloudfront#InvalidMinimumProtocolVersion":
            throw await de_InvalidMinimumProtocolVersionRes(parsedOutput, context);
        case "InvalidOrigin":
        case "com.amazonaws.cloudfront#InvalidOrigin":
            throw await de_InvalidOriginRes(parsedOutput, context);
        case "InvalidOriginAccessControl":
        case "com.amazonaws.cloudfront#InvalidOriginAccessControl":
            throw await de_InvalidOriginAccessControlRes(parsedOutput, context);
        case "InvalidOriginAccessIdentity":
        case "com.amazonaws.cloudfront#InvalidOriginAccessIdentity":
            throw await de_InvalidOriginAccessIdentityRes(parsedOutput, context);
        case "InvalidOriginKeepaliveTimeout":
        case "com.amazonaws.cloudfront#InvalidOriginKeepaliveTimeout":
            throw await de_InvalidOriginKeepaliveTimeoutRes(parsedOutput, context);
        case "InvalidOriginReadTimeout":
        case "com.amazonaws.cloudfront#InvalidOriginReadTimeout":
            throw await de_InvalidOriginReadTimeoutRes(parsedOutput, context);
        case "InvalidProtocolSettings":
        case "com.amazonaws.cloudfront#InvalidProtocolSettings":
            throw await de_InvalidProtocolSettingsRes(parsedOutput, context);
        case "InvalidQueryStringParameters":
        case "com.amazonaws.cloudfront#InvalidQueryStringParameters":
            throw await de_InvalidQueryStringParametersRes(parsedOutput, context);
        case "InvalidRelativePath":
        case "com.amazonaws.cloudfront#InvalidRelativePath":
            throw await de_InvalidRelativePathRes(parsedOutput, context);
        case "InvalidRequiredProtocol":
        case "com.amazonaws.cloudfront#InvalidRequiredProtocol":
            throw await de_InvalidRequiredProtocolRes(parsedOutput, context);
        case "InvalidResponseCode":
        case "com.amazonaws.cloudfront#InvalidResponseCode":
            throw await de_InvalidResponseCodeRes(parsedOutput, context);
        case "InvalidTTLOrder":
        case "com.amazonaws.cloudfront#InvalidTTLOrder":
            throw await de_InvalidTTLOrderRes(parsedOutput, context);
        case "InvalidViewerCertificate":
        case "com.amazonaws.cloudfront#InvalidViewerCertificate":
            throw await de_InvalidViewerCertificateRes(parsedOutput, context);
        case "InvalidWebACLId":
        case "com.amazonaws.cloudfront#InvalidWebACLId":
            throw await de_InvalidWebACLIdRes(parsedOutput, context);
        case "MissingBody":
        case "com.amazonaws.cloudfront#MissingBody":
            throw await de_MissingBodyRes(parsedOutput, context);
        case "NoSuchCachePolicy":
        case "com.amazonaws.cloudfront#NoSuchCachePolicy":
            throw await de_NoSuchCachePolicyRes(parsedOutput, context);
        case "NoSuchFieldLevelEncryptionConfig":
        case "com.amazonaws.cloudfront#NoSuchFieldLevelEncryptionConfig":
            throw await de_NoSuchFieldLevelEncryptionConfigRes(parsedOutput, context);
        case "NoSuchOrigin":
        case "com.amazonaws.cloudfront#NoSuchOrigin":
            throw await de_NoSuchOriginRes(parsedOutput, context);
        case "NoSuchOriginRequestPolicy":
        case "com.amazonaws.cloudfront#NoSuchOriginRequestPolicy":
            throw await de_NoSuchOriginRequestPolicyRes(parsedOutput, context);
        case "NoSuchRealtimeLogConfig":
        case "com.amazonaws.cloudfront#NoSuchRealtimeLogConfig":
            throw await de_NoSuchRealtimeLogConfigRes(parsedOutput, context);
        case "NoSuchResponseHeadersPolicy":
        case "com.amazonaws.cloudfront#NoSuchResponseHeadersPolicy":
            throw await de_NoSuchResponseHeadersPolicyRes(parsedOutput, context);
        case "RealtimeLogConfigOwnerMismatch":
        case "com.amazonaws.cloudfront#RealtimeLogConfigOwnerMismatch":
            throw await de_RealtimeLogConfigOwnerMismatchRes(parsedOutput, context);
        case "TooManyCacheBehaviors":
        case "com.amazonaws.cloudfront#TooManyCacheBehaviors":
            throw await de_TooManyCacheBehaviorsRes(parsedOutput, context);
        case "TooManyCertificates":
        case "com.amazonaws.cloudfront#TooManyCertificates":
            throw await de_TooManyCertificatesRes(parsedOutput, context);
        case "TooManyCookieNamesInWhiteList":
        case "com.amazonaws.cloudfront#TooManyCookieNamesInWhiteList":
            throw await de_TooManyCookieNamesInWhiteListRes(parsedOutput, context);
        case "TooManyDistributions":
        case "com.amazonaws.cloudfront#TooManyDistributions":
            throw await de_TooManyDistributionsRes(parsedOutput, context);
        case "TooManyDistributionsAssociatedToCachePolicy":
        case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToCachePolicy":
            throw await de_TooManyDistributionsAssociatedToCachePolicyRes(parsedOutput, context);
        case "TooManyDistributionsAssociatedToFieldLevelEncryptionConfig":
        case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToFieldLevelEncryptionConfig":
            throw await de_TooManyDistributionsAssociatedToFieldLevelEncryptionConfigRes(parsedOutput, context);
        case "TooManyDistributionsAssociatedToKeyGroup":
        case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToKeyGroup":
            throw await de_TooManyDistributionsAssociatedToKeyGroupRes(parsedOutput, context);
        case "TooManyDistributionsAssociatedToOriginAccessControl":
        case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToOriginAccessControl":
            throw await de_TooManyDistributionsAssociatedToOriginAccessControlRes(parsedOutput, context);
        case "TooManyDistributionsAssociatedToOriginRequestPolicy":
        case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToOriginRequestPolicy":
            throw await de_TooManyDistributionsAssociatedToOriginRequestPolicyRes(parsedOutput, context);
        case "TooManyDistributionsAssociatedToResponseHeadersPolicy":
        case "com.amazonaws.cloudfront#TooManyDistributionsAssociatedToResponseHeadersPolicy":
            throw await de_TooManyDistributionsAssociatedToResponseHeadersPolicyRes(parsedOutput, context);
        case "TooManyDistributionsWithFunctionAssociations":
        case "com.amazonaws.cloudfront#TooManyDistributionsWithFunctionAssociations":
            throw await de_TooManyDistributionsWithFunctionAssociationsRes(parsedOutput, context);
        case "TooManyDistributionsWithLambdaAssociations":
        case "com.amazonaws.cloudfront#TooManyDistributionsWithLambdaAssociations":
            throw await de_TooManyDistributionsWithLambdaAssociationsRes(parsedOutput, context);
        case "TooManyDistributionsWithSingleFunctionARN":
        case "com.amazonaws.cloudfront#TooManyDistributionsWithSingleFunctionARN":
            throw await de_TooManyDistributionsWithSingleFunctionARNRes(parsedOutput, context);
        case "TooManyFunctionAssociations":
        case "com.amazonaws.cloudfront#TooManyFunctionAssociations":
            throw await de_TooManyFunctionAssociationsRes(parsedOutput, context);
        case "TooManyHeadersInForwardedValues":
        case "com.amazonaws.cloudfront#TooManyHeadersInForwardedValues":
            throw await de_TooManyHeadersInForwardedValuesRes(parsedOutput, context);
        case "TooManyKeyGroupsAssociatedToDistribution":
        case "com.amazonaws.cloudfront#TooManyKeyGroupsAssociatedToDistribution":
            throw await de_TooManyKeyGroupsAssociatedToDistributionRes(parsedOutput, context);
        case "TooManyLambdaFunctionAssociations":
        case "com.amazonaws.cloudfront#TooManyLambdaFunctionAssociations":
            throw await de_TooManyLambdaFunctionAssociationsRes(parsedOutput, context);
        case "TooManyOriginCustomHeaders":
        case "com.amazonaws.cloudfront#TooManyOriginCustomHeaders":
            throw await de_TooManyOriginCustomHeadersRes(parsedOutput, context);
        case "TooManyOriginGroupsPerDistribution":
        case "com.amazonaws.cloudfront#TooManyOriginGroupsPerDistribution":
            throw await de_TooManyOriginGroupsPerDistributionRes(parsedOutput, context);
        case "TooManyOrigins":
        case "com.amazonaws.cloudfront#TooManyOrigins":
            throw await de_TooManyOriginsRes(parsedOutput, context);
        case "TooManyQueryStringParameters":
        case "com.amazonaws.cloudfront#TooManyQueryStringParameters":
            throw await de_TooManyQueryStringParametersRes(parsedOutput, context);
        case "TooManyTrustedSigners":
        case "com.amazonaws.cloudfront#TooManyTrustedSigners":
            throw await de_TooManyTrustedSignersRes(parsedOutput, context);
        case "TrustedKeyGroupDoesNotExist":
        case "com.amazonaws.cloudfront#TrustedKeyGroupDoesNotExist":
            throw await de_TrustedKeyGroupDoesNotExistRes(parsedOutput, context);
        case "TrustedSignerDoesNotExist":
        case "com.amazonaws.cloudfront#TrustedSignerDoesNotExist":
            throw await de_TrustedSignerDoesNotExistRes(parsedOutput, context);
        case "EntityAlreadyExists":
        case "com.amazonaws.cloudfront#EntityAlreadyExists":
            throw await de_EntityAlreadyExistsRes(parsedOutput, context);
        case "EntityLimitExceeded":
        case "com.amazonaws.cloudfront#EntityLimitExceeded":
            throw await de_EntityLimitExceededRes(parsedOutput, context);
        case "InvalidTagging":
        case "com.amazonaws.cloudfront#InvalidTagging":
            throw await de_InvalidTaggingRes(parsedOutput, context);
        case "UnsupportedOperation":
        case "com.amazonaws.cloudfront#UnsupportedOperation":
            throw await de_UnsupportedOperationRes(parsedOutput, context);
        case "CachePolicyAlreadyExists":
        case "com.amazonaws.cloudfront#CachePolicyAlreadyExists":
            throw await de_CachePolicyAlreadyExistsRes(parsedOutput, context);
        case "TooManyCachePolicies":
        case "com.amazonaws.cloudfront#TooManyCachePolicies":
            throw await de_TooManyCachePoliciesRes(parsedOutput, context);
        case "TooManyCookiesInCachePolicy":
        case "com.amazonaws.cloudfront#TooManyCookiesInCachePolicy":
            throw await de_TooManyCookiesInCachePolicyRes(parsedOutput, context);
        case "TooManyHeadersInCachePolicy":
        case "com.amazonaws.cloudfront#TooManyHeadersInCachePolicy":
            throw await de_TooManyHeadersInCachePolicyRes(parsedOutput, context);
        case "TooManyQueryStringsInCachePolicy":
        case "com.amazonaws.cloudfront#TooManyQueryStringsInCachePolicy":
            throw await de_TooManyQueryStringsInCachePolicyRes(parsedOutput, context);
        case "CloudFrontOriginAccessIdentityAlreadyExists":
        case "com.amazonaws.cloudfront#CloudFrontOriginAccessIdentityAlreadyExists":
            throw await de_CloudFrontOriginAccessIdentityAlreadyExistsRes(parsedOutput, context);
        case "TooManyCloudFrontOriginAccessIdentities":
        case "com.amazonaws.cloudfront#TooManyCloudFrontOriginAccessIdentities":
            throw await de_TooManyCloudFrontOriginAccessIdentitiesRes(parsedOutput, context);
        case "ContinuousDeploymentPolicyAlreadyExists":
        case "com.amazonaws.cloudfront#ContinuousDeploymentPolicyAlreadyExists":
            throw await de_ContinuousDeploymentPolicyAlreadyExistsRes(parsedOutput, context);
        case "StagingDistributionInUse":
        case "com.amazonaws.cloudfront#StagingDistributionInUse":
            throw await de_StagingDistributionInUseRes(parsedOutput, context);
        case "TooManyContinuousDeploymentPolicies":
        case "com.amazonaws.cloudfront#TooManyContinuousDeploymentPolicies":
            throw await de_TooManyContinuousDeploymentPoliciesRes(parsedOutput, context);
        case "ContinuousDeploymentPolicyInUse":
        case "com.amazonaws.cloudfront#ContinuousDeploymentPolicyInUse":
            throw await de_ContinuousDeploymentPolicyInUseRes(parsedOutput, context);
        case "IllegalOriginAccessConfiguration":
        case "com.amazonaws.cloudfront#IllegalOriginAccessConfiguration":
            throw await de_IllegalOriginAccessConfigurationRes(parsedOutput, context);
        case "InvalidDomainNameForOriginAccessControl":
        case "com.amazonaws.cloudfront#InvalidDomainNameForOriginAccessControl":
            throw await de_InvalidDomainNameForOriginAccessControlRes(parsedOutput, context);
        case "NoSuchContinuousDeploymentPolicy":
        case "com.amazonaws.cloudfront#NoSuchContinuousDeploymentPolicy":
            throw await de_NoSuchContinuousDeploymentPolicyRes(parsedOutput, context);
        case "InvalidAssociation":
        case "com.amazonaws.cloudfront#InvalidAssociation":
            throw await de_InvalidAssociationRes(parsedOutput, context);
        case "FieldLevelEncryptionConfigAlreadyExists":
        case "com.amazonaws.cloudfront#FieldLevelEncryptionConfigAlreadyExists":
            throw await de_FieldLevelEncryptionConfigAlreadyExistsRes(parsedOutput, context);
        case "NoSuchFieldLevelEncryptionProfile":
        case "com.amazonaws.cloudfront#NoSuchFieldLevelEncryptionProfile":
            throw await de_NoSuchFieldLevelEncryptionProfileRes(parsedOutput, context);
        case "QueryArgProfileEmpty":
        case "com.amazonaws.cloudfront#QueryArgProfileEmpty":
            throw await de_QueryArgProfileEmptyRes(parsedOutput, context);
        case "TooManyFieldLevelEncryptionConfigs":
        case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionConfigs":
            throw await de_TooManyFieldLevelEncryptionConfigsRes(parsedOutput, context);
        case "TooManyFieldLevelEncryptionContentTypeProfiles":
        case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionContentTypeProfiles":
            throw await de_TooManyFieldLevelEncryptionContentTypeProfilesRes(parsedOutput, context);
        case "TooManyFieldLevelEncryptionQueryArgProfiles":
        case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionQueryArgProfiles":
            throw await de_TooManyFieldLevelEncryptionQueryArgProfilesRes(parsedOutput, context);
        case "FieldLevelEncryptionProfileAlreadyExists":
        case "com.amazonaws.cloudfront#FieldLevelEncryptionProfileAlreadyExists":
            throw await de_FieldLevelEncryptionProfileAlreadyExistsRes(parsedOutput, context);
        case "FieldLevelEncryptionProfileSizeExceeded":
        case "com.amazonaws.cloudfront#FieldLevelEncryptionProfileSizeExceeded":
            throw await de_FieldLevelEncryptionProfileSizeExceededRes(parsedOutput, context);
        case "NoSuchPublicKey":
        case "com.amazonaws.cloudfront#NoSuchPublicKey":
            throw await de_NoSuchPublicKeyRes(parsedOutput, context);
        case "TooManyFieldLevelEncryptionEncryptionEntities":
        case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionEncryptionEntities":
            throw await de_TooManyFieldLevelEncryptionEncryptionEntitiesRes(parsedOutput, context);
        case "TooManyFieldLevelEncryptionFieldPatterns":
        case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionFieldPatterns":
            throw await de_TooManyFieldLevelEncryptionFieldPatternsRes(parsedOutput, context);
        case "TooManyFieldLevelEncryptionProfiles":
        case "com.amazonaws.cloudfront#TooManyFieldLevelEncryptionProfiles":
            throw await de_TooManyFieldLevelEncryptionProfilesRes(parsedOutput, context);
        case "FunctionAlreadyExists":
        case "com.amazonaws.cloudfront#FunctionAlreadyExists":
            throw await de_FunctionAlreadyExistsRes(parsedOutput, context);
        case "FunctionSizeLimitExceeded":
        case "com.amazonaws.cloudfront#FunctionSizeLimitExceeded":
            throw await de_FunctionSizeLimitExceededRes(parsedOutput, context);
        case "TooManyFunctions":
        case "com.amazonaws.cloudfront#TooManyFunctions":
            throw await de_TooManyFunctionsRes(parsedOutput, context);
        case "BatchTooLarge":
        case "com.amazonaws.cloudfront#BatchTooLarge":
            throw await de_BatchTooLargeRes(parsedOutput, context);
        case "TooManyInvalidationsInProgress":
        case "com.amazonaws.cloudfront#TooManyInvalidationsInProgress":
            throw await de_TooManyInvalidationsInProgressRes(parsedOutput, context);
        case "KeyGroupAlreadyExists":
        case "com.amazonaws.cloudfront#KeyGroupAlreadyExists":
            throw await de_KeyGroupAlreadyExistsRes(parsedOutput, context);
        case "TooManyKeyGroups":
        case "com.amazonaws.cloudfront#TooManyKeyGroups":
            throw await de_TooManyKeyGroupsRes(parsedOutput, context);
        case "TooManyPublicKeysInKeyGroup":
        case "com.amazonaws.cloudfront#TooManyPublicKeysInKeyGroup":
            throw await de_TooManyPublicKeysInKeyGroupRes(parsedOutput, context);
        case "EntitySizeLimitExceeded":
        case "com.amazonaws.cloudfront#EntitySizeLimitExceeded":
            throw await de_EntitySizeLimitExceededRes(parsedOutput, context);
        case "MonitoringSubscriptionAlreadyExists":
        case "com.amazonaws.cloudfront#MonitoringSubscriptionAlreadyExists":
            throw await de_MonitoringSubscriptionAlreadyExistsRes(parsedOutput, context);
        case "OriginAccessControlAlreadyExists":
        case "com.amazonaws.cloudfront#OriginAccessControlAlreadyExists":
            throw await de_OriginAccessControlAlreadyExistsRes(parsedOutput, context);
        case "TooManyOriginAccessControls":
        case "com.amazonaws.cloudfront#TooManyOriginAccessControls":
            throw await de_TooManyOriginAccessControlsRes(parsedOutput, context);
        case "OriginRequestPolicyAlreadyExists":
        case "com.amazonaws.cloudfront#OriginRequestPolicyAlreadyExists":
            throw await de_OriginRequestPolicyAlreadyExistsRes(parsedOutput, context);
        case "TooManyCookiesInOriginRequestPolicy":
        case "com.amazonaws.cloudfront#TooManyCookiesInOriginRequestPolicy":
            throw await de_TooManyCookiesInOriginRequestPolicyRes(parsedOutput, context);
        case "TooManyHeadersInOriginRequestPolicy":
        case "com.amazonaws.cloudfront#TooManyHeadersInOriginRequestPolicy":
            throw await de_TooManyHeadersInOriginRequestPolicyRes(parsedOutput, context);
        case "TooManyOriginRequestPolicies":
        case "com.amazonaws.cloudfront#TooManyOriginRequestPolicies":
            throw await de_TooManyOriginRequestPoliciesRes(parsedOutput, context);
        case "TooManyQueryStringsInOriginRequestPolicy":
        case "com.amazonaws.cloudfront#TooManyQueryStringsInOriginRequestPolicy":
            throw await de_TooManyQueryStringsInOriginRequestPolicyRes(parsedOutput, context);
        case "PublicKeyAlreadyExists":
        case "com.amazonaws.cloudfront#PublicKeyAlreadyExists":
            throw await de_PublicKeyAlreadyExistsRes(parsedOutput, context);
        case "TooManyPublicKeys":
        case "com.amazonaws.cloudfront#TooManyPublicKeys":
            throw await de_TooManyPublicKeysRes(parsedOutput, context);
        case "RealtimeLogConfigAlreadyExists":
        case "com.amazonaws.cloudfront#RealtimeLogConfigAlreadyExists":
            throw await de_RealtimeLogConfigAlreadyExistsRes(parsedOutput, context);
        case "TooManyRealtimeLogConfigs":
        case "com.amazonaws.cloudfront#TooManyRealtimeLogConfigs":
            throw await de_TooManyRealtimeLogConfigsRes(parsedOutput, context);
        case "ResponseHeadersPolicyAlreadyExists":
        case "com.amazonaws.cloudfront#ResponseHeadersPolicyAlreadyExists":
            throw await de_ResponseHeadersPolicyAlreadyExistsRes(parsedOutput, context);
        case "TooLongCSPInResponseHeadersPolicy":
        case "com.amazonaws.cloudfront#TooLongCSPInResponseHeadersPolicy":
            throw await de_TooLongCSPInResponseHeadersPolicyRes(parsedOutput, context);
        case "TooManyCustomHeadersInResponseHeadersPolicy":
        case "com.amazonaws.cloudfront#TooManyCustomHeadersInResponseHeadersPolicy":
            throw await de_TooManyCustomHeadersInResponseHeadersPolicyRes(parsedOutput, context);
        case "TooManyRemoveHeadersInResponseHeadersPolicy":
        case "com.amazonaws.cloudfront#TooManyRemoveHeadersInResponseHeadersPolicy":
            throw await de_TooManyRemoveHeadersInResponseHeadersPolicyRes(parsedOutput, context);
        case "TooManyResponseHeadersPolicies":
        case "com.amazonaws.cloudfront#TooManyResponseHeadersPolicies":
            throw await de_TooManyResponseHeadersPoliciesRes(parsedOutput, context);
        case "StreamingDistributionAlreadyExists":
        case "com.amazonaws.cloudfront#StreamingDistributionAlreadyExists":
            throw await de_StreamingDistributionAlreadyExistsRes(parsedOutput, context);
        case "TooManyStreamingDistributionCNAMEs":
        case "com.amazonaws.cloudfront#TooManyStreamingDistributionCNAMEs":
            throw await de_TooManyStreamingDistributionCNAMEsRes(parsedOutput, context);
        case "TooManyStreamingDistributions":
        case "com.amazonaws.cloudfront#TooManyStreamingDistributions":
            throw await de_TooManyStreamingDistributionsRes(parsedOutput, context);
        case "CannotDeleteEntityWhileInUse":
        case "com.amazonaws.cloudfront#CannotDeleteEntityWhileInUse":
            throw await de_CannotDeleteEntityWhileInUseRes(parsedOutput, context);
        case "IllegalDelete":
        case "com.amazonaws.cloudfront#IllegalDelete":
            throw await de_IllegalDeleteRes(parsedOutput, context);
        case "CachePolicyInUse":
        case "com.amazonaws.cloudfront#CachePolicyInUse":
            throw await de_CachePolicyInUseRes(parsedOutput, context);
        case "CloudFrontOriginAccessIdentityInUse":
        case "com.amazonaws.cloudfront#CloudFrontOriginAccessIdentityInUse":
            throw await de_CloudFrontOriginAccessIdentityInUseRes(parsedOutput, context);
        case "NoSuchCloudFrontOriginAccessIdentity":
        case "com.amazonaws.cloudfront#NoSuchCloudFrontOriginAccessIdentity":
            throw await de_NoSuchCloudFrontOriginAccessIdentityRes(parsedOutput, context);
        case "ResourceNotDisabled":
        case "com.amazonaws.cloudfront#ResourceNotDisabled":
            throw await de_ResourceNotDisabledRes(parsedOutput, context);
        case "DistributionNotDisabled":
        case "com.amazonaws.cloudfront#DistributionNotDisabled":
            throw await de_DistributionNotDisabledRes(parsedOutput, context);
        case "ResourceInUse":
        case "com.amazonaws.cloudfront#ResourceInUse":
            throw await de_ResourceInUseRes(parsedOutput, context);
        case "FieldLevelEncryptionConfigInUse":
        case "com.amazonaws.cloudfront#FieldLevelEncryptionConfigInUse":
            throw await de_FieldLevelEncryptionConfigInUseRes(parsedOutput, context);
        case "FieldLevelEncryptionProfileInUse":
        case "com.amazonaws.cloudfront#FieldLevelEncryptionProfileInUse":
            throw await de_FieldLevelEncryptionProfileInUseRes(parsedOutput, context);
        case "FunctionInUse":
        case "com.amazonaws.cloudfront#FunctionInUse":
            throw await de_FunctionInUseRes(parsedOutput, context);
        case "NoSuchFunctionExists":
        case "com.amazonaws.cloudfront#NoSuchFunctionExists":
            throw await de_NoSuchFunctionExistsRes(parsedOutput, context);
        case "NoSuchResource":
        case "com.amazonaws.cloudfront#NoSuchResource":
            throw await de_NoSuchResourceRes(parsedOutput, context);
        case "NoSuchMonitoringSubscription":
        case "com.amazonaws.cloudfront#NoSuchMonitoringSubscription":
            throw await de_NoSuchMonitoringSubscriptionRes(parsedOutput, context);
        case "NoSuchOriginAccessControl":
        case "com.amazonaws.cloudfront#NoSuchOriginAccessControl":
            throw await de_NoSuchOriginAccessControlRes(parsedOutput, context);
        case "OriginAccessControlInUse":
        case "com.amazonaws.cloudfront#OriginAccessControlInUse":
            throw await de_OriginAccessControlInUseRes(parsedOutput, context);
        case "OriginRequestPolicyInUse":
        case "com.amazonaws.cloudfront#OriginRequestPolicyInUse":
            throw await de_OriginRequestPolicyInUseRes(parsedOutput, context);
        case "PublicKeyInUse":
        case "com.amazonaws.cloudfront#PublicKeyInUse":
            throw await de_PublicKeyInUseRes(parsedOutput, context);
        case "RealtimeLogConfigInUse":
        case "com.amazonaws.cloudfront#RealtimeLogConfigInUse":
            throw await de_RealtimeLogConfigInUseRes(parsedOutput, context);
        case "ResponseHeadersPolicyInUse":
        case "com.amazonaws.cloudfront#ResponseHeadersPolicyInUse":
            throw await de_ResponseHeadersPolicyInUseRes(parsedOutput, context);
        case "NoSuchStreamingDistribution":
        case "com.amazonaws.cloudfront#NoSuchStreamingDistribution":
            throw await de_NoSuchStreamingDistributionRes(parsedOutput, context);
        case "StreamingDistributionNotDisabled":
        case "com.amazonaws.cloudfront#StreamingDistributionNotDisabled":
            throw await de_StreamingDistributionNotDisabledRes(parsedOutput, context);
        case "NoSuchInvalidation":
        case "com.amazonaws.cloudfront#NoSuchInvalidation":
            throw await de_NoSuchInvalidationRes(parsedOutput, context);
        case "TestFunctionFailed":
        case "com.amazonaws.cloudfront#TestFunctionFailed":
            throw await de_TestFunctionFailedRes(parsedOutput, context);
        case "CannotChangeImmutablePublicKeyFields":
        case "com.amazonaws.cloudfront#CannotChangeImmutablePublicKeyFields":
            throw await de_CannotChangeImmutablePublicKeyFieldsRes(parsedOutput, context);
        case "CannotUpdateEntityWhileInUse":
        case "com.amazonaws.cloudfront#CannotUpdateEntityWhileInUse":
            throw await de_CannotUpdateEntityWhileInUseRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
const throwDefaultError = withBaseException(__BaseException);
const de_AccessDeniedRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new AccessDenied({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_BatchTooLargeRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new BatchTooLarge({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_CachePolicyAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new CachePolicyAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_CachePolicyInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new CachePolicyInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_CannotChangeImmutablePublicKeyFieldsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new CannotChangeImmutablePublicKeyFields({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_CannotDeleteEntityWhileInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new CannotDeleteEntityWhileInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_CannotUpdateEntityWhileInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new CannotUpdateEntityWhileInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_CloudFrontOriginAccessIdentityAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new CloudFrontOriginAccessIdentityAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_CloudFrontOriginAccessIdentityInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new CloudFrontOriginAccessIdentityInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_CNAMEAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new CNAMEAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_ContinuousDeploymentPolicyAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new ContinuousDeploymentPolicyAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_ContinuousDeploymentPolicyInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new ContinuousDeploymentPolicyInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_DistributionAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new DistributionAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_DistributionNotDisabledRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new DistributionNotDisabled({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_EntityAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new EntityAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_EntityLimitExceededRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new EntityLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_EntityNotFoundRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new EntityNotFound({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_EntitySizeLimitExceededRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new EntitySizeLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_FieldLevelEncryptionConfigAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new FieldLevelEncryptionConfigAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_FieldLevelEncryptionConfigInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new FieldLevelEncryptionConfigInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_FieldLevelEncryptionProfileAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new FieldLevelEncryptionProfileAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_FieldLevelEncryptionProfileInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new FieldLevelEncryptionProfileInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_FieldLevelEncryptionProfileSizeExceededRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new FieldLevelEncryptionProfileSizeExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_FunctionAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new FunctionAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_FunctionInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new FunctionInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_FunctionSizeLimitExceededRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new FunctionSizeLimitExceeded({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_IllegalDeleteRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new IllegalDelete({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_IllegalOriginAccessConfigurationRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new IllegalOriginAccessConfiguration({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_IllegalUpdateRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new IllegalUpdate({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InconsistentQuantitiesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InconsistentQuantities({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidArgumentRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidArgument({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidAssociationRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidAssociation({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidDefaultRootObjectRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidDefaultRootObject({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidDomainNameForOriginAccessControlRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidDomainNameForOriginAccessControl({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidErrorCodeRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidErrorCode({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidForwardCookiesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidForwardCookies({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidFunctionAssociationRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidFunctionAssociation({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidGeoRestrictionParameterRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidGeoRestrictionParameter({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidHeadersForS3OriginRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidHeadersForS3Origin({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidIfMatchVersionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidIfMatchVersion({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidLambdaFunctionAssociationRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidLambdaFunctionAssociation({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidLocationCodeRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidLocationCode({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidMinimumProtocolVersionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidMinimumProtocolVersion({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidOriginRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidOrigin({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidOriginAccessControlRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidOriginAccessControl({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidOriginAccessIdentityRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidOriginAccessIdentity({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidOriginKeepaliveTimeoutRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidOriginKeepaliveTimeout({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidOriginReadTimeoutRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidOriginReadTimeout({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidProtocolSettingsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidProtocolSettings({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidQueryStringParametersRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidQueryStringParameters({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidRelativePathRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidRelativePath({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidRequiredProtocolRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidRequiredProtocol({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidResponseCodeRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidResponseCode({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidTaggingRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidTagging({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidTTLOrderRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidTTLOrder({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidViewerCertificateRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidViewerCertificate({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_InvalidWebACLIdRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new InvalidWebACLId({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_KeyGroupAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new KeyGroupAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_MissingBodyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new MissingBody({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_MonitoringSubscriptionAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new MonitoringSubscriptionAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchCachePolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchCachePolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchCloudFrontOriginAccessIdentityRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchCloudFrontOriginAccessIdentity({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchContinuousDeploymentPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchContinuousDeploymentPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchDistributionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchDistribution({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchFieldLevelEncryptionConfigRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchFieldLevelEncryptionConfig({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchFieldLevelEncryptionProfileRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchFieldLevelEncryptionProfile({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchFunctionExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchFunctionExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchInvalidationRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchInvalidation({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchMonitoringSubscriptionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchMonitoringSubscription({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchOriginRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchOrigin({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchOriginAccessControlRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchOriginAccessControl({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchOriginRequestPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchOriginRequestPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchPublicKeyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchPublicKey({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchRealtimeLogConfigRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchRealtimeLogConfig({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchResourceRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchResource({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchResponseHeadersPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchResponseHeadersPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_NoSuchStreamingDistributionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new NoSuchStreamingDistribution({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_OriginAccessControlAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new OriginAccessControlAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_OriginAccessControlInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new OriginAccessControlInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_OriginRequestPolicyAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new OriginRequestPolicyAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_OriginRequestPolicyInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new OriginRequestPolicyInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_PreconditionFailedRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new PreconditionFailed({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_PublicKeyAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new PublicKeyAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_PublicKeyInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new PublicKeyInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_QueryArgProfileEmptyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new QueryArgProfileEmpty({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_RealtimeLogConfigAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new RealtimeLogConfigAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_RealtimeLogConfigInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new RealtimeLogConfigInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_RealtimeLogConfigOwnerMismatchRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new RealtimeLogConfigOwnerMismatch({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_ResourceInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new ResourceInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_ResourceNotDisabledRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new ResourceNotDisabled({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_ResponseHeadersPolicyAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new ResponseHeadersPolicyAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_ResponseHeadersPolicyInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new ResponseHeadersPolicyInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_StagingDistributionInUseRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new StagingDistributionInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_StreamingDistributionAlreadyExistsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new StreamingDistributionAlreadyExists({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_StreamingDistributionNotDisabledRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new StreamingDistributionNotDisabled({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TestFunctionFailedRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TestFunctionFailed({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooLongCSPInResponseHeadersPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooLongCSPInResponseHeadersPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyCacheBehaviorsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyCacheBehaviors({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyCachePoliciesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyCachePolicies({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyCertificatesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyCertificates({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyCloudFrontOriginAccessIdentitiesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyCloudFrontOriginAccessIdentities({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyContinuousDeploymentPoliciesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyContinuousDeploymentPolicies({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyCookieNamesInWhiteListRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyCookieNamesInWhiteList({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyCookiesInCachePolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyCookiesInCachePolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyCookiesInOriginRequestPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyCookiesInOriginRequestPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyCustomHeadersInResponseHeadersPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyCustomHeadersInResponseHeadersPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionCNAMEsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionCNAMEs({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributions({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsAssociatedToCachePolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsAssociatedToCachePolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsAssociatedToFieldLevelEncryptionConfigRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsAssociatedToFieldLevelEncryptionConfig({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsAssociatedToKeyGroupRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsAssociatedToKeyGroup({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsAssociatedToOriginAccessControlRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsAssociatedToOriginAccessControl({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsAssociatedToOriginRequestPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsAssociatedToOriginRequestPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsAssociatedToResponseHeadersPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsAssociatedToResponseHeadersPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsWithFunctionAssociationsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsWithFunctionAssociations({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsWithLambdaAssociationsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsWithLambdaAssociations({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyDistributionsWithSingleFunctionARNRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyDistributionsWithSingleFunctionARN({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyFieldLevelEncryptionConfigsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyFieldLevelEncryptionConfigs({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyFieldLevelEncryptionContentTypeProfilesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyFieldLevelEncryptionContentTypeProfiles({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyFieldLevelEncryptionEncryptionEntitiesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyFieldLevelEncryptionEncryptionEntities({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyFieldLevelEncryptionFieldPatternsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyFieldLevelEncryptionFieldPatterns({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyFieldLevelEncryptionProfilesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyFieldLevelEncryptionProfiles({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyFieldLevelEncryptionQueryArgProfilesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyFieldLevelEncryptionQueryArgProfiles({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyFunctionAssociationsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyFunctionAssociations({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyFunctionsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyFunctions({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyHeadersInCachePolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyHeadersInCachePolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyHeadersInForwardedValuesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyHeadersInForwardedValues({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyHeadersInOriginRequestPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyHeadersInOriginRequestPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyInvalidationsInProgressRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyInvalidationsInProgress({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyKeyGroupsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyKeyGroups({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyKeyGroupsAssociatedToDistributionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyKeyGroupsAssociatedToDistribution({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyLambdaFunctionAssociationsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyLambdaFunctionAssociations({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyOriginAccessControlsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyOriginAccessControls({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyOriginCustomHeadersRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyOriginCustomHeaders({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyOriginGroupsPerDistributionRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyOriginGroupsPerDistribution({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyOriginRequestPoliciesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyOriginRequestPolicies({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyOriginsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyOrigins({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyPublicKeysRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyPublicKeys({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyPublicKeysInKeyGroupRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyPublicKeysInKeyGroup({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyQueryStringParametersRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyQueryStringParameters({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyQueryStringsInCachePolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyQueryStringsInCachePolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyQueryStringsInOriginRequestPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyQueryStringsInOriginRequestPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyRealtimeLogConfigsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyRealtimeLogConfigs({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyRemoveHeadersInResponseHeadersPolicyRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyRemoveHeadersInResponseHeadersPolicy({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyResponseHeadersPoliciesRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyResponseHeadersPolicies({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyStreamingDistributionCNAMEsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyStreamingDistributionCNAMEs({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyStreamingDistributionsRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyStreamingDistributions({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TooManyTrustedSignersRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TooManyTrustedSigners({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TrustedKeyGroupDoesNotExistRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TrustedKeyGroupDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_TrustedSignerDoesNotExistRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new TrustedSignerDoesNotExist({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const de_UnsupportedOperationRes = async (parsedOutput, context) => {
    const contents = map({});
    const data = parsedOutput.body.Error;
    if (data[_Me] != null) {
        contents[_Me] = __expectString(data[_Me]);
    }
    const exception = new UnsupportedOperation({
        $metadata: deserializeMetadata(parsedOutput),
        ...contents,
    });
    return __decorateServiceException(exception, parsedOutput.body.Error);
};
const se_AccessControlAllowHeadersList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_H);
    });
};
const se_AccessControlAllowMethodsList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_RHPACAMV, entry);
        return n.n(_Met);
    });
};
const se_AccessControlAllowOriginsList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_Or);
    });
};
const se_AccessControlExposeHeadersList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_H);
    });
};
const se_Aliases = (input, context) => {
    const bn = new __XmlNode(_Al);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_AliasList(input[_It], context));
    return bn;
};
const se_AliasList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_CNAME);
    });
};
const se_AllowedMethods = (input, context) => {
    const bn = new __XmlNode(_AM);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_MethodsList(input[_It], context));
    if (input[_CM] != null) {
        bn.c(se_CachedMethods(input[_CM], context).n(_CM));
    }
    return bn;
};
const se_AwsAccountNumberList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_AAN);
    });
};
const se_CacheBehavior = (input, context) => {
    const bn = new __XmlNode(_CB);
    if (input[_PP] != null) {
        bn.c(__XmlNode.of(_s, input[_PP]).n(_PP));
    }
    if (input[_TOI] != null) {
        bn.c(__XmlNode.of(_s, input[_TOI]).n(_TOI));
    }
    if (input[_TS] != null) {
        bn.c(se_TrustedSigners(input[_TS], context).n(_TS));
    }
    if (input[_TKG] != null) {
        bn.c(se_TrustedKeyGroups(input[_TKG], context).n(_TKG));
    }
    bn.cc(input, _VPP);
    if (input[_AM] != null) {
        bn.c(se_AllowedMethods(input[_AM], context).n(_AM));
    }
    if (input[_SS] != null) {
        bn.c(__XmlNode.of(_b, String(input[_SS])).n(_SS));
    }
    if (input[_Com] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Com])).n(_Com));
    }
    if (input[_LFA] != null) {
        bn.c(se_LambdaFunctionAssociations(input[_LFA], context).n(_LFA));
    }
    if (input[_FA] != null) {
        bn.c(se_FunctionAssociations(input[_FA], context).n(_FA));
    }
    if (input[_FLEI] != null) {
        bn.c(__XmlNode.of(_s, input[_FLEI]).n(_FLEI));
    }
    if (input[_RLCA] != null) {
        bn.c(__XmlNode.of(_s, input[_RLCA]).n(_RLCA));
    }
    if (input[_CPI] != null) {
        bn.c(__XmlNode.of(_s, input[_CPI]).n(_CPI));
    }
    if (input[_ORPI] != null) {
        bn.c(__XmlNode.of(_s, input[_ORPI]).n(_ORPI));
    }
    if (input[_RHPI] != null) {
        bn.c(__XmlNode.of(_s, input[_RHPI]).n(_RHPI));
    }
    if (input[_GC] != null) {
        bn.c(se_GrpcConfig(input[_GC], context).n(_GC));
    }
    if (input[_FV] != null) {
        bn.c(se_ForwardedValues(input[_FV], context).n(_FV));
    }
    if (input[_MTTL] != null) {
        bn.c(__XmlNode.of(_l, String(input[_MTTL])).n(_MTTL));
    }
    if (input[_DTTL] != null) {
        bn.c(__XmlNode.of(_l, String(input[_DTTL])).n(_DTTL));
    }
    if (input[_MTTLa] != null) {
        bn.c(__XmlNode.of(_l, String(input[_MTTLa])).n(_MTTLa));
    }
    return bn;
};
const se_CacheBehaviorList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_CacheBehavior(entry, context);
        return n.n(_CB);
    });
};
const se_CacheBehaviors = (input, context) => {
    const bn = new __XmlNode(_CBa);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_CacheBehaviorList(input[_It], context));
    return bn;
};
const se_CachedMethods = (input, context) => {
    const bn = new __XmlNode(_CM);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_MethodsList(input[_It], context));
    return bn;
};
const se_CachePolicyConfig = (input, context) => {
    const bn = new __XmlNode(_CPC);
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_DTTL] != null) {
        bn.c(__XmlNode.of(_l, String(input[_DTTL])).n(_DTTL));
    }
    if (input[_MTTLa] != null) {
        bn.c(__XmlNode.of(_l, String(input[_MTTLa])).n(_MTTLa));
    }
    if (input[_MTTL] != null) {
        bn.c(__XmlNode.of(_l, String(input[_MTTL])).n(_MTTL));
    }
    if (input[_PICKAFTO] != null) {
        bn.c(se_ParametersInCacheKeyAndForwardedToOrigin(input[_PICKAFTO], context).n(_PICKAFTO));
    }
    return bn;
};
const se_CachePolicyCookiesConfig = (input, context) => {
    const bn = new __XmlNode(_CPCC);
    if (input[_CBo] != null) {
        bn.c(__XmlNode.of(_CPCB, input[_CBo]).n(_CBo));
    }
    if (input[_Coo] != null) {
        bn.c(se_CookieNames(input[_Coo], context).n(_Coo));
    }
    return bn;
};
const se_CachePolicyHeadersConfig = (input, context) => {
    const bn = new __XmlNode(_CPHC);
    if (input[_HB] != null) {
        bn.c(__XmlNode.of(_CPHB, input[_HB]).n(_HB));
    }
    if (input[_He] != null) {
        bn.c(se_Headers(input[_He], context).n(_He));
    }
    return bn;
};
const se_CachePolicyQueryStringsConfig = (input, context) => {
    const bn = new __XmlNode(_CPQSC);
    if (input[_QSB] != null) {
        bn.c(__XmlNode.of(_CPQSB, input[_QSB]).n(_QSB));
    }
    if (input[_QS] != null) {
        bn.c(se_QueryStringNames(input[_QS], context).n(_QS));
    }
    return bn;
};
const se_Certificate = (input, context) => {
    const bn = new __XmlNode(_Ce);
    if (input[_Ar] != null) {
        bn.c(__XmlNode.of(_s, input[_Ar]).n(_Ar));
    }
    return bn;
};
const se_CloudFrontOriginAccessIdentityConfig = (input, context) => {
    const bn = new __XmlNode(_CFOAIC);
    if (input[_CR] != null) {
        bn.c(__XmlNode.of(_s, input[_CR]).n(_CR));
    }
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    return bn;
};
const se_ConnectionGroupAssociationFilter = (input, context) => {
    const bn = new __XmlNode(_CGAF);
    if (input[_AILI] != null) {
        bn.c(__XmlNode.of(_s, input[_AILI]).n(_AILI));
    }
    return bn;
};
const se_ContentTypeProfile = (input, context) => {
    const bn = new __XmlNode(_CTP);
    bn.cc(input, _Fo);
    if (input[_PI] != null) {
        bn.c(__XmlNode.of(_s, input[_PI]).n(_PI));
    }
    if (input[_CT] != null) {
        bn.c(__XmlNode.of(_s, input[_CT]).n(_CT));
    }
    return bn;
};
const se_ContentTypeProfileConfig = (input, context) => {
    const bn = new __XmlNode(_CTPC);
    if (input[_FWCTIU] != null) {
        bn.c(__XmlNode.of(_b, String(input[_FWCTIU])).n(_FWCTIU));
    }
    if (input[_CTPo] != null) {
        bn.c(se_ContentTypeProfiles(input[_CTPo], context).n(_CTPo));
    }
    return bn;
};
const se_ContentTypeProfileList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_ContentTypeProfile(entry, context);
        return n.n(_CTP);
    });
};
const se_ContentTypeProfiles = (input, context) => {
    const bn = new __XmlNode(_CTPo);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_ContentTypeProfileList(input[_It], context));
    return bn;
};
const se_ContinuousDeploymentPolicyConfig = (input, context) => {
    const bn = new __XmlNode(_CDPC);
    if (input[_SDDN] != null) {
        bn.c(se_StagingDistributionDnsNames(input[_SDDN], context).n(_SDDN));
    }
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_TC] != null) {
        bn.c(se_TrafficConfig(input[_TC], context).n(_TC));
    }
    return bn;
};
const se_ContinuousDeploymentSingleHeaderConfig = (input, context) => {
    const bn = new __XmlNode(_CDSHC);
    if (input[_H] != null) {
        bn.c(__XmlNode.of(_s, input[_H]).n(_H));
    }
    if (input[_V] != null) {
        bn.c(__XmlNode.of(_s, input[_V]).n(_V));
    }
    return bn;
};
const se_ContinuousDeploymentSingleWeightConfig = (input, context) => {
    const bn = new __XmlNode(_CDSWC);
    if (input[_W] != null) {
        bn.c(__XmlNode.of(_f, String(input[_W])).n(_W));
    }
    if (input[_SSC] != null) {
        bn.c(se_SessionStickinessConfig(input[_SSC], context).n(_SSC));
    }
    return bn;
};
const se_CookieNameList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_N);
    });
};
const se_CookieNames = (input, context) => {
    const bn = new __XmlNode(_CN);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_CookieNameList(input[_It], context));
    return bn;
};
const se_CookiePreference = (input, context) => {
    const bn = new __XmlNode(_CP);
    if (input[_For] != null) {
        bn.c(__XmlNode.of(_ISt, input[_For]).n(_For));
    }
    if (input[_WN] != null) {
        bn.c(se_CookieNames(input[_WN], context).n(_WN));
    }
    return bn;
};
const se_CustomErrorResponse = (input, context) => {
    const bn = new __XmlNode(_CER);
    if (input[_EC] != null) {
        bn.c(__XmlNode.of(_i, String(input[_EC])).n(_EC));
    }
    if (input[_RPP] != null) {
        bn.c(__XmlNode.of(_s, input[_RPP]).n(_RPP));
    }
    if (input[_RC] != null) {
        bn.c(__XmlNode.of(_s, input[_RC]).n(_RC));
    }
    if (input[_ECMTTL] != null) {
        bn.c(__XmlNode.of(_l, String(input[_ECMTTL])).n(_ECMTTL));
    }
    return bn;
};
const se_CustomErrorResponseList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_CustomErrorResponse(entry, context);
        return n.n(_CER);
    });
};
const se_CustomErrorResponses = (input, context) => {
    const bn = new __XmlNode(_CERu);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_CustomErrorResponseList(input[_It], context));
    return bn;
};
const se_CustomHeaders = (input, context) => {
    const bn = new __XmlNode(_CH);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_OriginCustomHeadersList(input[_It], context));
    return bn;
};
const se_Customizations = (input, context) => {
    const bn = new __XmlNode(_C);
    if (input[_WA] != null) {
        bn.c(se_WebAclCustomization(input[_WA], context).n(_WA));
    }
    if (input[_Ce] != null) {
        bn.c(se_Certificate(input[_Ce], context).n(_Ce));
    }
    if (input[_GR] != null) {
        bn.c(se_GeoRestrictionCustomization(input[_GR], context).n(_GR));
    }
    return bn;
};
const se_CustomOriginConfig = (input, context) => {
    const bn = new __XmlNode(_COC);
    if (input[_HTTPP] != null) {
        bn.c(__XmlNode.of(_i, String(input[_HTTPP])).n(_HTTPP));
    }
    if (input[_HTTPSP] != null) {
        bn.c(__XmlNode.of(_i, String(input[_HTTPSP])).n(_HTTPSP));
    }
    bn.cc(input, _OPP);
    if (input[_OSP] != null) {
        bn.c(se_OriginSslProtocols(input[_OSP], context).n(_OSP));
    }
    if (input[_ORT] != null) {
        bn.c(__XmlNode.of(_i, String(input[_ORT])).n(_ORT));
    }
    if (input[_OKT] != null) {
        bn.c(__XmlNode.of(_i, String(input[_OKT])).n(_OKT));
    }
    return bn;
};
const se_DefaultCacheBehavior = (input, context) => {
    const bn = new __XmlNode(_DCB);
    if (input[_TOI] != null) {
        bn.c(__XmlNode.of(_s, input[_TOI]).n(_TOI));
    }
    if (input[_TS] != null) {
        bn.c(se_TrustedSigners(input[_TS], context).n(_TS));
    }
    if (input[_TKG] != null) {
        bn.c(se_TrustedKeyGroups(input[_TKG], context).n(_TKG));
    }
    bn.cc(input, _VPP);
    if (input[_AM] != null) {
        bn.c(se_AllowedMethods(input[_AM], context).n(_AM));
    }
    if (input[_SS] != null) {
        bn.c(__XmlNode.of(_b, String(input[_SS])).n(_SS));
    }
    if (input[_Com] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Com])).n(_Com));
    }
    if (input[_LFA] != null) {
        bn.c(se_LambdaFunctionAssociations(input[_LFA], context).n(_LFA));
    }
    if (input[_FA] != null) {
        bn.c(se_FunctionAssociations(input[_FA], context).n(_FA));
    }
    if (input[_FLEI] != null) {
        bn.c(__XmlNode.of(_s, input[_FLEI]).n(_FLEI));
    }
    if (input[_RLCA] != null) {
        bn.c(__XmlNode.of(_s, input[_RLCA]).n(_RLCA));
    }
    if (input[_CPI] != null) {
        bn.c(__XmlNode.of(_s, input[_CPI]).n(_CPI));
    }
    if (input[_ORPI] != null) {
        bn.c(__XmlNode.of(_s, input[_ORPI]).n(_ORPI));
    }
    if (input[_RHPI] != null) {
        bn.c(__XmlNode.of(_s, input[_RHPI]).n(_RHPI));
    }
    if (input[_GC] != null) {
        bn.c(se_GrpcConfig(input[_GC], context).n(_GC));
    }
    if (input[_FV] != null) {
        bn.c(se_ForwardedValues(input[_FV], context).n(_FV));
    }
    if (input[_MTTL] != null) {
        bn.c(__XmlNode.of(_l, String(input[_MTTL])).n(_MTTL));
    }
    if (input[_DTTL] != null) {
        bn.c(__XmlNode.of(_l, String(input[_DTTL])).n(_DTTL));
    }
    if (input[_MTTLa] != null) {
        bn.c(__XmlNode.of(_l, String(input[_MTTLa])).n(_MTTLa));
    }
    return bn;
};
const se_DistributionConfig = (input, context) => {
    const bn = new __XmlNode(_DCi);
    if (input[_CR] != null) {
        bn.c(__XmlNode.of(_s, input[_CR]).n(_CR));
    }
    if (input[_Al] != null) {
        bn.c(se_Aliases(input[_Al], context).n(_Al));
    }
    if (input[_DRO] != null) {
        bn.c(__XmlNode.of(_s, input[_DRO]).n(_DRO));
    }
    if (input[_Ori] != null) {
        bn.c(se_Origins(input[_Ori], context).n(_Ori));
    }
    if (input[_OG] != null) {
        bn.c(se_OriginGroups(input[_OG], context).n(_OG));
    }
    if (input[_DCB] != null) {
        bn.c(se_DefaultCacheBehavior(input[_DCB], context).n(_DCB));
    }
    if (input[_CBa] != null) {
        bn.c(se_CacheBehaviors(input[_CBa], context).n(_CBa));
    }
    if (input[_CERu] != null) {
        bn.c(se_CustomErrorResponses(input[_CERu], context).n(_CERu));
    }
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_CTo, input[_Co]).n(_Co));
    }
    if (input[_Lo] != null) {
        bn.c(se_LoggingConfig(input[_Lo], context).n(_Lo));
    }
    bn.cc(input, _PC);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_VC] != null) {
        bn.c(se_ViewerCertificate(input[_VC], context).n(_VC));
    }
    if (input[_Re] != null) {
        bn.c(se_Restrictions(input[_Re], context).n(_Re));
    }
    if (input[_WACLI] != null) {
        bn.c(__XmlNode.of(_s, input[_WACLI]).n(_WACLI));
    }
    bn.cc(input, _HV);
    if (input[_IIPVE] != null) {
        bn.c(__XmlNode.of(_b, String(input[_IIPVE])).n(_IIPVE));
    }
    if (input[_CDPI] != null) {
        bn.c(__XmlNode.of(_s, input[_CDPI]).n(_CDPI));
    }
    if (input[_S] != null) {
        bn.c(__XmlNode.of(_b, String(input[_S])).n(_S));
    }
    if (input[_AILI] != null) {
        bn.c(__XmlNode.of(_s, input[_AILI]).n(_AILI));
    }
    if (input[_TCe] != null) {
        bn.c(se_TenantConfig(input[_TCe], context).n(_TCe));
    }
    bn.cc(input, _CMo);
    return bn;
};
const se_DistributionConfigWithTags = (input, context) => {
    const bn = new __XmlNode(_DCWT);
    if (input[_DCi] != null) {
        bn.c(se_DistributionConfig(input[_DCi], context).n(_DCi));
    }
    if (input[_T] != null) {
        bn.c(se_Tags(input[_T], context).n(_T));
    }
    return bn;
};
const se_DistributionResourceId = (input, context) => {
    const bn = new __XmlNode(_DRI);
    if (input[_DI] != null) {
        bn.c(__XmlNode.of(_s, input[_DI]).n(_DI));
    }
    if (input[_DTI] != null) {
        bn.c(__XmlNode.of(_s, input[_DTI]).n(_DTI));
    }
    return bn;
};
const se_DistributionTenantAssociationFilter = (input, context) => {
    const bn = new __XmlNode(_DTAF);
    if (input[_DI] != null) {
        bn.c(__XmlNode.of(_s, input[_DI]).n(_DI));
    }
    if (input[_CGI] != null) {
        bn.c(__XmlNode.of(_s, input[_CGI]).n(_CGI));
    }
    return bn;
};
const se_DomainItem = (input, context) => {
    const bn = new __XmlNode(_DIo);
    if (input[_Do] != null) {
        bn.c(__XmlNode.of(_s, input[_Do]).n(_Do));
    }
    return bn;
};
const se_DomainList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_DomainItem(entry, context);
        return n.n(_m);
    });
};
const se_EncryptionEntities = (input, context) => {
    const bn = new __XmlNode(_EE);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_EncryptionEntityList(input[_It], context));
    return bn;
};
const se_EncryptionEntity = (input, context) => {
    const bn = new __XmlNode(_EEn);
    if (input[_PKI] != null) {
        bn.c(__XmlNode.of(_s, input[_PKI]).n(_PKI));
    }
    if (input[_PIr] != null) {
        bn.c(__XmlNode.of(_s, input[_PIr]).n(_PIr));
    }
    if (input[_FP] != null) {
        bn.c(se_FieldPatterns(input[_FP], context).n(_FP));
    }
    return bn;
};
const se_EncryptionEntityList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_EncryptionEntity(entry, context);
        return n.n(_EEn);
    });
};
const se_EndPoint = (input, context) => {
    const bn = new __XmlNode(_EPn);
    if (input[_ST] != null) {
        bn.c(__XmlNode.of(_s, input[_ST]).n(_ST));
    }
    if (input[_KSC] != null) {
        bn.c(se_KinesisStreamConfig(input[_KSC], context).n(_KSC));
    }
    return bn;
};
const se_EndPointList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_EndPoint(entry, context);
        return n.n(_m);
    });
};
const se_FieldLevelEncryptionConfig = (input, context) => {
    const bn = new __XmlNode(_FLEC);
    if (input[_CR] != null) {
        bn.c(__XmlNode.of(_s, input[_CR]).n(_CR));
    }
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    if (input[_QAPC] != null) {
        bn.c(se_QueryArgProfileConfig(input[_QAPC], context).n(_QAPC));
    }
    if (input[_CTPC] != null) {
        bn.c(se_ContentTypeProfileConfig(input[_CTPC], context).n(_CTPC));
    }
    return bn;
};
const se_FieldLevelEncryptionProfileConfig = (input, context) => {
    const bn = new __XmlNode(_FLEPC);
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_CR] != null) {
        bn.c(__XmlNode.of(_s, input[_CR]).n(_CR));
    }
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    if (input[_EE] != null) {
        bn.c(se_EncryptionEntities(input[_EE], context).n(_EE));
    }
    return bn;
};
const se_FieldList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_Fi);
    });
};
const se_FieldPatternList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_FPi);
    });
};
const se_FieldPatterns = (input, context) => {
    const bn = new __XmlNode(_FP);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_FieldPatternList(input[_It], context));
    return bn;
};
const se_ForwardedValues = (input, context) => {
    const bn = new __XmlNode(_FV);
    if (input[_QSu] != null) {
        bn.c(__XmlNode.of(_b, String(input[_QSu])).n(_QSu));
    }
    if (input[_Coo] != null) {
        bn.c(se_CookiePreference(input[_Coo], context).n(_Coo));
    }
    if (input[_He] != null) {
        bn.c(se_Headers(input[_He], context).n(_He));
    }
    if (input[_QSCK] != null) {
        bn.c(se_QueryStringCacheKeys(input[_QSCK], context).n(_QSCK));
    }
    return bn;
};
const se_FunctionAssociation = (input, context) => {
    const bn = new __XmlNode(_FAu);
    bn.cc(input, _FARN);
    bn.cc(input, _ETv);
    return bn;
};
const se_FunctionAssociationList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_FunctionAssociation(entry, context);
        return n.n(_FAu);
    });
};
const se_FunctionAssociations = (input, context) => {
    const bn = new __XmlNode(_FA);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_FunctionAssociationList(input[_It], context));
    return bn;
};
const se_FunctionConfig = (input, context) => {
    const bn = new __XmlNode(_FCu);
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    if (input[_Ru] != null) {
        bn.c(__XmlNode.of(_FR, input[_Ru]).n(_Ru));
    }
    if (input[_KVSA] != null) {
        bn.c(se_KeyValueStoreAssociations(input[_KVSA], context).n(_KVSA));
    }
    return bn;
};
const se_GeoRestriction = (input, context) => {
    const bn = new __XmlNode(_GRe);
    if (input[_RT] != null) {
        bn.c(__XmlNode.of(_GRT, input[_RT]).n(_RT));
    }
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_LocationList(input[_It], context));
    return bn;
};
const se_GeoRestrictionCustomization = (input, context) => {
    const bn = new __XmlNode(_GRC);
    if (input[_RT] != null) {
        bn.c(__XmlNode.of(_GRT, input[_RT]).n(_RT));
    }
    bn.lc(input, "Locations", "Locations", () => se_LocationList(input[_Loc], context));
    return bn;
};
const se_GrpcConfig = (input, context) => {
    const bn = new __XmlNode(_GC);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    return bn;
};
const se_HeaderList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_N);
    });
};
const se_Headers = (input, context) => {
    const bn = new __XmlNode(_He);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_HeaderList(input[_It], context));
    return bn;
};
const se_ImportSource = (input, context) => {
    const bn = new __XmlNode(_IS);
    if (input[_STo] != null) {
        bn.c(__XmlNode.of(_IST, input[_STo]).n(_STo));
    }
    if (input[_SARN] != null) {
        bn.c(__XmlNode.of(_s, input[_SARN]).n(_SARN));
    }
    return bn;
};
const se_InvalidationBatch = (input, context) => {
    const bn = new __XmlNode(_IB);
    if (input[_Pa] != null) {
        bn.c(se_Paths(input[_Pa], context).n(_Pa));
    }
    if (input[_CR] != null) {
        bn.c(__XmlNode.of(_s, input[_CR]).n(_CR));
    }
    return bn;
};
const se_KeyGroupConfig = (input, context) => {
    const bn = new __XmlNode(_KGC);
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    bn.lc(input, "Items", "Items", () => se_PublicKeyIdList(input[_It], context));
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    return bn;
};
const se_KeyValueStoreAssociation = (input, context) => {
    const bn = new __XmlNode(_KVSAe);
    bn.cc(input, _KVSARN);
    return bn;
};
const se_KeyValueStoreAssociationList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_KeyValueStoreAssociation(entry, context);
        return n.n(_KVSAe);
    });
};
const se_KeyValueStoreAssociations = (input, context) => {
    const bn = new __XmlNode(_KVSA);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_KeyValueStoreAssociationList(input[_It], context));
    return bn;
};
const se_KinesisStreamConfig = (input, context) => {
    const bn = new __XmlNode(_KSC);
    if (input[_RARN] != null) {
        bn.c(__XmlNode.of(_s, input[_RARN]).n(_RARN));
    }
    if (input[_SARNt] != null) {
        bn.c(__XmlNode.of(_s, input[_SARNt]).n(_SARNt));
    }
    return bn;
};
const se_LambdaFunctionAssociation = (input, context) => {
    const bn = new __XmlNode(_LFAa);
    bn.cc(input, _LFARN);
    bn.cc(input, _ETv);
    if (input[_IBn] != null) {
        bn.c(__XmlNode.of(_b, String(input[_IBn])).n(_IBn));
    }
    return bn;
};
const se_LambdaFunctionAssociationList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_LambdaFunctionAssociation(entry, context);
        return n.n(_LFAa);
    });
};
const se_LambdaFunctionAssociations = (input, context) => {
    const bn = new __XmlNode(_LFA);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_LambdaFunctionAssociationList(input[_It], context));
    return bn;
};
const se_LocationList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_L);
    });
};
const se_LoggingConfig = (input, context) => {
    const bn = new __XmlNode(_LC);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_ICn] != null) {
        bn.c(__XmlNode.of(_b, String(input[_ICn])).n(_ICn));
    }
    if (input[_B] != null) {
        bn.c(__XmlNode.of(_s, input[_B]).n(_B));
    }
    if (input[_Pr] != null) {
        bn.c(__XmlNode.of(_s, input[_Pr]).n(_Pr));
    }
    return bn;
};
const se_ManagedCertificateRequest = (input, context) => {
    const bn = new __XmlNode(_MCR);
    bn.cc(input, _VTH);
    if (input[_PDN] != null) {
        bn.c(__XmlNode.of(_s, input[_PDN]).n(_PDN));
    }
    bn.cc(input, _CTLP);
    return bn;
};
const se_MethodsList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_Met, entry);
        return n.n(_Met);
    });
};
const se_MonitoringSubscription = (input, context) => {
    const bn = new __XmlNode(_MS);
    if (input[_RMSC] != null) {
        bn.c(se_RealtimeMetricsSubscriptionConfig(input[_RMSC], context).n(_RMSC));
    }
    return bn;
};
const se_Origin = (input, context) => {
    const bn = new __XmlNode(_Or);
    if (input[_Id] != null) {
        bn.c(__XmlNode.of(_s, input[_Id]).n(_Id));
    }
    if (input[_DN] != null) {
        bn.c(__XmlNode.of(_s, input[_DN]).n(_DN));
    }
    if (input[_OP] != null) {
        bn.c(__XmlNode.of(_s, input[_OP]).n(_OP));
    }
    if (input[_CH] != null) {
        bn.c(se_CustomHeaders(input[_CH], context).n(_CH));
    }
    if (input[_SOC] != null) {
        bn.c(se_S3OriginConfig(input[_SOC], context).n(_SOC));
    }
    if (input[_COC] != null) {
        bn.c(se_CustomOriginConfig(input[_COC], context).n(_COC));
    }
    if (input[_VOC] != null) {
        bn.c(se_VpcOriginConfig(input[_VOC], context).n(_VOC));
    }
    if (input[_CAo] != null) {
        bn.c(__XmlNode.of(_i, String(input[_CAo])).n(_CAo));
    }
    if (input[_CTon] != null) {
        bn.c(__XmlNode.of(_i, String(input[_CTon])).n(_CTon));
    }
    if (input[_OS] != null) {
        bn.c(se_OriginShield(input[_OS], context).n(_OS));
    }
    if (input[_OACI] != null) {
        bn.c(__XmlNode.of(_s, input[_OACI]).n(_OACI));
    }
    return bn;
};
const se_OriginAccessControlConfig = (input, context) => {
    const bn = new __XmlNode(_OACC);
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_De] != null) {
        bn.c(__XmlNode.of(_s, input[_De]).n(_De));
    }
    if (input[_SP] != null) {
        bn.c(__XmlNode.of(_OACSP, input[_SP]).n(_SP));
    }
    if (input[_SB] != null) {
        bn.c(__XmlNode.of(_OACSB, input[_SB]).n(_SB));
    }
    if (input[_OACOT] != null) {
        bn.c(__XmlNode.of(_OACOTr, input[_OACOT]).n(_OACOT));
    }
    return bn;
};
const se_OriginCustomHeader = (input, context) => {
    const bn = new __XmlNode(_OCH);
    if (input[_HN] != null) {
        bn.c(__XmlNode.of(_s, input[_HN]).n(_HN));
    }
    if (input[_HVe] != null) {
        bn.c(__XmlNode.of(_sST, input[_HVe]).n(_HVe));
    }
    return bn;
};
const se_OriginCustomHeadersList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_OriginCustomHeader(entry, context);
        return n.n(_OCH);
    });
};
const se_OriginGroup = (input, context) => {
    const bn = new __XmlNode(_OGr);
    if (input[_Id] != null) {
        bn.c(__XmlNode.of(_s, input[_Id]).n(_Id));
    }
    if (input[_FCa] != null) {
        bn.c(se_OriginGroupFailoverCriteria(input[_FCa], context).n(_FCa));
    }
    if (input[_Mem] != null) {
        bn.c(se_OriginGroupMembers(input[_Mem], context).n(_Mem));
    }
    if (input[_SC] != null) {
        bn.c(__XmlNode.of(_OGSC, input[_SC]).n(_SC));
    }
    return bn;
};
const se_OriginGroupFailoverCriteria = (input, context) => {
    const bn = new __XmlNode(_OGFC);
    if (input[_SCt] != null) {
        bn.c(se_StatusCodes(input[_SCt], context).n(_SCt));
    }
    return bn;
};
const se_OriginGroupList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_OriginGroup(entry, context);
        return n.n(_OGr);
    });
};
const se_OriginGroupMember = (input, context) => {
    const bn = new __XmlNode(_OGM);
    if (input[_OI] != null) {
        bn.c(__XmlNode.of(_s, input[_OI]).n(_OI));
    }
    return bn;
};
const se_OriginGroupMemberList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_OriginGroupMember(entry, context);
        return n.n(_OGM);
    });
};
const se_OriginGroupMembers = (input, context) => {
    const bn = new __XmlNode(_OGMr);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_OriginGroupMemberList(input[_It], context));
    return bn;
};
const se_OriginGroups = (input, context) => {
    const bn = new __XmlNode(_OG);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_OriginGroupList(input[_It], context));
    return bn;
};
const se_OriginList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_Origin(entry, context);
        return n.n(_Or);
    });
};
const se_OriginRequestPolicyConfig = (input, context) => {
    const bn = new __XmlNode(_ORPC);
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_HC] != null) {
        bn.c(se_OriginRequestPolicyHeadersConfig(input[_HC], context).n(_HC));
    }
    if (input[_CC] != null) {
        bn.c(se_OriginRequestPolicyCookiesConfig(input[_CC], context).n(_CC));
    }
    if (input[_QSC] != null) {
        bn.c(se_OriginRequestPolicyQueryStringsConfig(input[_QSC], context).n(_QSC));
    }
    return bn;
};
const se_OriginRequestPolicyCookiesConfig = (input, context) => {
    const bn = new __XmlNode(_ORPCC);
    if (input[_CBo] != null) {
        bn.c(__XmlNode.of(_ORPCB, input[_CBo]).n(_CBo));
    }
    if (input[_Coo] != null) {
        bn.c(se_CookieNames(input[_Coo], context).n(_Coo));
    }
    return bn;
};
const se_OriginRequestPolicyHeadersConfig = (input, context) => {
    const bn = new __XmlNode(_ORPHC);
    if (input[_HB] != null) {
        bn.c(__XmlNode.of(_ORPHB, input[_HB]).n(_HB));
    }
    if (input[_He] != null) {
        bn.c(se_Headers(input[_He], context).n(_He));
    }
    return bn;
};
const se_OriginRequestPolicyQueryStringsConfig = (input, context) => {
    const bn = new __XmlNode(_ORPQSC);
    if (input[_QSB] != null) {
        bn.c(__XmlNode.of(_ORPQSB, input[_QSB]).n(_QSB));
    }
    if (input[_QS] != null) {
        bn.c(se_QueryStringNames(input[_QS], context).n(_QS));
    }
    return bn;
};
const se_Origins = (input, context) => {
    const bn = new __XmlNode(_Ori);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_OriginList(input[_It], context));
    return bn;
};
const se_OriginShield = (input, context) => {
    const bn = new __XmlNode(_OS);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    bn.cc(input, _OSR);
    return bn;
};
const se_OriginSslProtocols = (input, context) => {
    const bn = new __XmlNode(_OSP);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_SslProtocolsList(input[_It], context));
    return bn;
};
const se_Parameter = (input, context) => {
    const bn = new __XmlNode(_Par);
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_PN, input[_N]).n(_N));
    }
    if (input[_V] != null) {
        bn.c(__XmlNode.of(_PV, input[_V]).n(_V));
    }
    return bn;
};
const se_ParameterDefinition = (input, context) => {
    const bn = new __XmlNode(_PD);
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_PN, input[_N]).n(_N));
    }
    if (input[_Def] != null) {
        bn.c(se_ParameterDefinitionSchema(input[_Def], context).n(_Def));
    }
    return bn;
};
const se_ParameterDefinitions = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_ParameterDefinition(entry, context);
        return n.n(_m);
    });
};
const se_ParameterDefinitionSchema = (input, context) => {
    const bn = new __XmlNode(_PDS);
    if (input[_SSt] != null) {
        bn.c(se_StringSchemaConfig(input[_SSt], context).n(_SSt));
    }
    return bn;
};
const se_Parameters = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_Parameter(entry, context);
        return n.n(_m);
    });
};
const se_ParametersInCacheKeyAndForwardedToOrigin = (input, context) => {
    const bn = new __XmlNode(_PICKAFTO);
    if (input[_EAEG] != null) {
        bn.c(__XmlNode.of(_b, String(input[_EAEG])).n(_EAEG));
    }
    if (input[_EAEB] != null) {
        bn.c(__XmlNode.of(_b, String(input[_EAEB])).n(_EAEB));
    }
    if (input[_HC] != null) {
        bn.c(se_CachePolicyHeadersConfig(input[_HC], context).n(_HC));
    }
    if (input[_CC] != null) {
        bn.c(se_CachePolicyCookiesConfig(input[_CC], context).n(_CC));
    }
    if (input[_QSC] != null) {
        bn.c(se_CachePolicyQueryStringsConfig(input[_QSC], context).n(_QSC));
    }
    return bn;
};
const se_PathList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_Pat);
    });
};
const se_Paths = (input, context) => {
    const bn = new __XmlNode(_Pa);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_PathList(input[_It], context));
    return bn;
};
const se_PublicKeyConfig = (input, context) => {
    const bn = new __XmlNode(_PKC);
    if (input[_CR] != null) {
        bn.c(__XmlNode.of(_s, input[_CR]).n(_CR));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_EK] != null) {
        bn.c(__XmlNode.of(_s, input[_EK]).n(_EK));
    }
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    return bn;
};
const se_PublicKeyIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_PK);
    });
};
const se_QueryArgProfile = (input, context) => {
    const bn = new __XmlNode(_QAP);
    if (input[_QA] != null) {
        bn.c(__XmlNode.of(_s, input[_QA]).n(_QA));
    }
    if (input[_PI] != null) {
        bn.c(__XmlNode.of(_s, input[_PI]).n(_PI));
    }
    return bn;
};
const se_QueryArgProfileConfig = (input, context) => {
    const bn = new __XmlNode(_QAPC);
    if (input[_FWQAPIU] != null) {
        bn.c(__XmlNode.of(_b, String(input[_FWQAPIU])).n(_FWQAPIU));
    }
    if (input[_QAPu] != null) {
        bn.c(se_QueryArgProfiles(input[_QAPu], context).n(_QAPu));
    }
    return bn;
};
const se_QueryArgProfileList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_QueryArgProfile(entry, context);
        return n.n(_QAP);
    });
};
const se_QueryArgProfiles = (input, context) => {
    const bn = new __XmlNode(_QAPu);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_QueryArgProfileList(input[_It], context));
    return bn;
};
const se_QueryStringCacheKeys = (input, context) => {
    const bn = new __XmlNode(_QSCK);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_QueryStringCacheKeysList(input[_It], context));
    return bn;
};
const se_QueryStringCacheKeysList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_N);
    });
};
const se_QueryStringNames = (input, context) => {
    const bn = new __XmlNode(_QSN);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_QueryStringNamesList(input[_It], context));
    return bn;
};
const se_QueryStringNamesList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_N);
    });
};
const se_RealtimeMetricsSubscriptionConfig = (input, context) => {
    const bn = new __XmlNode(_RMSC);
    bn.cc(input, _RMSS);
    return bn;
};
const se_ResponseHeadersPolicyAccessControlAllowHeaders = (input, context) => {
    const bn = new __XmlNode(_RHPACAH);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_AccessControlAllowHeadersList(input[_It], context));
    return bn;
};
const se_ResponseHeadersPolicyAccessControlAllowMethods = (input, context) => {
    const bn = new __XmlNode(_RHPACAM);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_AccessControlAllowMethodsList(input[_It], context));
    return bn;
};
const se_ResponseHeadersPolicyAccessControlAllowOrigins = (input, context) => {
    const bn = new __XmlNode(_RHPACAO);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_AccessControlAllowOriginsList(input[_It], context));
    return bn;
};
const se_ResponseHeadersPolicyAccessControlExposeHeaders = (input, context) => {
    const bn = new __XmlNode(_RHPACEH);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_AccessControlExposeHeadersList(input[_It], context));
    return bn;
};
const se_ResponseHeadersPolicyConfig = (input, context) => {
    const bn = new __XmlNode(_RHPC);
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_CCo] != null) {
        bn.c(se_ResponseHeadersPolicyCorsConfig(input[_CCo], context).n(_CCo));
    }
    if (input[_SHC] != null) {
        bn.c(se_ResponseHeadersPolicySecurityHeadersConfig(input[_SHC], context).n(_SHC));
    }
    if (input[_STHC] != null) {
        bn.c(se_ResponseHeadersPolicyServerTimingHeadersConfig(input[_STHC], context).n(_STHC));
    }
    if (input[_CHC] != null) {
        bn.c(se_ResponseHeadersPolicyCustomHeadersConfig(input[_CHC], context).n(_CHC));
    }
    if (input[_RHC] != null) {
        bn.c(se_ResponseHeadersPolicyRemoveHeadersConfig(input[_RHC], context).n(_RHC));
    }
    return bn;
};
const se_ResponseHeadersPolicyContentSecurityPolicy = (input, context) => {
    const bn = new __XmlNode(_RHPCSP);
    if (input[_Ov] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Ov])).n(_Ov));
    }
    if (input[_CSP] != null) {
        bn.c(__XmlNode.of(_s, input[_CSP]).n(_CSP));
    }
    return bn;
};
const se_ResponseHeadersPolicyContentTypeOptions = (input, context) => {
    const bn = new __XmlNode(_RHPCTO);
    if (input[_Ov] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Ov])).n(_Ov));
    }
    return bn;
};
const se_ResponseHeadersPolicyCorsConfig = (input, context) => {
    const bn = new __XmlNode(_RHPCC);
    if (input[_ACAO] != null) {
        bn.c(se_ResponseHeadersPolicyAccessControlAllowOrigins(input[_ACAO], context).n(_ACAO));
    }
    if (input[_ACAH] != null) {
        bn.c(se_ResponseHeadersPolicyAccessControlAllowHeaders(input[_ACAH], context).n(_ACAH));
    }
    if (input[_ACAM] != null) {
        bn.c(se_ResponseHeadersPolicyAccessControlAllowMethods(input[_ACAM], context).n(_ACAM));
    }
    if (input[_ACAC] != null) {
        bn.c(__XmlNode.of(_b, String(input[_ACAC])).n(_ACAC));
    }
    if (input[_ACEH] != null) {
        bn.c(se_ResponseHeadersPolicyAccessControlExposeHeaders(input[_ACEH], context).n(_ACEH));
    }
    if (input[_ACMAS] != null) {
        bn.c(__XmlNode.of(_i, String(input[_ACMAS])).n(_ACMAS));
    }
    if (input[_OO] != null) {
        bn.c(__XmlNode.of(_b, String(input[_OO])).n(_OO));
    }
    return bn;
};
const se_ResponseHeadersPolicyCustomHeader = (input, context) => {
    const bn = new __XmlNode(_RHPCH);
    if (input[_H] != null) {
        bn.c(__XmlNode.of(_s, input[_H]).n(_H));
    }
    if (input[_V] != null) {
        bn.c(__XmlNode.of(_s, input[_V]).n(_V));
    }
    if (input[_Ov] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Ov])).n(_Ov));
    }
    return bn;
};
const se_ResponseHeadersPolicyCustomHeaderList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_ResponseHeadersPolicyCustomHeader(entry, context);
        return n.n(_RHPCH);
    });
};
const se_ResponseHeadersPolicyCustomHeadersConfig = (input, context) => {
    const bn = new __XmlNode(_RHPCHC);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_ResponseHeadersPolicyCustomHeaderList(input[_It], context));
    return bn;
};
const se_ResponseHeadersPolicyFrameOptions = (input, context) => {
    const bn = new __XmlNode(_RHPFO);
    if (input[_Ov] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Ov])).n(_Ov));
    }
    if (input[_FO] != null) {
        bn.c(__XmlNode.of(_FOL, input[_FO]).n(_FO));
    }
    return bn;
};
const se_ResponseHeadersPolicyReferrerPolicy = (input, context) => {
    const bn = new __XmlNode(_RHPRP);
    if (input[_Ov] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Ov])).n(_Ov));
    }
    if (input[_RP] != null) {
        bn.c(__XmlNode.of(_RPL, input[_RP]).n(_RP));
    }
    return bn;
};
const se_ResponseHeadersPolicyRemoveHeader = (input, context) => {
    const bn = new __XmlNode(_RHPRH);
    if (input[_H] != null) {
        bn.c(__XmlNode.of(_s, input[_H]).n(_H));
    }
    return bn;
};
const se_ResponseHeadersPolicyRemoveHeaderList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_ResponseHeadersPolicyRemoveHeader(entry, context);
        return n.n(_RHPRH);
    });
};
const se_ResponseHeadersPolicyRemoveHeadersConfig = (input, context) => {
    const bn = new __XmlNode(_RHPRHC);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_ResponseHeadersPolicyRemoveHeaderList(input[_It], context));
    return bn;
};
const se_ResponseHeadersPolicySecurityHeadersConfig = (input, context) => {
    const bn = new __XmlNode(_RHPSHC);
    if (input[_XSSP] != null) {
        bn.c(se_ResponseHeadersPolicyXSSProtection(input[_XSSP], context).n(_XSSP));
    }
    if (input[_FOr] != null) {
        bn.c(se_ResponseHeadersPolicyFrameOptions(input[_FOr], context).n(_FOr));
    }
    if (input[_RP] != null) {
        bn.c(se_ResponseHeadersPolicyReferrerPolicy(input[_RP], context).n(_RP));
    }
    if (input[_CSP] != null) {
        bn.c(se_ResponseHeadersPolicyContentSecurityPolicy(input[_CSP], context).n(_CSP));
    }
    if (input[_CTO] != null) {
        bn.c(se_ResponseHeadersPolicyContentTypeOptions(input[_CTO], context).n(_CTO));
    }
    if (input[_STS] != null) {
        bn.c(se_ResponseHeadersPolicyStrictTransportSecurity(input[_STS], context).n(_STS));
    }
    return bn;
};
const se_ResponseHeadersPolicyServerTimingHeadersConfig = (input, context) => {
    const bn = new __XmlNode(_RHPSTHC);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_SR] != null) {
        bn.c(__XmlNode.of(_SR, String(input[_SR])).n(_SR));
    }
    return bn;
};
const se_ResponseHeadersPolicyStrictTransportSecurity = (input, context) => {
    const bn = new __XmlNode(_RHPSTS);
    if (input[_Ov] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Ov])).n(_Ov));
    }
    if (input[_ISn] != null) {
        bn.c(__XmlNode.of(_b, String(input[_ISn])).n(_ISn));
    }
    if (input[_Pre] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Pre])).n(_Pre));
    }
    if (input[_ACMAS] != null) {
        bn.c(__XmlNode.of(_i, String(input[_ACMAS])).n(_ACMAS));
    }
    return bn;
};
const se_ResponseHeadersPolicyXSSProtection = (input, context) => {
    const bn = new __XmlNode(_RHPXSSP);
    if (input[_Ov] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Ov])).n(_Ov));
    }
    if (input[_Pro] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Pro])).n(_Pro));
    }
    if (input[_MB] != null) {
        bn.c(__XmlNode.of(_b, String(input[_MB])).n(_MB));
    }
    if (input[_RU] != null) {
        bn.c(__XmlNode.of(_s, input[_RU]).n(_RU));
    }
    return bn;
};
const se_Restrictions = (input, context) => {
    const bn = new __XmlNode(_Re);
    if (input[_GRe] != null) {
        bn.c(se_GeoRestriction(input[_GRe], context).n(_GRe));
    }
    return bn;
};
const se_S3Origin = (input, context) => {
    const bn = new __XmlNode(_SO);
    if (input[_DN] != null) {
        bn.c(__XmlNode.of(_s, input[_DN]).n(_DN));
    }
    if (input[_OAI] != null) {
        bn.c(__XmlNode.of(_s, input[_OAI]).n(_OAI));
    }
    return bn;
};
const se_S3OriginConfig = (input, context) => {
    const bn = new __XmlNode(_SOC);
    if (input[_OAI] != null) {
        bn.c(__XmlNode.of(_s, input[_OAI]).n(_OAI));
    }
    return bn;
};
const se_SessionStickinessConfig = (input, context) => {
    const bn = new __XmlNode(_SSC);
    if (input[_ITTL] != null) {
        bn.c(__XmlNode.of(_i, String(input[_ITTL])).n(_ITTL));
    }
    if (input[_MTTLax] != null) {
        bn.c(__XmlNode.of(_i, String(input[_MTTLax])).n(_MTTLax));
    }
    return bn;
};
const se_SslProtocolsList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_SPs, entry);
        return n.n(_SPs);
    });
};
const se_StagingDistributionDnsNameList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_DNn);
    });
};
const se_StagingDistributionDnsNames = (input, context) => {
    const bn = new __XmlNode(_SDDN);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_StagingDistributionDnsNameList(input[_It], context));
    return bn;
};
const se_StatusCodeList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_i, String(entry));
        return n.n(_SCta);
    });
};
const se_StatusCodes = (input, context) => {
    const bn = new __XmlNode(_SCt);
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_StatusCodeList(input[_It], context));
    return bn;
};
const se_StreamingDistributionConfig = (input, context) => {
    const bn = new __XmlNode(_SDC);
    if (input[_CR] != null) {
        bn.c(__XmlNode.of(_s, input[_CR]).n(_CR));
    }
    if (input[_SO] != null) {
        bn.c(se_S3Origin(input[_SO], context).n(_SO));
    }
    if (input[_Al] != null) {
        bn.c(se_Aliases(input[_Al], context).n(_Al));
    }
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    if (input[_Lo] != null) {
        bn.c(se_StreamingLoggingConfig(input[_Lo], context).n(_Lo));
    }
    if (input[_TS] != null) {
        bn.c(se_TrustedSigners(input[_TS], context).n(_TS));
    }
    bn.cc(input, _PC);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    return bn;
};
const se_StreamingDistributionConfigWithTags = (input, context) => {
    const bn = new __XmlNode(_SDCWT);
    if (input[_SDC] != null) {
        bn.c(se_StreamingDistributionConfig(input[_SDC], context).n(_SDC));
    }
    if (input[_T] != null) {
        bn.c(se_Tags(input[_T], context).n(_T));
    }
    return bn;
};
const se_StreamingLoggingConfig = (input, context) => {
    const bn = new __XmlNode(_SLC);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_B] != null) {
        bn.c(__XmlNode.of(_s, input[_B]).n(_B));
    }
    if (input[_Pr] != null) {
        bn.c(__XmlNode.of(_s, input[_Pr]).n(_Pr));
    }
    return bn;
};
const se_StringSchemaConfig = (input, context) => {
    const bn = new __XmlNode(_SSCt);
    if (input[_Co] != null) {
        bn.c(__XmlNode.of(_s, input[_Co]).n(_Co));
    }
    if (input[_DV] != null) {
        bn.c(__XmlNode.of(_PV, input[_DV]).n(_DV));
    }
    if (input[_Req] != null) {
        bn.c(__XmlNode.of(_b, String(input[_Req])).n(_Req));
    }
    return bn;
};
const se_Tag = (input, context) => {
    const bn = new __XmlNode(_Ta);
    if (input[_K] != null) {
        bn.c(__XmlNode.of(_TK, input[_K]).n(_K));
    }
    if (input[_V] != null) {
        bn.c(__XmlNode.of(_TV, input[_V]).n(_V));
    }
    return bn;
};
const se_TagKeyList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_TK, entry);
        return n.n(_K);
    });
};
const se_TagKeys = (input, context) => {
    const bn = new __XmlNode(_TKa);
    bn.lc(input, "Items", "Items", () => se_TagKeyList(input[_It], context));
    return bn;
};
const se_TagList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = se_Tag(entry, context);
        return n.n(_Ta);
    });
};
const se_Tags = (input, context) => {
    const bn = new __XmlNode(_T);
    bn.lc(input, "Items", "Items", () => se_TagList(input[_It], context));
    return bn;
};
const se_TenantConfig = (input, context) => {
    const bn = new __XmlNode(_TCe);
    bn.lc(input, "ParameterDefinitions", "ParameterDefinitions", () => se_ParameterDefinitions(input[_PDa], context));
    return bn;
};
const se_TrafficConfig = (input, context) => {
    const bn = new __XmlNode(_TC);
    if (input[_SWC] != null) {
        bn.c(se_ContinuousDeploymentSingleWeightConfig(input[_SWC], context).n(_SWC));
    }
    if (input[_SHCi] != null) {
        bn.c(se_ContinuousDeploymentSingleHeaderConfig(input[_SHCi], context).n(_SHCi));
    }
    if (input[_Ty] != null) {
        bn.c(__XmlNode.of(_CDPT, input[_Ty]).n(_Ty));
    }
    return bn;
};
const se_TrustedKeyGroupIdList = (input, context) => {
    return input
        .filter((e) => e != null)
        .map((entry) => {
        const n = __XmlNode.of(_s, entry);
        return n.n(_KG);
    });
};
const se_TrustedKeyGroups = (input, context) => {
    const bn = new __XmlNode(_TKG);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_TrustedKeyGroupIdList(input[_It], context));
    return bn;
};
const se_TrustedSigners = (input, context) => {
    const bn = new __XmlNode(_TS);
    if (input[_E] != null) {
        bn.c(__XmlNode.of(_b, String(input[_E])).n(_E));
    }
    if (input[_Q] != null) {
        bn.c(__XmlNode.of(_i, String(input[_Q])).n(_Q));
    }
    bn.lc(input, "Items", "Items", () => se_AwsAccountNumberList(input[_It], context));
    return bn;
};
const se_ViewerCertificate = (input, context) => {
    const bn = new __XmlNode(_VC);
    if (input[_CFDC] != null) {
        bn.c(__XmlNode.of(_b, String(input[_CFDC])).n(_CFDC));
    }
    if (input[_IAMCI] != null) {
        bn.c(__XmlNode.of(_s, input[_IAMCI]).n(_IAMCI));
    }
    if (input[_ACMCA] != null) {
        bn.c(__XmlNode.of(_s, input[_ACMCA]).n(_ACMCA));
    }
    bn.cc(input, _SSLSM);
    bn.cc(input, _MPV);
    if (input[_Ce] != null) {
        bn.c(__XmlNode.of(_s, input[_Ce]).n(_Ce));
    }
    bn.cc(input, _CS);
    return bn;
};
const se_VpcOriginConfig = (input, context) => {
    const bn = new __XmlNode(_VOC);
    if (input[_VOI] != null) {
        bn.c(__XmlNode.of(_s, input[_VOI]).n(_VOI));
    }
    if (input[_ORT] != null) {
        bn.c(__XmlNode.of(_i, String(input[_ORT])).n(_ORT));
    }
    if (input[_OKT] != null) {
        bn.c(__XmlNode.of(_i, String(input[_OKT])).n(_OKT));
    }
    return bn;
};
const se_VpcOriginEndpointConfig = (input, context) => {
    const bn = new __XmlNode(_VOEC);
    if (input[_N] != null) {
        bn.c(__XmlNode.of(_s, input[_N]).n(_N));
    }
    if (input[_Ar] != null) {
        bn.c(__XmlNode.of(_s, input[_Ar]).n(_Ar));
    }
    if (input[_HTTPP] != null) {
        bn.c(__XmlNode.of(_i, String(input[_HTTPP])).n(_HTTPP));
    }
    if (input[_HTTPSP] != null) {
        bn.c(__XmlNode.of(_i, String(input[_HTTPSP])).n(_HTTPSP));
    }
    bn.cc(input, _OPP);
    if (input[_OSP] != null) {
        bn.c(se_OriginSslProtocols(input[_OSP], context).n(_OSP));
    }
    return bn;
};
const se_WebAclCustomization = (input, context) => {
    const bn = new __XmlNode(_WAC);
    if (input[_Ac] != null) {
        bn.c(__XmlNode.of(_CAT, input[_Ac]).n(_Ac));
    }
    if (input[_Ar] != null) {
        bn.c(__XmlNode.of(_s, input[_Ar]).n(_Ar));
    }
    return bn;
};
const de_AccessControlAllowHeadersList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AccessControlAllowMethodsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AccessControlAllowOriginsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AccessControlExposeHeadersList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_ActiveTrustedKeyGroups = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_KG] != null) {
        contents[_It] = de_KGKeyPairIdsList(__getArrayIfSingleItem(output[_It][_KG]), context);
    }
    return contents;
};
const de_ActiveTrustedSigners = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_Si] != null) {
        contents[_It] = de_SignerList(__getArrayIfSingleItem(output[_It][_Si]), context);
    }
    return contents;
};
const de_Aliases = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_CNAME] != null) {
        contents[_It] = de_AliasList(__getArrayIfSingleItem(output[_It][_CNAME]), context);
    }
    return contents;
};
const de_AliasICPRecordal = (output, context) => {
    const contents = {};
    if (output[_CNAME] != null) {
        contents[_CNAME] = __expectString(output[_CNAME]);
    }
    if (output[_ICPRS] != null) {
        contents[_ICPRS] = __expectString(output[_ICPRS]);
    }
    return contents;
};
const de_AliasICPRecordals = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AliasICPRecordal(entry, context);
    });
};
const de_AliasList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AllowedMethods = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_Met] != null) {
        contents[_It] = de_MethodsList(__getArrayIfSingleItem(output[_It][_Met]), context);
    }
    if (output[_CM] != null) {
        contents[_CM] = de_CachedMethods(output[_CM], context);
    }
    return contents;
};
const de_AnycastIpList = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output.AnycastIps === "") {
        contents[_AI] = [];
    }
    else if (output[_AI] != null && output[_AI][_AIn] != null) {
        contents[_AI] = de_AnycastIps(__getArrayIfSingleItem(output[_AI][_AIn]), context);
    }
    if (output[_IC] != null) {
        contents[_IC] = __strictParseInt32(output[_IC]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    return contents;
};
const de_AnycastIpListCollection = (output, context) => {
    const contents = {};
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_AILS] != null) {
        contents[_It] = de_AnycastIpListSummaries(__getArrayIfSingleItem(output[_It][_AILS]), context);
    }
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    return contents;
};
const de_AnycastIpListSummaries = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AnycastIpListSummary(entry, context);
    });
};
const de_AnycastIpListSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output[_IC] != null) {
        contents[_IC] = __strictParseInt32(output[_IC]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    return contents;
};
const de_AnycastIps = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AwsAccountNumberList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_CacheBehavior = (output, context) => {
    const contents = {};
    if (output[_PP] != null) {
        contents[_PP] = __expectString(output[_PP]);
    }
    if (output[_TOI] != null) {
        contents[_TOI] = __expectString(output[_TOI]);
    }
    if (output[_TS] != null) {
        contents[_TS] = de_TrustedSigners(output[_TS], context);
    }
    if (output[_TKG] != null) {
        contents[_TKG] = de_TrustedKeyGroups(output[_TKG], context);
    }
    if (output[_VPP] != null) {
        contents[_VPP] = __expectString(output[_VPP]);
    }
    if (output[_AM] != null) {
        contents[_AM] = de_AllowedMethods(output[_AM], context);
    }
    if (output[_SS] != null) {
        contents[_SS] = __parseBoolean(output[_SS]);
    }
    if (output[_Com] != null) {
        contents[_Com] = __parseBoolean(output[_Com]);
    }
    if (output[_LFA] != null) {
        contents[_LFA] = de_LambdaFunctionAssociations(output[_LFA], context);
    }
    if (output[_FA] != null) {
        contents[_FA] = de_FunctionAssociations(output[_FA], context);
    }
    if (output[_FLEI] != null) {
        contents[_FLEI] = __expectString(output[_FLEI]);
    }
    if (output[_RLCA] != null) {
        contents[_RLCA] = __expectString(output[_RLCA]);
    }
    if (output[_CPI] != null) {
        contents[_CPI] = __expectString(output[_CPI]);
    }
    if (output[_ORPI] != null) {
        contents[_ORPI] = __expectString(output[_ORPI]);
    }
    if (output[_RHPI] != null) {
        contents[_RHPI] = __expectString(output[_RHPI]);
    }
    if (output[_GC] != null) {
        contents[_GC] = de_GrpcConfig(output[_GC], context);
    }
    if (output[_FV] != null) {
        contents[_FV] = de_ForwardedValues(output[_FV], context);
    }
    if (output[_MTTL] != null) {
        contents[_MTTL] = __strictParseLong(output[_MTTL]);
    }
    if (output[_DTTL] != null) {
        contents[_DTTL] = __strictParseLong(output[_DTTL]);
    }
    if (output[_MTTLa] != null) {
        contents[_MTTLa] = __strictParseLong(output[_MTTLa]);
    }
    return contents;
};
const de_CacheBehaviorList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CacheBehavior(entry, context);
    });
};
const de_CacheBehaviors = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_CB] != null) {
        contents[_It] = de_CacheBehaviorList(__getArrayIfSingleItem(output[_It][_CB]), context);
    }
    return contents;
};
const de_CachedMethods = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_Met] != null) {
        contents[_It] = de_MethodsList(__getArrayIfSingleItem(output[_It][_Met]), context);
    }
    return contents;
};
const de_CachePolicy = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_CPC] != null) {
        contents[_CPC] = de_CachePolicyConfig(output[_CPC], context);
    }
    return contents;
};
const de_CachePolicyConfig = (output, context) => {
    const contents = {};
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_DTTL] != null) {
        contents[_DTTL] = __strictParseLong(output[_DTTL]);
    }
    if (output[_MTTLa] != null) {
        contents[_MTTLa] = __strictParseLong(output[_MTTLa]);
    }
    if (output[_MTTL] != null) {
        contents[_MTTL] = __strictParseLong(output[_MTTL]);
    }
    if (output[_PICKAFTO] != null) {
        contents[_PICKAFTO] = de_ParametersInCacheKeyAndForwardedToOrigin(output[_PICKAFTO], context);
    }
    return contents;
};
const de_CachePolicyCookiesConfig = (output, context) => {
    const contents = {};
    if (output[_CBo] != null) {
        contents[_CBo] = __expectString(output[_CBo]);
    }
    if (output[_Coo] != null) {
        contents[_Coo] = de_CookieNames(output[_Coo], context);
    }
    return contents;
};
const de_CachePolicyHeadersConfig = (output, context) => {
    const contents = {};
    if (output[_HB] != null) {
        contents[_HB] = __expectString(output[_HB]);
    }
    if (output[_He] != null) {
        contents[_He] = de_Headers(output[_He], context);
    }
    return contents;
};
const de_CachePolicyList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_CPS] != null) {
        contents[_It] = de_CachePolicySummaryList(__getArrayIfSingleItem(output[_It][_CPS]), context);
    }
    return contents;
};
const de_CachePolicyQueryStringsConfig = (output, context) => {
    const contents = {};
    if (output[_QSB] != null) {
        contents[_QSB] = __expectString(output[_QSB]);
    }
    if (output[_QS] != null) {
        contents[_QS] = de_QueryStringNames(output[_QS], context);
    }
    return contents;
};
const de_CachePolicySummary = (output, context) => {
    const contents = {};
    if (output[_Ty] != null) {
        contents[_Ty] = __expectString(output[_Ty]);
    }
    if (output[_CPa] != null) {
        contents[_CPa] = de_CachePolicy(output[_CPa], context);
    }
    return contents;
};
const de_CachePolicySummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CachePolicySummary(entry, context);
    });
};
const de_Certificate = (output, context) => {
    const contents = {};
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    return contents;
};
const de_CloudFrontOriginAccessIdentity = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_SCUI] != null) {
        contents[_SCUI] = __expectString(output[_SCUI]);
    }
    if (output[_CFOAIC] != null) {
        contents[_CFOAIC] = de_CloudFrontOriginAccessIdentityConfig(output[_CFOAIC], context);
    }
    return contents;
};
const de_CloudFrontOriginAccessIdentityConfig = (output, context) => {
    const contents = {};
    if (output[_CR] != null) {
        contents[_CR] = __expectString(output[_CR]);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    return contents;
};
const de_CloudFrontOriginAccessIdentityList = (output, context) => {
    const contents = {};
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_CFOAIS] != null) {
        contents[_It] = de_CloudFrontOriginAccessIdentitySummaryList(__getArrayIfSingleItem(output[_It][_CFOAIS]), context);
    }
    return contents;
};
const de_CloudFrontOriginAccessIdentitySummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_SCUI] != null) {
        contents[_SCUI] = __expectString(output[_SCUI]);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    return contents;
};
const de_CloudFrontOriginAccessIdentitySummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CloudFrontOriginAccessIdentitySummary(entry, context);
    });
};
const de_ConflictingAlias = (output, context) => {
    const contents = {};
    if (output[_A] != null) {
        contents[_A] = __expectString(output[_A]);
    }
    if (output[_DI] != null) {
        contents[_DI] = __expectString(output[_DI]);
    }
    if (output[_AIc] != null) {
        contents[_AIc] = __expectString(output[_AIc]);
    }
    return contents;
};
const de_ConflictingAliases = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ConflictingAlias(entry, context);
    });
};
const de_ConflictingAliasesList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_CAon] != null) {
        contents[_It] = de_ConflictingAliases(__getArrayIfSingleItem(output[_It][_CAon]), context);
    }
    return contents;
};
const de_ConnectionGroup = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_T] != null) {
        contents[_T] = de_Tags(output[_T], context);
    }
    if (output[_IE] != null) {
        contents[_IE] = __parseBoolean(output[_IE]);
    }
    if (output[_RE] != null) {
        contents[_RE] = __expectString(output[_RE]);
    }
    if (output[_AILI] != null) {
        contents[_AILI] = __expectString(output[_AILI]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_ID] != null) {
        contents[_ID] = __parseBoolean(output[_ID]);
    }
    return contents;
};
const de_ConnectionGroupSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output[_RE] != null) {
        contents[_RE] = __expectString(output[_RE]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_ET] != null) {
        contents[_ET] = __expectString(output[_ET]);
    }
    if (output[_AILI] != null) {
        contents[_AILI] = __expectString(output[_AILI]);
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_ID] != null) {
        contents[_ID] = __parseBoolean(output[_ID]);
    }
    return contents;
};
const de_ConnectionGroupSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ConnectionGroupSummary(entry, context);
    });
};
const de_ContentTypeProfile = (output, context) => {
    const contents = {};
    if (output[_Fo] != null) {
        contents[_Fo] = __expectString(output[_Fo]);
    }
    if (output[_PI] != null) {
        contents[_PI] = __expectString(output[_PI]);
    }
    if (output[_CT] != null) {
        contents[_CT] = __expectString(output[_CT]);
    }
    return contents;
};
const de_ContentTypeProfileConfig = (output, context) => {
    const contents = {};
    if (output[_FWCTIU] != null) {
        contents[_FWCTIU] = __parseBoolean(output[_FWCTIU]);
    }
    if (output[_CTPo] != null) {
        contents[_CTPo] = de_ContentTypeProfiles(output[_CTPo], context);
    }
    return contents;
};
const de_ContentTypeProfileList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ContentTypeProfile(entry, context);
    });
};
const de_ContentTypeProfiles = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_CTP] != null) {
        contents[_It] = de_ContentTypeProfileList(__getArrayIfSingleItem(output[_It][_CTP]), context);
    }
    return contents;
};
const de_ContinuousDeploymentPolicy = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_CDPC] != null) {
        contents[_CDPC] = de_ContinuousDeploymentPolicyConfig(output[_CDPC], context);
    }
    return contents;
};
const de_ContinuousDeploymentPolicyConfig = (output, context) => {
    const contents = {};
    if (output[_SDDN] != null) {
        contents[_SDDN] = de_StagingDistributionDnsNames(output[_SDDN], context);
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_TC] != null) {
        contents[_TC] = de_TrafficConfig(output[_TC], context);
    }
    return contents;
};
const de_ContinuousDeploymentPolicyList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_CDPS] != null) {
        contents[_It] = de_ContinuousDeploymentPolicySummaryList(__getArrayIfSingleItem(output[_It][_CDPS]), context);
    }
    return contents;
};
const de_ContinuousDeploymentPolicySummary = (output, context) => {
    const contents = {};
    if (output[_CDP] != null) {
        contents[_CDP] = de_ContinuousDeploymentPolicy(output[_CDP], context);
    }
    return contents;
};
const de_ContinuousDeploymentPolicySummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ContinuousDeploymentPolicySummary(entry, context);
    });
};
const de_ContinuousDeploymentSingleHeaderConfig = (output, context) => {
    const contents = {};
    if (output[_H] != null) {
        contents[_H] = __expectString(output[_H]);
    }
    if (output[_V] != null) {
        contents[_V] = __expectString(output[_V]);
    }
    return contents;
};
const de_ContinuousDeploymentSingleWeightConfig = (output, context) => {
    const contents = {};
    if (output[_W] != null) {
        contents[_W] = __strictParseFloat(output[_W]);
    }
    if (output[_SSC] != null) {
        contents[_SSC] = de_SessionStickinessConfig(output[_SSC], context);
    }
    return contents;
};
const de_CookieNameList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_CookieNames = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_N] != null) {
        contents[_It] = de_CookieNameList(__getArrayIfSingleItem(output[_It][_N]), context);
    }
    return contents;
};
const de_CookiePreference = (output, context) => {
    const contents = {};
    if (output[_For] != null) {
        contents[_For] = __expectString(output[_For]);
    }
    if (output[_WN] != null) {
        contents[_WN] = de_CookieNames(output[_WN], context);
    }
    return contents;
};
const de_CustomErrorResponse = (output, context) => {
    const contents = {};
    if (output[_EC] != null) {
        contents[_EC] = __strictParseInt32(output[_EC]);
    }
    if (output[_RPP] != null) {
        contents[_RPP] = __expectString(output[_RPP]);
    }
    if (output[_RC] != null) {
        contents[_RC] = __expectString(output[_RC]);
    }
    if (output[_ECMTTL] != null) {
        contents[_ECMTTL] = __strictParseLong(output[_ECMTTL]);
    }
    return contents;
};
const de_CustomErrorResponseList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CustomErrorResponse(entry, context);
    });
};
const de_CustomErrorResponses = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_CER] != null) {
        contents[_It] = de_CustomErrorResponseList(__getArrayIfSingleItem(output[_It][_CER]), context);
    }
    return contents;
};
const de_CustomHeaders = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_OCH] != null) {
        contents[_It] = de_OriginCustomHeadersList(__getArrayIfSingleItem(output[_It][_OCH]), context);
    }
    return contents;
};
const de_Customizations = (output, context) => {
    const contents = {};
    if (output[_WA] != null) {
        contents[_WA] = de_WebAclCustomization(output[_WA], context);
    }
    if (output[_Ce] != null) {
        contents[_Ce] = de_Certificate(output[_Ce], context);
    }
    if (output[_GR] != null) {
        contents[_GR] = de_GeoRestrictionCustomization(output[_GR], context);
    }
    return contents;
};
const de_CustomOriginConfig = (output, context) => {
    const contents = {};
    if (output[_HTTPP] != null) {
        contents[_HTTPP] = __strictParseInt32(output[_HTTPP]);
    }
    if (output[_HTTPSP] != null) {
        contents[_HTTPSP] = __strictParseInt32(output[_HTTPSP]);
    }
    if (output[_OPP] != null) {
        contents[_OPP] = __expectString(output[_OPP]);
    }
    if (output[_OSP] != null) {
        contents[_OSP] = de_OriginSslProtocols(output[_OSP], context);
    }
    if (output[_ORT] != null) {
        contents[_ORT] = __strictParseInt32(output[_ORT]);
    }
    if (output[_OKT] != null) {
        contents[_OKT] = __strictParseInt32(output[_OKT]);
    }
    return contents;
};
const de_DefaultCacheBehavior = (output, context) => {
    const contents = {};
    if (output[_TOI] != null) {
        contents[_TOI] = __expectString(output[_TOI]);
    }
    if (output[_TS] != null) {
        contents[_TS] = de_TrustedSigners(output[_TS], context);
    }
    if (output[_TKG] != null) {
        contents[_TKG] = de_TrustedKeyGroups(output[_TKG], context);
    }
    if (output[_VPP] != null) {
        contents[_VPP] = __expectString(output[_VPP]);
    }
    if (output[_AM] != null) {
        contents[_AM] = de_AllowedMethods(output[_AM], context);
    }
    if (output[_SS] != null) {
        contents[_SS] = __parseBoolean(output[_SS]);
    }
    if (output[_Com] != null) {
        contents[_Com] = __parseBoolean(output[_Com]);
    }
    if (output[_LFA] != null) {
        contents[_LFA] = de_LambdaFunctionAssociations(output[_LFA], context);
    }
    if (output[_FA] != null) {
        contents[_FA] = de_FunctionAssociations(output[_FA], context);
    }
    if (output[_FLEI] != null) {
        contents[_FLEI] = __expectString(output[_FLEI]);
    }
    if (output[_RLCA] != null) {
        contents[_RLCA] = __expectString(output[_RLCA]);
    }
    if (output[_CPI] != null) {
        contents[_CPI] = __expectString(output[_CPI]);
    }
    if (output[_ORPI] != null) {
        contents[_ORPI] = __expectString(output[_ORPI]);
    }
    if (output[_RHPI] != null) {
        contents[_RHPI] = __expectString(output[_RHPI]);
    }
    if (output[_GC] != null) {
        contents[_GC] = de_GrpcConfig(output[_GC], context);
    }
    if (output[_FV] != null) {
        contents[_FV] = de_ForwardedValues(output[_FV], context);
    }
    if (output[_MTTL] != null) {
        contents[_MTTL] = __strictParseLong(output[_MTTL]);
    }
    if (output[_DTTL] != null) {
        contents[_DTTL] = __strictParseLong(output[_DTTL]);
    }
    if (output[_MTTLa] != null) {
        contents[_MTTLa] = __strictParseLong(output[_MTTLa]);
    }
    return contents;
};
const de_Distribution = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_ARN] != null) {
        contents[_ARN] = __expectString(output[_ARN]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_IPIB] != null) {
        contents[_IPIB] = __strictParseInt32(output[_IPIB]);
    }
    if (output[_DN] != null) {
        contents[_DN] = __expectString(output[_DN]);
    }
    if (output[_ATS] != null) {
        contents[_ATS] = de_ActiveTrustedSigners(output[_ATS], context);
    }
    if (output[_ATKG] != null) {
        contents[_ATKG] = de_ActiveTrustedKeyGroups(output[_ATKG], context);
    }
    if (output[_DCi] != null) {
        contents[_DCi] = de_DistributionConfig(output[_DCi], context);
    }
    if (output.AliasICPRecordals === "") {
        contents[_AICPR] = [];
    }
    else if (output[_AICPR] != null && output[_AICPR][_AICPRl] != null) {
        contents[_AICPR] = de_AliasICPRecordals(__getArrayIfSingleItem(output[_AICPR][_AICPRl]), context);
    }
    return contents;
};
const de_DistributionConfig = (output, context) => {
    const contents = {};
    if (output[_CR] != null) {
        contents[_CR] = __expectString(output[_CR]);
    }
    if (output[_Al] != null) {
        contents[_Al] = de_Aliases(output[_Al], context);
    }
    if (output[_DRO] != null) {
        contents[_DRO] = __expectString(output[_DRO]);
    }
    if (output[_Ori] != null) {
        contents[_Ori] = de_Origins(output[_Ori], context);
    }
    if (output[_OG] != null) {
        contents[_OG] = de_OriginGroups(output[_OG], context);
    }
    if (output[_DCB] != null) {
        contents[_DCB] = de_DefaultCacheBehavior(output[_DCB], context);
    }
    if (output[_CBa] != null) {
        contents[_CBa] = de_CacheBehaviors(output[_CBa], context);
    }
    if (output[_CERu] != null) {
        contents[_CERu] = de_CustomErrorResponses(output[_CERu], context);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_Lo] != null) {
        contents[_Lo] = de_LoggingConfig(output[_Lo], context);
    }
    if (output[_PC] != null) {
        contents[_PC] = __expectString(output[_PC]);
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_VC] != null) {
        contents[_VC] = de_ViewerCertificate(output[_VC], context);
    }
    if (output[_Re] != null) {
        contents[_Re] = de_Restrictions(output[_Re], context);
    }
    if (output[_WACLI] != null) {
        contents[_WACLI] = __expectString(output[_WACLI]);
    }
    if (output[_HV] != null) {
        contents[_HV] = __expectString(output[_HV]);
    }
    if (output[_IIPVE] != null) {
        contents[_IIPVE] = __parseBoolean(output[_IIPVE]);
    }
    if (output[_CDPI] != null) {
        contents[_CDPI] = __expectString(output[_CDPI]);
    }
    if (output[_S] != null) {
        contents[_S] = __parseBoolean(output[_S]);
    }
    if (output[_AILI] != null) {
        contents[_AILI] = __expectString(output[_AILI]);
    }
    if (output[_TCe] != null) {
        contents[_TCe] = de_TenantConfig(output[_TCe], context);
    }
    if (output[_CMo] != null) {
        contents[_CMo] = __expectString(output[_CMo]);
    }
    return contents;
};
const de_DistributionIdList = (output, context) => {
    const contents = {};
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_DI] != null) {
        contents[_It] = de_DistributionIdListSummary(__getArrayIfSingleItem(output[_It][_DI]), context);
    }
    return contents;
};
const de_DistributionIdListSummary = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_DistributionList = (output, context) => {
    const contents = {};
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_DS] != null) {
        contents[_It] = de_DistributionSummaryList(__getArrayIfSingleItem(output[_It][_DS]), context);
    }
    return contents;
};
const de_DistributionSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_ARN] != null) {
        contents[_ARN] = __expectString(output[_ARN]);
    }
    if (output[_ET] != null) {
        contents[_ET] = __expectString(output[_ET]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_DN] != null) {
        contents[_DN] = __expectString(output[_DN]);
    }
    if (output[_Al] != null) {
        contents[_Al] = de_Aliases(output[_Al], context);
    }
    if (output[_Ori] != null) {
        contents[_Ori] = de_Origins(output[_Ori], context);
    }
    if (output[_OG] != null) {
        contents[_OG] = de_OriginGroups(output[_OG], context);
    }
    if (output[_DCB] != null) {
        contents[_DCB] = de_DefaultCacheBehavior(output[_DCB], context);
    }
    if (output[_CBa] != null) {
        contents[_CBa] = de_CacheBehaviors(output[_CBa], context);
    }
    if (output[_CERu] != null) {
        contents[_CERu] = de_CustomErrorResponses(output[_CERu], context);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_PC] != null) {
        contents[_PC] = __expectString(output[_PC]);
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_VC] != null) {
        contents[_VC] = de_ViewerCertificate(output[_VC], context);
    }
    if (output[_Re] != null) {
        contents[_Re] = de_Restrictions(output[_Re], context);
    }
    if (output[_WACLI] != null) {
        contents[_WACLI] = __expectString(output[_WACLI]);
    }
    if (output[_HV] != null) {
        contents[_HV] = __expectString(output[_HV]);
    }
    if (output[_IIPVE] != null) {
        contents[_IIPVE] = __parseBoolean(output[_IIPVE]);
    }
    if (output.AliasICPRecordals === "") {
        contents[_AICPR] = [];
    }
    else if (output[_AICPR] != null && output[_AICPR][_AICPRl] != null) {
        contents[_AICPR] = de_AliasICPRecordals(__getArrayIfSingleItem(output[_AICPR][_AICPRl]), context);
    }
    if (output[_S] != null) {
        contents[_S] = __parseBoolean(output[_S]);
    }
    if (output[_CMo] != null) {
        contents[_CMo] = __expectString(output[_CMo]);
    }
    if (output[_AILI] != null) {
        contents[_AILI] = __expectString(output[_AILI]);
    }
    return contents;
};
const de_DistributionSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DistributionSummary(entry, context);
    });
};
const de_DistributionTenant = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_DI] != null) {
        contents[_DI] = __expectString(output[_DI]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output.Domains === "") {
        contents[_D] = [];
    }
    else if (output[_D] != null && output[_D][_m] != null) {
        contents[_D] = de_DomainResultList(__getArrayIfSingleItem(output[_D][_m]), context);
    }
    if (output[_T] != null) {
        contents[_T] = de_Tags(output[_T], context);
    }
    if (output[_C] != null) {
        contents[_C] = de_Customizations(output[_C], context);
    }
    if (output.Parameters === "") {
        contents[_P] = [];
    }
    else if (output[_P] != null && output[_P][_m] != null) {
        contents[_P] = de_Parameters(__getArrayIfSingleItem(output[_P][_m]), context);
    }
    if (output[_CGI] != null) {
        contents[_CGI] = __expectString(output[_CGI]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    return contents;
};
const de_DistributionTenantList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DistributionTenantSummary(entry, context);
    });
};
const de_DistributionTenantSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_DI] != null) {
        contents[_DI] = __expectString(output[_DI]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output.Domains === "") {
        contents[_D] = [];
    }
    else if (output[_D] != null && output[_D][_m] != null) {
        contents[_D] = de_DomainResultList(__getArrayIfSingleItem(output[_D][_m]), context);
    }
    if (output[_CGI] != null) {
        contents[_CGI] = __expectString(output[_CGI]);
    }
    if (output[_C] != null) {
        contents[_C] = de_Customizations(output[_C], context);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_ET] != null) {
        contents[_ET] = __expectString(output[_ET]);
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    return contents;
};
const de_DnsConfiguration = (output, context) => {
    const contents = {};
    if (output[_Do] != null) {
        contents[_Do] = __expectString(output[_Do]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_Rea] != null) {
        contents[_Rea] = __expectString(output[_Rea]);
    }
    return contents;
};
const de_DnsConfigurationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DnsConfiguration(entry, context);
    });
};
const de_DomainConflict = (output, context) => {
    const contents = {};
    if (output[_Do] != null) {
        contents[_Do] = __expectString(output[_Do]);
    }
    if (output[_RTe] != null) {
        contents[_RTe] = __expectString(output[_RTe]);
    }
    if (output[_RI] != null) {
        contents[_RI] = __expectString(output[_RI]);
    }
    if (output[_AIc] != null) {
        contents[_AIc] = __expectString(output[_AIc]);
    }
    return contents;
};
const de_DomainConflictsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DomainConflict(entry, context);
    });
};
const de_DomainResult = (output, context) => {
    const contents = {};
    if (output[_Do] != null) {
        contents[_Do] = __expectString(output[_Do]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    return contents;
};
const de_DomainResultList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DomainResult(entry, context);
    });
};
const de_EncryptionEntities = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_EEn] != null) {
        contents[_It] = de_EncryptionEntityList(__getArrayIfSingleItem(output[_It][_EEn]), context);
    }
    return contents;
};
const de_EncryptionEntity = (output, context) => {
    const contents = {};
    if (output[_PKI] != null) {
        contents[_PKI] = __expectString(output[_PKI]);
    }
    if (output[_PIr] != null) {
        contents[_PIr] = __expectString(output[_PIr]);
    }
    if (output[_FP] != null) {
        contents[_FP] = de_FieldPatterns(output[_FP], context);
    }
    return contents;
};
const de_EncryptionEntityList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_EncryptionEntity(entry, context);
    });
};
const de_EndPoint = (output, context) => {
    const contents = {};
    if (output[_ST] != null) {
        contents[_ST] = __expectString(output[_ST]);
    }
    if (output[_KSC] != null) {
        contents[_KSC] = de_KinesisStreamConfig(output[_KSC], context);
    }
    return contents;
};
const de_EndPointList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_EndPoint(entry, context);
    });
};
const de_FieldLevelEncryption = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_FLEC] != null) {
        contents[_FLEC] = de_FieldLevelEncryptionConfig(output[_FLEC], context);
    }
    return contents;
};
const de_FieldLevelEncryptionConfig = (output, context) => {
    const contents = {};
    if (output[_CR] != null) {
        contents[_CR] = __expectString(output[_CR]);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_QAPC] != null) {
        contents[_QAPC] = de_QueryArgProfileConfig(output[_QAPC], context);
    }
    if (output[_CTPC] != null) {
        contents[_CTPC] = de_ContentTypeProfileConfig(output[_CTPC], context);
    }
    return contents;
};
const de_FieldLevelEncryptionList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_FLES] != null) {
        contents[_It] = de_FieldLevelEncryptionSummaryList(__getArrayIfSingleItem(output[_It][_FLES]), context);
    }
    return contents;
};
const de_FieldLevelEncryptionProfile = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_FLEPC] != null) {
        contents[_FLEPC] = de_FieldLevelEncryptionProfileConfig(output[_FLEPC], context);
    }
    return contents;
};
const de_FieldLevelEncryptionProfileConfig = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_CR] != null) {
        contents[_CR] = __expectString(output[_CR]);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_EE] != null) {
        contents[_EE] = de_EncryptionEntities(output[_EE], context);
    }
    return contents;
};
const de_FieldLevelEncryptionProfileList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_FLEPS] != null) {
        contents[_It] = de_FieldLevelEncryptionProfileSummaryList(__getArrayIfSingleItem(output[_It][_FLEPS]), context);
    }
    return contents;
};
const de_FieldLevelEncryptionProfileSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_EE] != null) {
        contents[_EE] = de_EncryptionEntities(output[_EE], context);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    return contents;
};
const de_FieldLevelEncryptionProfileSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_FieldLevelEncryptionProfileSummary(entry, context);
    });
};
const de_FieldLevelEncryptionSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_QAPC] != null) {
        contents[_QAPC] = de_QueryArgProfileConfig(output[_QAPC], context);
    }
    if (output[_CTPC] != null) {
        contents[_CTPC] = de_ContentTypeProfileConfig(output[_CTPC], context);
    }
    return contents;
};
const de_FieldLevelEncryptionSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_FieldLevelEncryptionSummary(entry, context);
    });
};
const de_FieldList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_FieldPatternList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_FieldPatterns = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_FPi] != null) {
        contents[_It] = de_FieldPatternList(__getArrayIfSingleItem(output[_It][_FPi]), context);
    }
    return contents;
};
const de_ForwardedValues = (output, context) => {
    const contents = {};
    if (output[_QSu] != null) {
        contents[_QSu] = __parseBoolean(output[_QSu]);
    }
    if (output[_Coo] != null) {
        contents[_Coo] = de_CookiePreference(output[_Coo], context);
    }
    if (output[_He] != null) {
        contents[_He] = de_Headers(output[_He], context);
    }
    if (output[_QSCK] != null) {
        contents[_QSCK] = de_QueryStringCacheKeys(output[_QSCK], context);
    }
    return contents;
};
const de_FunctionAssociation = (output, context) => {
    const contents = {};
    if (output[_FARN] != null) {
        contents[_FARN] = __expectString(output[_FARN]);
    }
    if (output[_ETv] != null) {
        contents[_ETv] = __expectString(output[_ETv]);
    }
    return contents;
};
const de_FunctionAssociationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_FunctionAssociation(entry, context);
    });
};
const de_FunctionAssociations = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_FAu] != null) {
        contents[_It] = de_FunctionAssociationList(__getArrayIfSingleItem(output[_It][_FAu]), context);
    }
    return contents;
};
const de_FunctionConfig = (output, context) => {
    const contents = {};
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_Ru] != null) {
        contents[_Ru] = __expectString(output[_Ru]);
    }
    if (output[_KVSA] != null) {
        contents[_KVSA] = de_KeyValueStoreAssociations(output[_KVSA], context);
    }
    return contents;
};
const de_FunctionExecutionLogList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_FunctionList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_FSu] != null) {
        contents[_It] = de_FunctionSummaryList(__getArrayIfSingleItem(output[_It][_FSu]), context);
    }
    return contents;
};
const de_FunctionMetadata = (output, context) => {
    const contents = {};
    if (output[_FARN] != null) {
        contents[_FARN] = __expectString(output[_FARN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    return contents;
};
const de_FunctionSummary = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_FCu] != null) {
        contents[_FCu] = de_FunctionConfig(output[_FCu], context);
    }
    if (output[_FM] != null) {
        contents[_FM] = de_FunctionMetadata(output[_FM], context);
    }
    return contents;
};
const de_FunctionSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_FunctionSummary(entry, context);
    });
};
const de_GeoRestriction = (output, context) => {
    const contents = {};
    if (output[_RT] != null) {
        contents[_RT] = __expectString(output[_RT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_L] != null) {
        contents[_It] = de_LocationList(__getArrayIfSingleItem(output[_It][_L]), context);
    }
    return contents;
};
const de_GeoRestrictionCustomization = (output, context) => {
    const contents = {};
    if (output[_RT] != null) {
        contents[_RT] = __expectString(output[_RT]);
    }
    if (output.Locations === "") {
        contents[_Loc] = [];
    }
    else if (output[_Loc] != null && output[_Loc][_L] != null) {
        contents[_Loc] = de_LocationList(__getArrayIfSingleItem(output[_Loc][_L]), context);
    }
    return contents;
};
const de_GrpcConfig = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    return contents;
};
const de_HeaderList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_Headers = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_N] != null) {
        contents[_It] = de_HeaderList(__getArrayIfSingleItem(output[_It][_N]), context);
    }
    return contents;
};
const de_Invalidation = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_CTre] != null) {
        contents[_CTre] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTre]));
    }
    if (output[_IB] != null) {
        contents[_IB] = de_InvalidationBatch(output[_IB], context);
    }
    return contents;
};
const de_InvalidationBatch = (output, context) => {
    const contents = {};
    if (output[_Pa] != null) {
        contents[_Pa] = de_Paths(output[_Pa], context);
    }
    if (output[_CR] != null) {
        contents[_CR] = __expectString(output[_CR]);
    }
    return contents;
};
const de_InvalidationList = (output, context) => {
    const contents = {};
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_ISnv] != null) {
        contents[_It] = de_InvalidationSummaryList(__getArrayIfSingleItem(output[_It][_ISnv]), context);
    }
    return contents;
};
const de_InvalidationSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_CTre] != null) {
        contents[_CTre] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTre]));
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    return contents;
};
const de_InvalidationSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_InvalidationSummary(entry, context);
    });
};
const de_KeyGroup = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_KGC] != null) {
        contents[_KGC] = de_KeyGroupConfig(output[_KGC], context);
    }
    return contents;
};
const de_KeyGroupConfig = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_PK] != null) {
        contents[_It] = de_PublicKeyIdList(__getArrayIfSingleItem(output[_It][_PK]), context);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    return contents;
};
const de_KeyGroupList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_KGS] != null) {
        contents[_It] = de_KeyGroupSummaryList(__getArrayIfSingleItem(output[_It][_KGS]), context);
    }
    return contents;
};
const de_KeyGroupSummary = (output, context) => {
    const contents = {};
    if (output[_KG] != null) {
        contents[_KG] = de_KeyGroup(output[_KG], context);
    }
    return contents;
};
const de_KeyGroupSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_KeyGroupSummary(entry, context);
    });
};
const de_KeyPairIdList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_KeyPairIds = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_KPI] != null) {
        contents[_It] = de_KeyPairIdList(__getArrayIfSingleItem(output[_It][_KPI]), context);
    }
    return contents;
};
const de_KeyValueStore = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_ARN] != null) {
        contents[_ARN] = __expectString(output[_ARN]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    return contents;
};
const de_KeyValueStoreAssociation = (output, context) => {
    const contents = {};
    if (output[_KVSARN] != null) {
        contents[_KVSARN] = __expectString(output[_KVSARN]);
    }
    return contents;
};
const de_KeyValueStoreAssociationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_KeyValueStoreAssociation(entry, context);
    });
};
const de_KeyValueStoreAssociations = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_KVSAe] != null) {
        contents[_It] = de_KeyValueStoreAssociationList(__getArrayIfSingleItem(output[_It][_KVSAe]), context);
    }
    return contents;
};
const de_KeyValueStoreList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_KVS] != null) {
        contents[_It] = de_KeyValueStoreSummaryList(__getArrayIfSingleItem(output[_It][_KVS]), context);
    }
    return contents;
};
const de_KeyValueStoreSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_KeyValueStore(entry, context);
    });
};
const de_KGKeyPairIds = (output, context) => {
    const contents = {};
    if (output[_KGI] != null) {
        contents[_KGI] = __expectString(output[_KGI]);
    }
    if (output[_KPIe] != null) {
        contents[_KPIe] = de_KeyPairIds(output[_KPIe], context);
    }
    return contents;
};
const de_KGKeyPairIdsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_KGKeyPairIds(entry, context);
    });
};
const de_KinesisStreamConfig = (output, context) => {
    const contents = {};
    if (output[_RARN] != null) {
        contents[_RARN] = __expectString(output[_RARN]);
    }
    if (output[_SARNt] != null) {
        contents[_SARNt] = __expectString(output[_SARNt]);
    }
    return contents;
};
const de_LambdaFunctionAssociation = (output, context) => {
    const contents = {};
    if (output[_LFARN] != null) {
        contents[_LFARN] = __expectString(output[_LFARN]);
    }
    if (output[_ETv] != null) {
        contents[_ETv] = __expectString(output[_ETv]);
    }
    if (output[_IBn] != null) {
        contents[_IBn] = __parseBoolean(output[_IBn]);
    }
    return contents;
};
const de_LambdaFunctionAssociationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_LambdaFunctionAssociation(entry, context);
    });
};
const de_LambdaFunctionAssociations = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_LFAa] != null) {
        contents[_It] = de_LambdaFunctionAssociationList(__getArrayIfSingleItem(output[_It][_LFAa]), context);
    }
    return contents;
};
const de_LocationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_LoggingConfig = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_ICn] != null) {
        contents[_ICn] = __parseBoolean(output[_ICn]);
    }
    if (output[_B] != null) {
        contents[_B] = __expectString(output[_B]);
    }
    if (output[_Pr] != null) {
        contents[_Pr] = __expectString(output[_Pr]);
    }
    return contents;
};
const de_ManagedCertificateDetails = (output, context) => {
    const contents = {};
    if (output[_CA] != null) {
        contents[_CA] = __expectString(output[_CA]);
    }
    if (output[_CSe] != null) {
        contents[_CSe] = __expectString(output[_CSe]);
    }
    if (output[_VTH] != null) {
        contents[_VTH] = __expectString(output[_VTH]);
    }
    if (output.ValidationTokenDetails === "") {
        contents[_VTD] = [];
    }
    else if (output[_VTD] != null && output[_VTD][_m] != null) {
        contents[_VTD] = de_ValidationTokenDetailList(__getArrayIfSingleItem(output[_VTD][_m]), context);
    }
    return contents;
};
const de_MethodsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_MonitoringSubscription = (output, context) => {
    const contents = {};
    if (output[_RMSC] != null) {
        contents[_RMSC] = de_RealtimeMetricsSubscriptionConfig(output[_RMSC], context);
    }
    return contents;
};
const de_Origin = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_DN] != null) {
        contents[_DN] = __expectString(output[_DN]);
    }
    if (output[_OP] != null) {
        contents[_OP] = __expectString(output[_OP]);
    }
    if (output[_CH] != null) {
        contents[_CH] = de_CustomHeaders(output[_CH], context);
    }
    if (output[_SOC] != null) {
        contents[_SOC] = de_S3OriginConfig(output[_SOC], context);
    }
    if (output[_COC] != null) {
        contents[_COC] = de_CustomOriginConfig(output[_COC], context);
    }
    if (output[_VOC] != null) {
        contents[_VOC] = de_VpcOriginConfig(output[_VOC], context);
    }
    if (output[_CAo] != null) {
        contents[_CAo] = __strictParseInt32(output[_CAo]);
    }
    if (output[_CTon] != null) {
        contents[_CTon] = __strictParseInt32(output[_CTon]);
    }
    if (output[_OS] != null) {
        contents[_OS] = de_OriginShield(output[_OS], context);
    }
    if (output[_OACI] != null) {
        contents[_OACI] = __expectString(output[_OACI]);
    }
    return contents;
};
const de_OriginAccessControl = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_OACC] != null) {
        contents[_OACC] = de_OriginAccessControlConfig(output[_OACC], context);
    }
    return contents;
};
const de_OriginAccessControlConfig = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_De] != null) {
        contents[_De] = __expectString(output[_De]);
    }
    if (output[_SP] != null) {
        contents[_SP] = __expectString(output[_SP]);
    }
    if (output[_SB] != null) {
        contents[_SB] = __expectString(output[_SB]);
    }
    if (output[_OACOT] != null) {
        contents[_OACOT] = __expectString(output[_OACOT]);
    }
    return contents;
};
const de_OriginAccessControlList = (output, context) => {
    const contents = {};
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_OACS] != null) {
        contents[_It] = de_OriginAccessControlSummaryList(__getArrayIfSingleItem(output[_It][_OACS]), context);
    }
    return contents;
};
const de_OriginAccessControlSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_De] != null) {
        contents[_De] = __expectString(output[_De]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_SP] != null) {
        contents[_SP] = __expectString(output[_SP]);
    }
    if (output[_SB] != null) {
        contents[_SB] = __expectString(output[_SB]);
    }
    if (output[_OACOT] != null) {
        contents[_OACOT] = __expectString(output[_OACOT]);
    }
    return contents;
};
const de_OriginAccessControlSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OriginAccessControlSummary(entry, context);
    });
};
const de_OriginCustomHeader = (output, context) => {
    const contents = {};
    if (output[_HN] != null) {
        contents[_HN] = __expectString(output[_HN]);
    }
    if (output[_HVe] != null) {
        contents[_HVe] = __expectString(output[_HVe]);
    }
    return contents;
};
const de_OriginCustomHeadersList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OriginCustomHeader(entry, context);
    });
};
const de_OriginGroup = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_FCa] != null) {
        contents[_FCa] = de_OriginGroupFailoverCriteria(output[_FCa], context);
    }
    if (output[_Mem] != null) {
        contents[_Mem] = de_OriginGroupMembers(output[_Mem], context);
    }
    if (output[_SC] != null) {
        contents[_SC] = __expectString(output[_SC]);
    }
    return contents;
};
const de_OriginGroupFailoverCriteria = (output, context) => {
    const contents = {};
    if (output[_SCt] != null) {
        contents[_SCt] = de_StatusCodes(output[_SCt], context);
    }
    return contents;
};
const de_OriginGroupList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OriginGroup(entry, context);
    });
};
const de_OriginGroupMember = (output, context) => {
    const contents = {};
    if (output[_OI] != null) {
        contents[_OI] = __expectString(output[_OI]);
    }
    return contents;
};
const de_OriginGroupMemberList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OriginGroupMember(entry, context);
    });
};
const de_OriginGroupMembers = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_OGM] != null) {
        contents[_It] = de_OriginGroupMemberList(__getArrayIfSingleItem(output[_It][_OGM]), context);
    }
    return contents;
};
const de_OriginGroups = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_OGr] != null) {
        contents[_It] = de_OriginGroupList(__getArrayIfSingleItem(output[_It][_OGr]), context);
    }
    return contents;
};
const de_OriginList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Origin(entry, context);
    });
};
const de_OriginRequestPolicy = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_ORPC] != null) {
        contents[_ORPC] = de_OriginRequestPolicyConfig(output[_ORPC], context);
    }
    return contents;
};
const de_OriginRequestPolicyConfig = (output, context) => {
    const contents = {};
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_HC] != null) {
        contents[_HC] = de_OriginRequestPolicyHeadersConfig(output[_HC], context);
    }
    if (output[_CC] != null) {
        contents[_CC] = de_OriginRequestPolicyCookiesConfig(output[_CC], context);
    }
    if (output[_QSC] != null) {
        contents[_QSC] = de_OriginRequestPolicyQueryStringsConfig(output[_QSC], context);
    }
    return contents;
};
const de_OriginRequestPolicyCookiesConfig = (output, context) => {
    const contents = {};
    if (output[_CBo] != null) {
        contents[_CBo] = __expectString(output[_CBo]);
    }
    if (output[_Coo] != null) {
        contents[_Coo] = de_CookieNames(output[_Coo], context);
    }
    return contents;
};
const de_OriginRequestPolicyHeadersConfig = (output, context) => {
    const contents = {};
    if (output[_HB] != null) {
        contents[_HB] = __expectString(output[_HB]);
    }
    if (output[_He] != null) {
        contents[_He] = de_Headers(output[_He], context);
    }
    return contents;
};
const de_OriginRequestPolicyList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_ORPS] != null) {
        contents[_It] = de_OriginRequestPolicySummaryList(__getArrayIfSingleItem(output[_It][_ORPS]), context);
    }
    return contents;
};
const de_OriginRequestPolicyQueryStringsConfig = (output, context) => {
    const contents = {};
    if (output[_QSB] != null) {
        contents[_QSB] = __expectString(output[_QSB]);
    }
    if (output[_QS] != null) {
        contents[_QS] = de_QueryStringNames(output[_QS], context);
    }
    return contents;
};
const de_OriginRequestPolicySummary = (output, context) => {
    const contents = {};
    if (output[_Ty] != null) {
        contents[_Ty] = __expectString(output[_Ty]);
    }
    if (output[_ORP] != null) {
        contents[_ORP] = de_OriginRequestPolicy(output[_ORP], context);
    }
    return contents;
};
const de_OriginRequestPolicySummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OriginRequestPolicySummary(entry, context);
    });
};
const de_Origins = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_Or] != null) {
        contents[_It] = de_OriginList(__getArrayIfSingleItem(output[_It][_Or]), context);
    }
    return contents;
};
const de_OriginShield = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_OSR] != null) {
        contents[_OSR] = __expectString(output[_OSR]);
    }
    return contents;
};
const de_OriginSslProtocols = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_SPs] != null) {
        contents[_It] = de_SslProtocolsList(__getArrayIfSingleItem(output[_It][_SPs]), context);
    }
    return contents;
};
const de_Parameter = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_V] != null) {
        contents[_V] = __expectString(output[_V]);
    }
    return contents;
};
const de_ParameterDefinition = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Def] != null) {
        contents[_Def] = de_ParameterDefinitionSchema(output[_Def], context);
    }
    return contents;
};
const de_ParameterDefinitions = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ParameterDefinition(entry, context);
    });
};
const de_ParameterDefinitionSchema = (output, context) => {
    const contents = {};
    if (output[_SSt] != null) {
        contents[_SSt] = de_StringSchemaConfig(output[_SSt], context);
    }
    return contents;
};
const de_Parameters = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Parameter(entry, context);
    });
};
const de_ParametersInCacheKeyAndForwardedToOrigin = (output, context) => {
    const contents = {};
    if (output[_EAEG] != null) {
        contents[_EAEG] = __parseBoolean(output[_EAEG]);
    }
    if (output[_EAEB] != null) {
        contents[_EAEB] = __parseBoolean(output[_EAEB]);
    }
    if (output[_HC] != null) {
        contents[_HC] = de_CachePolicyHeadersConfig(output[_HC], context);
    }
    if (output[_CC] != null) {
        contents[_CC] = de_CachePolicyCookiesConfig(output[_CC], context);
    }
    if (output[_QSC] != null) {
        contents[_QSC] = de_CachePolicyQueryStringsConfig(output[_QSC], context);
    }
    return contents;
};
const de_PathList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_Paths = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_Pat] != null) {
        contents[_It] = de_PathList(__getArrayIfSingleItem(output[_It][_Pat]), context);
    }
    return contents;
};
const de_PublicKey = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_PKC] != null) {
        contents[_PKC] = de_PublicKeyConfig(output[_PKC], context);
    }
    return contents;
};
const de_PublicKeyConfig = (output, context) => {
    const contents = {};
    if (output[_CR] != null) {
        contents[_CR] = __expectString(output[_CR]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_EK] != null) {
        contents[_EK] = __expectString(output[_EK]);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    return contents;
};
const de_PublicKeyIdList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_PublicKeyList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_PKS] != null) {
        contents[_It] = de_PublicKeySummaryList(__getArrayIfSingleItem(output[_It][_PKS]), context);
    }
    return contents;
};
const de_PublicKeySummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_EK] != null) {
        contents[_EK] = __expectString(output[_EK]);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    return contents;
};
const de_PublicKeySummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PublicKeySummary(entry, context);
    });
};
const de_QueryArgProfile = (output, context) => {
    const contents = {};
    if (output[_QA] != null) {
        contents[_QA] = __expectString(output[_QA]);
    }
    if (output[_PI] != null) {
        contents[_PI] = __expectString(output[_PI]);
    }
    return contents;
};
const de_QueryArgProfileConfig = (output, context) => {
    const contents = {};
    if (output[_FWQAPIU] != null) {
        contents[_FWQAPIU] = __parseBoolean(output[_FWQAPIU]);
    }
    if (output[_QAPu] != null) {
        contents[_QAPu] = de_QueryArgProfiles(output[_QAPu], context);
    }
    return contents;
};
const de_QueryArgProfileList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_QueryArgProfile(entry, context);
    });
};
const de_QueryArgProfiles = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_QAP] != null) {
        contents[_It] = de_QueryArgProfileList(__getArrayIfSingleItem(output[_It][_QAP]), context);
    }
    return contents;
};
const de_QueryStringCacheKeys = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_N] != null) {
        contents[_It] = de_QueryStringCacheKeysList(__getArrayIfSingleItem(output[_It][_N]), context);
    }
    return contents;
};
const de_QueryStringCacheKeysList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_QueryStringNames = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_N] != null) {
        contents[_It] = de_QueryStringNamesList(__getArrayIfSingleItem(output[_It][_N]), context);
    }
    return contents;
};
const de_QueryStringNamesList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_RealtimeLogConfig = (output, context) => {
    const contents = {};
    if (output[_ARN] != null) {
        contents[_ARN] = __expectString(output[_ARN]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_SR] != null) {
        contents[_SR] = __strictParseLong(output[_SR]);
    }
    if (output.EndPoints === "") {
        contents[_EP] = [];
    }
    else if (output[_EP] != null && output[_EP][_m] != null) {
        contents[_EP] = de_EndPointList(__getArrayIfSingleItem(output[_EP][_m]), context);
    }
    if (output.Fields === "") {
        contents[_F] = [];
    }
    else if (output[_F] != null && output[_F][_Fi] != null) {
        contents[_F] = de_FieldList(__getArrayIfSingleItem(output[_F][_Fi]), context);
    }
    return contents;
};
const de_RealtimeLogConfigList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RealtimeLogConfig(entry, context);
    });
};
const de_RealtimeLogConfigs = (output, context) => {
    const contents = {};
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_m] != null) {
        contents[_It] = de_RealtimeLogConfigList(__getArrayIfSingleItem(output[_It][_m]), context);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    return contents;
};
const de_RealtimeMetricsSubscriptionConfig = (output, context) => {
    const contents = {};
    if (output[_RMSS] != null) {
        contents[_RMSS] = __expectString(output[_RMSS]);
    }
    return contents;
};
const de_ResponseHeadersPolicy = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_RHPC] != null) {
        contents[_RHPC] = de_ResponseHeadersPolicyConfig(output[_RHPC], context);
    }
    return contents;
};
const de_ResponseHeadersPolicyAccessControlAllowHeaders = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_H] != null) {
        contents[_It] = de_AccessControlAllowHeadersList(__getArrayIfSingleItem(output[_It][_H]), context);
    }
    return contents;
};
const de_ResponseHeadersPolicyAccessControlAllowMethods = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_Met] != null) {
        contents[_It] = de_AccessControlAllowMethodsList(__getArrayIfSingleItem(output[_It][_Met]), context);
    }
    return contents;
};
const de_ResponseHeadersPolicyAccessControlAllowOrigins = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_Or] != null) {
        contents[_It] = de_AccessControlAllowOriginsList(__getArrayIfSingleItem(output[_It][_Or]), context);
    }
    return contents;
};
const de_ResponseHeadersPolicyAccessControlExposeHeaders = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_H] != null) {
        contents[_It] = de_AccessControlExposeHeadersList(__getArrayIfSingleItem(output[_It][_H]), context);
    }
    return contents;
};
const de_ResponseHeadersPolicyConfig = (output, context) => {
    const contents = {};
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_CCo] != null) {
        contents[_CCo] = de_ResponseHeadersPolicyCorsConfig(output[_CCo], context);
    }
    if (output[_SHC] != null) {
        contents[_SHC] = de_ResponseHeadersPolicySecurityHeadersConfig(output[_SHC], context);
    }
    if (output[_STHC] != null) {
        contents[_STHC] = de_ResponseHeadersPolicyServerTimingHeadersConfig(output[_STHC], context);
    }
    if (output[_CHC] != null) {
        contents[_CHC] = de_ResponseHeadersPolicyCustomHeadersConfig(output[_CHC], context);
    }
    if (output[_RHC] != null) {
        contents[_RHC] = de_ResponseHeadersPolicyRemoveHeadersConfig(output[_RHC], context);
    }
    return contents;
};
const de_ResponseHeadersPolicyContentSecurityPolicy = (output, context) => {
    const contents = {};
    if (output[_Ov] != null) {
        contents[_Ov] = __parseBoolean(output[_Ov]);
    }
    if (output[_CSP] != null) {
        contents[_CSP] = __expectString(output[_CSP]);
    }
    return contents;
};
const de_ResponseHeadersPolicyContentTypeOptions = (output, context) => {
    const contents = {};
    if (output[_Ov] != null) {
        contents[_Ov] = __parseBoolean(output[_Ov]);
    }
    return contents;
};
const de_ResponseHeadersPolicyCorsConfig = (output, context) => {
    const contents = {};
    if (output[_ACAO] != null) {
        contents[_ACAO] = de_ResponseHeadersPolicyAccessControlAllowOrigins(output[_ACAO], context);
    }
    if (output[_ACAH] != null) {
        contents[_ACAH] = de_ResponseHeadersPolicyAccessControlAllowHeaders(output[_ACAH], context);
    }
    if (output[_ACAM] != null) {
        contents[_ACAM] = de_ResponseHeadersPolicyAccessControlAllowMethods(output[_ACAM], context);
    }
    if (output[_ACAC] != null) {
        contents[_ACAC] = __parseBoolean(output[_ACAC]);
    }
    if (output[_ACEH] != null) {
        contents[_ACEH] = de_ResponseHeadersPolicyAccessControlExposeHeaders(output[_ACEH], context);
    }
    if (output[_ACMAS] != null) {
        contents[_ACMAS] = __strictParseInt32(output[_ACMAS]);
    }
    if (output[_OO] != null) {
        contents[_OO] = __parseBoolean(output[_OO]);
    }
    return contents;
};
const de_ResponseHeadersPolicyCustomHeader = (output, context) => {
    const contents = {};
    if (output[_H] != null) {
        contents[_H] = __expectString(output[_H]);
    }
    if (output[_V] != null) {
        contents[_V] = __expectString(output[_V]);
    }
    if (output[_Ov] != null) {
        contents[_Ov] = __parseBoolean(output[_Ov]);
    }
    return contents;
};
const de_ResponseHeadersPolicyCustomHeaderList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ResponseHeadersPolicyCustomHeader(entry, context);
    });
};
const de_ResponseHeadersPolicyCustomHeadersConfig = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_RHPCH] != null) {
        contents[_It] = de_ResponseHeadersPolicyCustomHeaderList(__getArrayIfSingleItem(output[_It][_RHPCH]), context);
    }
    return contents;
};
const de_ResponseHeadersPolicyFrameOptions = (output, context) => {
    const contents = {};
    if (output[_Ov] != null) {
        contents[_Ov] = __parseBoolean(output[_Ov]);
    }
    if (output[_FO] != null) {
        contents[_FO] = __expectString(output[_FO]);
    }
    return contents;
};
const de_ResponseHeadersPolicyList = (output, context) => {
    const contents = {};
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_RHPS] != null) {
        contents[_It] = de_ResponseHeadersPolicySummaryList(__getArrayIfSingleItem(output[_It][_RHPS]), context);
    }
    return contents;
};
const de_ResponseHeadersPolicyReferrerPolicy = (output, context) => {
    const contents = {};
    if (output[_Ov] != null) {
        contents[_Ov] = __parseBoolean(output[_Ov]);
    }
    if (output[_RP] != null) {
        contents[_RP] = __expectString(output[_RP]);
    }
    return contents;
};
const de_ResponseHeadersPolicyRemoveHeader = (output, context) => {
    const contents = {};
    if (output[_H] != null) {
        contents[_H] = __expectString(output[_H]);
    }
    return contents;
};
const de_ResponseHeadersPolicyRemoveHeaderList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ResponseHeadersPolicyRemoveHeader(entry, context);
    });
};
const de_ResponseHeadersPolicyRemoveHeadersConfig = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_RHPRH] != null) {
        contents[_It] = de_ResponseHeadersPolicyRemoveHeaderList(__getArrayIfSingleItem(output[_It][_RHPRH]), context);
    }
    return contents;
};
const de_ResponseHeadersPolicySecurityHeadersConfig = (output, context) => {
    const contents = {};
    if (output[_XSSP] != null) {
        contents[_XSSP] = de_ResponseHeadersPolicyXSSProtection(output[_XSSP], context);
    }
    if (output[_FOr] != null) {
        contents[_FOr] = de_ResponseHeadersPolicyFrameOptions(output[_FOr], context);
    }
    if (output[_RP] != null) {
        contents[_RP] = de_ResponseHeadersPolicyReferrerPolicy(output[_RP], context);
    }
    if (output[_CSP] != null) {
        contents[_CSP] = de_ResponseHeadersPolicyContentSecurityPolicy(output[_CSP], context);
    }
    if (output[_CTO] != null) {
        contents[_CTO] = de_ResponseHeadersPolicyContentTypeOptions(output[_CTO], context);
    }
    if (output[_STS] != null) {
        contents[_STS] = de_ResponseHeadersPolicyStrictTransportSecurity(output[_STS], context);
    }
    return contents;
};
const de_ResponseHeadersPolicyServerTimingHeadersConfig = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_SR] != null) {
        contents[_SR] = __strictParseFloat(output[_SR]);
    }
    return contents;
};
const de_ResponseHeadersPolicyStrictTransportSecurity = (output, context) => {
    const contents = {};
    if (output[_Ov] != null) {
        contents[_Ov] = __parseBoolean(output[_Ov]);
    }
    if (output[_ISn] != null) {
        contents[_ISn] = __parseBoolean(output[_ISn]);
    }
    if (output[_Pre] != null) {
        contents[_Pre] = __parseBoolean(output[_Pre]);
    }
    if (output[_ACMAS] != null) {
        contents[_ACMAS] = __strictParseInt32(output[_ACMAS]);
    }
    return contents;
};
const de_ResponseHeadersPolicySummary = (output, context) => {
    const contents = {};
    if (output[_Ty] != null) {
        contents[_Ty] = __expectString(output[_Ty]);
    }
    if (output[_RHP] != null) {
        contents[_RHP] = de_ResponseHeadersPolicy(output[_RHP], context);
    }
    return contents;
};
const de_ResponseHeadersPolicySummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ResponseHeadersPolicySummary(entry, context);
    });
};
const de_ResponseHeadersPolicyXSSProtection = (output, context) => {
    const contents = {};
    if (output[_Ov] != null) {
        contents[_Ov] = __parseBoolean(output[_Ov]);
    }
    if (output[_Pro] != null) {
        contents[_Pro] = __parseBoolean(output[_Pro]);
    }
    if (output[_MB] != null) {
        contents[_MB] = __parseBoolean(output[_MB]);
    }
    if (output[_RU] != null) {
        contents[_RU] = __expectString(output[_RU]);
    }
    return contents;
};
const de_Restrictions = (output, context) => {
    const contents = {};
    if (output[_GRe] != null) {
        contents[_GRe] = de_GeoRestriction(output[_GRe], context);
    }
    return contents;
};
const de_S3Origin = (output, context) => {
    const contents = {};
    if (output[_DN] != null) {
        contents[_DN] = __expectString(output[_DN]);
    }
    if (output[_OAI] != null) {
        contents[_OAI] = __expectString(output[_OAI]);
    }
    return contents;
};
const de_S3OriginConfig = (output, context) => {
    const contents = {};
    if (output[_OAI] != null) {
        contents[_OAI] = __expectString(output[_OAI]);
    }
    return contents;
};
const de_SessionStickinessConfig = (output, context) => {
    const contents = {};
    if (output[_ITTL] != null) {
        contents[_ITTL] = __strictParseInt32(output[_ITTL]);
    }
    if (output[_MTTLax] != null) {
        contents[_MTTLax] = __strictParseInt32(output[_MTTLax]);
    }
    return contents;
};
const de_Signer = (output, context) => {
    const contents = {};
    if (output[_AAN] != null) {
        contents[_AAN] = __expectString(output[_AAN]);
    }
    if (output[_KPIe] != null) {
        contents[_KPIe] = de_KeyPairIds(output[_KPIe], context);
    }
    return contents;
};
const de_SignerList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Signer(entry, context);
    });
};
const de_SslProtocolsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_StagingDistributionDnsNameList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_StagingDistributionDnsNames = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_DNn] != null) {
        contents[_It] = de_StagingDistributionDnsNameList(__getArrayIfSingleItem(output[_It][_DNn]), context);
    }
    return contents;
};
const de_StatusCodeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __strictParseInt32(entry);
    });
};
const de_StatusCodes = (output, context) => {
    const contents = {};
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_SCta] != null) {
        contents[_It] = de_StatusCodeList(__getArrayIfSingleItem(output[_It][_SCta]), context);
    }
    return contents;
};
const de_StreamingDistribution = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_ARN] != null) {
        contents[_ARN] = __expectString(output[_ARN]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_DN] != null) {
        contents[_DN] = __expectString(output[_DN]);
    }
    if (output[_ATS] != null) {
        contents[_ATS] = de_ActiveTrustedSigners(output[_ATS], context);
    }
    if (output[_SDC] != null) {
        contents[_SDC] = de_StreamingDistributionConfig(output[_SDC], context);
    }
    return contents;
};
const de_StreamingDistributionConfig = (output, context) => {
    const contents = {};
    if (output[_CR] != null) {
        contents[_CR] = __expectString(output[_CR]);
    }
    if (output[_SO] != null) {
        contents[_SO] = de_S3Origin(output[_SO], context);
    }
    if (output[_Al] != null) {
        contents[_Al] = de_Aliases(output[_Al], context);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_Lo] != null) {
        contents[_Lo] = de_StreamingLoggingConfig(output[_Lo], context);
    }
    if (output[_TS] != null) {
        contents[_TS] = de_TrustedSigners(output[_TS], context);
    }
    if (output[_PC] != null) {
        contents[_PC] = __expectString(output[_PC]);
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    return contents;
};
const de_StreamingDistributionList = (output, context) => {
    const contents = {};
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_SDS] != null) {
        contents[_It] = de_StreamingDistributionSummaryList(__getArrayIfSingleItem(output[_It][_SDS]), context);
    }
    return contents;
};
const de_StreamingDistributionSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_ARN] != null) {
        contents[_ARN] = __expectString(output[_ARN]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_DN] != null) {
        contents[_DN] = __expectString(output[_DN]);
    }
    if (output[_SO] != null) {
        contents[_SO] = de_S3Origin(output[_SO], context);
    }
    if (output[_Al] != null) {
        contents[_Al] = de_Aliases(output[_Al], context);
    }
    if (output[_TS] != null) {
        contents[_TS] = de_TrustedSigners(output[_TS], context);
    }
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_PC] != null) {
        contents[_PC] = __expectString(output[_PC]);
    }
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    return contents;
};
const de_StreamingDistributionSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_StreamingDistributionSummary(entry, context);
    });
};
const de_StreamingLoggingConfig = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_B] != null) {
        contents[_B] = __expectString(output[_B]);
    }
    if (output[_Pr] != null) {
        contents[_Pr] = __expectString(output[_Pr]);
    }
    return contents;
};
const de_StringSchemaConfig = (output, context) => {
    const contents = {};
    if (output[_Co] != null) {
        contents[_Co] = __expectString(output[_Co]);
    }
    if (output[_DV] != null) {
        contents[_DV] = __expectString(output[_DV]);
    }
    if (output[_Req] != null) {
        contents[_Req] = __parseBoolean(output[_Req]);
    }
    return contents;
};
const de_Tag = (output, context) => {
    const contents = {};
    if (output[_K] != null) {
        contents[_K] = __expectString(output[_K]);
    }
    if (output[_V] != null) {
        contents[_V] = __expectString(output[_V]);
    }
    return contents;
};
const de_TagList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Tag(entry, context);
    });
};
const de_Tags = (output, context) => {
    const contents = {};
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_Ta] != null) {
        contents[_It] = de_TagList(__getArrayIfSingleItem(output[_It][_Ta]), context);
    }
    return contents;
};
const de_TenantConfig = (output, context) => {
    const contents = {};
    if (output.ParameterDefinitions === "") {
        contents[_PDa] = [];
    }
    else if (output[_PDa] != null && output[_PDa][_m] != null) {
        contents[_PDa] = de_ParameterDefinitions(__getArrayIfSingleItem(output[_PDa][_m]), context);
    }
    return contents;
};
const de_TestResult = (output, context) => {
    const contents = {};
    if (output[_FSu] != null) {
        contents[_FSu] = de_FunctionSummary(output[_FSu], context);
    }
    if (output[_CU] != null) {
        contents[_CU] = __expectString(output[_CU]);
    }
    if (output.FunctionExecutionLogs === "") {
        contents[_FEL] = [];
    }
    else if (output[_FEL] != null && output[_FEL][_m] != null) {
        contents[_FEL] = de_FunctionExecutionLogList(__getArrayIfSingleItem(output[_FEL][_m]), context);
    }
    if (output[_FEM] != null) {
        contents[_FEM] = __expectString(output[_FEM]);
    }
    if (output[_FOu] != null) {
        contents[_FOu] = __expectString(output[_FOu]);
    }
    return contents;
};
const de_TrafficConfig = (output, context) => {
    const contents = {};
    if (output[_SWC] != null) {
        contents[_SWC] = de_ContinuousDeploymentSingleWeightConfig(output[_SWC], context);
    }
    if (output[_SHCi] != null) {
        contents[_SHCi] = de_ContinuousDeploymentSingleHeaderConfig(output[_SHCi], context);
    }
    if (output[_Ty] != null) {
        contents[_Ty] = __expectString(output[_Ty]);
    }
    return contents;
};
const de_TrustedKeyGroupIdList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_TrustedKeyGroups = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_KG] != null) {
        contents[_It] = de_TrustedKeyGroupIdList(__getArrayIfSingleItem(output[_It][_KG]), context);
    }
    return contents;
};
const de_TrustedSigners = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __parseBoolean(output[_E]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_AAN] != null) {
        contents[_It] = de_AwsAccountNumberList(__getArrayIfSingleItem(output[_It][_AAN]), context);
    }
    return contents;
};
const de_ValidationTokenDetail = (output, context) => {
    const contents = {};
    if (output[_Do] != null) {
        contents[_Do] = __expectString(output[_Do]);
    }
    if (output[_RTed] != null) {
        contents[_RTed] = __expectString(output[_RTed]);
    }
    if (output[_RF] != null) {
        contents[_RF] = __expectString(output[_RF]);
    }
    return contents;
};
const de_ValidationTokenDetailList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ValidationTokenDetail(entry, context);
    });
};
const de_ViewerCertificate = (output, context) => {
    const contents = {};
    if (output[_CFDC] != null) {
        contents[_CFDC] = __parseBoolean(output[_CFDC]);
    }
    if (output[_IAMCI] != null) {
        contents[_IAMCI] = __expectString(output[_IAMCI]);
    }
    if (output[_ACMCA] != null) {
        contents[_ACMCA] = __expectString(output[_ACMCA]);
    }
    if (output[_SSLSM] != null) {
        contents[_SSLSM] = __expectString(output[_SSLSM]);
    }
    if (output[_MPV] != null) {
        contents[_MPV] = __expectString(output[_MPV]);
    }
    if (output[_Ce] != null) {
        contents[_Ce] = __expectString(output[_Ce]);
    }
    if (output[_CS] != null) {
        contents[_CS] = __expectString(output[_CS]);
    }
    return contents;
};
const de_VpcOrigin = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_VOEC] != null) {
        contents[_VOEC] = de_VpcOriginEndpointConfig(output[_VOEC], context);
    }
    return contents;
};
const de_VpcOriginConfig = (output, context) => {
    const contents = {};
    if (output[_VOI] != null) {
        contents[_VOI] = __expectString(output[_VOI]);
    }
    if (output[_ORT] != null) {
        contents[_ORT] = __strictParseInt32(output[_ORT]);
    }
    if (output[_OKT] != null) {
        contents[_OKT] = __strictParseInt32(output[_OKT]);
    }
    return contents;
};
const de_VpcOriginEndpointConfig = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output[_HTTPP] != null) {
        contents[_HTTPP] = __strictParseInt32(output[_HTTPP]);
    }
    if (output[_HTTPSP] != null) {
        contents[_HTTPSP] = __strictParseInt32(output[_HTTPSP]);
    }
    if (output[_OPP] != null) {
        contents[_OPP] = __expectString(output[_OPP]);
    }
    if (output[_OSP] != null) {
        contents[_OSP] = de_OriginSslProtocols(output[_OSP], context);
    }
    return contents;
};
const de_VpcOriginList = (output, context) => {
    const contents = {};
    if (output[_M] != null) {
        contents[_M] = __expectString(output[_M]);
    }
    if (output[_NM] != null) {
        contents[_NM] = __expectString(output[_NM]);
    }
    if (output[_MI] != null) {
        contents[_MI] = __strictParseInt32(output[_MI]);
    }
    if (output[_IT] != null) {
        contents[_IT] = __parseBoolean(output[_IT]);
    }
    if (output[_Q] != null) {
        contents[_Q] = __strictParseInt32(output[_Q]);
    }
    if (output.Items === "") {
        contents[_It] = [];
    }
    else if (output[_It] != null && output[_It][_VOS] != null) {
        contents[_It] = de_VpcOriginSummaryList(__getArrayIfSingleItem(output[_It][_VOS]), context);
    }
    return contents;
};
const de_VpcOriginSummary = (output, context) => {
    const contents = {};
    if (output[_Id] != null) {
        contents[_Id] = __expectString(output[_Id]);
    }
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_LMT] != null) {
        contents[_LMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LMT]));
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    if (output[_OEA] != null) {
        contents[_OEA] = __expectString(output[_OEA]);
    }
    return contents;
};
const de_VpcOriginSummaryList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_VpcOriginSummary(entry, context);
    });
};
const de_WebAclCustomization = (output, context) => {
    const contents = {};
    if (output[_Ac] != null) {
        contents[_Ac] = __expectString(output[_Ac]);
    }
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    return contents;
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const _A = "Alias";
const _AAN = "AwsAccountNumber";
const _ACAC = "AccessControlAllowCredentials";
const _ACAH = "AccessControlAllowHeaders";
const _ACAM = "AccessControlAllowMethods";
const _ACAO = "AccessControlAllowOrigins";
const _ACEH = "AccessControlExposeHeaders";
const _ACMAS = "AccessControlMaxAgeSec";
const _ACMCA = "ACMCertificateArn";
const _ADTWACLR = "AssociateDistributionTenantWebACLRequest";
const _ADWACLR = "AssociateDistributionWebACLRequest";
const _AF = "AssociationFilter";
const _AI = "AnycastIps";
const _AICPR = "AliasICPRecordals";
const _AICPRl = "AliasICPRecordal";
const _AILI = "AnycastIpListId";
const _AILN = "AnycastIpListName";
const _AILS = "AnycastIpListSummary";
const _AIc = "AccountId";
const _AIn = "AnycastIp";
const _AM = "AllowedMethods";
const _ARN = "ARN";
const _ATKG = "ActiveTrustedKeyGroups";
const _ATS = "ActiveTrustedSigners";
const _Ac = "Action";
const _Al = "Aliases";
const _Ar = "Arn";
const _B = "Bucket";
const _C = "Customizations";
const _CA = "CertificateArn";
const _CAILR = "CreateAnycastIpListRequest";
const _CAT = "CustomizationActionType";
const _CAo = "ConnectionAttempts";
const _CAon = "ConflictingAlias";
const _CB = "CacheBehavior";
const _CBa = "CacheBehaviors";
const _CBo = "CookieBehavior";
const _CC = "CookiesConfig";
const _CCGR = "CreateConnectionGroupRequest";
const _CCo = "CorsConfig";
const _CDP = "ContinuousDeploymentPolicy";
const _CDPC = "ContinuousDeploymentPolicyConfig";
const _CDPI = "ContinuousDeploymentPolicyId";
const _CDPS = "ContinuousDeploymentPolicySummary";
const _CDPT = "ContinuousDeploymentPolicyType";
const _CDR = "CopyDistributionRequest";
const _CDSHC = "ContinuousDeploymentSingleHeaderConfig";
const _CDSWC = "ContinuousDeploymentSingleWeightConfig";
const _CDTR = "CreateDistributionTenantRequest";
const _CER = "CustomErrorResponse";
const _CERu = "CustomErrorResponses";
const _CFDC = "CloudFrontDefaultCertificate";
const _CFOAIC = "CloudFrontOriginAccessIdentityConfig";
const _CFOAIS = "CloudFrontOriginAccessIdentitySummary";
const _CFR = "CreateFunctionRequest";
const _CG = "ConnectionGroups";
const _CGAF = "ConnectionGroupAssociationFilter";
const _CGI = "ConnectionGroupId";
const _CGS = "ConnectionGroupSummary";
const _CH = "CustomHeaders";
const _CHC = "CustomHeadersConfig";
const _CKVSR = "CreateKeyValueStoreRequest";
const _CM = "CachedMethods";
const _CMo = "ConnectionMode";
const _CN = "CookieNames";
const _CNAME = "CNAME";
const _COC = "CustomOriginConfig";
const _CP = "CookiePreference";
const _CPC = "CachePolicyConfig";
const _CPCB = "CachePolicyCookieBehavior";
const _CPCC = "CachePolicyCookiesConfig";
const _CPHB = "CachePolicyHeaderBehavior";
const _CPHC = "CachePolicyHeadersConfig";
const _CPI = "CachePolicyId";
const _CPQSB = "CachePolicyQueryStringBehavior";
const _CPQSC = "CachePolicyQueryStringsConfig";
const _CPS = "CachePolicySummary";
const _CPa = "CachePolicy";
const _CR = "CallerReference";
const _CRLCR = "CreateRealtimeLogConfigRequest";
const _CS = "CertificateSource";
const _CSP = "ContentSecurityPolicy";
const _CSe = "CertificateStatus";
const _CT = "ContentType";
const _CTLP = "CertificateTransparencyLoggingPreference";
const _CTO = "ContentTypeOptions";
const _CTP = "ContentTypeProfile";
const _CTPC = "ContentTypeProfileConfig";
const _CTPo = "ContentTypeProfiles";
const _CTo = "CommentType";
const _CTon = "ConnectionTimeout";
const _CTr = "CreatedTime";
const _CTre = "CreateTime";
const _CU = "ComputeUtilization";
const _CVOR = "CreateVpcOriginRequest";
const _Ce = "Certificate";
const _Co = "Comment";
const _Com = "Compress";
const _Coo = "Cookies";
const _D = "Domains";
const _DC = "DomainConflicts";
const _DCB = "DefaultCacheBehavior";
const _DCL = "DnsConfigurationList";
const _DCVR = "DomainControlValidationResource";
const _DCWT = "DistributionConfigWithTags";
const _DCi = "DistributionConfig";
const _DCn = "DnsConfiguration";
const _DI = "DistributionId";
const _DIo = "DomainItem";
const _DN = "DomainName";
const _DNn = "DnsName";
const _DRI = "DistributionResourceId";
const _DRLCR = "DeleteRealtimeLogConfigRequest";
const _DRO = "DefaultRootObject";
const _DS = "DistributionSummary";
const _DTAF = "DistributionTenantAssociationFilter";
const _DTI = "DistributionTenantId";
const _DTL = "DistributionTenantList";
const _DTS = "DistributionTenantSummary";
const _DTTL = "DefaultTTL";
const _DV = "DefaultValue";
const _De = "Description";
const _Def = "Definition";
const _Do = "Domain";
const _E = "Enabled";
const _EAEB = "EnableAcceptEncodingBrotli";
const _EAEG = "EnableAcceptEncodingGzip";
const _EC = "ErrorCode";
const _ECMTTL = "ErrorCachingMinTTL";
const _EE = "EncryptionEntities";
const _EEn = "EncryptionEntity";
const _EK = "EncodedKey";
const _EO = "EventObject";
const _EP = "EndPoints";
const _EPn = "EndPoint";
const _ET = "ETag";
const _ETv = "EventType";
const _F = "Fields";
const _FA = "FunctionAssociations";
const _FARN = "FunctionARN";
const _FAu = "FunctionAssociation";
const _FB = "FunctionBlob";
const _FC = "FunctionCode";
const _FCa = "FailoverCriteria";
const _FCu = "FunctionConfig";
const _FEL = "FunctionExecutionLogs";
const _FEM = "FunctionErrorMessage";
const _FEO = "FunctionEventObject";
const _FLEC = "FieldLevelEncryptionConfig";
const _FLEI = "FieldLevelEncryptionId";
const _FLEPC = "FieldLevelEncryptionProfileConfig";
const _FLEPS = "FieldLevelEncryptionProfileSummary";
const _FLES = "FieldLevelEncryptionSummary";
const _FM = "FunctionMetadata";
const _FN = "FunctionName";
const _FO = "FrameOption";
const _FOL = "FrameOptionsList";
const _FOr = "FrameOptions";
const _FOu = "FunctionOutput";
const _FP = "FieldPatterns";
const _FPi = "FieldPattern";
const _FR = "FunctionRuntime";
const _FS = "FunctionStage";
const _FSu = "FunctionSummary";
const _FV = "ForwardedValues";
const _FWCTIU = "ForwardWhenContentTypeIsUnknown";
const _FWQAPIU = "ForwardWhenQueryArgProfileIsUnknown";
const _Fi = "Field";
const _Fo = "Format";
const _For = "Forward";
const _GC = "GrpcConfig";
const _GR = "GeoRestrictions";
const _GRC = "GeoRestrictionCustomization";
const _GRLCR = "GetRealtimeLogConfigRequest";
const _GRT = "GeoRestrictionType";
const _GRe = "GeoRestriction";
const _H = "Header";
const _HB = "HeaderBehavior";
const _HC = "HeadersConfig";
const _HN = "HeaderName";
const _HTTPP = "HTTPPort";
const _HTTPSP = "HTTPSPort";
const _HV = "HttpVersion";
const _HVe = "HeaderValue";
const _He = "Headers";
const _I = "Identifier";
const _IAMCI = "IAMCertificateId";
const _IB = "InvalidationBatch";
const _IBn = "IncludeBody";
const _IC = "IpCount";
const _ICPRS = "ICPRecordalStatus";
const _ICn = "IncludeCookies";
const _ID = "IsDefault";
const _IE = "Ipv6Enabled";
const _IIPVE = "IsIPV6Enabled";
const _IM = "IfMatch";
const _IPIB = "InProgressInvalidationBatches";
const _IS = "ImportSource";
const _IST = "ImportSourceType";
const _ISn = "IncludeSubdomains";
const _ISnv = "InvalidationSummary";
const _ISt = "ItemSelection";
const _IT = "IsTruncated";
const _ITTL = "IdleTTL";
const _Id = "Id";
const _It = "Items";
const _K = "Key";
const _KG = "KeyGroup";
const _KGC = "KeyGroupConfig";
const _KGI = "KeyGroupId";
const _KGS = "KeyGroupSummary";
const _KPI = "KeyPairId";
const _KPIe = "KeyPairIds";
const _KSC = "KinesisStreamConfig";
const _KVS = "KeyValueStore";
const _KVSA = "KeyValueStoreAssociations";
const _KVSARN = "KeyValueStoreARN";
const _KVSAe = "KeyValueStoreAssociation";
const _KVSC = "KeyValueStoreComment";
const _KVSN = "KeyValueStoreName";
const _L = "Location";
const _LC = "LoggingConfig";
const _LCGR = "ListConnectionGroupsRequest";
const _LDBRLCR = "ListDistributionsByRealtimeLogConfigRequest";
const _LDCR = "ListDomainConflictsRequest";
const _LDTBCR = "ListDistributionTenantsByCustomizationRequest";
const _LDTR = "ListDistributionTenantsRequest";
const _LFA = "LambdaFunctionAssociations";
const _LFARN = "LambdaFunctionARN";
const _LFAa = "LambdaFunctionAssociation";
const _LMT = "LastModifiedTime";
const _Lo = "Logging";
const _Loc = "Locations";
const _M = "Marker";
const _MB = "ModeBlock";
const _MCR = "ManagedCertificateRequest";
const _MI = "MaxItems";
const _MPV = "MinimumProtocolVersion";
const _MS = "MonitoringSubscription";
const _MTTL = "MinTTL";
const _MTTLa = "MaxTTL";
const _MTTLax = "MaximumTTL";
const _Me = "Message";
const _Mem = "Members";
const _Met = "Method";
const _N = "Name";
const _NM = "NextMarker";
const _O = "Operation";
const _OACC = "OriginAccessControlConfig";
const _OACI = "OriginAccessControlId";
const _OACOT = "OriginAccessControlOriginType";
const _OACOTr = "OriginAccessControlOriginTypes";
const _OACS = "OriginAccessControlSummary";
const _OACSB = "OriginAccessControlSigningBehaviors";
const _OACSP = "OriginAccessControlSigningProtocols";
const _OAI = "OriginAccessIdentity";
const _OCH = "OriginCustomHeader";
const _OEA = "OriginEndpointArn";
const _OG = "OriginGroups";
const _OGFC = "OriginGroupFailoverCriteria";
const _OGM = "OriginGroupMember";
const _OGMr = "OriginGroupMembers";
const _OGSC = "OriginGroupSelectionCriteria";
const _OGr = "OriginGroup";
const _OI = "OriginId";
const _OKT = "OriginKeepaliveTimeout";
const _OO = "OriginOverride";
const _OP = "OriginPath";
const _OPP = "OriginProtocolPolicy";
const _ORP = "OriginRequestPolicy";
const _ORPC = "OriginRequestPolicyConfig";
const _ORPCB = "OriginRequestPolicyCookieBehavior";
const _ORPCC = "OriginRequestPolicyCookiesConfig";
const _ORPHB = "OriginRequestPolicyHeaderBehavior";
const _ORPHC = "OriginRequestPolicyHeadersConfig";
const _ORPI = "OriginRequestPolicyId";
const _ORPQSB = "OriginRequestPolicyQueryStringBehavior";
const _ORPQSC = "OriginRequestPolicyQueryStringsConfig";
const _ORPS = "OriginRequestPolicySummary";
const _ORT = "OriginReadTimeout";
const _OS = "OriginShield";
const _OSP = "OriginSslProtocols";
const _OSR = "OriginShieldRegion";
const _Or = "Origin";
const _Ori = "Origins";
const _Ov = "Override";
const _P = "Parameters";
const _PC = "PriceClass";
const _PD = "ParameterDefinition";
const _PDN = "PrimaryDomainName";
const _PDS = "ParameterDefinitionSchema";
const _PDa = "ParameterDefinitions";
const _PI = "ProfileId";
const _PICKAFTO = "ParametersInCacheKeyAndForwardedToOrigin";
const _PIr = "ProviderId";
const _PK = "PublicKey";
const _PKC = "PublicKeyConfig";
const _PKI = "PublicKeyId";
const _PKS = "PublicKeySummary";
const _PN = "ParameterName";
const _PP = "PathPattern";
const _PV = "ParameterValue";
const _Pa = "Paths";
const _Par = "Parameter";
const _Pat = "Path";
const _Pr = "Prefix";
const _Pre = "Preload";
const _Pro = "Protection";
const _Q = "Quantity";
const _QA = "QueryArg";
const _QAP = "QueryArgProfile";
const _QAPC = "QueryArgProfileConfig";
const _QAPu = "QueryArgProfiles";
const _QS = "QueryStrings";
const _QSB = "QueryStringBehavior";
const _QSC = "QueryStringsConfig";
const _QSCK = "QueryStringCacheKeys";
const _QSN = "QueryStringNames";
const _QSu = "QueryString";
const _R = "Resource";
const _RARN = "RoleARN";
const _RC = "ResponseCode";
const _RE = "RoutingEndpoint";
const _RF = "RedirectFrom";
const _RHC = "RemoveHeadersConfig";
const _RHP = "ResponseHeadersPolicy";
const _RHPACAH = "ResponseHeadersPolicyAccessControlAllowHeaders";
const _RHPACAM = "ResponseHeadersPolicyAccessControlAllowMethods";
const _RHPACAMV = "ResponseHeadersPolicyAccessControlAllowMethodsValues";
const _RHPACAO = "ResponseHeadersPolicyAccessControlAllowOrigins";
const _RHPACEH = "ResponseHeadersPolicyAccessControlExposeHeaders";
const _RHPC = "ResponseHeadersPolicyConfig";
const _RHPCC = "ResponseHeadersPolicyCorsConfig";
const _RHPCH = "ResponseHeadersPolicyCustomHeader";
const _RHPCHC = "ResponseHeadersPolicyCustomHeadersConfig";
const _RHPCSP = "ResponseHeadersPolicyContentSecurityPolicy";
const _RHPCTO = "ResponseHeadersPolicyContentTypeOptions";
const _RHPFO = "ResponseHeadersPolicyFrameOptions";
const _RHPI = "ResponseHeadersPolicyId";
const _RHPRH = "ResponseHeadersPolicyRemoveHeader";
const _RHPRHC = "ResponseHeadersPolicyRemoveHeadersConfig";
const _RHPRP = "ResponseHeadersPolicyReferrerPolicy";
const _RHPS = "ResponseHeadersPolicySummary";
const _RHPSHC = "ResponseHeadersPolicySecurityHeadersConfig";
const _RHPSTHC = "ResponseHeadersPolicyServerTimingHeadersConfig";
const _RHPSTS = "ResponseHeadersPolicyStrictTransportSecurity";
const _RHPXSSP = "ResponseHeadersPolicyXSSProtection";
const _RI = "ResourceId";
const _RLC = "RealtimeLogConfig";
const _RLCA = "RealtimeLogConfigArn";
const _RLCN = "RealtimeLogConfigName";
const _RMSC = "RealtimeMetricsSubscriptionConfig";
const _RMSS = "RealtimeMetricsSubscriptionStatus";
const _RP = "ReferrerPolicy";
const _RPL = "ReferrerPolicyList";
const _RPP = "ResponsePagePath";
const _RT = "RestrictionType";
const _RTe = "ResourceType";
const _RTed = "RedirectTo";
const _RU = "ReportUri";
const _Re = "Restrictions";
const _Rea = "Reason";
const _Req = "Required";
const _Ru = "Runtime";
const _S = "Staging";
const _SARN = "SourceARN";
const _SARNt = "StreamARN";
const _SB = "SigningBehavior";
const _SC = "SelectionCriteria";
const _SCUI = "S3CanonicalUserId";
const _SCt = "StatusCodes";
const _SCta = "StatusCode";
const _SDC = "StreamingDistributionConfig";
const _SDCWT = "StreamingDistributionConfigWithTags";
const _SDDN = "StagingDistributionDnsNames";
const _SDI = "StagingDistributionId";
const _SDS = "StreamingDistributionSummary";
const _SHC = "SecurityHeadersConfig";
const _SHCi = "SingleHeaderConfig";
const _SLC = "StreamingLoggingConfig";
const _SO = "S3Origin";
const _SOC = "S3OriginConfig";
const _SP = "SigningProtocol";
const _SPs = "SslProtocol";
const _SR = "SamplingRate";
const _SS = "SmoothStreaming";
const _SSC = "SessionStickinessConfig";
const _SSCt = "StringSchemaConfig";
const _SSLSM = "SSLSupportMethod";
const _SSt = "StringSchema";
const _ST = "StreamType";
const _STHC = "ServerTimingHeadersConfig";
const _STS = "StrictTransportSecurity";
const _STo = "SourceType";
const _SWC = "SingleWeightConfig";
const _Si = "Signer";
const _St = "Stage";
const _Sta = "Status";
const _T = "Tags";
const _TC = "TrafficConfig";
const _TCe = "TenantConfig";
const _TFR = "TestFunctionRequest";
const _TK = "TagKey";
const _TKG = "TrustedKeyGroups";
const _TKa = "TagKeys";
const _TOI = "TargetOriginId";
const _TR = "TargetResource";
const _TS = "TrustedSigners";
const _TV = "TagValue";
const _Ta = "Tag";
const _Ty = "Type";
const _UCGR = "UpdateConnectionGroupRequest";
const _UDAR = "UpdateDomainAssociationRequest";
const _UDTR = "UpdateDistributionTenantRequest";
const _UFR = "UpdateFunctionRequest";
const _UKVSR = "UpdateKeyValueStoreRequest";
const _URLCR = "UpdateRealtimeLogConfigRequest";
const _V = "Value";
const _VC = "ViewerCertificate";
const _VDCR = "VerifyDnsConfigurationRequest";
const _VOC = "VpcOriginConfig";
const _VOEC = "VpcOriginEndpointConfig";
const _VOI = "VpcOriginId";
const _VOS = "VpcOriginSummary";
const _VPP = "ViewerProtocolPolicy";
const _VTD = "ValidationTokenDetails";
const _VTH = "ValidationTokenHost";
const _W = "Weight";
const _WA = "WebAcl";
const _WAC = "WebAclCustomization";
const _WACLA = "WebACLArn";
const _WACLI = "WebACLId";
const _WN = "WhitelistedNames";
const _WT = "WithTags";
const _XSSP = "XSSProtection";
const _b = "boolean";
const _ct = "content-type";
const _d = "domain";
const _e = "etag";
const _et = "ettag";
const _f = "float";
const _i = "integer";
const _im = "if-match";
const _l = "long";
const _lo = "location";
const _m = "member";
const _s = "string";
const _sST = "sensitiveStringType";
const _st = "staging";
const _ve = '<?xml version="1.0" encoding="UTF-8"?>';
