"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@oclif/core");
const fs = __importStar(require("node:fs"));
const node_path_1 = __importDefault(require("node:path"));
const aws_1 = __importDefault(require("../../aws"));
const log_1 = require("../../log");
const Tarballs = __importStar(require("../../tarballs"));
const upload_util_1 = require("../../upload-util");
class UploadDeb extends core_1.Command {
    static description = 'Upload deb package built with `pack deb`.';
    static flags = {
        'dry-run': core_1.Flags.boolean({ description: 'Run the command without uploading to S3.' }),
        root: core_1.Flags.string({ char: 'r', default: '.', description: 'Path to oclif CLI root.', required: true }),
    };
    async run() {
        const { flags } = await this.parse(UploadDeb);
        const buildConfig = await Tarballs.buildConfig(flags.root);
        const { config, s3Config } = buildConfig;
        const dist = (f) => buildConfig.dist(node_path_1.default.join('deb', f));
        const S3Options = {
            ACL: s3Config.acl || 'public-read',
            Bucket: s3Config.bucket,
        };
        if (!fs.existsSync(dist('Release')))
            this.error('Cannot find debian artifacts', {
                suggestions: ['Run "oclif pack deb" before uploading'],
            });
        const cloudKeyBase = (0, upload_util_1.commitAWSDir)(config.pjson.version, buildConfig.gitSha, s3Config);
        const upload = (file) => {
            const cloudKey = `${cloudKeyBase}/apt/${file}`;
            return aws_1.default.s3.uploadFile(dist(file), { ...S3Options, CacheControl: 'max-age=86400', Key: cloudKey }, {
                dryRun: flags['dry-run'],
            });
        };
        // apt expects ../apt/dists/versionName/[artifacts] but oclif wants versions/sha/apt/[artifacts]
        // see https://github.com/oclif/oclif/issues/347 for the AWS-redirect that solves this
        // this workaround puts the code in both places that the redirect was doing
        // with this, the docs are correct. The copies are all done in parallel so it shouldn't be too costly.
        const uploadWorkaround = (file) => {
            const cloudKey = `${cloudKeyBase}/apt/./${file}`;
            return aws_1.default.s3.uploadFile(dist(file), { ...S3Options, CacheControl: 'max-age=86400', Key: cloudKey }, {
                dryRun: flags['dry-run'],
            });
        };
        const uploadDeb = async (arch) => {
            const deb = (0, upload_util_1.templateShortKey)('deb', {
                arch,
                bin: config.bin,
                versionShaRevision: (0, upload_util_1.debVersion)(buildConfig),
            });
            if (fs.existsSync(dist(deb)))
                await Promise.all([upload(deb), uploadWorkaround(deb)]);
        };
        (0, log_1.log)(`starting upload of deb artifacts for v${config.version}-${buildConfig.gitSha}`);
        const arches = buildConfig.targets.filter((t) => t.platform === 'linux');
        await Promise.all([
            ...arches.map((a) => uploadDeb((0, upload_util_1.debArch)(a.arch))),
            upload('Packages.gz'),
            upload('Packages.xz'),
            upload('Packages.bz2'),
            upload('Release'),
            uploadWorkaround('Packages.gz'),
            uploadWorkaround('Packages.xz'),
            uploadWorkaround('Packages.bz2'),
            uploadWorkaround('Release'),
            ...(fs.existsSync(dist('InRelease')) ? [upload('InRelease'), uploadWorkaround('InRelease')] : []),
            ...(fs.existsSync(dist('Release.gpg')) ? [upload('Release.gpg'), uploadWorkaround('Release.gpg')] : []),
        ]);
        (0, log_1.log)(`done uploading deb artifacts for v${config.version}-${buildConfig.gitSha}`);
    }
}
exports.default = UploadDeb;
