/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import javax.tools.FileObject;

public final class Util {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n, String string) throws IOException {
        Charset charset = null;
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.err.println("Illegal charset name : " + string);
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            System.err.println("Unsupported charset : " + string);
            return null;
        }
        CharsetDecoder charsetDecoder = charset.newDecoder();
        charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] byArray = org.eclipse.jdt.internal.compiler.util.Util.getInputStreamAsByteArray(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        return charsetDecoder.decode(byteBuffer).array();
    }

    public static CharSequence getCharContents(FileObject fileObject, boolean bl, byte[] byArray, String string) throws IOException {
        if (byArray == null) {
            return null;
        }
        Charset charset = null;
        try {
            charset = Charset.forName(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            System.err.println("Illegal charset name : " + string);
            return null;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            System.err.println("Unsupported charset : " + string);
            return null;
        }
        CharsetDecoder charsetDecoder = charset.newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        if (bl) {
            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            return charsetDecoder.decode(byteBuffer);
        }
        charsetDecoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        CharBuffer charBuffer = CharBuffer.allocate(byArray.length);
        CoderResult coderResult = null;
        String string2 = charsetDecoder.replacement();
        int n = string2.length();
        EncodingErrorCollector encodingErrorCollector = null;
        while (true) {
            CharBuffer charBuffer2;
            if ((coderResult = charsetDecoder.decode(byteBuffer, charBuffer, true)).isMalformed() || coderResult.isUnmappable()) {
                if (encodingErrorCollector == null) {
                    encodingErrorCollector = new EncodingErrorCollector(fileObject, string);
                }
                Util.reportEncodingError(encodingErrorCollector, charBuffer.position(), coderResult.length());
                if (charBuffer.position() + n >= charBuffer.capacity()) {
                    charBuffer2 = CharBuffer.allocate(charBuffer.capacity() * 2);
                    charBuffer.flip();
                    charBuffer2.put(charBuffer);
                    charBuffer = charBuffer2;
                }
                charBuffer.append(string2);
                byteBuffer.position(byteBuffer.position() + coderResult.length());
                continue;
            }
            if (!coderResult.isOverflow()) break;
            charBuffer2 = CharBuffer.allocate(charBuffer.capacity() * 2);
            charBuffer.flip();
            charBuffer2.put(charBuffer);
            charBuffer = charBuffer2;
        }
        charBuffer.flip();
        if (encodingErrorCollector != null) {
            encodingErrorCollector.reportAllEncodingErrors(charBuffer.toString());
        }
        return charBuffer;
    }

    private static void reportEncodingError(EncodingErrorCollector encodingErrorCollector, int n, int n2) {
        encodingErrorCollector.collect(n, -n2);
    }

    public static class EncodingErrorCollector {
        ArrayList<EncodingError> encodingErrors = new ArrayList();
        FileObject fileObject;
        String encoding;

        public EncodingErrorCollector(FileObject fileObject, String string) {
            this.fileObject = fileObject;
            this.encoding = string;
        }

        public void collect(int n, int n2) {
            this.encodingErrors.add(new EncodingError(n, n2));
        }

        public void reportAllEncodingErrors(String string) {
            char[] cArray = string.toCharArray();
            for (EncodingError encodingError : this.encodingErrors) {
                System.err.println(this.fileObject.getName() + " Unmappable character for encoding " + this.encoding);
                System.err.println(encodingError.getSource(cArray));
            }
        }
    }

    public static class EncodingError {
        int position;
        int length;

        public EncodingError(int n, int n2) {
            this.position = n;
            this.length = n2;
        }

        public String getSource(char[] cArray) {
            int n;
            int n2;
            char c;
            int n3;
            int n4 = this.position;
            int n5 = this.position + this.length - 1;
            if (n4 > n5 || n4 < 0 && n5 < 0 || cArray.length == 0) {
                return "No source available";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\t');
            int n6 = cArray.length;
            int n7 = n3 = n4 >= n6 ? n6 - 1 : n4;
            while (n3 > 0 && (c = cArray[n3 - 1]) != '\n' && c != '\r') {
                --n3;
            }
            int n8 = n2 = n5 >= n6 ? n6 - 1 : n5;
            while (n2 + 1 < n6 && (c = cArray[n2 + 1]) != '\r' && c != '\n') {
                ++n2;
            }
            while ((c = cArray[n3]) == ' ' || c == '\t') {
                ++n3;
            }
            stringBuffer.append(cArray, n3, n2 - n3 + 1);
            stringBuffer.append(LINE_SEPARATOR).append("\t");
            for (n = n3; n < n4; ++n) {
                stringBuffer.append(cArray[n] == '\t' ? (char)'\t' : ' ');
            }
            for (n = n4; n <= (n5 >= n6 ? n6 - 1 : n5); ++n) {
                stringBuffer.append('^');
            }
            return stringBuffer.toString();
        }
    }
}

