/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.GroupBuilder;
import io.cucumber.cucumberexpressions.TreeRegexp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public class Group {
    private final List<Group> children;
    private final String value;
    private final int start;
    private final int end;

    Group(String value, int start, int end, List<Group> children) {
        this.value = value;
        this.start = start;
        this.end = end;
        this.children = children;
    }

    public String getValue() {
        return this.value;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public List<Group> getChildren() {
        return this.children;
    }

    public List<String> getValues() {
        List<Group> groups = this.getChildren().isEmpty() ? Collections.singletonList(this) : this.getChildren();
        return groups.stream().map(Group::getValue).collect(Collectors.toList());
    }

    public static Collection<Group> parse(Pattern expression) {
        GroupBuilder builder = TreeRegexp.createGroupBuilder(expression);
        return Group.toGroups(builder.getChildren());
    }

    private static List<Group> toGroups(List<GroupBuilder> children) {
        ArrayList<Group> list = new ArrayList<Group>();
        if (children != null) {
            for (GroupBuilder child : children) {
                list.add(new Group(child.getSource(), child.getStartIndex(), child.getEndIndex(), Group.toGroups(child.getChildren())));
            }
        }
        return list;
    }
}

