/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.text.mindmapmode;

import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPanel;
import com.lightdev.app.shtm.SHTMLPrefsChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.dpolivaev.mnemonicsetter.MnemonicSetter;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.CssRuleBuilder;
import org.freeplane.core.ui.components.html.StyleSheetConfigurer;
import org.freeplane.core.util.HtmlProcessor;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EventBuffer;
import org.freeplane.features.text.mindmapmode.FreeplaneToSHTMLPropertyChangeAdapter;
import org.freeplane.features.text.mindmapmode.MTextController;

public class EditNodeWYSIWYG
extends EditNodeBase {
    private static final Dimension PREFERRED_CONTENT_SIZE = new Dimension(600, 400);
    private String title;
    private Font font;
    private StyleSheet customStyleSheet = NodeCss.EMPTY.getStyleSheet();
    private Color textColor = Color.BLACK;
    private Dimension preferredContentSize = PREFERRED_CONTENT_SIZE;
    private int horizontalAlignment;
    private ComponentOrientation componentOrientation;

    public void setTitle(String purpose) {
        this.title = purpose;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public StyleSheet getCustomStyleSheet() {
        return this.customStyleSheet;
    }

    public void setCustomStyleSheet(StyleSheet customStyleSheet) {
        this.customStyleSheet = customStyleSheet;
    }

    public Dimension getPreferredContentSize() {
        return this.preferredContentSize;
    }

    public void setPreferredContentSize(Dimension preferredSize) {
        this.preferredContentSize = preferredSize;
    }

    public EditNodeWYSIWYG(NodeModel node, String text, EditNodeBase.IEditControl editControl, boolean enableSplit) {
        super(node, text, false, editControl);
        this.horizontalAlignment = HorizontalTextAlignment.DEFAULT.swingConstant;
        this.componentOrientation = TextWritingDirection.DEFAULT.componentOrientation;
    }

    @Override
    public void show(RootPaneContainer frame) {
        try {
            HTMLDialog htmlEditorWindow = this.createHtmlEditor(frame);
            htmlEditorWindow.setBase(this);
            String titleText = this.getEditControl().getEditType() == EditNodeBase.EditedComponent.TEXT ? TextUtils.getText((String)this.title) : TextUtils.getText((String)this.title) + " (" + TextController.getController().getShortPlainText(this.node, 30, " ...") + ")";
            final JDialog dialog = htmlEditorWindow.getDialog();
            dialog.setTitle(titleText);
            this.getEditControl().getEditType().installHolder(this.node, dialog);
            htmlEditorWindow.setSplitEnabled(this.getEditControl().canSplit());
            SHTMLPanel htmlEditorPanel = htmlEditorWindow.getHtmlEditorPanel();
            StringBuilder ruleBuilder = new StringBuilder(100);
            ruleBuilder.append("body {");
            ruleBuilder.append(new CssRuleBuilder().withCSSFont(this.font, UITools.FONT_SCALE_FACTOR).withColor(this.textColor).withBackground(this.getBackground()).withAlignment(this.horizontalAlignment));
            ruleBuilder.append("}\n");
            if (this.getEditControl().getEditType() != EditNodeBase.EditedComponent.NOTE || ResourceController.getResourceController().getBooleanProperty("resources_use_margin_top_zero_for_notes")) {
                ruleBuilder.append("p {margin-top:0;}\n");
            }
            HTMLDocument document = htmlEditorPanel.getDocument();
            JEditorPane editorPane = htmlEditorPanel.getEditorPane();
            editorPane.setComponentOrientation(this.componentOrientation);
            if (this.textColor != null) {
                editorPane.setForeground(this.textColor);
                editorPane.setCaretColor(this.textColor);
            }
            htmlEditorWindow.updateStyleSheet(ruleBuilder.toString(), this.customStyleSheet);
            URL url = this.node.getMap().getURL();
            if (url != null) {
                document.setBase(url);
            } else {
                document.setBase(new URL("file: "));
            }
            htmlEditorPanel.setContentPanePreferredSize(this.preferredContentSize);
            this.restoreDialogSize(dialog);
            dialog.pack();
            dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    EditNodeWYSIWYG.this.saveDialogSize(dialog);
                }
            });
            if (ResourceController.getResourceController().getBooleanProperty("el__position_window_below_node")) {
                UITools.setDialogLocationUnder((JDialog)dialog, (NodeModel)this.node);
            } else {
                UITools.setDialogLocationRelativeTo((JDialog)dialog, (NodeModel)this.node);
            }
            String content = this.getText();
            if (!HtmlUtils.isHtml((String)content)) {
                content = HtmlUtils.plainToHTML((String)content);
            }
            HtmlProcessor.configureUnknownTags((HTMLDocument)htmlEditorPanel.getDocument());
            htmlEditorPanel.setCurrentDocumentContent(content);
            KeyEvent firstKeyEvent = MTextController.getController().getEventQueue().getFirstEvent();
            JEditorPane currentPane = htmlEditorPanel.getEditorPane();
            if (currentPane == htmlEditorPanel.getMostRecentFocusOwner()) {
                this.redispatchKeyEvents(currentPane, firstKeyEvent);
                if (firstKeyEvent == null) {
                    editorPane.setCaretPosition(htmlEditorPanel.getDocument().getLength());
                }
            } else {
                EventBuffer keyEventDispatcher = MTextController.getController().getEventQueue();
                keyEventDispatcher.deactivate();
            }
            htmlEditorPanel.getMostRecentFocusOwner().requestFocus();
            htmlEditorWindow.show();
        }
        catch (Exception ex) {
            LogUtils.severe((String)"Loading of WYSIWYG HTML editor failed. Use the other editors instead.", (Throwable)ex);
        }
    }

    public HTMLDialog createHtmlEditor(RootPaneContainer frame) throws Exception {
        HTMLDialog htmlEditorWindow = new HTMLDialog(this, "", "", frame);
        ResourceController.getResourceController().addPropertyChangeListener((IFreeplanePropertyListener)new FreeplaneToSHTMLPropertyChangeAdapter("simplyhtml.window.", (SHTMLPrefsChangeListener)htmlEditorWindow.getHtmlEditorPanel()));
        return htmlEditorWindow;
    }

    public void setTextAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        this.componentOrientation = componentOrientation;
    }

    private static class HTMLDialog
    extends EditNodeBase.EditDialog {
        private SHTMLPanel htmlEditorPanel;
        private JButton splitButton;
        private StyleSheet ownStyleSheet = StyleSheetConfigurer.createDefaultStyleSheet();

        HTMLDialog(EditNodeBase base, String title, String purpose, RootPaneContainer frame) throws Exception {
            super(base, title, frame);
            JDialog dialog = this.getDialog();
            dialog.setModal(ResourceController.getResourceController().getBooleanProperty("enforceModalEditorDialogs"));
            this.createEditorPanel(purpose);
            this.getContentPane().add((Component)this.htmlEditorPanel, "Center");
            UITools.addEscapeActionToDialog((JDialog)dialog, (Action)new EditNodeBase.EditDialog.CancelAction());
            JButton okButton = new JButton();
            JButton cancelButton = new JButton();
            this.splitButton = new JButton();
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)okButton, (String)TextUtils.getRawText((String)"ok"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)cancelButton, (String)TextUtils.getRawText((String)"cancel"));
            LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)this.splitButton, (String)TextUtils.getRawText((String)"split"));
            EditNodeBase.EditDialog.SubmitAction submitAction = new EditNodeBase.EditDialog.SubmitAction();
            okButton.addActionListener(submitAction);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.cancel();
                }
            });
            EditNodeBase.EditDialog.SplitAction splitAction = new EditNodeBase.EditDialog.SplitAction();
            this.splitButton.addActionListener(splitAction);
            UITools.addKeyActionToDialog((JDialog)dialog, (Action)submitAction, (String)"alt ENTER", (String)"submit");
            KeyStroke splitNodeHotKey = ResourceController.getResourceController().getAcceleratorManager().getAccelerator("SplitNode");
            if (splitNodeHotKey != null) {
                UITools.addKeyActionToDialog((JDialog)dialog, (Action)splitAction, (String)splitNodeHotKey.toString(), (String)"split");
            }
            JPanel buttonPane = new JPanel();
            buttonPane.add(okButton);
            buttonPane.add(cancelButton);
            buttonPane.add(this.splitButton);
            buttonPane.setMaximumSize(new Dimension(1000, 20));
            MnemonicSetter.INSTANCE.setComponentMnemonics(new Container[]{buttonPane, this.htmlEditorPanel.getMenuBar()});
            if (ResourceController.getResourceController().getBooleanProperty("el__buttons_above")) {
                this.getContentPane().add((Component)buttonPane, "North");
            } else {
                this.getContentPane().add((Component)buttonPane, "South");
            }
        }

        @Override
        protected void cancel() {
            super.cancel();
            StyleSheet styleSheet = this.htmlEditorPanel.getDocument().getStyleSheet();
            StyleSheetConfigurer.resetStyles((StyleSheet)styleSheet, (int)1);
            this.getBase().getEditControl().cancel();
        }

        private SHTMLPanel createEditorPanel(String purpose) throws Exception {
            if (this.htmlEditorPanel == null) {
                this.htmlEditorPanel = MTextController.getController().createSHTMLPanel(purpose);
                SHTMLEditorPane editorPane = (SHTMLEditorPane)this.htmlEditorPanel.getEditorPane();
                SpellCheckerController spellCheckerController = SpellCheckerController.getController();
                spellCheckerController.enableAutoSpell((JTextComponent)editorPane, true);
                spellCheckerController.addSpellCheckerMenu(editorPane.getPopup());
                spellCheckerController.enableShortKey((JTextComponent)editorPane, true);
            }
            return this.htmlEditorPanel;
        }

        public SHTMLPanel getHtmlEditorPanel() {
            return this.htmlEditorPanel;
        }

        @Override
        public Component getMostRecentFocusOwner() {
            if (this.getDialog().isFocused()) {
                return this.getFocusOwner();
            }
            return this.htmlEditorPanel.getMostRecentFocusOwner();
        }

        @Override
        protected boolean isChanged() {
            return this.htmlEditorPanel.needsSaving();
        }

        @Override
        protected void split() {
            super.split();
            StyleSheet styleSheet = this.htmlEditorPanel.getDocument().getStyleSheet();
            StyleSheetConfigurer.resetStyles((StyleSheet)styleSheet, (int)1);
            this.getBase().getEditControl().split(HtmlUtils.unescapeHTMLUnicodeEntity((String)this.htmlEditorPanel.getDocumentText()), this.htmlEditorPanel.getCaretPosition());
        }

        @Override
        protected void submit() {
            super.submit();
            StyleSheetConfigurer.resetStyles((StyleSheet)this.htmlEditorPanel.getDocument().getStyleSheet(), (int)1);
            if (this.htmlEditorPanel.needsSaving()) {
                this.getBase().getEditControl().ok(HtmlUtils.unescapeHTMLUnicodeEntity((String)this.htmlEditorPanel.getDocumentText()));
            } else {
                this.getBase().getEditControl().cancel();
            }
        }

        public void setSplitEnabled(boolean enableSplit) {
            this.splitButton.setEnabled(enableSplit);
            this.splitButton.setVisible(enableSplit);
        }

        public void updateStyleSheet(String rule, StyleSheet customStyleSheet) {
            StyleSheet styleSheet = this.htmlEditorPanel.getDocument().getStyleSheet();
            StyleSheetConfigurer.resetStyles((StyleSheet)styleSheet, (int)1);
            this.ownStyleSheet.removeStyle("body");
            this.ownStyleSheet.removeStyle("p");
            this.ownStyleSheet.addRule(rule);
            styleSheet.addStyleSheet(this.ownStyleSheet);
            styleSheet.addStyleSheet(customStyleSheet);
        }
    }
}

