/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.url.MapVersionInterpreter;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

class ImportBranchAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ImportBranchAction() {
        super("ImportBranchAction");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        NodeModel parent = Controller.getCurrentModeController().getMapController().getSelectedNode();
        if (parent == null) {
            return;
        }
        JFileChooser chooser = UITools.newFileChooser();
        FileFilter fileFilter = ((MFileManager)UrlManager.getController()).getFileFilter();
        if (fileFilter != null) {
            chooser.addChoosableFileFilter(fileFilter);
            chooser.setFileFilter(fileFilter);
        }
        if ((returnVal = chooser.showOpenDialog(Controller.getCurrentController().getViewController().getCurrentRootComponent())) == 0) {
            MapModel map = parent.getMap();
            URL url = map.getURL();
            IExtension ownVersion = map.removeExtension(MapVersionInterpreter.class);
            try {
                NodeModel node = ((MFileManager)UrlManager.getController()).loadTree(map, chooser.getSelectedFile());
                if (node == map.getRootNode()) {
                    return;
                }
                PersistentNodeHook.removeMapExtensions((NodeModel)node);
                node.setSide(MapController.suggestNewChildSide((NodeModel)parent, (NodeModel.Side)NodeModel.Side.DEFAULT));
                ((MMapController)Controller.getCurrentModeController().getMapController()).insertNode(node, parent);
            }
            catch (Exception ex) {
                UrlManager.getController().handleLoadingException(ex);
            }
            finally {
                map.putExtension(MapVersionInterpreter.class, ownVersion);
                map.setURL(url);
            }
        }
    }
}

