/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.FreeplaneMenuBar;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.BorderLayoutWithVisibleCenterComponent;
import org.freeplane.main.application.Browser;
import org.freeplane.main.application.MapViewDockingWindows;
import org.freeplane.main.application.NavigationNextMapAction;
import org.freeplane.main.application.NavigationPreviousMapAction;
import org.freeplane.main.application.SplitPaneLayoutManager2Decorator;
import org.freeplane.main.application.SplitPaneLayoutManagerDecorator;
import org.freeplane.view.swing.map.MapView;

class ApplicationViewController
extends FrameController {
    private static final String SPLIT_PANE_LAST_LEFT_POSITION = "split_pane_last_left_position";
    private static final String SPLIT_PANE_LAST_POSITION = "split_pane_last_position";
    private static final String SPLIT_PANE_LAST_RIGHT_POSITION = "split_pane_last_right_position";
    private static final String SPLIT_PANE_LAST_TOP_POSITION = "split_pane_last_top_position";
    private final JFrame frame;
    private String mLocationPreferenceValue;
    private JComponent mMindMapComponent;
    private JSplitPane mSplitPane;
    private final NavigationNextMapAction navigationNextMap;
    private final NavigationPreviousMapAction navigationPreviousMap = new NavigationPreviousMapAction();
    private final ApplicationResourceController resourceController;
    private JComponent mapPane;
    private MapViewDockingWindows mapViewWindows;

    private static Image frameIcon(String size) {
        return new ImageIcon(ResourceController.getResourceController().getResource("/images/Freeplane_frame_icon_" + size + ".png")).getImage();
    }

    public ApplicationViewController(Controller controller, IMapViewManager mapViewController, JFrame frame) {
        super(controller, mapViewController, "");
        controller.addAction((AFreeplaneAction)this.navigationPreviousMap);
        this.navigationNextMap = new NavigationNextMapAction();
        controller.addAction((AFreeplaneAction)this.navigationNextMap);
        this.resourceController = (ApplicationResourceController)ResourceController.getResourceController();
        this.frame = frame;
    }

    public void changeNoteWindowLocation() {
        this.saveSplitPanePosition();
        this.mLocationPreferenceValue = this.resourceController.getProperty("note_location");
        if (this.mMindMapComponent != null) {
            this.insertComponentIntoSplitPane(this.mMindMapComponent);
        }
    }

    public String getAdjustableProperty(String label) {
        return this.resourceController.getProperty(label);
    }

    public FreeplaneMenuBar getFreeplaneMenuBar() {
        return Controller.getCurrentModeController().getUserInputListenerFactory().getMenuBar();
    }

    public void insertComponentIntoSplitPane(JComponent pMindMapComponent) {
        this.mMindMapComponent = pMindMapComponent;
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.mSplitPane.setLeftComponent(null);
        this.mSplitPane.setRightComponent(null);
        if ("right".equals(this.mLocationPreferenceValue)) {
            this.mSplitPane.setOrientation(1);
            this.mSplitPane.setLeftComponent(this.mapPane);
            this.mSplitPane.setRightComponent(pMindMapComponent);
        } else if ("left".equals(this.mLocationPreferenceValue)) {
            this.mSplitPane.setOrientation(1);
            this.mSplitPane.setLeftComponent(pMindMapComponent);
            this.mSplitPane.setRightComponent(this.mapPane);
        } else if ("top".equals(this.mLocationPreferenceValue)) {
            this.mSplitPane.setOrientation(0);
            this.mSplitPane.setLeftComponent(pMindMapComponent);
            this.mSplitPane.setRightComponent(this.mapPane);
        } else {
            this.mSplitPane.setOrientation(0);
            this.mSplitPane.setLeftComponent(this.mapPane);
            this.mSplitPane.setRightComponent(pMindMapComponent);
        }
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.mSplitPane)) {
            focusOwner.requestFocusInWindow();
        }
        this.mSplitPane.setContinuousLayout(true);
        this.mSplitPane.setOneTouchExpandable(false);
        SwingUtilities.invokeLater(this::resetDividerLocation);
    }

    private void resetDividerLocation() {
        int lastSplitPanePosition = -1;
        if ("right".equals(this.mLocationPreferenceValue)) {
            lastSplitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LAST_RIGHT_POSITION, -1);
        } else if ("left".equals(this.mLocationPreferenceValue)) {
            lastSplitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LAST_LEFT_POSITION, -1);
        } else if ("top".equals(this.mLocationPreferenceValue)) {
            lastSplitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LAST_TOP_POSITION, -1);
        } else if ("bottom".equals(this.mLocationPreferenceValue)) {
            lastSplitPanePosition = this.resourceController.getIntProperty(SPLIT_PANE_LAST_POSITION, -1);
        }
        if (lastSplitPanePosition != -1) {
            this.mSplitPane.setDividerLocation(lastSplitPanePosition);
            this.mSplitPane.setDividerLocation(lastSplitPanePosition);
        } else {
            this.mSplitPane.setDividerLocation(0.5);
            this.mSplitPane.setDividerLocation(0.5);
        }
    }

    public void openDocument(Hyperlink link) throws IOException {
        new Browser().openDocument(link);
    }

    public void openDocument(URL url) throws Exception {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            uri = new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), url.getRef());
        }
        this.openDocument(new Hyperlink(uri));
    }

    public boolean quit() {
        if (!super.quit()) {
            return false;
        }
        this.controller.fireApplicationStopped();
        this.frame.dispose();
        return true;
    }

    public void removeSplitPane() {
        this.saveSplitPanePosition();
        this.mMindMapComponent = null;
        this.mSplitPane.setLeftComponent(null);
        this.mSplitPane.setRightComponent(null);
        this.mSplitPane.setLeftComponent(this.mapPane);
        final Controller controller = Controller.getCurrentModeController().getController();
        IMapSelection selection = controller.getSelection();
        if (selection == null) {
            return;
        }
        final NodeModel node = selection.getSelected();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component component = controller.getMapViewManager().getComponent(node);
                if (component != null) {
                    component.requestFocus();
                }
            }
        });
    }

    public void saveProperties() {
        if (this.mapViewWindows == null) {
            return;
        }
        this.saveSplitPanePosition();
        if (this.frame.isResizable()) {
            int winState = this.frame.getExtendedState() & 0xFFFFFFFE;
            if (6 != (winState & 6)) {
                this.resourceController.setProperty("appwindow_x", String.valueOf(this.frame.getX()));
                this.resourceController.setProperty("appwindow_y", String.valueOf(this.frame.getY()));
                this.resourceController.setProperty("appwindow_width", String.valueOf(this.frame.getWidth()));
                this.resourceController.setProperty("appwindow_height", String.valueOf(this.frame.getHeight()));
            }
            this.resourceController.setProperty("appwindow_state", String.valueOf(winState));
        }
        this.mapViewWindows.saveLayout();
        this.resourceController.getLastOpenedList().saveProperties();
    }

    private void saveSplitPanePosition() {
        if (this.mSplitPane == null) {
            return;
        }
        if ("right".equals(this.mLocationPreferenceValue)) {
            this.resourceController.setProperty(SPLIT_PANE_LAST_RIGHT_POSITION, "" + this.mSplitPane.getLastDividerLocation());
        } else if ("left".equals(this.mLocationPreferenceValue)) {
            this.resourceController.setProperty(SPLIT_PANE_LAST_LEFT_POSITION, "" + this.mSplitPane.getLastDividerLocation());
        } else if ("top".equals(this.mLocationPreferenceValue)) {
            this.resourceController.setProperty(SPLIT_PANE_LAST_TOP_POSITION, "" + this.mSplitPane.getLastDividerLocation());
        } else {
            this.resourceController.setProperty(SPLIT_PANE_LAST_POSITION, "" + this.mSplitPane.getLastDividerLocation());
        }
    }

    protected void setFreeplaneMenuBar(FreeplaneMenuBar menuBar) {
        if (Compat.isMacOsX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            this.frame.setJMenuBar((JMenuBar)menuBar);
            System.setProperty("apple.laf.useScreenMenuBar", "false");
        } else {
            this.frame.setJMenuBar((JMenuBar)menuBar);
        }
    }

    public void setTitle(String frameTitle) {
        this.frame.setTitle(frameTitle);
        this.mapViewWindows.setTitle();
    }

    public void setWaitingCursor(boolean waiting) {
        if (waiting) {
            this.frame.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            this.frame.getRootPane().getGlassPane().setVisible(true);
        } else {
            this.frame.getRootPane().getGlassPane().setCursor(Cursor.getPredefinedCursor(0));
            this.frame.getRootPane().getGlassPane().setVisible(false);
        }
    }

    public void viewNumberChanged(int number) {
        this.navigationPreviousMap.setEnabled(number > 1);
        this.navigationNextMap.setEnabled(number > 1);
    }

    public void init(Controller controller) {
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.mLocationPreferenceValue = this.resourceController.getProperty("note_location", "bottom");
        this.mSplitPane = new JSplitPane(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                return false;
            }

            @Override
            public void setLayout(LayoutManager layout) {
                if (layout == null || layout instanceof SplitPaneLayoutManagerDecorator) {
                    super.setLayout(layout);
                } else if (layout instanceof LayoutManager2) {
                    super.setLayout(new SplitPaneLayoutManager2Decorator((LayoutManager2)layout));
                } else {
                    super.setLayout(new SplitPaneLayoutManagerDecorator(layout));
                }
            }
        };
        this.mSplitPane.setResizeWeight(1.0);
        this.mapViewWindows = new MapViewDockingWindows();
        this.mapPane = this.mapViewWindows.getMapPane();
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BorderLayoutWithVisibleCenterComponent());
        contentPane.add((Component)this.mSplitPane, "Center");
        this.mSplitPane.setLeftComponent(this.mapPane);
        this.mSplitPane.setRightComponent(null);
        this.initFrame(this.frame);
        super.init(controller);
    }

    private void initFrame(JFrame frame) {
        if (!Compat.isMacOsX()) {
            frame.setIconImages(Arrays.asList(ApplicationViewController.frameIcon("16x16"), ApplicationViewController.frameIcon("32x32"), ApplicationViewController.frameIcon("64x64"), ApplicationViewController.frameIcon("128x128"), ApplicationViewController.frameIcon("256x256"), ApplicationViewController.frameIcon("512x512")));
        }
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Controller.getCurrentController().quit();
            }
        });
        frame.setFocusTraversalKeysEnabled(false);
        int win_width = ResourceController.getResourceController().getIntProperty("appwindow_width", -1);
        int win_height = ResourceController.getResourceController().getIntProperty("appwindow_height", -1);
        int win_x = ResourceController.getResourceController().getIntProperty("appwindow_x", -1);
        int win_y = ResourceController.getResourceController().getIntProperty("appwindow_y", -1);
        Rectangle frameBounds = UITools.getValidFrameBounds((Component)frame, (int)win_x, (int)win_y, (int)win_width, (int)win_height);
        frame.setBounds(frameBounds);
        frame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        int win_state = Integer.parseInt(ResourceController.getResourceController().getProperty("appwindow_state", "0"));
        win_state = (win_state & 1) != 0 ? 0 : win_state;
        frame.setExtendedState(win_state);
    }

    public void openMapsOnStart() {
        this.mapViewWindows.loadLayout();
    }

    public void focusTo(MapView currentMapView) {
        this.mapViewWindows.focusMapViewLater(currentMapView);
    }

    public void previousMapView() {
        this.mapViewWindows.selectPreviousMapView();
    }

    public void nextMapView() {
        this.mapViewWindows.selectNextMapView();
    }

    public void setFullScreen(boolean fullScreen) {
        super.setFullScreen(fullScreen);
        if (fullScreen) {
            this.mapViewWindows.setTabAreaInvisiblePolicy((JFrame)UITools.getCurrentRootComponent());
        } else {
            this.mapViewWindows.setTabAreaVisiblePolicy((JFrame)UITools.getCurrentRootComponent());
        }
    }

    public Component getCurrentRootComponent() {
        JComponent mapViewComponent = this.controller.getMapViewManager().getMapViewComponent();
        return mapViewComponent != null ? SwingUtilities.getRoot(mapViewComponent) : this.frame;
    }

    public Component getMenuComponent() {
        return this.frame;
    }

    public List<? extends Component> getMapViewVector() {
        return this.mapViewWindows != null ? this.mapViewWindows.getMapViewVector() : null;
    }
}

