/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.googleearth.KmlExporter;
import org.fibs.geotag.tasks.BackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class GoogleEarthExportTask
extends BackgroundTask<Void> {
    private static final I18n i18n = I18nFactory.getI18n(GoogleEarthExportTask.class);
    private List<ImageInfo> images;
    private File file;

    public GoogleEarthExportTask(String name, List<ImageInfo> images, File file) {
        super(name);
        this.images = images;
        this.file = file;
    }

    @Override
    public int getCurrentProgress() {
        return 0;
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getMinProgress() {
        return 0;
    }

    @Override
    protected String doInBackground() throws Exception {
        KmlExporter exporter = new KmlExporter(this.images);
        try {
            exporter.write(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String message = String.format(i18n.tr("Finished exporting to %s."), this.file.getPath());
        return message;
    }
}

