/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.gephi.project.api.GephiFormatException;
import org.gephi.project.api.LegacyGephiFormatException;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.gephi.project.api.ProjectListener;
import org.gephi.project.api.Workspace;
import org.gephi.project.api.WorkspaceListener;
import org.gephi.project.impl.ProjectImpl;
import org.gephi.project.impl.ProjectInformationImpl;
import org.gephi.project.impl.ProjectsImpl;
import org.gephi.project.impl.WorkspaceImpl;
import org.gephi.project.impl.WorkspaceInformationImpl;
import org.gephi.project.impl.WorkspaceProviderImpl;
import org.gephi.project.io.DuplicateTask;
import org.gephi.project.io.LoadTask;
import org.gephi.project.io.SaveTask;
import org.gephi.utils.longtask.api.LongTaskExecutor;
import org.gephi.utils.longtask.spi.LongTask;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectControllerImpl
implements ProjectController {
    private final ProjectsImpl projects = new ProjectsImpl();
    private final List<WorkspaceListener> workspaceListeners = new ArrayList<WorkspaceListener>();
    private final List<ProjectListener> projectListeners = new ArrayList<ProjectListener>();
    private final LongTaskExecutor longTaskExecutor = new LongTaskExecutor(false, "ProjectController");

    public ProjectControllerImpl() {
        this.registerNetbeansPropertyEditors();
    }

    private void registerNetbeansPropertyEditors() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(PropertyEditorManager.getEditorSearchPath()));
        if (!list.contains("org.netbeans.beaninfo.editors")) {
            list.add(0, "org.netbeans.beaninfo.editors");
            PropertyEditorManager.setEditorSearchPath(list.toArray(new String[list.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectImpl newProject() {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            this.fireProjectEvent(ProjectListener::lock);
            ProjectImpl project = null;
            try {
                this.closeCurrentProject();
                project = new ProjectImpl(this.projects.nextUntitledProjectName());
                this.projects.addProject(project);
                this.openProjectInternal(project);
                ProjectImpl finalProject = project;
                this.fireProjectEvent(pl -> pl.opened(finalProject));
                return project;
            }
            catch (Exception e) {
                return this.handleException(project, e);
            }
        }
    }

    private ProjectImpl handleException(Project project, Throwable t) {
        this.fireProjectEvent(pl -> pl.error(project, t));
        if (t instanceof GephiFormatException) {
            throw (GephiFormatException)t;
        }
        if (t instanceof LegacyGephiFormatException) {
            throw (LegacyGephiFormatException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    @Override
    public Project openProject(File file) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            this.fireProjectEvent(ProjectListener::lock);
            LoadTask loadTask = new LoadTask(file);
            Future res = this.longTaskExecutor.execute((LongTask)loadTask, () -> {
                ProjectImpl project = loadTask.execute(this.getProjects());
                if (project != null) {
                    this.openProjectInternal(project);
                    this.fireProjectEvent(pl -> pl.opened(project));
                } else {
                    this.fireProjectEvent(ProjectListener::unlock);
                }
                return project;
            }, "", t -> this.handleException(null, t));
            try {
                return (Project)res.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void openProject(Project project) {
        if (!this.projects.containsProject(project)) {
            throw new IllegalArgumentException("Project " + project.getUniqueIdentifier() + " does not belong to the list of active projects");
        }
        File file = project.getFile();
        if (file == null) {
            throw new IllegalArgumentException("Project " + project.getUniqueIdentifier() + " has no file associated");
        }
        this.openProject(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProject(Project project) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            if (!((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).hasFile()) {
                throw new IllegalStateException("Project has no file");
            }
            File file = ((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).getFile();
            this.saveProject(project, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProject(Project project, File file) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            this.fireProjectEvent(ProjectListener::lock);
            SaveTask saveTask = new SaveTask(project, file);
            this.longTaskExecutor.execute((LongTask)saveTask, () -> {
                ((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).setFile(file);
                if (saveTask.run()) {
                    ((ProjectImpl)project).setLastOpened();
                    this.fireProjectEvent(pl -> pl.saved(project));
                } else {
                    this.fireProjectEvent(ProjectListener::unlock);
                }
            }, "", t -> this.handleException(project, t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCurrentProject() {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            if (this.projects.hasCurrentProject()) {
                this.fireProjectEvent(ProjectListener::lock);
                ProjectImpl project = this.projects.getCurrentProject();
                try {
                    if (project.hasCurrentWorkspace()) {
                        this.fireWorkspaceEvent(EventType.UNSELECT, project.getCurrentWorkspace());
                    }
                    for (Workspace ws : project.getWorkspaces()) {
                        this.fireWorkspaceEvent(EventType.CLOSE, ws);
                    }
                    this.projects.closeCurrentProject();
                    this.fireWorkspaceEvent(EventType.DISABLE, null);
                    this.fireProjectEvent(pl -> pl.closed(project));
                }
                catch (Exception e) {
                    this.handleException(project, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProject(Project project) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            if (this.projects.getCurrentProject() == project) {
                this.closeCurrentProject();
            }
            this.projects.removeProject((ProjectImpl)project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectsImpl getProjects() {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            return this.projects;
        }
    }

    @Override
    public Collection<Project> getAllProjects() {
        return Collections.unmodifiableList(Arrays.asList(this.projects.getProjects()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCurrentProject() {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            return this.projects.hasCurrentProject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workspace newWorkspace(Project project) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            WorkspaceImpl workspace = ((WorkspaceProviderImpl)project.getLookup().lookup(WorkspaceProviderImpl.class)).newWorkspace();
            this.fireWorkspaceEvent(EventType.INITIALIZE, workspace);
            return workspace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWorkspace(Workspace workspace) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            Project project = workspace.getProject();
            WorkspaceProviderImpl workspaceProvider = (WorkspaceProviderImpl)project.getLookup().lookup(WorkspaceProviderImpl.class);
            Workspace toSelectWorkspace = null;
            if (this.getCurrentWorkspace() == workspace) {
                toSelectWorkspace = workspaceProvider.getPrecedingWorkspace(workspace);
            }
            workspaceProvider.removeWorkspace(workspace);
            this.fireWorkspaceEvent(EventType.CLOSE, workspace);
            if (this.getCurrentWorkspace() == workspace) {
                if (toSelectWorkspace == null) {
                    this.closeCurrentProject();
                } else {
                    this.openWorkspace(toSelectWorkspace);
                }
            }
        }
    }

    private void openProjectInternal(Project project) {
        ProjectImpl projectImpl = (ProjectImpl)project;
        if (this.projects.hasCurrentProject()) {
            this.closeCurrentProject();
        }
        this.projects.addOrReplaceProject(projectImpl);
        this.projects.setCurrentProject(projectImpl);
        for (Workspace ws : projectImpl.getWorkspaces()) {
            this.fireWorkspaceEvent(EventType.INITIALIZE, ws);
        }
        if (!projectImpl.hasCurrentWorkspace()) {
            Workspace workspace;
            if (projectImpl.getWorkspaces().isEmpty()) {
                workspace = this.newWorkspace(project);
                this.openWorkspace(workspace);
            } else {
                workspace = (Workspace)projectImpl.getWorkspaces().get(0);
                this.openWorkspace(workspace);
            }
        } else {
            this.fireWorkspaceEvent(EventType.SELECT, projectImpl.getCurrentWorkspace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectImpl getCurrentProject() {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            return this.projects.getCurrentProject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkspaceImpl getCurrentWorkspace() {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            if (this.projects.hasCurrentProject()) {
                return this.getCurrentProject().getCurrentWorkspace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCurrentWorkspace() {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            WorkspaceImpl workspace = this.getCurrentWorkspace();
            if (workspace != null) {
                ((WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class)).close();
                this.fireWorkspaceEvent(EventType.UNSELECT, workspace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openWorkspace(Workspace workspace) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            this.closeCurrentWorkspace();
            this.getCurrentProject().setCurrentWorkspace(workspace);
            this.fireWorkspaceEvent(EventType.SELECT, workspace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workspace openNewWorkspace() {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            Workspace workspace;
            if (this.hasCurrentProject()) {
                ProjectImpl project = this.getCurrentProject();
                workspace = this.newWorkspace(project);
                this.openWorkspace(workspace);
            } else {
                ProjectImpl project = this.newProject();
                workspace = project.getCurrentWorkspace();
            }
            return workspace;
        }
    }

    @Override
    public Workspace duplicateWorkspace(Workspace workspace) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            DuplicateTask duplicateTask = new DuplicateTask(workspace);
            Future res = this.longTaskExecutor.execute((LongTask)duplicateTask, () -> {
                WorkspaceImpl newWorkspace = duplicateTask.run();
                if (newWorkspace != null) {
                    ((WorkspaceInformationImpl)newWorkspace.getLookup().lookup(WorkspaceInformationImpl.class)).setName(NbBundle.getMessage(ProjectControllerImpl.class, (String)"Workspace.duplicated.name", (Object)workspace.getName()));
                    this.fireWorkspaceEvent(EventType.INITIALIZE, newWorkspace);
                    this.openWorkspace(newWorkspace);
                }
                return newWorkspace;
            }, "", t -> this.handleException(workspace.getProject(), t));
            try {
                return (Workspace)res.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameProject(Project project, String name) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            ((ProjectInformationImpl)project.getLookup().lookup(ProjectInformationImpl.class)).setName(name);
            this.fireProjectEvent(pl -> pl.changed(project));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameWorkspace(Workspace workspace, String name) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            ((WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class)).setName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSource(Workspace workspace, String source) {
        ProjectControllerImpl projectControllerImpl = this;
        synchronized (projectControllerImpl) {
            ((WorkspaceInformationImpl)workspace.getLookup().lookup(WorkspaceInformationImpl.class)).setSource(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWorkspaceListener(WorkspaceListener workspaceListener) {
        List<WorkspaceListener> list = this.workspaceListeners;
        synchronized (list) {
            this.workspaceListeners.add(workspaceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWorkspaceListener(WorkspaceListener workspaceListener) {
        List<WorkspaceListener> list = this.workspaceListeners;
        synchronized (list) {
            this.workspaceListeners.remove(workspaceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProjectListener(ProjectListener projectListener) {
        List<ProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.add(projectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeProjectListener(ProjectListener projectListener) {
        List<ProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.remove(projectListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProjectEvent(Consumer<? super ProjectListener> consumer) {
        ArrayList<ProjectListener> listeners;
        List<ProjectListener> list = this.projectListeners;
        synchronized (list) {
            listeners = new ArrayList<ProjectListener>(this.projectListeners);
            listeners.addAll(Lookup.getDefault().lookupAll(ProjectListener.class));
        }
        for (ProjectListener listener : listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireWorkspaceEvent(EventType event, Workspace workspace) {
        ArrayList<WorkspaceListener> listeners;
        List<WorkspaceListener> list = this.workspaceListeners;
        synchronized (list) {
            listeners = new ArrayList<WorkspaceListener>(this.workspaceListeners);
            listeners.addAll(Lookup.getDefault().lookupAll(WorkspaceListener.class));
        }
        for (WorkspaceListener wl : listeners) {
            try {
                switch (event) {
                    case INITIALIZE: {
                        wl.initialize(workspace);
                        break;
                    }
                    case SELECT: {
                        wl.select(workspace);
                        break;
                    }
                    case UNSELECT: {
                        wl.unselect(workspace);
                        break;
                    }
                    case CLOSE: {
                        wl.close(workspace);
                        break;
                    }
                    case DISABLE: {
                        wl.disable();
                    }
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public static enum EventType {
        INITIALIZE,
        SELECT,
        UNSELECT,
        CLOSE,
        DISABLE;

    }
}

