/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.support;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.kotlin.dsl.support.ClassBytesRepository;
import org.gradle.kotlin.dsl.support.ClassBytesRepositoryKt;
import org.gradle.util.internal.TextUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0013\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u00150\u0014J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\tJ.\u0010\u0018\u001a \u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f0\bj\u0002`\r2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u001e\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u001e\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J.\u0010\u001f\u001a \u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f0\bj\u0002`\r2\u0006\u0010 \u001a\u00020\u000fH\u0002J.\u0010!\u001a \u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f0\bj\u0002`\r2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u000fH\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\"\u001a\u00020\u000fH\u0002R2\u0010\u0006\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\t\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\u0004\u0018\u0001`\f0\bj\u0002`\r0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/gradle/kotlin/dsl/support/ClassBytesRepository;", "Ljava/io/Closeable;", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "classPathDependencies", "(Lorg/gradle/internal/classpath/ClassPath;Lorg/gradle/internal/classpath/ClassPath;)V", "classBytesIndex", "", "Lkotlin/Function1;", "", "Lkotlin/Function0;", "", "Lorg/gradle/kotlin/dsl/support/ClassBytesSupplier;", "Lorg/gradle/kotlin/dsl/support/ClassBytesIndex;", "classPathFiles", "Ljava/io/File;", "openJars", "", "Ljava/util/jar/JarFile;", "allClassesBytesBySourceName", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "classBytesFor", "sourceName", "classBytesIndexFor", "entry", "classBytesSupplierForFilePath", "classFilePath", "classBytesSupplierForSourceName", "close", "", "directoryClassBytesIndexFor", "dir", "jarClassBytesIndexFor", "jar", "openJarFile", "file", "sourceNamesFrom", "sourceNamesFromDir", "sourceNamesFromJar", "kotlin-dsl"})
public final class ClassBytesRepository
implements Closeable {
    private final Map<File, JarFile> openJars;
    private final List<File> classPathFiles;
    private final List<Function1<String, Function0<byte[]>>> classBytesIndex;

    @Nullable
    public final byte[] classBytesFor(@NotNull String sourceName) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Function0<byte[]> function0 = this.classBytesSupplierForSourceName(sourceName);
        if (function0 != null) {
            Function0<byte[]> function02;
            Function0<byte[]> it = function02 = function0;
            boolean bl = false;
            byArray = (byte[])it.invoke();
        } else {
            byArray = null;
        }
        return byArray;
    }

    @NotNull
    public final Sequence<Pair<String, Function0<byte[]>>> allClassesBytesBySourceName() {
        return SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.classPathFiles), (Function1)((Function1)new Function1<File, Sequence<? extends String>>(this){
            final /* synthetic */ ClassBytesRepository this$0;

            @NotNull
            public final Sequence<String> invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return ClassBytesRepository.access$sourceNamesFrom(this.this$0, it);
            }
            {
                this.this$0 = classBytesRepository;
                super(1);
            }
        })), (Function1)((Function1)new Function1<String, Pair<? extends String, ? extends Function0<? extends byte[]>>>(this){
            final /* synthetic */ ClassBytesRepository this$0;

            @Nullable
            public final Pair<String, Function0<byte[]>> invoke(@NotNull String sourceName) {
                Pair pair;
                Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
                Function0 function0 = ClassBytesRepository.access$classBytesSupplierForSourceName(this.this$0, sourceName);
                if (function0 != null) {
                    Function0 function02;
                    Function0 it = function02 = function0;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)sourceName, (Object)it);
                } else {
                    pair = null;
                }
                return pair;
            }
            {
                this.this$0 = classBytesRepository;
                super(1);
            }
        }));
    }

    private final Function0<byte[]> classBytesSupplierForSourceName(String sourceName) {
        return (Function0)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull(ClassBytesRepositoryKt.classFilePathCandidatesFor(sourceName), (Function1)((Function1)new Function1<String, Function0<? extends byte[]>>(this){

            @Nullable
            public final Function0<byte[]> invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ClassBytesRepository.access$classBytesSupplierForFilePath((ClassBytesRepository)this.receiver, p1);
            }
        })));
    }

    private final Function0<byte[]> classBytesSupplierForFilePath(String classFilePath) {
        return (Function0)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.classBytesIndex), (Function1)((Function1)new Function1<Function1<? super String, ? extends Function0<? extends byte[]>>, Function0<? extends byte[]>>(classFilePath){
            final /* synthetic */ String $classFilePath;

            @Nullable
            public final Function0<byte[]> invoke(@NotNull Function1<? super String, ? extends Function0<byte[]>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (Function0)it.invoke((Object)this.$classFilePath);
            }
            {
                this.$classFilePath = string2;
                super(1);
            }
        })));
    }

    private final Sequence<String> sourceNamesFrom(File entry) {
        return ClassBytesRepositoryKt.access$isClassPathArchive$p(entry) ? this.sourceNamesFromJar(entry) : (entry.isDirectory() ? this.sourceNamesFromDir(entry) : SequencesKt.emptySequence());
    }

    private final Sequence<String> sourceNamesFromJar(File jar) {
        JarFile jarFile;
        JarFile $this$run = jarFile = this.openJarFile(jar);
        boolean bl = false;
        Enumeration<JarEntry> enumeration = $this$run.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries()");
        Enumeration<JarEntry> enumeration2 = enumeration;
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2)), (Function1)sourceNamesFromJar.1.1.INSTANCE), (Function1)sourceNamesFromJar.1.2.INSTANCE);
    }

    private final Sequence<String> sourceNamesFromDir(File dir) {
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)dir)), (Function1)sourceNamesFromDir.1.INSTANCE), (Function1)((Function1)new Function1<File, String>(dir){
            final /* synthetic */ File $dir;

            @NotNull
            public final String invoke(@NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = TextUtil.normaliseFileSeparators((String)FilesKt.relativeTo((File)it, (File)this.$dir).getPath());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normaliseFileSeparators(it.relativeTo(dir).path)");
                return ClassBytesRepositoryKt.kotlinSourceNameOf(string2);
            }
            {
                this.$dir = file;
                super(1);
            }
        }));
    }

    private final Function1<String, Function0<byte[]>> classBytesIndexFor(File entry) {
        return ClassBytesRepositoryKt.access$isClassPathArchive$p(entry) ? this.jarClassBytesIndexFor(entry) : (entry.isDirectory() ? this.directoryClassBytesIndexFor(entry) : (Function1<String, Function0<byte[]>>)classBytesIndexFor.1.INSTANCE);
    }

    private final Function1<String, Function0<byte[]>> jarClassBytesIndexFor(File jar) {
        return (Function1)new Function1<String, Function0<? extends byte[]>>(this, jar){
            final /* synthetic */ ClassBytesRepository this$0;
            final /* synthetic */ File $jar;

            @Nullable
            public final Function0<byte[]> invoke(@NotNull String classFilePath) {
                Function0 function0;
                JarFile jarFile;
                Intrinsics.checkNotNullParameter((Object)classFilePath, (String)"classFilePath");
                JarFile $this$run = jarFile = ClassBytesRepository.access$openJarFile(this.this$0, this.$jar);
                boolean bl = false;
                JarEntry jarEntry = $this$run.getJarEntry(classFilePath);
                if (jarEntry != null) {
                    JarEntry jarEntry2;
                    JarEntry jarEntry3 = jarEntry2 = jarEntry;
                    boolean bl2 = false;
                    function0 = (Function0)new Function0<byte[]>(jarEntry3, $this$run){
                        final /* synthetic */ JarEntry $jarEntry;
                        final /* synthetic */ JarFile $this_run$inlined;
                        {
                            this.$jarEntry = jarEntry;
                            this.$this_run$inlined = jarFile;
                            super(0);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @NotNull
                        public final byte[] invoke() {
                            byte[] byArray;
                            Closeable closeable = this.$this_run$inlined.getInputStream(this.$jarEntry);
                            Throwable throwable = null;
                            try {
                                InputStream jarInput = (InputStream)closeable;
                                boolean bl = false;
                                InputStream inputStream = jarInput;
                                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"jarInput");
                                byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            return byArray;
                        }
                    };
                } else {
                    function0 = null;
                }
                return function0;
            }
            {
                this.this$0 = classBytesRepository;
                this.$jar = file;
                super(1);
            }
        };
    }

    private final Function1<String, Function0<byte[]>> directoryClassBytesIndexFor(File dir) {
        return (Function1)new Function1<String, Function0<? extends byte[]>>(dir){
            final /* synthetic */ File $dir;

            @Nullable
            public final Function0<byte[]> invoke(@NotNull String classFilePath) {
                Function0 function0;
                File file;
                Intrinsics.checkNotNullParameter((Object)classFilePath, (String)"classFilePath");
                File it = file = FilesKt.resolve((File)this.$dir, (String)classFilePath);
                boolean bl = false;
                File file2 = it.isFile() ? file : null;
                if (file2 != null) {
                    File classFile = file = file2;
                    boolean bl2 = false;
                    function0 = (Function0)new Function0<byte[]>(classFile){
                        final /* synthetic */ File $classFile;

                        @NotNull
                        public final byte[] invoke() {
                            return FilesKt.readBytes((File)this.$classFile);
                        }
                        {
                            this.$classFile = file;
                            super(0);
                        }
                    };
                } else {
                    function0 = null;
                }
                return function0;
            }
            {
                this.$dir = file;
                super(1);
            }
        };
    }

    private final JarFile openJarFile(File file) {
        Object object = openJarFile.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        JarFile jarFile = this.openJars.computeIfAbsent(file, (Function)object);
        Intrinsics.checkNotNullExpressionValue((Object)jarFile, (String)"openJars.computeIfAbsent(file, ::JarFile)");
        return jarFile;
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.openJars.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarFile p1 = (JarFile)element$iv;
            boolean bl = false;
            p1.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClassBytesRepository(@NotNull ClassPath classPath, @NotNull ClassPath classPathDependencies) {
        Collection<Function1<String, Function0<byte[]>>> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter((Object)classPathDependencies, (String)"classPathDependencies");
        this.openJars = new LinkedHashMap();
        List list2 = classPath.getAsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classPath.asFiles");
        this.classPathFiles = list2;
        Collection collection2 = this.classPathFiles;
        List list3 = classPathDependencies.getAsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"classPathDependencies.asFiles");
        Iterable iterable = CollectionsKt.plus((Collection)collection2, (Iterable)list3);
        ClassBytesRepository classBytesRepository = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            Function1<String, Function0<byte[]>> function1 = this.classBytesIndexFor((File)v3);
            collection.add(function1);
        }
        collection = (List)destination$iv$iv;
        classBytesRepository.classBytesIndex = collection;
    }

    public /* synthetic */ ClassBytesRepository(ClassPath classPath, ClassPath classPath2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassPath classPath3 = ClassPath.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)classPath3, (String)"ClassPath.EMPTY");
            classPath2 = classPath3;
        }
        this(classPath, classPath2);
    }

    public static final /* synthetic */ Sequence access$sourceNamesFrom(ClassBytesRepository $this, File entry) {
        return $this.sourceNamesFrom(entry);
    }

    public static final /* synthetic */ Function0 access$classBytesSupplierForSourceName(ClassBytesRepository $this, String sourceName) {
        return $this.classBytesSupplierForSourceName(sourceName);
    }

    public static final /* synthetic */ Function0 access$classBytesSupplierForFilePath(ClassBytesRepository $this, String classFilePath) {
        return $this.classBytesSupplierForFilePath(classFilePath);
    }

    public static final /* synthetic */ JarFile access$openJarFile(ClassBytesRepository $this, File file) {
        return $this.openJarFile(file);
    }
}

