/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs3.engine.behavior.ICacheListener;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public abstract class AbstractCacheEventQueue<K, V>
implements ICacheEventQueue<K, V> {
    private static final Log log = LogManager.getLog(AbstractCacheEventQueue.class);
    protected static final int DEFAULT_WAIT_TO_DIE_MILLIS = 10000;
    private int waitToDieMillis = 10000;
    private ICacheListener<K, V> listener;
    private long listenerId;
    private String cacheName;
    private int maxFailure;
    private int waitBeforeRetry;
    private final AtomicBoolean working = new AtomicBoolean(true);

    public int getWaitToDieMillis() {
        return this.waitToDieMillis;
    }

    public void setWaitToDieMillis(int wtdm) {
        this.waitToDieMillis = wtdm;
    }

    public String toString() {
        return "CacheEventQueue [listenerId=" + this.listenerId + ", cacheName=" + this.cacheName + "]";
    }

    @Override
    public long getListenerId() {
        return this.listenerId;
    }

    protected String getCacheName() {
        return this.cacheName;
    }

    protected void initialize(ICacheListener<K, V> listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = listener;
        this.listenerId = listenerId;
        this.cacheName = cacheName;
        this.maxFailure = maxFailure <= 0 ? 3 : maxFailure;
        this.waitBeforeRetry = waitBeforeRetry <= 0 ? 500 : waitBeforeRetry;
        log.debug("Constructed: {0}", this);
    }

    @Override
    public void addPutEvent(ICacheElement<K, V> ce) {
        this.put(new PutEvent(ce));
    }

    @Override
    public void addRemoveEvent(K key) {
        this.put(new RemoveEvent(key));
    }

    @Override
    public void addRemoveAllEvent() {
        this.put(new RemoveAllEvent());
    }

    @Override
    public void addDisposeEvent() {
        this.put(new DisposeEvent());
    }

    protected abstract void put(AbstractCacheEvent var1);

    @Override
    public boolean isWorking() {
        return this.working.get();
    }

    public void setWorking(boolean b) {
        this.working.set(b);
    }

    protected class DisposeEvent
    extends AbstractCacheEvent {
        protected DisposeEvent() {
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleDispose(AbstractCacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "DisposeEvent";
        }
    }

    protected class RemoveAllEvent
    extends AbstractCacheEvent {
        protected RemoveAllEvent() {
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleRemoveAll(AbstractCacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "RemoveAllEvent";
        }
    }

    protected class RemoveEvent
    extends AbstractCacheEvent {
        private final K key;

        RemoveEvent(K key) {
            this.key = key;
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handleRemove(AbstractCacheEventQueue.this.cacheName, this.key);
        }

        public String toString() {
            return "RemoveEvent for " + this.key;
        }
    }

    protected class PutEvent
    extends AbstractCacheEvent {
        private final ICacheElement<K, V> ice;

        PutEvent(ICacheElement<K, V> ice) {
            this.ice = ice;
        }

        @Override
        protected void doRun() throws IOException {
            AbstractCacheEventQueue.this.listener.handlePut(this.ice);
        }

        public String toString() {
            return "PutEvent for key: " + this.ice.getKey() + " value: " + this.ice.getVal();
        }
    }

    protected abstract class AbstractCacheEvent
    implements Runnable {
        protected AbstractCacheEvent() {
        }

        @Override
        public void run() {
            for (int failures = 0; failures < AbstractCacheEventQueue.this.maxFailure; ++failures) {
                try {
                    this.doRun();
                    return;
                }
                catch (IOException e) {
                    log.warn("Error while running event from Queue: {0}. Retrying...", this, e);
                    try {
                        Thread.sleep(AbstractCacheEventQueue.this.waitBeforeRetry);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        log.warn("Interrupted while sleeping for retry on event {0}.", this, ie);
                        break;
                    }
                }
            }
            log.warn("Dropping Event and marking Event Queue {0} as non-functional.", this);
            AbstractCacheEventQueue.this.destroy();
        }

        protected abstract void doRun() throws IOException;
    }
}

