/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Tag;
import org.languagetool.ToneTag;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.PatternToken;

public class PatternRuleLoaderTest {
    @Test
    public void testGetRules() throws Exception {
        PatternRuleLoader prg = new PatternRuleLoader();
        String name = "/xx/grammar.xml";
        List rules = prg.getRules(JLanguageTool.getDataBroker().getFromRulesDirAsStream(name), name, null);
        Assert.assertTrue((rules.size() >= 30 ? 1 : 0) != 0);
        Rule demoRule1 = this.getRuleById("DEMO_RULE", rules);
        Assert.assertEquals((Object)"http://fake-server.org/foo-bar-error-explained", (Object)demoRule1.getUrl().toString());
        Assert.assertEquals((Object)"[This is <marker>fuu bah</marker>.]", (Object)demoRule1.getCorrectExamples().toString());
        List incorrectExamples = demoRule1.getIncorrectExamples();
        Assert.assertEquals((long)1L, (long)incorrectExamples.size());
        Assert.assertEquals((Object)"This is <marker>foo bar</marker>.", (Object)((IncorrectExample)incorrectExamples.get(0)).getExample());
        Rule demoRule2 = this.getRuleById("API_OUTPUT_TEST_RULE", rules);
        Assert.assertNull((Object)demoRule2.getUrl());
        Assert.assertEquals((Object)ITSIssueType.Uncategorized, (Object)demoRule1.getLocQualityIssueType());
        Assert.assertEquals((String)"tag inheritance failed", (Object)ITSIssueType.Addition, (Object)this.getRuleById("TEST_GO", rules).getLocQualityIssueType());
        Assert.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Uncategorized, (Object)this.getRuleById("TEST_PHRASES1", rules).getLocQualityIssueType());
        Assert.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Characters, (Object)this.getRuleById("test_include", rules).getLocQualityIssueType());
        List<Rule> groupRules1 = this.getRulesById("test_spacebefore", rules);
        Assert.assertEquals((String)"tag inheritance form category failed", (Object)ITSIssueType.Addition, (Object)groupRules1.get(0).getLocQualityIssueType());
        Assert.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Duplication, (Object)groupRules1.get(1).getLocQualityIssueType());
        List<Rule> groupRules2 = this.getRulesById("test_unification_with_negation", rules);
        Assert.assertEquals((String)"tag inheritance from rulegroup failed", (Object)ITSIssueType.Grammar, (Object)groupRules2.get(0).getLocQualityIssueType());
        Set<String> categories = this.getCategoryNames(rules);
        Assert.assertEquals((long)5L, (long)categories.size());
        Assert.assertTrue((boolean)categories.contains("misc"));
        Assert.assertTrue((boolean)categories.contains("otherCategory"));
        Assert.assertTrue((boolean)categories.contains("Test tokens with min and max attributes"));
        Assert.assertTrue((boolean)categories.contains("A category that's off by default"));
        PatternRule demoRuleWithChunk = (PatternRule)this.getRuleById("DEMO_CHUNK_RULE", rules);
        List patternTokens = demoRuleWithChunk.getPatternTokens();
        Assert.assertEquals((long)2L, (long)patternTokens.size());
        Assert.assertEquals(null, (Object)((PatternToken)patternTokens.get(1)).getPOStag());
        Assert.assertEquals((Object)new ChunkTag("B-NP-singular"), (Object)((PatternToken)patternTokens.get(1)).getChunkTag());
        List<Rule> orRules = this.getRulesById("GROUP_WITH_URL", rules);
        Assert.assertEquals((long)3L, (long)orRules.size());
        Assert.assertEquals((Object)"http://fake-server.org/rule-group-url", (Object)orRules.get(0).getUrl().toString());
        Assert.assertEquals((Object)"http://fake-server.org/rule-group-url-overwrite", (Object)orRules.get(1).getUrl().toString());
        Assert.assertEquals((Object)"http://fake-server.org/rule-group-url", (Object)orRules.get(2).getUrl().toString());
        Assert.assertEquals((Object)"short message on rule group", (Object)((PatternRule)orRules.get(0)).getShortMessage());
        Assert.assertEquals((Object)"overwriting short message", (Object)((PatternRule)orRules.get(1)).getShortMessage());
        Assert.assertEquals((Object)"short message on rule group", (Object)((PatternRule)orRules.get(2)).getShortMessage());
        List<Rule> orRules2 = this.getRulesById("OR_GROUPS", rules);
        for (Rule rule : orRules2) {
            Assert.assertNull((String)"http://fake-server.org/rule-group-url", (Object)rule.getUrl());
        }
        Rule nextRule = this.getRuleById("DEMO_CHUNK_RULE", rules);
        Assert.assertNull((String)"http://fake-server.org/rule-group-url", (Object)nextRule.getUrl());
    }

    @Test
    public void testPremiumXmlFlag() throws IOException {
        PatternRuleLoader prg = new PatternRuleLoader();
        String nameNonPremium = "/xx/grammar-nonPremium.xml";
        List rulesInNonPremiumFile = prg.getRules(JLanguageTool.getDataBroker().getFromRulesDirAsStream(nameNonPremium), nameNonPremium, null);
        Rule rule1 = this.getRuleById("F-NP_C-NP_RG-NP_R-NP", rulesInNonPremiumFile);
        Assert.assertFalse((boolean)rule1.isPremium());
        Rule rule2 = this.getRuleById("F-NP_C-NP_RG-NP_R-P", rulesInNonPremiumFile);
        Assert.assertTrue((boolean)rule2.isPremium());
        Rule rule3 = this.getRuleById("F-NP_C-NP_RG-P_R-NP", rulesInNonPremiumFile);
        Assert.assertFalse((boolean)rule3.isPremium());
        Rule rule4 = this.getRuleById("F-NP_C-NP_RG-P_R-P", rulesInNonPremiumFile);
        Assert.assertTrue((boolean)rule4.isPremium());
        Rule rule5 = this.getRuleById("F-NP_C-P_RG-NP_R-NP", rulesInNonPremiumFile);
        Assert.assertFalse((boolean)rule5.isPremium());
        Rule rule6 = this.getRuleById("F-NP_C-P_RG-NP_R-P", rulesInNonPremiumFile);
        Assert.assertFalse((boolean)rule6.isPremium());
        Rule rule7 = this.getRuleById("F-NP_C-P_RG-P_R-NP", rulesInNonPremiumFile);
        Assert.assertFalse((boolean)rule7.isPremium());
        Rule rule8 = this.getRuleById("F-NP_C-P_RG-P_R-P", rulesInNonPremiumFile);
        Assert.assertTrue((boolean)rule8.isPremium());
        String namePremium = "/xx/grammar-premium.xml";
        List rulesInPremiumFile = prg.getRules(JLanguageTool.getDataBroker().getFromRulesDirAsStream(namePremium), namePremium, null);
        Rule rule9 = this.getRuleById("F-P_C-P_RG-P_R-P", rulesInPremiumFile);
        Assert.assertTrue((boolean)rule9.isPremium());
        Rule rule10 = this.getRuleById("F-P_C-P_RG-P_R-NP", rulesInPremiumFile);
        Assert.assertFalse((boolean)rule10.isPremium());
        Rule rule11 = this.getRuleById("F-P_C-P_RG-NP_R-P", rulesInPremiumFile);
        Assert.assertTrue((boolean)rule11.isPremium());
        Rule rule12 = this.getRuleById("F-P_C-P_RG-NP_R-NP", rulesInPremiumFile);
        Assert.assertFalse((boolean)rule12.isPremium());
        Rule rule13 = this.getRuleById("F-P_C-NP_RG-P_R-NP", rulesInPremiumFile);
        Assert.assertFalse((boolean)rule13.isPremium());
        Rule rule14 = this.getRuleById("F-P_C-NP_RG-P_R-P", rulesInPremiumFile);
        Assert.assertTrue((boolean)rule14.isPremium());
        Rule rule15 = this.getRuleById("F-P_C-NP_RG-NP_R-NP", rulesInPremiumFile);
        Assert.assertFalse((boolean)rule15.isPremium());
        Rule rule16 = this.getRuleById("F-P_C-NP_RG-NP_R-P", rulesInPremiumFile);
        Assert.assertTrue((boolean)rule16.isPremium());
    }

    @Test
    public void testToneTagsAttribute() throws IOException {
        PatternRuleLoader prg = new PatternRuleLoader();
        String styleRuleFile = "/xx/style.xml";
        List styleRules = prg.getRules(JLanguageTool.getDataBroker().getFromRulesDirAsStream(styleRuleFile), styleRuleFile, null);
        Rule formalClarityToneRule = this.getRuleById("Formal_Clarity_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)formalClarityToneRule.hasToneTag(ToneTag.formal));
        Assert.assertTrue((boolean)formalClarityToneRule.hasToneTag(ToneTag.clarity));
        Assert.assertEquals((long)2L, (long)formalClarityToneRule.getToneTags().size());
        Assert.assertFalse((boolean)formalClarityToneRule.isGoalSpecific());
        Rule noToneRule = this.getRuleById("NO_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)noToneRule.getToneTags().isEmpty());
        Assert.assertFalse((boolean)noToneRule.isGoalSpecific());
        Rule confidentAcademicScientificToneRule = this.getRuleById("CONFIDENT_ACADEMIC_SCIENTIFIC_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)confidentAcademicScientificToneRule.hasToneTag(ToneTag.confident));
        Assert.assertTrue((boolean)confidentAcademicScientificToneRule.hasToneTag(ToneTag.academic));
        Assert.assertTrue((boolean)confidentAcademicScientificToneRule.hasToneTag(ToneTag.scientific));
        Assert.assertEquals((long)3L, (long)confidentAcademicScientificToneRule.getToneTags().size());
        Assert.assertFalse((boolean)confidentAcademicScientificToneRule.isGoalSpecific());
        Rule confidentAcademicToneRule = this.getRuleById("CONFIDENT_ACADEMIC_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)confidentAcademicToneRule.hasToneTag(ToneTag.confident));
        Assert.assertTrue((boolean)confidentAcademicToneRule.hasToneTag(ToneTag.academic));
        Assert.assertEquals((long)2L, (long)confidentAcademicToneRule.getToneTags().size());
        Assert.assertFalse((boolean)confidentAcademicToneRule.isGoalSpecific());
        Rule pickyClarityConfidentAcademicToneRule = this.getRuleById("PICKY-CLARITY_CONFIDENT_ACADEMIC_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicToneRule.hasToneTag(ToneTag.clarity));
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicToneRule.hasToneTag(ToneTag.confident));
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicToneRule.hasToneTag(ToneTag.academic));
        Assert.assertEquals((long)3L, (long)pickyClarityConfidentAcademicToneRule.getToneTags().size());
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicToneRule.hasTag(Tag.picky));
        Assert.assertFalse((boolean)pickyClarityConfidentAcademicToneRule.isGoalSpecific());
        Rule pickyClarityConfidentAcademicScientificToneRule = this.getRuleById("PICKY-CLARITY_CONFIDENT_ACADEMIC_SCIENTIFIC_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicScientificToneRule.hasToneTag(ToneTag.clarity));
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicScientificToneRule.hasToneTag(ToneTag.confident));
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicScientificToneRule.hasToneTag(ToneTag.academic));
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicScientificToneRule.hasToneTag(ToneTag.scientific));
        Assert.assertEquals((long)4L, (long)pickyClarityConfidentAcademicScientificToneRule.getToneTags().size());
        Assert.assertTrue((boolean)pickyClarityConfidentAcademicScientificToneRule.hasTag(Tag.picky));
        Assert.assertFalse((boolean)pickyClarityConfidentAcademicScientificToneRule.isGoalSpecific());
        Rule persuasiveObjectiveToneRule = this.getRuleById("PERSUASIVE_OBJECTIVE_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)persuasiveObjectiveToneRule.hasToneTag(ToneTag.persuasive));
        Assert.assertTrue((boolean)persuasiveObjectiveToneRule.hasToneTag(ToneTag.objective));
        Assert.assertEquals((long)2L, (long)persuasiveObjectiveToneRule.getToneTags().size());
        Assert.assertFalse((boolean)persuasiveObjectiveToneRule.isGoalSpecific());
        Rule persuasiveObjectiveInformalToneRule = this.getRuleById("PERSUASIVE_OBJECTIVE_INFORMAL_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)persuasiveObjectiveInformalToneRule.hasToneTag(ToneTag.persuasive));
        Assert.assertTrue((boolean)persuasiveObjectiveInformalToneRule.hasToneTag(ToneTag.objective));
        Assert.assertTrue((boolean)persuasiveObjectiveInformalToneRule.hasToneTag(ToneTag.informal));
        Assert.assertEquals((long)3L, (long)persuasiveObjectiveInformalToneRule.getToneTags().size());
        Assert.assertFalse((boolean)persuasiveObjectiveInformalToneRule.isGoalSpecific());
        Rule persuasiveGoalSpecificToneRule = this.getRuleById("PERSUASIVE_GOAL_SPECIFIC_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)persuasiveGoalSpecificToneRule.hasToneTag(ToneTag.persuasive));
        Assert.assertTrue((boolean)persuasiveGoalSpecificToneRule.isGoalSpecific());
        Rule persuasiveNotGoalSpecificToneRule = this.getRuleById("PERSUASIVE_NOT_GOAL_SPECIFIC_TONE_RULE", styleRules);
        Assert.assertTrue((boolean)persuasiveNotGoalSpecificToneRule.hasToneTag(ToneTag.persuasive));
        Assert.assertFalse((boolean)persuasiveNotGoalSpecificToneRule.isGoalSpecific());
        Rule isGoalSpecificRule = this.getRuleById("IS_GOAL_SPECIFIC_RULE_GROUP_FALSE_OVERRIDE_TEST_1", styleRules);
        Assert.assertTrue((boolean)isGoalSpecificRule.isGoalSpecific());
        Rule isNotSetGoalSpecificRule = this.getRuleById("IS_GOAL_SPECIFIC_RULE_GROUP_FALSE_OVERRIDE_TEST_2", styleRules);
        Assert.assertFalse((boolean)isNotSetGoalSpecificRule.isGoalSpecific());
        Rule isNotGoalSpecificRule = this.getRuleById("IS_GOAL_SPECIFIC_RULE_GROUP_FALSE_OVERRIDE_TEST_3", styleRules);
        Assert.assertFalse((boolean)isNotGoalSpecificRule.isGoalSpecific());
        Rule isGoalSpecificFromCategoryRule = this.getRuleById("IS_GOAL_SPECIFIC_FROM_CATEGORY", styleRules);
        Assert.assertTrue((boolean)isGoalSpecificFromCategoryRule.isGoalSpecific());
    }

    @Test
    public void testPrioAttribute() throws IOException {
        PatternRuleLoader prg = new PatternRuleLoader();
        String xmlFile = "/xx/grammar-withPrio.xml";
        List xmlPrioRules = prg.getRules(JLanguageTool.getDataBroker().getFromRulesDirAsStream(xmlFile), xmlFile, null);
        Rule rulePrio15 = this.getRuleById("CAT-PRIO-5-RG-PRIO-10-R-PRIO-15", xmlPrioRules);
        Assert.assertEquals((long)15L, (long)rulePrio15.getPriority());
        Rule rulePrio10 = this.getRuleById("CAT-PRIO-5-RG-PRIO-10-R-PRIO-0", xmlPrioRules);
        Assert.assertEquals((long)10L, (long)rulePrio10.getPriority());
        Rule rulePrio5 = this.getRuleById("CAT-PRIO-5-RG-PRIO-0-R-PRIO-0", xmlPrioRules);
        Assert.assertEquals((long)5L, (long)rulePrio5.getPriority());
        Rule rulePrio0_0 = this.getRuleById("CAT-PRIO-0-RG-PRIO-0-R-PRIO-0", xmlPrioRules);
        Assert.assertEquals((long)0L, (long)rulePrio0_0.getPriority());
        Rule rulePrio0_1 = this.getRuleById("CAT-PRIO-0-R-PRIO-0", xmlPrioRules);
        Assert.assertEquals((long)0L, (long)rulePrio0_1.getPriority());
    }

    private Set<String> getCategoryNames(List<AbstractPatternRule> rules) {
        HashSet<String> categories = new HashSet<String>();
        for (AbstractPatternRule rule : rules) {
            categories.add(rule.getCategory().getName());
        }
        return categories;
    }

    private Rule getRuleById(String id, List<AbstractPatternRule> rules) {
        for (Rule rule : rules) {
            if (!rule.getId().equals(id)) continue;
            return rule;
        }
        throw new RuntimeException("No rule found for id '" + id + "'");
    }

    private List<Rule> getRulesById(String id, List<AbstractPatternRule> rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (Rule rule : rules) {
            if (!rule.getId().equals(id)) continue;
            result.add(rule);
        }
        return result;
    }

    @Test
    @Ignore
    public void testEncryptDecrypt() throws Exception {
        String encrypted = this.encrypt();
        System.out.println("encrypted: " + this.decrypt(encrypted));
        String decrypted = this.decrypt(encrypted);
        System.out.println("decrypted: " + decrypted);
        PatternRuleLoader loader = new PatternRuleLoader();
        List rules = loader.getRules((InputStream)new ByteArrayInputStream(decrypted.getBytes(StandardCharsets.UTF_8)), "<unknown>", null);
        System.out.println("Loaded " + rules.size() + " rules");
    }

    private String encrypt() throws Exception {
        Key key = PatternRuleLoaderTest.generateKey();
        Cipher c = Cipher.getInstance("AES");
        c.init(1, key);
        List<String> lines = Files.readAllLines(Paths.get("grammar-premium.xml", new String[0]));
        String val = String.join((CharSequence)"\n", lines);
        byte[] encVal = c.doFinal(val.getBytes(StandardCharsets.UTF_8));
        String encoded = Base64.getEncoder().encodeToString(encVal);
        try (FileWriter fw = new FileWriter("/tmp/encoded");){
            fw.write(encoded);
        }
        return encoded;
    }

    private String decrypt(String encrypted) throws Exception {
        Key key = PatternRuleLoaderTest.generateKey();
        Cipher c = Cipher.getInstance("AES");
        c.init(2, key);
        byte[] decodedValue = Base64.getDecoder().decode(encrypted);
        byte[] decValue = c.doFinal(decodedValue);
        return new String(decValue);
    }

    private static Key generateKey() {
        return new SecretKeySpec("mykey...........".getBytes(StandardCharsets.UTF_8), "AES");
    }
}

