/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.formdev.flatlaf.icons.FlatSearchWithHistoryIcon;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.util.Duration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.config.Konstanten;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.FilmResolution;
import mediathek.daten.IndexedFilmList;
import mediathek.daten.ListePset;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.FilterSelectionComboBoxModel;
import mediathek.gui.actions.PlayFilmAction;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.dialog.DialogAboNoSet;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.gui.dialog.DialogAddMoreDownload;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.gui.messages.ButtonStartEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.gui.messages.history.DownloadHistoryChangedEvent;
import mediathek.gui.tabs.AGuiTabPanel;
import mediathek.gui.tabs.tab_film.DownloadSubtitleAction;
import mediathek.gui.tabs.tab_film.FilmDescriptionPanel;
import mediathek.gui.tabs.tab_film.JDownloadHelper;
import mediathek.gui.tabs.tab_film.OnlineSearchProviders;
import mediathek.gui.tabs.tab_film.PsetButtonsPanel;
import mediathek.gui.tabs.tab_film.SearchFieldData;
import mediathek.gui.tabs.tab_film.helpers.GuiFilmeModelHelper;
import mediathek.gui.tabs.tab_film.helpers.GuiModelHelper;
import mediathek.gui.tabs.tab_film.helpers.LuceneGuiFilmeModelHelper;
import mediathek.javafx.bookmark.BookmarkWindowController;
import mediathek.javafx.filterpanel.FilmActionPanel;
import mediathek.javafx.filterpanel.OldSwingJavaFxFilterDialog;
import mediathek.javafx.filterpanel.SearchControlFieldMode;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Filter;
import mediathek.tool.FilterDTO;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.SVGIconUtilities;
import mediathek.tool.cellrenderer.CellRendererFilme;
import mediathek.tool.datum.DatumFilm;
import mediathek.tool.listener.BeobTableHeader;
import mediathek.tool.models.TModelFilm;
import mediathek.tool.table.MVFilmTable;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.RangeSlider;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;

public class GuiFilme
extends AGuiTabPanel {
    public static final String NAME = "Filme";
    private static final String ACTION_MAP_KEY_PLAY_FILM = "film_abspielen";
    private static final String ACTION_MAP_KEY_SAVE_FILM = "download_film";
    private static final String ACTION_MAP_KEY_BOOKMARK_FILM = "bookmark_film";
    private static final String ACTION_MAP_KEY_COPY_NORMAL_URL = "copy_url";
    private static final String ACTION_MAP_KEY_COPY_HD_URL = "copy_url_hd";
    private static final String ACTION_MAP_KEY_COPY_KLEIN_URL = "copy_url_klein";
    private static final String ACTION_MAP_KEY_MARK_SEEN = "seen";
    private static final String ACTION_MAP_KEY_MARK_UNSEEN = "unseen";
    private static final int[] HIDDEN_COLUMNS = new int[]{4, 5, 6};
    private static final Logger logger = LogManager.getLogger();
    private static final int[] BUTTON_COLUMNS = new int[]{4, 5, 6};
    public static boolean[] VISIBLE_COLUMNS = new boolean[17];
    public final PlayFilmAction playFilmAction = new PlayFilmAction(this);
    public final SaveFilmAction saveFilmAction = new SaveFilmAction();
    public final BookmarkFilmAction bookmarkFilmAction = new BookmarkFilmAction();
    protected final JTabbedPane psetButtonsTab = new JTabbedPane();
    private final PauseTransition reloadTableDataTransition = new PauseTransition(Duration.millis(250.0));
    private final AGuiTabPanel.MarkFilmAsSeenAction markFilmAsSeenAction = new AGuiTabPanel.MarkFilmAsSeenAction();
    private final AGuiTabPanel.MarkFilmAsUnseenAction markFilmAsUnseenAction = new AGuiTabPanel.MarkFilmAsUnseenAction();
    private final JScrollPane filmListScrollPane = new JScrollPane();
    private final JPanel extensionArea = new JPanel();
    private final JCheckBoxMenuItem cbkShowDescription = new JCheckBoxMenuItem("Beschreibung anzeigen");
    private final SeenHistoryController historyController = new SeenHistoryController();
    private final JToolBar toolBar = new JToolBar();
    private final JCheckBoxMenuItem cbShowButtons = new JCheckBoxMenuItem("Buttons anzeigen");
    private final PauseTransition zeitraumTransition = new PauseTransition(Duration.millis(250.0));
    public FilmActionPanel filmActionPanel;
    public ToggleFilterDialogVisibilityAction toggleFilterDialogVisibilityAction = new ToggleFilterDialogVisibilityAction();
    protected SearchField searchField;
    protected JComboBox<FilterDTO> filterSelectionComboBox = new JComboBox<FilterDTO>(new FilterSelectionComboBoxModel());
    protected FilterVisibilityToggleButton btnToggleFilterDialogVisibility = new FilterVisibilityToggleButton(this.toggleFilterDialogVisibilityAction);
    protected PsetButtonsPanel psetButtonsPanel;
    private Optional<BookmarkWindowController> bookmarkWindowController = Optional.empty();
    private boolean stopBeob;
    private MVFilmTable tabelle;
    private ListenableFuture<TableModel> modelFuture;

    public GuiFilme(Daten aDaten, MediathekGui mediathekGui) {
        this.daten = aDaten;
        this.mediathekGui = mediathekGui;
        this.descriptionPanel = new FilmDescriptionPanel(this);
        this.searchField = this.daten.getListeFilmeNachBlackList() instanceof IndexedFilmList ? new LuceneSearchField() : new RegularSearchField();
        this.setLayout(new BorderLayout());
        this.add((Component)this.filmListScrollPane, "Center");
        this.createExtensionArea();
        this.createToolBar();
        this.extensionArea.add(this.descriptionTab);
        this.extensionArea.add(this.psetButtonsTab);
        this.setupFilmListTable();
        this.setupFilmSelectionPropertyListener();
        this.setupDescriptionTab(this.tabelle, this.cbkShowDescription, "film.show_description");
        this.setupPsetButtonsTab();
        this.setupFilmActionPanel();
        this.start_init();
        MessageBus.getMessageBus().subscribe(this);
        this.setupActionListeners();
    }

    private void createToolBar() {
        this.add((Component)this.toolBar, "North");
        this.toolBar.setFloatable(true);
        this.toolBar.setName(NAME);
        this.toolBar.add(this.playFilmAction);
        this.toolBar.add(this.saveFilmAction);
        this.toolBar.add(this.bookmarkFilmAction);
        this.toolBar.addSeparator();
        this.filterSelectionComboBox.setMaximumSize(new Dimension(150, 100));
        this.toolBar.add(this.filterSelectionComboBox);
        this.toolBar.addSeparator();
        this.toolBar.add(new JLabel("Suche:"));
        this.toolBar.add(this.searchField);
        this.toolBar.addSeparator();
        this.toolBar.add(this.btnToggleFilterDialogVisibility);
    }

    @Handler
    public void handleTableModelChange(TableModelChangeEvent e) {
        if (e.active) {
            SwingUtilities.invokeLater(() -> {
                this.playFilmAction.setEnabled(false);
                this.saveFilmAction.setEnabled(false);
                this.bookmarkFilmAction.setEnabled(false);
                this.toggleFilterDialogVisibilityAction.setEnabled(false);
                this.searchField.setEnabled(false);
                this.filterSelectionComboBox.setEnabled(false);
            });
        } else {
            SwingUtilities.invokeLater(() -> {
                this.playFilmAction.setEnabled(true);
                this.saveFilmAction.setEnabled(true);
                this.bookmarkFilmAction.setEnabled(true);
                this.toggleFilterDialogVisibilityAction.setEnabled(true);
                this.searchField.setEnabled(true);
                this.filterSelectionComboBox.setEnabled(true);
            });
        }
    }

    @Override
    public void tabelleSpeichern() {
        if (this.tabelle != null) {
            this.tabelle.writeTableConfigurationData();
        }
    }

    private void setupFilmListTable() {
        this.tabelle = new MVFilmTable();
        this.filmListScrollPane.setViewportView(this.tabelle);
    }

    private void setupFilmSelectionPropertyListener() {
        this.tabelle.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateSelectedListItemsCount(this.tabelle);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                GuiFilme.this.updateSelectedListItemsCount(GuiFilme.this.tabelle);
                GuiFilme.this.onComponentShown();
            }
        });
    }

    private void createExtensionArea() {
        this.extensionArea.setLayout(new VerticalLayout());
        this.add((Component)this.extensionArea, "South");
    }

    public void installViewMenuEntry(JMenu jMenuAnsicht) {
        jMenuAnsicht.add((Component)this.cbShowButtons, 0);
    }

    protected void makeButtonsTabVisible(boolean visible) {
        if (visible) {
            if (this.psetButtonsTab.indexOfComponent(this.psetButtonsPanel) == -1) {
                this.psetButtonsTab.add((Component)this.psetButtonsPanel, 0);
                this.psetButtonsTab.setTitleAt(0, "Buttons");
            }
        } else if (this.psetButtonsTab.indexOfComponent(this.psetButtonsPanel) != -1) {
            this.psetButtonsTab.remove(this.psetButtonsPanel);
        }
    }

    @Override
    public void installMenuEntries(JMenu menu) {
        JMenuItem miMarkFilmAsSeen = new JMenuItem("Filme als gesehen markieren");
        miMarkFilmAsSeen.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        miMarkFilmAsSeen.addActionListener(this.markFilmAsSeenAction);
        JMenuItem miMarkFilmAsUnseen = new JMenuItem("Filme als ungesehen markieren");
        miMarkFilmAsUnseen.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        miMarkFilmAsUnseen.addActionListener(this.markFilmAsUnseenAction);
        menu.add(this.playFilmAction);
        menu.add(this.saveFilmAction);
        menu.add(this.bookmarkFilmAction);
        menu.addSeparator();
        menu.add(miMarkFilmAsSeen);
        menu.add(miMarkFilmAsUnseen);
        menu.addSeparator();
        menu.add(this.mediathekGui.toggleBlacklistAction);
        menu.add(this.mediathekGui.editBlacklistAction);
        menu.addSeparator();
        menu.add(this.cbkShowDescription);
    }

    private void setupFilmActionPanel() {
        this.filmActionPanel = new FilmActionPanel(this.btnToggleFilterDialogVisibility);
    }

    private void setupPsetButtonsTab() {
        boolean initialVisibility = ApplicationConfiguration.getConfiguration().getBoolean("application.buttons_panel.visible", false);
        this.setupButtonsMenuItem(initialVisibility);
        this.psetButtonsPanel = new PsetButtonsPanel(this);
        this.psetButtonsPanel.putClientProperty("JTabbedPane.tabClosable", true);
        this.psetButtonsPanel.putClientProperty("JTabbedPane.tabCloseCallback", tabIndex -> this.cbShowButtons.doClick());
        this.psetButtonsPanel.install(this.psetButtonsTab);
        this.makeButtonsTabVisible(initialVisibility);
    }

    private void setupButtonsMenuItem(boolean initialVisibility) {
        Configuration config = ApplicationConfiguration.getConfiguration();
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.cbShowButtons.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        }
        this.cbShowButtons.setSelected(initialVisibility);
        this.cbShowButtons.addActionListener(l -> {
            boolean visible = this.cbShowButtons.isSelected();
            this.makeButtonsTabVisible(visible);
            config.setProperty("application.buttons_panel.visible", visible);
        });
    }

    private void onComponentShown() {
        this.updateFilmData();
        this.updateStartInfoProperty();
    }

    public int getTableRowCount() {
        if (this.tabelle != null) {
            return this.tabelle.getModel().getRowCount();
        }
        return 0;
    }

    private void setupKeyMapping() {
        InputMap focusedWindowMap = this.tabelle.getInputMap();
        focusedWindowMap.put(KeyStroke.getKeyStroke(80, 0), ACTION_MAP_KEY_PLAY_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(10, 0), ACTION_MAP_KEY_PLAY_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(68, 0), ACTION_MAP_KEY_SAVE_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(66, 0), ACTION_MAP_KEY_BOOKMARK_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(72, 0), ACTION_MAP_KEY_COPY_HD_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(78, 0), ACTION_MAP_KEY_COPY_NORMAL_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(75, 0), ACTION_MAP_KEY_COPY_KLEIN_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(71, 0), ACTION_MAP_KEY_MARK_SEEN);
        focusedWindowMap.put(KeyStroke.getKeyStroke(85, 0), ACTION_MAP_KEY_MARK_UNSEEN);
        ActionMap actionMap = this.tabelle.getActionMap();
        actionMap.put(ACTION_MAP_KEY_PLAY_FILM, this.playFilmAction);
        actionMap.put(ACTION_MAP_KEY_SAVE_FILM, this.saveFilmAction);
        actionMap.put(ACTION_MAP_KEY_BOOKMARK_FILM, this.bookmarkFilmAction);
        actionMap.put(ACTION_MAP_KEY_COPY_NORMAL_URL, new CopyUrlToClipboardAction(FilmResolution.Enum.NORMAL));
        actionMap.put(ACTION_MAP_KEY_COPY_HD_URL, new CopyUrlToClipboardAction(FilmResolution.Enum.HIGH_QUALITY));
        actionMap.put(ACTION_MAP_KEY_COPY_KLEIN_URL, new CopyUrlToClipboardAction(FilmResolution.Enum.LOW));
        actionMap.put(ACTION_MAP_KEY_MARK_SEEN, this.markFilmAsSeenAction);
        actionMap.put(ACTION_MAP_KEY_MARK_UNSEEN, this.markFilmAsUnseenAction);
    }

    private void setupCellRenderer() {
        CellRendererFilme cellRenderer = new CellRendererFilme();
        this.tabelle.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelle.setDefaultRenderer(DatumFilm.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Integer.class, cellRenderer);
    }

    private void start_init() {
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> GuiFilme.this.filmActionPanel.updateThemaComboBox());
            }
        });
        this.setupKeyMapping();
        this.tabelle.setModel(new TModelFilm());
        this.tabelle.addMouseListener(new TableContextMenuHandler());
        this.tabelle.getSelectionModel().addListSelectionListener(event -> {
            ListSelectionModel m3 = (ListSelectionModel)event.getSource();
            if (!(m3.isSelectionEmpty() || m3.getValueIsAdjusting() || this.stopBeob)) {
                this.updateFilmData();
            }
        });
        this.setupCellRenderer();
        this.tabelle.setLineBreak(MVConfig.getBool(MVConfig.Configs.SYSTEM_TAB_FILME_LINEBREAK));
        this.setupHeaderPopupMenu();
        this.tabelle.readColumnConfigurationData();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    private void setupHeaderPopupMenu() {
        BeobTableHeader headerListener = new BeobTableHeader(this.tabelle, VISIBLE_COLUMNS, HIDDEN_COLUMNS, BUTTON_COLUMNS, true, MVConfig.Configs.SYSTEM_TAB_FILME_LINEBREAK);
        this.tabelle.getTableHeader().addMouseListener(headerListener);
    }

    @Handler
    private void handleDownloadHistoryChangedEvent(DownloadHistoryChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (this.filmActionPanel.isShowUnseenOnly()) {
                Platform.runLater(this.reloadTableDataTransition::playFromStart);
            } else {
                this.tabelle.fireTableDataChanged(true);
            }
        });
    }

    @Handler
    private void handleButtonStart(ButtonStartEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.tabelle.fireTableDataChanged(true);
            this.updateStartInfoProperty();
        });
    }

    @Handler
    private void handleAboListChanged(AboListChangedEvent e) {
        Platform.runLater(this.reloadTableDataTransition::playFromStart);
    }

    @Handler
    private void handleBlacklistChangedEvent(BlacklistChangedEvent e) {
        Platform.runLater(this.reloadTableDataTransition::playFromStart);
    }

    @Handler
    private void handleStartEvent(StartEvent msg) {
        SwingUtilities.invokeLater(() -> this.updateStartInfoProperty());
    }

    private synchronized void saveFilm(DatenPset pSet) {
        if (Daten.listePset.getListeSpeichern().isEmpty()) {
            new DialogAboNoSet(this.mediathekGui).setVisible(true);
            return;
        }
        List<DatenFilm> liste = this.getSelFilme();
        boolean standard = false;
        String pfad = "";
        boolean info = false;
        boolean subtitle = false;
        if (liste.size() > 1) {
            if (pSet == null) {
                pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(0);
            }
            DialogAddMoreDownload damd = new DialogAddMoreDownload(this.mediathekGui, pSet);
            damd.setVisible(true);
            standard = damd.addAll;
            pfad = damd.getPath();
            info = damd.info;
            subtitle = damd.subtitle;
            if (damd.cancel) {
                return;
            }
        }
        for (DatenFilm datenFilm : liste) {
            int ret;
            DatenDownload datenDownload = this.daten.getListeDownloads().getDownloadUrlFilm(datenFilm.getUrlNormalQuality());
            if (datenDownload != null && (ret = JOptionPane.showConfirmDialog(this.mediathekGui, "Download f\u00fcr den Film existiert bereits.\nNochmal anlegen?", "Anlegen?", 0)) != 0) continue;
            if (standard) {
                if (pSet == null) {
                    pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(0);
                }
                datenDownload = new DatenDownload(pSet, datenFilm, 2, null, "", pfad, "");
                datenDownload.arr[35] = Boolean.toString(info);
                datenDownload.arr[37] = Boolean.toString(subtitle);
                this.daten.getListeDownloads().addMitNummer(datenDownload);
                MessageBus.getMessageBus().publishAsync(new DownloadListChangedEvent());
                if (!Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN))) continue;
                datenDownload.startDownload();
                continue;
            }
            this.saveFilm(datenFilm, pSet);
        }
    }

    private void saveFilm(DatenFilm datenFilm, DatenPset pSet) {
        if (Daten.listePset.getListeSpeichern().isEmpty()) {
            MVMessageDialog.showMessageDialog(this, "Ohne Programm-Sets k\u00f6nnen keine Downloads gestartet werden.", "MediathekView", 0);
        } else {
            Optional<FilmResolution.Enum> res = this.filmActionPanel.isShowOnlyHighQuality() ? Optional.of(FilmResolution.Enum.HIGH_QUALITY) : Optional.empty();
            DialogAddDownload dialog = new DialogAddDownload((Frame)this.mediathekGui, datenFilm, pSet, res);
            dialog.setVisible(true);
        }
    }

    private void bookmarkFilm() {
        List<DatenFilm> movies = this.getSelFilme();
        long size = movies.size();
        if (size > 250L) {
            int reply = JOptionPane.showConfirmDialog(this, String.format("M\u00f6chten Sie wirklich %d Eintr\u00e4ge der Merkliste bearbeiten?%nDas Programm k\u00f6nnte w\u00e4hrend der Operation nicht reagieren.", size), "MediathekView", 0);
            if (reply == 0) {
                this.daten.getListeBookmarkList().checkAndBookmarkMovies(movies);
                this.repaint();
            }
        } else {
            this.daten.getListeBookmarkList().checkAndBookmarkMovies(movies);
            this.repaint();
        }
    }

    public void showBookmarkWindow() {
        if (this.bookmarkWindowController.isEmpty()) {
            this.bookmarkWindowController = Optional.of(new BookmarkWindowController());
            this.bookmarkWindowController.get().setPartner(this);
        }
        this.bookmarkWindowController.get().show();
    }

    public void playerStarten(DatenPset pSet) {
        if (this.tabelle.getSelectedRow() == -1) {
            NoSelectionErrorDialog.show(this);
        } else if (pSet.istSpeichern()) {
            this.saveFilm(pSet);
        } else {
            String aufloesung = this.filmActionPanel.isShowOnlyHighQuality() ? FilmResolution.Enum.HIGH_QUALITY.toString() : "";
            Optional<DatenFilm> filmSelection = this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(film -> this.daten.getStarterClass().urlMitProgrammStarten(pSet, (DatenFilm)film, aufloesung));
        }
    }

    public void saveSettings() {
        this.bookmarkWindowController.ifPresent(BookmarkWindowController::saveSettings);
    }

    private Optional<DatenFilm> getFilm(int zeileTabelle) {
        if (zeileTabelle >= 0 && zeileTabelle < this.tabelle.getRowCount()) {
            return Optional.of((DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(zeileTabelle), 16));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DatenFilm> getCurrentlySelectedFilm() {
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow != -1) {
            try {
                int modelIndex = this.tabelle.convertRowIndexToModel(selectedTableRow);
                return Optional.of((DatenFilm)this.tabelle.getModel().getValueAt(modelIndex, 16));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<DatenFilm> getSelFilme() {
        ArrayList<DatenFilm> arrayFilme = new ArrayList<DatenFilm>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenFilm datenFilm = (DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 16);
                arrayFilme.add(datenFilm);
            }
        } else {
            NoSelectionErrorDialog.show(this);
        }
        return arrayFilme;
    }

    private void updateFilmData() {
        InfoDialog infoDialog = this.mediathekGui.getFilmInfoDialog();
        if (infoDialog != null) {
            Optional<DatenFilm> filmSelection = this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(infoDialog::updateCurrentFilm);
        }
    }

    private void setupDataTransitions() {
        this.reloadTableDataTransition.setOnFinished(e -> {
            try {
                SwingUtilities.invokeAndWait(this::loadTable);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                ex.printStackTrace();
                logger.error("Table reload failed", (Throwable)ex);
            }
        });
        this.zeitraumTransition.setOnFinished(evt -> {
            this.filmActionPanel.getViewSettingsPane().senderCheckList.getCheckModel().clearChecks();
            try {
                SwingUtilities.invokeAndWait(() -> this.daten.getListeBlacklist().filterListe());
            }
            catch (InterruptedException | InvocationTargetException e) {
                logger.error("Failed to filter list", (Throwable)e);
            }
            this.reloadTableDataTransition.playFromStart();
        });
    }

    private void setupActionListeners() {
        Platform.runLater(() -> {
            this.setupDataTransitions();
            ChangeListener<Boolean> reloadTableListener = (ob, ov, nv) -> this.reloadTableDataTransition.playFromStart();
            ChangeListener<Boolean> reloadTableListener2 = (ob, ov, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.reloadTableDataTransition.playFromStart();
                }
            };
            this.filmActionPanel.showOnlyHighQualityProperty().addListener(reloadTableListener);
            this.filmActionPanel.showSubtitlesOnlyProperty().addListener(reloadTableListener);
            this.filmActionPanel.showNewOnlyProperty().addListener(reloadTableListener);
            this.filmActionPanel.showBookMarkedOnlyProperty().addListener(reloadTableListener);
            this.filmActionPanel.showUnseenOnlyProperty().addListener(reloadTableListener);
            this.filmActionPanel.dontShowAbosProperty().addListener(reloadTableListener);
            this.filmActionPanel.dontShowTrailersProperty().addListener(reloadTableListener);
            this.filmActionPanel.dontShowSignLanguageProperty().addListener(reloadTableListener);
            this.filmActionPanel.dontShowAudioVersionsProperty().addListener(reloadTableListener);
            this.filmActionPanel.showLivestreamsOnlyProperty().addListener(reloadTableListener);
            RangeSlider filmLengthSlider = this.filmActionPanel.getFilmLengthSlider();
            filmLengthSlider.lowValueChangingProperty().addListener(reloadTableListener2);
            filmLengthSlider.highValueChangingProperty().addListener(reloadTableListener2);
            this.filmActionPanel.zeitraumProperty().addListener((observable2, oldValue, newValue) -> this.zeitraumTransition.playFromStart());
            this.filmActionPanel.getViewSettingsPane().themaComboBox.setOnAction(evt -> {
                if (!this.filmActionPanel.getViewSettingsPane().themaComboBox.getItems().isEmpty()) {
                    this.reloadTableDataTransition.playFromStart();
                }
            });
        });
    }

    @Override
    protected void setupShowFilmDescriptionMenuItem() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.cbkShowDescription.setAccelerator(KeyStroke.getKeyStroke(121, 0));
        this.cbkShowDescription.setSelected(config.getBoolean("film.show_description", true));
        this.cbkShowDescription.addActionListener(l -> {
            boolean visible = this.cbkShowDescription.isSelected();
            this.makeDescriptionTabVisible(visible);
            config.setProperty("film.show_description", visible);
        });
    }

    private void loadTable() {
        if (this.modelFuture != null && !this.modelFuture.isDone()) {
            return;
        }
        final MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
        messageBus.publish(new TableModelChangeEvent(true));
        this.stopBeob = true;
        this.tabelle.getSpalten();
        this.tabelle.setEnabled(false);
        ListeningExecutorService decoratedPool = this.daten.getDecoratedPool();
        this.modelFuture = decoratedPool.submit(() -> {
            SearchFieldData searchFieldData = new SearchFieldData(this.searchField.getText(), this.searchField.getSearchMode());
            GuiModelHelper helper = Daten.getInstance().getListeFilmeNachBlackList() instanceof IndexedFilmList ? new LuceneGuiFilmeModelHelper(this.filmActionPanel, this.historyController, searchFieldData) : new GuiFilmeModelHelper(this.filmActionPanel, this.historyController, searchFieldData);
            return helper.getFilteredTableModel();
        });
        Futures.addCallback(this.modelFuture, new FutureCallback<TableModel>(){

            @Override
            public void onSuccess(TableModel model) {
                SwingUtilities.invokeLater(() -> {
                    GuiFilme.this.tabelle.setModel(model);
                    GuiFilme.this.tabelle.setEnabled(true);
                    GuiFilme.this.updateStartInfoProperty();
                    GuiFilme.this.tabelle.setSpalten();
                    GuiFilme.this.updateFilmData();
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.tabelle.scrollToSelection();
                    messageBus.publish(new TableModelChangeEvent(false));
                });
            }

            @Override
            public void onFailure(@NotNull Throwable thrown) {
                logger.error("Model filtering failed!", thrown);
                SwingUtilities.invokeLater(() -> {
                    GuiFilme.this.tabelle.setEnabled(true);
                    GuiFilme.this.updateStartInfoProperty();
                    GuiFilme.this.tabelle.setSpalten();
                    GuiFilme.this.updateFilmData();
                    GuiFilme.this.stopBeob = false;
                    messageBus.publish(new TableModelChangeEvent(false));
                });
            }
        }, decoratedPool);
    }

    public class SaveFilmAction
    extends AbstractAction {
        public SaveFilmAction() {
            this.putValue("ShortDescription", "Film downloaden");
            this.putValue("Name", "Film downloaden");
            this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/download.svg"));
            KeyStroke keyStroke = SystemUtils.IS_OS_MAC_OSX ? KeyStroke.getKeyStroke(118, GuiFunktionen.getPlatformControlKey()) : KeyStroke.getKeyStroke(68, GuiFunktionen.getPlatformControlKey());
            this.putValue("AcceleratorKey", keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.saveFilm(null);
        }
    }

    public class BookmarkFilmAction
    extends AbstractAction {
        public BookmarkFilmAction() {
            KeyStroke keyStroke = SystemUtils.IS_OS_MAC_OSX ? KeyStroke.getKeyStroke(119, GuiFunktionen.getPlatformControlKey()) : KeyStroke.getKeyStroke(66, GuiFunktionen.getPlatformControlKey());
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", "Film merken");
            this.putValue("Name", "Film merken");
            this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/bookmark.svg"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.bookmarkFilm();
        }
    }

    public class ToggleFilterDialogVisibilityAction
    extends AbstractAction {
        public ToggleFilterDialogVisibilityAction() {
            this.putValue("Name", "Filterdialog anzeigen");
            this.putValue("ShortDescription", "Filter anzeigen");
            this.putValue("SmallIcon", SVGIconUtilities.createSVGIcon("icons/fontawesome/filter.svg"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(123, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OldSwingJavaFxFilterDialog dlg = GuiFilme.this.filmActionPanel.getFilterDialog();
            if (dlg != null) {
                boolean visible = dlg.isVisible();
                visible = !visible;
                dlg.setVisible(visible);
            }
        }
    }

    static class FilterVisibilityToggleButton
    extends JToggleButton {
        public FilterVisibilityToggleButton(Action a) {
            super(a);
            this.setText("");
            boolean visible = ApplicationConfiguration.getConfiguration().getBoolean("application.ui.filter_dialog.visible", false);
            this.setSelected(visible);
        }
    }

    public class LuceneSearchField
    extends SearchField {
        private static final Dimension LUCENE_DEFAULT_DIMENSION = new Dimension(700, 100);
        private final SearchField.SearchHistoryButton luceneSearchHistoryButton;

        public LuceneSearchField() {
            this.luceneSearchHistoryButton = new SearchField.SearchHistoryButton(SearchControlFieldMode.LUCENE);
            this.setMaximumSize(LUCENE_DEFAULT_DIMENSION);
            this.setSearchMode(SearchControlFieldMode.LUCENE);
            this.putClientProperty("JTextField.placeholderText", "Lucene Search Query");
            this.putClientProperty("JTextField.leadingComponent", this.luceneSearchHistoryButton);
        }

        @Override
        protected void createTrailingComponents() {
            JToolBar searchToolbar = new JToolBar();
            searchToolbar.addSeparator();
            JButton luceneBtn = new JButton();
            luceneBtn.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
            luceneBtn.setToolTipText("Lucene Query Syntax Hilfe");
            luceneBtn.addActionListener(l -> {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    if (desktop.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            desktop.browse(Konstanten.LUCENE_CLIENT_HELP_URL.uri());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        this.showError();
                    }
                } else {
                    this.showError();
                }
            });
            searchToolbar.add(luceneBtn);
            this.putClientProperty("JTextField.trailingComponent", searchToolbar);
        }

        private void showError() {
            JOptionPane.showMessageDialog(this, "Es konnte kein Browser ge\u00f6ffnet werden.", "MediathekView", 0);
        }

        @Override
        protected void performSearch() {
            String searchText = this.getText();
            if (!searchText.isEmpty()) {
                this.luceneSearchHistoryButton.addHistoryEntry(searchText);
            }
            GuiFilme.this.loadTable();
        }
    }

    public abstract class SearchField
    extends JTextField {
        private static final Dimension DEFAULT_DIMENSION = new Dimension(500, 100);
        private static final String SEARCHMODE_PROPERTY_STRING = "searchMode";
        protected final PropertyChangeSupport pcs;
        protected SearchControlFieldMode searchMode;

        public SearchField() {
            super("", 20);
            this.pcs = new PropertyChangeSupport(this);
            this.setMaximumSize(DEFAULT_DIMENSION);
            this.putClientProperty("JTextField.showClearButton", true);
            this.putClientProperty("JTextField.clearCallback", textField -> this.clearSearchField());
            this.addKeyListener(new EscapeKeyAdapter());
            this.addActionListener(l -> this.performSearch());
            this.createTrailingComponents();
        }

        protected abstract void createTrailingComponents();

        protected abstract void performSearch();

        protected void clearSearchField() {
            this.setText("");
            this.fireActionPerformed();
        }

        public void addSearchModeChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(SEARCHMODE_PROPERTY_STRING, listener);
        }

        public SearchControlFieldMode getSearchMode() {
            return this.searchMode;
        }

        public void setSearchMode(SearchControlFieldMode mode) {
            SearchControlFieldMode oldValue = this.searchMode;
            this.searchMode = mode;
            this.pcs.firePropertyChange(SEARCHMODE_PROPERTY_STRING, (Object)oldValue, (Object)mode);
        }

        @Override
        protected void fireActionPerformed() {
            super.fireActionPerformed();
        }

        class EscapeKeyAdapter
        extends KeyAdapter {
            EscapeKeyAdapter() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    SearchField.this.clearSearchField();
                }
            }
        }

        public class SearchHistoryButton
        extends JButton {
            private static final Logger logger = LogManager.getLogger();
            private final List<String> historyList;
            private final JMenuItem miClearHistory;
            private String SEARCH_HISTORY_CONFIG;

            public SearchHistoryButton(SearchControlFieldMode mode) {
                super(new FlatSearchWithHistoryIcon(true));
                this.historyList = new ArrayList<String>();
                this.miClearHistory = new JMenuItem("Historie l\u00f6schen");
                this.SEARCH_HISTORY_CONFIG = "search.history.items";
                this.setToolTipText("Vorherige Suchen");
                if (mode != null && mode == SearchControlFieldMode.LUCENE) {
                    this.SEARCH_HISTORY_CONFIG = this.SEARCH_HISTORY_CONFIG + "_lucene";
                }
                this.miClearHistory.addActionListener(l -> {
                    this.historyList.clear();
                    this.saveHistory();
                });
                this.addActionListener(l -> {
                    JPopupMenu popupMenu = new JPopupMenu();
                    popupMenu.add(this.miClearHistory);
                    if (!this.historyList.isEmpty()) {
                        popupMenu.addSeparator();
                        for (String item : this.historyList) {
                            JMenuItem historyItem = new JMenuItem(item);
                            historyItem.addActionListener(li -> {
                                GuiFilme.this.searchField.setText(item);
                                GuiFilme.this.searchField.fireActionPerformed();
                            });
                            popupMenu.add(historyItem);
                        }
                    }
                    popupMenu.show(this, 0, this.getHeight());
                });
                this.loadHistory();
            }

            public void addHistoryEntry(String text) {
                if (!this.historyList.contains(text)) {
                    this.historyList.add(0, text);
                    this.saveHistory();
                }
            }

            private void loadHistory() {
                try {
                    List<String> entries;
                    ObjectMapper mapper = new ObjectMapper();
                    String json = ApplicationConfiguration.getConfiguration().getString(this.SEARCH_HISTORY_CONFIG, "");
                    if (!json.isEmpty() && !(entries = mapper.readValue(json, new TypeReference<List<String>>(this){})).isEmpty()) {
                        this.historyList.addAll(entries);
                    }
                }
                catch (JsonProcessingException ex) {
                    logger.error("Failed to load search history", (Throwable)ex);
                }
            }

            private void saveHistory() {
                ObjectMapper mapper = new ObjectMapper();
                try {
                    String json = mapper.writeValueAsString(this.historyList);
                    ApplicationConfiguration.getConfiguration().setProperty(this.SEARCH_HISTORY_CONFIG, json);
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to write search history", (Throwable)e);
                }
            }
        }
    }

    public class RegularSearchField
    extends SearchField {
        private final SearchField.SearchHistoryButton regularSearchHistoryButton = new SearchField.SearchHistoryButton(null);

        public RegularSearchField() {
            this.addSearchModeChangeListener(evt -> this.setupHelperTexts());
            this.setupPlaceholderText();
            this.putClientProperty("JTextField.leadingComponent", this.regularSearchHistoryButton);
            this.installDocumentListener();
        }

        protected void setupPlaceholderText() {
            boolean bSearchThroughDescription = ApplicationConfiguration.getConfiguration().getBoolean("searchfield.film.search_through_description", false);
            if (bSearchThroughDescription) {
                this.setSearchMode(SearchControlFieldMode.IRGENDWO);
            } else {
                this.setSearchMode(SearchControlFieldMode.THEMA_TITEL);
            }
        }

        @Override
        protected void performSearch() {
            String searchText = this.getText();
            if (!searchText.isEmpty()) {
                this.regularSearchHistoryButton.addHistoryEntry(searchText);
            }
            GuiFilme.this.loadTable();
        }

        private void installDocumentListener() {
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.doCheck();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.doCheck();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.doCheck();
                }

                private void doCheck() {
                    String searchText = RegularSearchField.this.getText();
                    RegularSearchField.this.checkPatternValidity(searchText);
                    RegularSearchField.this.setForegroundTextColor(searchText);
                }
            });
        }

        private void setForegroundTextColor(String text) {
            if (Filter.isPattern(text)) {
                this.setForeground(MVColor.getRegExPatternColor());
            } else {
                this.setForeground(UIManager.getColor("TextField.foreground"));
            }
        }

        private boolean isPatternValid(String text) {
            return Filter.makePatternNoCache(text) != null;
        }

        private void checkPatternValidity(String text) {
            if (Filter.isPattern(text)) {
                GuiFunktionen.showErrorIndication(this, !this.isPatternValid(text));
            } else {
                GuiFunktionen.showErrorIndication(this, false);
            }
        }

        private void setupHelperTexts() {
            String text = switch (this.searchMode) {
                case SearchControlFieldMode.IRGENDWO -> "Thema/Titel/Beschreibung";
                case SearchControlFieldMode.THEMA_TITEL -> "Thema/Titel";
                case SearchControlFieldMode.LUCENE -> "Lucene Query";
                default -> {
                    logger.error("Illegal search mode");
                    yield "";
                }
            };
            this.putClientProperty("JTextField.placeholderText", text);
            if (this.searchMode == SearchControlFieldMode.IRGENDWO || this.searchMode == SearchControlFieldMode.THEMA_TITEL) {
                this.setToolTipText(text + " durchsuchen");
            } else {
                this.setToolTipText("Lucene Query Syntax f\u00fcr die Suche");
            }
        }

        @Override
        protected void createTrailingComponents() {
            JToolBar searchToolbar = new JToolBar();
            searchToolbar.addSeparator();
            searchToolbar.add(new ToggleSearchFieldToggleButton());
            this.putClientProperty("JTextField.trailingComponent", searchToolbar);
        }

        class ToggleSearchFieldToggleButton
        extends JToggleButton {
            public ToggleSearchFieldToggleButton() {
                FlatSVGIcon selectedIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/envelope-open-text.svg");
                selectedIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> MVColor.getSelectedColor()));
                FlatSVGIcon normalIcon = SVGIconUtilities.createSVGIcon("icons/fontawesome/envelope-open-text.svg");
                normalIcon.setColorFilter(new FlatSVGIcon.ColorFilter(color -> Color.GRAY));
                this.setIcon(normalIcon);
                this.setSelectedIcon(selectedIcon);
                boolean bSearchThroughDescription = ApplicationConfiguration.getConfiguration().getBoolean("searchfield.film.search_through_description", false);
                this.setSelected(bSearchThroughDescription);
                this.setupToolTip(bSearchThroughDescription);
                this.addActionListener(l -> {
                    switch (RegularSearchField.this.getSearchMode()) {
                        case IRGENDWO: {
                            RegularSearchField.this.setSearchMode(SearchControlFieldMode.THEMA_TITEL);
                            this.setupToolTip(false);
                            break;
                        }
                        case THEMA_TITEL: {
                            RegularSearchField.this.setSearchMode(SearchControlFieldMode.IRGENDWO);
                            this.setupToolTip(true);
                        }
                    }
                    ApplicationConfiguration.getConfiguration().setProperty("searchfield.film.search_through_description", RegularSearchField.this.getSearchMode() == SearchControlFieldMode.IRGENDWO);
                    GuiFilme.this.loadTable();
                });
            }

            private void setupToolTip(boolean active) {
                if (active) {
                    this.setToolTipText("Suche in Beschreibung aktiviert");
                } else {
                    this.setToolTipText("Suche in Beschreibung deaktiviert");
                }
            }
        }
    }

    private class CopyUrlToClipboardAction
    extends AbstractAction {
        private final FilmResolution.Enum resolution;

        CopyUrlToClipboardAction(FilmResolution.Enum resolution) {
            this.resolution = resolution;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Optional<DatenFilm> filmSelection = GuiFilme.this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(film -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(this.resolution)));
        }
    }

    class TableContextMenuHandler
    extends MouseAdapter {
        private final BeobPrint beobPrint = new BeobPrint();
        private final BeobAbo beobAbo = new BeobAbo(false);
        private final BeobAbo beobAboMitTitel = new BeobAbo(true);
        private final BeobBlacklist beobBlacklistSender = new BeobBlacklist(true, false);
        private final BeobBlacklist beobBlacklistSenderThema = new BeobBlacklist(true, true);
        private final BeobBlacklist beobBlacklistThema = new BeobBlacklist(false, true);
        private final JMenuItem miSave = this.createSaveFilmItem();
        private final JMenuItem miBookmark = this.createBookmarkFilmItem();
        private final ActionListener unseenActionListener = new BeobHistory(false);
        private final ActionListener seenActionListener = new BeobHistory(true);
        private final JDownloadHelper jDownloadHelper = new JDownloadHelper();
        private final DownloadSubtitleAction downloadSubtitleAction = new DownloadSubtitleAction(GuiFilme.this);
        private Point p;
        private JMenuItem miPrintTable;

        TableContextMenuHandler() {
            this.createStaticMenuEntries();
        }

        private void createStaticMenuEntries() {
            this.miPrintTable = new JMenuItem("Tabelle drucken");
            this.miPrintTable.addActionListener(this.beobPrint);
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                InfoDialog infoDialog;
                if (arg0.getClickCount() == 1) {
                    this.p = arg0.getPoint();
                    int row = GuiFilme.this.tabelle.rowAtPoint(this.p);
                    int column = GuiFilme.this.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (arg0.getClickCount() > 1 && (infoDialog = GuiFilme.this.mediathekGui.getFilmInfoDialog()) != null && !infoDialog.isVisible()) {
                    infoDialog.showInfo();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1) {
                switch (GuiFilme.this.tabelle.convertColumnIndexToModel(column)) {
                    case 4: {
                        Optional<DatenFilm> filmSelection = GuiFilme.this.getCurrentlySelectedFilm();
                        filmSelection.ifPresent(datenFilm -> {
                            boolean stop = false;
                            DatenDownload datenDownload = GuiFilme.this.daten.getListeDownloadsButton().getDownloadUrlFilm(datenFilm.getUrlNormalQuality());
                            if (datenDownload != null && datenDownload.start != null && datenDownload.start.status == 2) {
                                stop = true;
                                GuiFilme.this.daten.getListeDownloadsButton().delDownloadButton(datenFilm.getUrlNormalQuality());
                            }
                            if (!stop) {
                                GuiFilme.this.playFilmAction.actionPerformed(null);
                            }
                        });
                        break;
                    }
                    case 5: {
                        GuiFilme.this.saveFilm(null);
                        break;
                    }
                    case 6: {
                        GuiFilme.this.getCurrentlySelectedFilm().ifPresent(film -> {
                            if (!film.isLivestream()) {
                                GuiFilme.this.bookmarkFilm();
                            }
                        });
                    }
                }
            }
        }

        private JMenuItem createSaveFilmItem() {
            JMenuItem item = new JMenuItem("Film aufzeichnen");
            item.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/download.svg"));
            item.addActionListener(GuiFilme.this.saveFilmAction);
            return item;
        }

        private JMenuItem createBookmarkFilmItem() {
            JMenuItem item = new JMenuItem("Film merken");
            item.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/bookmark.svg"));
            item.addActionListener(GuiFilme.this.bookmarkFilmAction);
            return item;
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiFilme.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiFilme.this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(GuiFilme.this.playFilmAction);
            jPopupMenu.add(this.miSave);
            jPopupMenu.add(this.miBookmark);
            jPopupMenu.addSeparator();
            JMenu submenueAbo = new JMenu("Abo");
            jPopupMenu.add(submenueAbo);
            JMenuItem itemAbo = new JMenuItem("Abo mit Sender und Thema anlegen");
            JMenuItem itemAboMitTitel = new JMenuItem("Abo mit Sender und Thema und Titel anlegen");
            Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
            res.ifPresent(film -> {
                if (GuiFilme.this.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false) != null) {
                    itemAbo.setEnabled(false);
                    itemAboMitTitel.setEnabled(false);
                } else {
                    itemAbo.addActionListener(this.beobAbo);
                    itemAboMitTitel.addActionListener(this.beobAboMitTitel);
                }
                if (film.isLivestream()) {
                    jPopupMenu.remove(this.miBookmark);
                } else {
                    this.miBookmark.setText(film.isBookmarked() ? "Film aus Merkliste entfernen" : "Film merken");
                }
            });
            submenueAbo.add(itemAbo);
            submenueAbo.add(itemAboMitTitel);
            JMenu submenue = new JMenu("Film mit Set starten");
            jPopupMenu.add(submenue);
            ListePset liste = Daten.listePset.getListeButton();
            for (DatenPset pset : liste) {
                if (pset.getListeProg().isEmpty() && pset.arr[0].isEmpty()) continue;
                Color col = pset.getFarbe();
                JMenuItem item = new JMenuItem(pset.arr[0]);
                if (pset.getListeProg().isEmpty()) {
                    if (col != null) {
                        item.setForeground(col);
                    }
                } else {
                    item.addActionListener(l -> GuiFilme.this.playerStarten(pset));
                    if (col != null) {
                        item.setBackground(col);
                    }
                }
                submenue.add(item);
            }
            JMenu submenueBlack = new JMenu("Blacklist");
            jPopupMenu.add(submenueBlack);
            JMenuItem itemBlackSender = new JMenuItem("Sender in die Blacklist einf\u00fcgen");
            itemBlackSender.addActionListener(this.beobBlacklistSender);
            JMenuItem itemBlackThema = new JMenuItem("Thema in die Blacklist einf\u00fcgen");
            itemBlackThema.addActionListener(this.beobBlacklistThema);
            JMenuItem itemBlackSenderThema = new JMenuItem("Sender und Thema in die Blacklist einf\u00fcgen");
            itemBlackSenderThema.addActionListener(this.beobBlacklistSenderThema);
            submenueBlack.add(itemBlackSender);
            submenueBlack.add(itemBlackThema);
            submenueBlack.add(itemBlackSenderThema);
            res.ifPresent(film -> {
                this.jDownloadHelper.installContextMenu((DatenFilm)film, jPopupMenu);
                jPopupMenu.addSeparator();
                this.setupCopytoClipboardContextMenu((DatenFilm)film, jPopupMenu);
                jPopupMenu.addSeparator();
                this.setupSearchEntries(jPopupMenu, (DatenFilm)film);
            });
            res.ifPresent(film -> {
                if (film.hasSubtitle()) {
                    jPopupMenu.add(this.downloadSubtitleAction);
                    jPopupMenu.addSeparator();
                }
            });
            jPopupMenu.add(this.miPrintTable);
            jPopupMenu.add(((GuiFilme)GuiFilme.this).mediathekGui.showFilmInformationAction);
            res.ifPresent(film -> this.setupHistoryContextActions(jPopupMenu, (DatenFilm)film));
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private void setupHistoryContextActions(@NotNull JPopupMenu popupMenu, @NotNull DatenFilm film) {
            if (!film.isLivestream()) {
                try (SeenHistoryController history = new SeenHistoryController();){
                    JMenuItem miHistory;
                    if (history.hasBeenSeen(film)) {
                        miHistory = new JMenuItem("Film als ungesehen markieren");
                        miHistory.addActionListener(this.unseenActionListener);
                    } else {
                        miHistory = new JMenuItem("Film als gesehen markieren");
                        miHistory.addActionListener(this.seenActionListener);
                    }
                    popupMenu.add(miHistory);
                }
            }
        }

        private void setupCopytoClipboardContextMenu(@NotNull DatenFilm film, @NotNull JPopupMenu popupMenu) {
            JMenu mCopyToClipboard = new JMenu("In Zwischenablage kopieren");
            JMenuItem miCopyClipboardTitle = new JMenuItem("Titel");
            miCopyClipboardTitle.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getTitle()));
            mCopyToClipboard.add(miCopyClipboardTitle);
            JMenuItem miCopyClipboardThema = new JMenuItem("Thema");
            miCopyClipboardThema.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getThema()));
            mCopyToClipboard.add(miCopyClipboardThema);
            JMenuItem miCopyTitleThemaToClipboard = new JMenuItem("Thema - Titel");
            miCopyTitleThemaToClipboard.addActionListener(e -> {
                String text = film.getThema() + " - " + film.getTitle();
                GuiFunktionen.copyToClipboard(text);
            });
            mCopyToClipboard.add(miCopyTitleThemaToClipboard);
            this.setupFilmUrlCopyToClipboardEntries(mCopyToClipboard, film);
            popupMenu.add(mCopyToClipboard);
        }

        private void setupFilmUrlCopyToClipboardEntries(@NotNull JMenu parentMenu, @NotNull DatenFilm film) {
            JMenuItem item;
            parentMenu.addSeparator();
            String uNormal = film.getUrlFuerAufloesung(FilmResolution.Enum.NORMAL);
            String uHd = film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY);
            String uLow = film.getUrlFuerAufloesung(FilmResolution.Enum.LOW);
            if (uHd.equals(uNormal)) {
                uHd = "";
            }
            if (uLow.equals(uNormal)) {
                uLow = "";
            }
            if (!uNormal.isEmpty()) {
                ActionListener copyNormalUrlListener = e -> GuiFunktionen.copyToClipboard(uNormal);
                if (!uHd.isEmpty() || !uLow.isEmpty()) {
                    JMenu submenueURL = new JMenu("Film-URL");
                    if (!uHd.isEmpty()) {
                        item = new JMenuItem("h\u00f6chste/hohe Qualit\u00e4t");
                        item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY)));
                        submenueURL.add(item);
                    }
                    item = new JMenuItem("mittlere Qualit\u00e4t");
                    item.addActionListener(copyNormalUrlListener);
                    submenueURL.add(item);
                    if (!uLow.isEmpty()) {
                        item = new JMenuItem("niedrige Qualit\u00e4t");
                        item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(FilmResolution.Enum.LOW)));
                        submenueURL.add(item);
                    }
                    parentMenu.add(submenueURL);
                } else {
                    item = new JMenuItem("Verf\u00fcgbare URL");
                    item.addActionListener(copyNormalUrlListener);
                    parentMenu.add(item);
                }
            }
            if (!film.getSubtitleUrl().isEmpty()) {
                item = new JMenuItem("Untertitel-URL");
                item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getSubtitleUrl()));
                parentMenu.add(item);
            }
        }

        private void setupSearchEntries(@NotNull JPopupMenu popupMenu, @NotNull DatenFilm film) {
            JMenu mOnlineSearch = new JMenu("Online-Suche nach");
            JMenu mThema = new JMenu("Thema");
            JMenu mTitel = new JMenu("Titel");
            EnumSet<OnlineSearchProviders> set = EnumSet.allOf(OnlineSearchProviders.class);
            for (OnlineSearchProviders item : set) {
                JMenuItem miThema = new JMenuItem(item.toString());
                miThema.addActionListener(l -> {
                    String url = item.getQueryUrl() + URLEncoder.encode(film.getThema(), StandardCharsets.UTF_8);
                    try {
                        UrlHyperlinkAction.openURL(MediathekGui.ui(), url);
                    }
                    catch (URISyntaxException ex) {
                        logger.error("Failed to launch online search for url {}", (Object)url);
                    }
                });
                mThema.add(miThema);
                JMenuItem miTitel = new JMenuItem(item.toString());
                miTitel.addActionListener(l -> {
                    String url = item.getQueryUrl() + URLEncoder.encode(film.getTitle(), StandardCharsets.UTF_8);
                    try {
                        UrlHyperlinkAction.openURL(MediathekGui.ui(), url);
                    }
                    catch (URISyntaxException ex) {
                        logger.error("Failed to launch online search for url {}", (Object)url);
                    }
                });
                mTitel.add(miTitel);
            }
            mOnlineSearch.add(mThema);
            mOnlineSearch.add(mTitel);
            popupMenu.add(mOnlineSearch);
            popupMenu.addSeparator();
        }

        private class BeobPrint
        implements ActionListener {
            private BeobPrint() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiFilme.this.tabelle.print();
                }
                catch (PrinterException ex) {
                    logger.error(ex);
                }
            }
        }

        private class BeobAbo
        implements ActionListener {
            private final boolean mitTitel;

            BeobAbo(boolean mmitTitel) {
                this.mitTitel = mmitTitel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    new DialogAboNoSet(GuiFilme.this.mediathekGui).setVisible(true);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(TableContextMenuHandler.this.p);
                    if (nr >= 0) {
                        GuiFilme.this.stopBeob = true;
                        Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                        res.ifPresent(film -> {
                            DatenAbo datenAbo = GuiFilme.this.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false);
                            if (datenAbo != null) {
                                GuiFilme.this.daten.getListeAbo().aboLoeschen(datenAbo);
                            } else if (this.mitTitel) {
                                GuiFilme.this.daten.getListeAbo().addAbo(film.getThema(), film.getSender(), film.getThema(), film.getTitle());
                            } else {
                                GuiFilme.this.daten.getListeAbo().addAbo(film.getThema(), film.getSender(), film.getThema(), "");
                            }
                        });
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }

        private final class BeobBlacklist
        implements ActionListener {
            private final boolean sender;
            private final boolean thema;

            BeobBlacklist(boolean sender, boolean thema) {
                this.sender = sender;
                this.thema = thema;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(TableContextMenuHandler.this.p);
                if (nr >= 0) {
                    Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                    res.ifPresent(film -> {
                        String thema = film.getThema();
                        String sender = film.getSender();
                        MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ON, Boolean.TRUE.toString());
                        ListeBlacklist listeBlacklist = GuiFilme.this.daten.getListeBlacklist();
                        if (!this.sender) {
                            listeBlacklist.add(new BlacklistRule("", thema, "", ""));
                        } else if (!this.thema) {
                            listeBlacklist.add(new BlacklistRule(sender, "", "", ""));
                        } else {
                            listeBlacklist.add(new BlacklistRule(sender, thema, "", ""));
                        }
                    });
                }
            }
        }

        private class BeobHistory
        implements ActionListener {
            private final boolean seen;

            BeobHistory(boolean seen) {
                this.seen = seen;
            }

            private void updateHistory(DatenFilm film) {
                try (SeenHistoryController history = new SeenHistoryController();){
                    if (this.seen) {
                        history.markSeen(film);
                    } else {
                        history.markUnseen(film);
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(TableContextMenuHandler.this.p);
                if (nr != -1) {
                    Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                    res.ifPresent(this::updateHistory);
                }
            }
        }
    }
}

