/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.cluster;

import java.time.Clock;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.ad.util.ClientUtil;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;

@Deprecated
public class DailyCron
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(DailyCron.class);
    protected static final String FIELD_MODEL = "queue";
    static final String CANNOT_DELETE_OLD_CHECKPOINT_MSG = "Cannot delete old checkpoint.";
    static final String CHECKPOINT_NOT_EXIST_MSG = "Checkpoint index does not exist.";
    static final String CHECKPOINT_DELETED_MSG = "checkpoint docs get deleted";
    private final Clock clock;
    private final Duration checkpointTtl;
    private final ClientUtil clientUtil;

    public DailyCron(Clock clock, Duration checkpointTtl, ClientUtil clientUtil) {
        this.clock = clock;
        this.clientUtil = clientUtil;
        this.checkpointTtl = checkpointTtl;
    }

    @Override
    public void run() {
        DeleteByQueryRequest deleteRequest = new DeleteByQueryRequest(new String[]{".opendistro-anomaly-checkpoints"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").lte((Object)(this.clock.millis() - this.checkpointTtl.toMillis())).format("epoch_millis"))).setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        this.clientUtil.execute(DeleteByQueryAction.INSTANCE, deleteRequest, ActionListener.wrap(response -> LOG.info("{} checkpoint docs get deleted", (Object)response.getDeleted()), exception -> {
            if (exception instanceof IndexNotFoundException) {
                LOG.info(CHECKPOINT_NOT_EXIST_MSG);
            } else {
                LOG.error(CANNOT_DELETE_OLD_CHECKPOINT_MSG, (Throwable)exception);
            }
        }));
    }
}

