/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.ad.annotation.Generated;
import org.opensearch.ad.cluster.ADVersionUtil;
import org.opensearch.ad.model.ADEntityTaskProfile;
import org.opensearch.ad.model.ADTask;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class ADTaskProfile
implements ToXContentObject,
Writeable {
    public static final String AD_TASK_FIELD = "ad_task";
    public static final String SHINGLE_SIZE_FIELD = "shingle_size";
    public static final String RCF_TOTAL_UPDATES_FIELD = "rcf_total_updates";
    public static final String THRESHOLD_MODEL_TRAINED_FIELD = "threshold_model_trained";
    public static final String THRESHOLD_MODEL_TRAINING_DATA_SIZE_FIELD = "threshold_model_training_data_size";
    public static final String MODEL_SIZE_IN_BYTES = "model_size_in_bytes";
    public static final String NODE_ID_FIELD = "node_id";
    public static final String TASK_ID_FIELD = "task_id";
    public static final String AD_TASK_TYPE_FIELD = "task_type";
    public static final String DETECTOR_TASK_SLOTS_FIELD = "detector_task_slots";
    public static final String TOTAL_ENTITIES_INITED_FIELD = "total_entities_inited";
    public static final String TOTAL_ENTITIES_COUNT_FIELD = "total_entities_count";
    public static final String PENDING_ENTITIES_COUNT_FIELD = "pending_entities_count";
    public static final String RUNNING_ENTITIES_COUNT_FIELD = "running_entities_count";
    public static final String RUNNING_ENTITIES_FIELD = "running_entities";
    public static final String ENTITY_TASK_PROFILE_FIELD = "entity_task_profiles";
    public static final String LATEST_HC_TASK_RUN_TIME_FIELD = "latest_hc_task_run_time";
    private ADTask adTask;
    private Integer shingleSize;
    private Long rcfTotalUpdates;
    private Boolean thresholdModelTrained;
    private Integer thresholdModelTrainingDataSize;
    private Long modelSizeInBytes;
    private String nodeId;
    private String taskId;
    private String adTaskType;
    private Integer detectorTaskSlots;
    private Boolean totalEntitiesInited;
    private Integer totalEntitiesCount;
    private Integer pendingEntitiesCount;
    private Integer runningEntitiesCount;
    private List<String> runningEntities;
    private Long latestHCTaskRunTime;
    private List<ADEntityTaskProfile> entityTaskProfiles;

    public ADTaskProfile() {
    }

    public ADTaskProfile(ADTask adTask) {
        this.adTask = adTask;
    }

    public ADTaskProfile(String taskId, int shingleSize, long rcfTotalUpdates, boolean thresholdModelTrained, int thresholdModelTrainingDataSize, long modelSizeInBytes, String nodeId) {
        this.taskId = taskId;
        this.shingleSize = shingleSize;
        this.rcfTotalUpdates = rcfTotalUpdates;
        this.thresholdModelTrained = thresholdModelTrained;
        this.thresholdModelTrainingDataSize = thresholdModelTrainingDataSize;
        this.modelSizeInBytes = modelSizeInBytes;
        this.nodeId = nodeId;
    }

    public ADTaskProfile(ADTask adTask, Integer shingleSize, Long rcfTotalUpdates, Boolean thresholdModelTrained, Integer thresholdModelTrainingDataSize, Long modelSizeInBytes, String nodeId, String taskId, String adTaskType, Integer detectorTaskSlots, Boolean totalEntitiesInited, Integer totalEntitiesCount, Integer pendingEntitiesCount, Integer runningEntitiesCount, List<String> runningEntities, Long latestHCTaskRunTime) {
        this.adTask = adTask;
        this.shingleSize = shingleSize;
        this.rcfTotalUpdates = rcfTotalUpdates;
        this.thresholdModelTrained = thresholdModelTrained;
        this.thresholdModelTrainingDataSize = thresholdModelTrainingDataSize;
        this.modelSizeInBytes = modelSizeInBytes;
        this.nodeId = nodeId;
        this.taskId = taskId;
        this.adTaskType = adTaskType;
        this.detectorTaskSlots = detectorTaskSlots;
        this.totalEntitiesInited = totalEntitiesInited;
        this.totalEntitiesCount = totalEntitiesCount;
        this.pendingEntitiesCount = pendingEntitiesCount;
        this.runningEntitiesCount = runningEntitiesCount;
        this.runningEntities = runningEntities;
        this.latestHCTaskRunTime = latestHCTaskRunTime;
    }

    public ADTaskProfile(StreamInput input) throws IOException {
        this.adTask = input.readBoolean() ? new ADTask(input) : null;
        this.shingleSize = input.readOptionalInt();
        this.rcfTotalUpdates = input.readOptionalLong();
        this.thresholdModelTrained = input.readOptionalBoolean();
        this.thresholdModelTrainingDataSize = input.readOptionalInt();
        this.modelSizeInBytes = input.readOptionalLong();
        this.nodeId = input.readOptionalString();
        if (input.available() > 0) {
            this.taskId = input.readOptionalString();
            this.adTaskType = input.readOptionalString();
            this.detectorTaskSlots = input.readOptionalInt();
            this.totalEntitiesInited = input.readOptionalBoolean();
            this.totalEntitiesCount = input.readOptionalInt();
            this.pendingEntitiesCount = input.readOptionalInt();
            this.runningEntitiesCount = input.readOptionalInt();
            if (input.readBoolean()) {
                this.runningEntities = input.readStringList();
            }
            if (input.readBoolean()) {
                this.entityTaskProfiles = input.readList(ADEntityTaskProfile::new);
            }
            this.latestHCTaskRunTime = input.readOptionalLong();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.writeTo(out, Version.CURRENT);
    }

    public void writeTo(StreamOutput out, Version adVersion) throws IOException {
        if (this.adTask != null) {
            out.writeBoolean(true);
            this.adTask.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalInt(this.shingleSize);
        out.writeOptionalLong(this.rcfTotalUpdates);
        out.writeOptionalBoolean(this.thresholdModelTrained);
        out.writeOptionalInt(this.thresholdModelTrainingDataSize);
        out.writeOptionalLong(this.modelSizeInBytes);
        out.writeOptionalString(this.nodeId);
        if (ADVersionUtil.compatibleWithVersionOnOrAfter1_1(adVersion)) {
            out.writeOptionalString(this.taskId);
            out.writeOptionalString(this.adTaskType);
            out.writeOptionalInt(this.detectorTaskSlots);
            out.writeOptionalBoolean(this.totalEntitiesInited);
            out.writeOptionalInt(this.totalEntitiesCount);
            out.writeOptionalInt(this.pendingEntitiesCount);
            out.writeOptionalInt(this.runningEntitiesCount);
            if (this.runningEntities != null && this.runningEntities.size() > 0) {
                out.writeBoolean(true);
                out.writeStringCollection(this.runningEntities);
            } else {
                out.writeBoolean(false);
            }
            if (this.entityTaskProfiles != null && this.entityTaskProfiles.size() > 0) {
                out.writeBoolean(true);
                out.writeList(this.entityTaskProfiles);
            } else {
                out.writeBoolean(false);
            }
            out.writeOptionalLong(this.latestHCTaskRunTime);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        if (this.adTask != null) {
            xContentBuilder.field(AD_TASK_FIELD, (ToXContent)this.adTask);
        }
        if (this.shingleSize != null) {
            xContentBuilder.field(SHINGLE_SIZE_FIELD, this.shingleSize);
        }
        if (this.rcfTotalUpdates != null) {
            xContentBuilder.field(RCF_TOTAL_UPDATES_FIELD, this.rcfTotalUpdates);
        }
        if (this.thresholdModelTrained != null) {
            xContentBuilder.field(THRESHOLD_MODEL_TRAINED_FIELD, this.thresholdModelTrained);
        }
        if (this.thresholdModelTrainingDataSize != null) {
            xContentBuilder.field(THRESHOLD_MODEL_TRAINING_DATA_SIZE_FIELD, this.thresholdModelTrainingDataSize);
        }
        if (this.modelSizeInBytes != null) {
            xContentBuilder.field(MODEL_SIZE_IN_BYTES, this.modelSizeInBytes);
        }
        if (this.nodeId != null) {
            xContentBuilder.field(NODE_ID_FIELD, this.nodeId);
        }
        if (this.taskId != null) {
            xContentBuilder.field(TASK_ID_FIELD, this.taskId);
        }
        if (this.adTaskType != null) {
            xContentBuilder.field(AD_TASK_TYPE_FIELD, this.adTaskType);
        }
        if (this.detectorTaskSlots != null) {
            xContentBuilder.field(DETECTOR_TASK_SLOTS_FIELD, this.detectorTaskSlots);
        }
        if (this.totalEntitiesInited != null) {
            xContentBuilder.field(TOTAL_ENTITIES_INITED_FIELD, this.totalEntitiesInited);
        }
        if (this.totalEntitiesCount != null) {
            xContentBuilder.field(TOTAL_ENTITIES_COUNT_FIELD, this.totalEntitiesCount);
        }
        if (this.pendingEntitiesCount != null) {
            xContentBuilder.field(PENDING_ENTITIES_COUNT_FIELD, this.pendingEntitiesCount);
        }
        if (this.runningEntitiesCount != null) {
            xContentBuilder.field(RUNNING_ENTITIES_COUNT_FIELD, this.runningEntitiesCount);
        }
        if (this.runningEntities != null) {
            xContentBuilder.field(RUNNING_ENTITIES_FIELD, this.runningEntities);
        }
        if (this.entityTaskProfiles != null && this.entityTaskProfiles.size() > 0) {
            xContentBuilder.field(ENTITY_TASK_PROFILE_FIELD, (Object)this.entityTaskProfiles.toArray());
        }
        if (this.latestHCTaskRunTime != null) {
            xContentBuilder.field(LATEST_HC_TASK_RUN_TIME_FIELD, this.latestHCTaskRunTime);
        }
        return xContentBuilder.endObject();
    }

    public static ADTaskProfile parse(XContentParser parser) throws IOException {
        ADTask adTask = null;
        Integer shingleSize = null;
        Long rcfTotalUpdates = null;
        Boolean thresholdModelTrained = null;
        Integer thresholdModelTrainingDataSize = null;
        Long modelSizeInBytes = null;
        String nodeId = null;
        String taskId = null;
        String taskType = null;
        Integer detectorTaskSlots = null;
        Boolean totalEntitiesInited = null;
        Integer totalEntitiesCount = null;
        Integer pendingEntitiesCount = null;
        Integer runningEntitiesCount = null;
        ArrayList<String> runningEntities = null;
        ArrayList<ADEntityTaskProfile> entityTaskProfiles = null;
        Long latestHCTaskRunTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block38: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "ad_task": {
                    adTask = ADTask.parse(parser);
                    continue block38;
                }
                case "shingle_size": {
                    shingleSize = parser.intValue();
                    continue block38;
                }
                case "rcf_total_updates": {
                    rcfTotalUpdates = parser.longValue();
                    continue block38;
                }
                case "threshold_model_trained": {
                    thresholdModelTrained = parser.booleanValue();
                    continue block38;
                }
                case "threshold_model_training_data_size": {
                    thresholdModelTrainingDataSize = parser.intValue();
                    continue block38;
                }
                case "model_size_in_bytes": {
                    modelSizeInBytes = parser.longValue();
                    continue block38;
                }
                case "node_id": {
                    nodeId = parser.text();
                    continue block38;
                }
                case "task_id": {
                    taskId = parser.text();
                    continue block38;
                }
                case "task_type": {
                    taskType = parser.text();
                    continue block38;
                }
                case "detector_task_slots": {
                    detectorTaskSlots = parser.intValue();
                    continue block38;
                }
                case "total_entities_inited": {
                    totalEntitiesInited = parser.booleanValue();
                    continue block38;
                }
                case "total_entities_count": {
                    totalEntitiesCount = parser.intValue();
                    continue block38;
                }
                case "pending_entities_count": {
                    pendingEntitiesCount = parser.intValue();
                    continue block38;
                }
                case "running_entities_count": {
                    runningEntitiesCount = parser.intValue();
                    continue block38;
                }
                case "running_entities": {
                    runningEntities = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        runningEntities.add(parser.text());
                    }
                    continue block38;
                }
                case "entity_task_profiles": {
                    entityTaskProfiles = new ArrayList<ADEntityTaskProfile>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        entityTaskProfiles.add(ADEntityTaskProfile.parse(parser));
                    }
                    continue block38;
                }
                case "latest_hc_task_run_time": {
                    latestHCTaskRunTime = parser.longValue();
                    continue block38;
                }
            }
            parser.skipChildren();
        }
        return new ADTaskProfile(adTask, shingleSize, rcfTotalUpdates, thresholdModelTrained, thresholdModelTrainingDataSize, modelSizeInBytes, nodeId, taskId, taskType, detectorTaskSlots, totalEntitiesInited, totalEntitiesCount, pendingEntitiesCount, runningEntitiesCount, runningEntities, latestHCTaskRunTime);
    }

    public ADTask getAdTask() {
        return this.adTask;
    }

    public void setAdTask(ADTask adTask) {
        this.adTask = adTask;
    }

    public Integer getShingleSize() {
        return this.shingleSize;
    }

    public void setShingleSize(Integer shingleSize) {
        this.shingleSize = shingleSize;
    }

    public Long getRcfTotalUpdates() {
        return this.rcfTotalUpdates;
    }

    public void setRcfTotalUpdates(Long rcfTotalUpdates) {
        this.rcfTotalUpdates = rcfTotalUpdates;
    }

    public Boolean getThresholdModelTrained() {
        return this.thresholdModelTrained;
    }

    public void setThresholdModelTrained(Boolean thresholdModelTrained) {
        this.thresholdModelTrained = thresholdModelTrained;
    }

    public Integer getThresholdModelTrainingDataSize() {
        return this.thresholdModelTrainingDataSize;
    }

    public void setThresholdModelTrainingDataSize(Integer thresholdModelTrainingDataSize) {
        this.thresholdModelTrainingDataSize = thresholdModelTrainingDataSize;
    }

    public Long getModelSizeInBytes() {
        return this.modelSizeInBytes;
    }

    public void setModelSizeInBytes(Long modelSizeInBytes) {
        this.modelSizeInBytes = modelSizeInBytes;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getAdTaskType() {
        return this.adTaskType;
    }

    public void setAdTaskType(String adTaskType) {
        this.adTaskType = adTaskType;
    }

    public boolean getTotalEntitiesInited() {
        return this.totalEntitiesInited != null && this.totalEntitiesInited != false;
    }

    public void setTotalEntitiesInited(Boolean totalEntitiesInited) {
        this.totalEntitiesInited = totalEntitiesInited;
    }

    public Long getLatestHCTaskRunTime() {
        return this.latestHCTaskRunTime;
    }

    public void setLatestHCTaskRunTime(Long latestHCTaskRunTime) {
        this.latestHCTaskRunTime = latestHCTaskRunTime;
    }

    public Integer getTotalEntitiesCount() {
        return this.totalEntitiesCount;
    }

    public void setTotalEntitiesCount(Integer totalEntitiesCount) {
        this.totalEntitiesCount = totalEntitiesCount;
    }

    public Integer getDetectorTaskSlots() {
        return this.detectorTaskSlots;
    }

    public void setDetectorTaskSlots(Integer detectorTaskSlots) {
        this.detectorTaskSlots = detectorTaskSlots;
    }

    public Integer getPendingEntitiesCount() {
        return this.pendingEntitiesCount;
    }

    public void setPendingEntitiesCount(Integer pendingEntitiesCount) {
        this.pendingEntitiesCount = pendingEntitiesCount;
    }

    public Integer getRunningEntitiesCount() {
        return this.runningEntitiesCount;
    }

    public void setRunningEntitiesCount(Integer runningEntitiesCount) {
        this.runningEntitiesCount = runningEntitiesCount;
    }

    public List<String> getRunningEntities() {
        return this.runningEntities;
    }

    public void setRunningEntities(List<String> runningEntities) {
        this.runningEntities = runningEntities;
    }

    public List<ADEntityTaskProfile> getEntityTaskProfiles() {
        return this.entityTaskProfiles;
    }

    public void setEntityTaskProfiles(List<ADEntityTaskProfile> entityTaskProfiles) {
        this.entityTaskProfiles = entityTaskProfiles;
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ADTaskProfile that = (ADTaskProfile)o;
        return Objects.equals(this.adTask, that.adTask) && Objects.equals(this.shingleSize, that.shingleSize) && Objects.equals(this.rcfTotalUpdates, that.rcfTotalUpdates) && Objects.equals(this.thresholdModelTrained, that.thresholdModelTrained) && Objects.equals(this.thresholdModelTrainingDataSize, that.thresholdModelTrainingDataSize) && Objects.equals(this.modelSizeInBytes, that.modelSizeInBytes) && Objects.equals(this.nodeId, that.nodeId) && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.adTaskType, that.adTaskType) && Objects.equals(this.detectorTaskSlots, that.detectorTaskSlots) && Objects.equals(this.totalEntitiesInited, that.totalEntitiesInited) && Objects.equals(this.totalEntitiesCount, that.totalEntitiesCount) && Objects.equals(this.pendingEntitiesCount, that.pendingEntitiesCount) && Objects.equals(this.runningEntitiesCount, that.runningEntitiesCount) && Objects.equals(this.runningEntities, that.runningEntities) && Objects.equals(this.latestHCTaskRunTime, that.latestHCTaskRunTime) && Objects.equals(this.entityTaskProfiles, that.entityTaskProfiles);
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.adTask, this.shingleSize, this.rcfTotalUpdates, this.thresholdModelTrained, this.thresholdModelTrainingDataSize, this.modelSizeInBytes, this.nodeId, this.taskId, this.adTaskType, this.detectorTaskSlots, this.totalEntitiesInited, this.totalEntitiesCount, this.pendingEntitiesCount, this.runningEntitiesCount, this.runningEntities, this.entityTaskProfiles, this.latestHCTaskRunTime);
    }

    public String toString() {
        return "ADTaskProfile{adTask=" + this.adTask + ", shingleSize=" + this.shingleSize + ", rcfTotalUpdates=" + this.rcfTotalUpdates + ", thresholdModelTrained=" + this.thresholdModelTrained + ", thresholdModelTrainingDataSize=" + this.thresholdModelTrainingDataSize + ", modelSizeInBytes=" + this.modelSizeInBytes + ", nodeId='" + this.nodeId + "', taskId='" + this.taskId + "', adTaskType='" + this.adTaskType + "', detectorTaskSlots=" + this.detectorTaskSlots + ", totalEntitiesInited=" + this.totalEntitiesInited + ", totalEntitiesCount=" + this.totalEntitiesCount + ", pendingEntitiesCount=" + this.pendingEntitiesCount + ", runningEntitiesCount=" + this.runningEntitiesCount + ", runningEntities=" + this.runningEntities + ", latestHCTaskRunTime=" + this.latestHCTaskRunTime + ", entityTaskProfiles=" + this.entityTaskProfiles + "}";
    }
}

