/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.ad.model.DetectorProfileName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class ProfileRequest
extends BaseNodesRequest<ProfileRequest> {
    private Set<DetectorProfileName> profilesToBeRetrieved;
    private String detectorId;
    private boolean forMultiEntityDetector;

    public ProfileRequest(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.profilesToBeRetrieved = new HashSet<DetectorProfileName>();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                this.profilesToBeRetrieved.add((DetectorProfileName)in.readEnum(DetectorProfileName.class));
            }
        }
        this.detectorId = in.readString();
        this.forMultiEntityDetector = in.readBoolean();
    }

    public ProfileRequest(String detectorId, Set<DetectorProfileName> profilesToBeRetrieved, boolean forMultiEntityDetector, DiscoveryNode ... nodes) {
        super(nodes);
        this.detectorId = detectorId;
        this.profilesToBeRetrieved = profilesToBeRetrieved;
        this.forMultiEntityDetector = forMultiEntityDetector;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.profilesToBeRetrieved.size());
        for (DetectorProfileName profile : this.profilesToBeRetrieved) {
            out.writeEnum((Enum)profile);
        }
        out.writeString(this.detectorId);
        out.writeBoolean(this.forMultiEntityDetector);
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public Set<DetectorProfileName> getProfilesToBeRetrieved() {
        return this.profilesToBeRetrieved;
    }

    public boolean isForMultiEntityDetector() {
        return this.forMultiEntityDetector;
    }
}

