/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.common.model.dimension;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.util.IndexUtils;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.composite.HistogramValuesSourceBuilder;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0014\u0010\"\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010$\u001a\u00020\u0014H\u0016J\u0014\u0010%\u001a\u0006\u0012\u0002\b\u00030&2\u0006\u0010'\u001a\u00020\u0011H\u0016J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u00063"}, d2={"Lorg/opensearch/indexmanagement/common/model/dimension/Histogram;", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "sourceField", "", "targetField", "interval", "", "(Ljava/lang/String;Ljava/lang/String;D)V", "getInterval", "()D", "getSourceField", "()Ljava/lang/String;", "getTargetField", "canBeRealizedInMappings", "", "mappings", "", "", "component1", "component2", "component3", "copy", "equals", "other", "getRewrittenAggregation", "Lorg/opensearch/search/aggregations/bucket/histogram/HistogramAggregationBuilder;", "aggregationBuilder", "subAggregations", "Lorg/opensearch/search/aggregations/AggregatorFactories$Builder;", "hashCode", "", "toBucketQuery", "Lorg/opensearch/index/query/AbstractQueryBuilder;", "bucketKey", "toSourceBuilder", "Lorg/opensearch/search/aggregations/bucket/composite/CompositeValuesSourceBuilder;", "appendType", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nHistogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Histogram.kt\norg/opensearch/indexmanagement/common/model/dimension/Histogram\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,148:1\n1#2:149\n13579#3,2:150\n*S KotlinDebug\n*F\n+ 1 Histogram.kt\norg/opensearch/indexmanagement/common/model/dimension/Histogram\n*L\n79#1:150,2\n*E\n"})
public final class Histogram
extends Dimension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String sourceField;
    @NotNull
    private final String targetField;
    private final double interval;
    @NotNull
    public static final String HISTOGRAM_INTERVAL_FIELD = "interval";
    private static final double bucketError = 5.0E-5;

    public Histogram(@NotNull String sourceField, @NotNull String targetField, double interval) {
        Intrinsics.checkNotNullParameter((Object)sourceField, (String)"sourceField");
        Intrinsics.checkNotNullParameter((Object)targetField, (String)"targetField");
        super(Dimension.Type.HISTOGRAM, sourceField, targetField);
        this.sourceField = sourceField;
        this.targetField = targetField;
        this.interval = interval;
        if (!(((CharSequence)this.getSourceField()).length() > 0 && ((CharSequence)this.getTargetField()).length() > 0)) {
            boolean $i$a$-require-Histogram$32 = false;
            String $i$a$-require-Histogram$32 = "Source and target field must not be empty";
            throw new IllegalArgumentException($i$a$-require-Histogram$32.toString());
        }
        if (!(this.interval > 0.0)) {
            boolean bl = false;
            String string = "Interval must be a positive decimal";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public String getSourceField() {
        return this.sourceField;
    }

    @Override
    @NotNull
    public String getTargetField() {
        return this.targetField;
    }

    public final double getInterval() {
        return this.interval;
    }

    public Histogram(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        this(string, string2, sin.readDouble());
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject().startObject(this.getType().getType()).field("source_field", this.getSourceField()).field("target_field", this.getTargetField()).field(HISTOGRAM_INTERVAL_FIELD, this.interval).endObject().endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026ct()\n        .endObject()");
        return xContentBuilder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getSourceField());
        out.writeString(this.getTargetField());
        out.writeDouble(this.interval);
    }

    @Override
    @NotNull
    public CompositeValuesSourceBuilder<?> toSourceBuilder(boolean appendType) {
        String name = appendType ? this.getTargetField() + "." + Dimension.Type.HISTOGRAM.getType() : this.getTargetField();
        HistogramValuesSourceBuilder histogramValuesSourceBuilder = ((HistogramValuesSourceBuilder)((HistogramValuesSourceBuilder)new HistogramValuesSourceBuilder(name).missingBucket(true)).field(this.getSourceField())).interval(this.interval);
        Intrinsics.checkNotNullExpressionValue((Object)histogramValuesSourceBuilder, (String)"HistogramValuesSourceBui\u2026 .interval(this.interval)");
        return (CompositeValuesSourceBuilder)histogramValuesSourceBuilder;
    }

    @Override
    @NotNull
    public AbstractQueryBuilder<?> toBucketQuery(@NotNull Object bucketKey) {
        Intrinsics.checkNotNullParameter((Object)bucketKey, (String)"bucketKey");
        if (!(bucketKey instanceof Double)) {
            throw new IllegalArgumentException("Received invalid histogram bucket key type [" + Reflection.getOrCreateKotlinClass(bucketKey.getClass()) + "] when Double is expected.");
        }
        RangeQueryBuilder rangeQueryBuilder = new RangeQueryBuilder(this.getSourceField()).from((Object)(((Number)bucketKey).doubleValue() - 5.0E-5), true).to((Object)(((Number)bucketKey).doubleValue() + this.interval + 5.0E-5), true);
        Intrinsics.checkNotNullExpressionValue((Object)rangeQueryBuilder, (String)"RangeQueryBuilder(source\u2026panion.bucketError, true)");
        return (AbstractQueryBuilder)rangeQueryBuilder;
    }

    @Override
    public boolean canBeRealizedInMappings(@NotNull Map<String, ? extends Object> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        Map<?, ?> map = IndexUtils.Companion.getFieldFromMappings(this.getSourceField(), mappings);
        if (map == null || (map = map.get("type")) == null) {
            return false;
        }
        Map<?, ?> fieldType = map;
        Set numberTypes = new LinkedHashSet();
        NumberFieldMapper.NumberType[] $this$forEach$iv = NumberFieldMapper.NumberType.values();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            NumberFieldMapper.NumberType element$iv;
            NumberFieldMapper.NumberType it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String string = it.typeName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.typeName()");
            numberTypes.add(string);
        }
        return CollectionsKt.contains((Iterable)numberTypes, fieldType);
    }

    @NotNull
    public final HistogramAggregationBuilder getRewrittenAggregation(@NotNull HistogramAggregationBuilder aggregationBuilder, @NotNull AggregatorFactories.Builder subAggregations) {
        BucketOrder bucketOrder;
        HistogramAggregationBuilder histogramAggregationBuilder;
        Intrinsics.checkNotNullParameter((Object)aggregationBuilder, (String)"aggregationBuilder");
        Intrinsics.checkNotNullParameter((Object)subAggregations, (String)"subAggregations");
        HistogramAggregationBuilder it = histogramAggregationBuilder = new HistogramAggregationBuilder(aggregationBuilder.getName()).interval(aggregationBuilder.interval());
        boolean bl = false;
        double d = aggregationBuilder.minBound();
        if (!Double.isInfinite(d) && !Double.isNaN(d) && !Double.isInfinite(d = aggregationBuilder.maxBound()) && !Double.isNaN(d)) {
            it.extendedBounds(aggregationBuilder.minBound(), aggregationBuilder.maxBound());
        }
        it = histogramAggregationBuilder = histogramAggregationBuilder.keyed(aggregationBuilder.keyed());
        boolean bl2 = false;
        if (aggregationBuilder.minDocCount() >= 0L) {
            it.minDocCount(aggregationBuilder.minDocCount());
        }
        it = histogramAggregationBuilder = histogramAggregationBuilder.offset(aggregationBuilder.offset());
        boolean bl3 = false;
        BucketOrder bucketOrder2 = bucketOrder = aggregationBuilder.order();
        if (bucketOrder2 != null) {
            BucketOrder bucketOrder3;
            Intrinsics.checkNotNullExpressionValue((Object)bucketOrder2, (String)"order()");
            BucketOrder $this$getRewrittenAggregation_u24lambda_u246_u24lambda_u245 = bucketOrder3 = bucketOrder;
            boolean bl4 = false;
            it.order($this$getRewrittenAggregation_u24lambda_u246_u24lambda_u245);
        }
        AbstractAggregationBuilder abstractAggregationBuilder = ((HistogramAggregationBuilder)histogramAggregationBuilder.field(this.getTargetField() + ".histogram")).subAggregations(subAggregations);
        Intrinsics.checkNotNullExpressionValue((Object)abstractAggregationBuilder, (String)"HistogramAggregationBuil\u2026egations(subAggregations)");
        return (HistogramAggregationBuilder)abstractAggregationBuilder;
    }

    @NotNull
    public final String component1() {
        return this.sourceField;
    }

    @NotNull
    public final String component2() {
        return this.targetField;
    }

    public final double component3() {
        return this.interval;
    }

    @NotNull
    public final Histogram copy(@NotNull String sourceField, @NotNull String targetField, double interval) {
        Intrinsics.checkNotNullParameter((Object)sourceField, (String)"sourceField");
        Intrinsics.checkNotNullParameter((Object)targetField, (String)"targetField");
        return new Histogram(sourceField, targetField, interval);
    }

    public static /* synthetic */ Histogram copy$default(Histogram histogram, String string, String string2, double d, int n, Object object) {
        if ((n & 1) != 0) {
            string = histogram.sourceField;
        }
        if ((n & 2) != 0) {
            string2 = histogram.targetField;
        }
        if ((n & 4) != 0) {
            d = histogram.interval;
        }
        return histogram.copy(string, string2, d);
    }

    @NotNull
    public String toString() {
        return "Histogram(sourceField=" + this.sourceField + ", targetField=" + this.targetField + ", interval=" + this.interval + ")";
    }

    public int hashCode() {
        int result2 = this.sourceField.hashCode();
        result2 = result2 * 31 + this.targetField.hashCode();
        result2 = result2 * 31 + Double.hashCode(this.interval);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Histogram)) {
            return false;
        }
        Histogram histogram = (Histogram)other;
        if (!Intrinsics.areEqual((Object)this.sourceField, (Object)histogram.sourceField)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetField, (Object)histogram.targetField)) {
            return false;
        }
        return Double.compare(this.interval, histogram.interval) == 0;
    }

    @JvmStatic
    @NotNull
    public static final Histogram parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final Histogram readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/common/model/dimension/Histogram$Companion;", "", "()V", "HISTOGRAM_INTERVAL_FIELD", "", "bucketError", "", "parse", "Lorg/opensearch/indexmanagement/common/model/dimension/Histogram;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nHistogram.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Histogram.kt\norg/opensearch/indexmanagement/common/model/dimension/Histogram$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Histogram parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String sourceField = null;
            String targetField = null;
            Double interval = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block18: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block18;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 1658170326: {
                            if (string.equals("source_field")) {
                                n = 1;
                            }
                            break;
                        }
                        case -210221876: {
                            if (string.equals("target_field")) {
                                n = 2;
                            }
                            break;
                        }
                        case 570418373: {
                            if (string.equals(Histogram.HISTOGRAM_INTERVAL_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            sourceField = xcp.text();
                            continue block10;
                        }
                        case 2: {
                            targetField = xcp.text();
                            continue block10;
                        }
                        case 3: {
                            interval = xcp.doubleValue();
                            continue block10;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in histogram dimension.");
            }
            if (targetField == null) {
                targetField = sourceField;
            }
            String string = sourceField;
            if (string == null) {
                boolean $i$a$-requireNotNull-Histogram$Companion$parse$42 = false;
                String $i$a$-requireNotNull-Histogram$Companion$parse$42 = "Source field must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-Histogram$Companion$parse$42.toString());
            }
            String string2 = targetField;
            if (string2 == null) {
                String string3 = string;
                boolean $i$a$-requireNotNull-Histogram$Companion$parse$52 = false;
                String string4 = string3;
                String $i$a$-requireNotNull-Histogram$Companion$parse$52 = "Target field must not be null";
                throw new IllegalArgumentException($i$a$-requireNotNull-Histogram$Companion$parse$52.toString());
            }
            Double d = interval;
            if (d == null) {
                String string5 = string2;
                String string6 = string;
                boolean bl = false;
                String string7 = "Interval field must not be null";
                String string8 = string6;
                String string9 = string5;
                String string10 = string7;
                throw new IllegalArgumentException(string10.toString());
            }
            double d2 = ((Number)d).doubleValue();
            String string11 = string2;
            String string12 = string;
            return new Histogram(string12, string11, d2);
        }

        @JvmStatic
        @NotNull
        public final Histogram readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Histogram(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

