/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class NoopServingTranslatorFactory
implements TranslatorFactory {
    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return Collections.singleton(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) {
        if (!this.isSupported(input, output)) {
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        String batchifier = ArgumentsUtil.stringValue(arguments, "batchifier", "none");
        return new NoopServingTranslator(Batchifier.fromString(batchifier));
    }

    static final class NoopServingTranslator
    implements Translator<Input, Output> {
        private Batchifier batchifier;

        NoopServingTranslator(Batchifier batchifier) {
            this.batchifier = batchifier;
        }

        @Override
        public Batchifier getBatchifier() {
            return this.batchifier;
        }

        @Override
        public NDList processInput(TranslatorContext ctx, Input input) throws TranslateException {
            NDManager manager = ctx.getNDManager();
            try {
                ctx.setAttachment("properties", input.getProperties());
                return input.getDataAsNDList(manager);
            }
            catch (IllegalArgumentException e) {
                throw new TranslateException("Input is not a NDList data type", e);
            }
        }

        @Override
        public Output processOutput(TranslatorContext ctx, NDList list) {
            Map prop = (Map)ctx.getAttachment("properties");
            String contentType = (String)prop.get("Content-Type");
            String accept = (String)prop.get("Accept");
            Output output = new Output();
            if ("tensor/npz".equalsIgnoreCase(accept) || "tensor/npz".equalsIgnoreCase(contentType)) {
                output.add(list.encode(NDList.Encoding.NPZ));
                output.addProperty("Content-Type", "tensor/npz");
            } else if ("tensor/safetensors".equalsIgnoreCase(accept) || "tensor/safetensors".equalsIgnoreCase(contentType)) {
                output.add(list.encode(NDList.Encoding.SAFETENSORS));
                output.addProperty("Content-Type", "tensor/safetensors");
            } else {
                output.add(list.encode());
                output.addProperty("Content-Type", "tensor/ndlist");
            }
            return output;
        }
    }
}

