/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.Predicate;

public class CaseInsensitiveStringMatchPredicate
implements Predicate<CharSequence> {
    @Nonnull
    private final String target;

    public CaseInsensitiveStringMatchPredicate(@Nonnull String matchString) {
        this.target = Constraint.isNotNull(matchString, "Target string cannot be null");
    }

    @Override
    public boolean test(CharSequence input) {
        if (input == null) {
            return false;
        }
        return this.target.equalsIgnoreCase(input.toString());
    }
}

