// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const selectorParser = require('postcss-selector-parser');

/**
 * @param {import('stylelint').PostcssResult} result
 * @param {import('postcss').Rule} node
 * @param {(root: import('postcss-selector-parser').Root) => void} callback
 * @returns {string | undefined}
 */
function transformSelector(result, node, callback) {
	try {
		return selectorParser(callback).processSync(node, { updateSelector: true });
	} catch {
		result.warn('Cannot parse selector', { node, stylelintType: 'parseError' });

		return undefined;
	}
}

module.exports = transformSelector;
