/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.parser;

import java.nio.charset.StandardCharsets;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.SkipResult;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.res.StringManager;

public class Cookie {
    private static final Log log;
    private static final UserDataHelper invalidCookieVersionLog;
    private static final UserDataHelper invalidCookieLog;
    private static final StringManager sm;
    private static final boolean[] isCookieOctet;
    private static final boolean[] isText;
    private static final byte[] VERSION_BYTES;
    private static final byte[] PATH_BYTES;
    private static final byte[] DOMAIN_BYTES;
    private static final byte[] EMPTY_BYTES;
    private static final byte TAB_BYTE = 9;
    private static final byte SPACE_BYTE = 32;
    private static final byte QUOTE_BYTE = 34;
    private static final byte COMMA_BYTE = 44;
    private static final byte FORWARDSLASH_BYTE = 47;
    private static final byte SEMICOLON_BYTE = 59;
    private static final byte EQUALS_BYTE = 61;
    private static final byte SLASH_BYTE = 92;
    private static final byte DEL_BYTE = 127;

    private Cookie() {
    }

    public static void parseCookie(byte[] byArray, int n, int n2, ServerCookies serverCookies) {
        ByteBuffer byteBuffer = new ByteBuffer(byArray, n, n2);
        Cookie.skipLWS(byteBuffer);
        int n3 = byteBuffer.position();
        SkipResult skipResult = Cookie.skipBytes(byteBuffer, VERSION_BYTES);
        if (skipResult != SkipResult.FOUND) {
            Cookie.parseCookieRfc6265(byteBuffer, serverCookies);
            return;
        }
        Cookie.skipLWS(byteBuffer);
        skipResult = Cookie.skipByte(byteBuffer, (byte)61);
        if (skipResult != SkipResult.FOUND) {
            byteBuffer.position(n3);
            Cookie.parseCookieRfc6265(byteBuffer, serverCookies);
            return;
        }
        Cookie.skipLWS(byteBuffer);
        ByteBuffer byteBuffer2 = Cookie.readCookieValue(byteBuffer);
        if (byteBuffer2 != null && byteBuffer2.remaining() == 1) {
            int n4 = byteBuffer2.get() - 48;
            if (n4 == 1 || n4 == 0) {
                Cookie.skipLWS(byteBuffer);
                byte by = byteBuffer.get();
                if (by == 59 || by == 44) {
                    Cookie.parseCookieRfc2109(byteBuffer, serverCookies, n4);
                }
            } else {
                byteBuffer2.rewind();
                Cookie.logInvalidVersion(byteBuffer2);
            }
        } else {
            Cookie.logInvalidVersion(byteBuffer2);
        }
    }

    public static String unescapeCookieValueRfc2109(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        if (string.charAt(0) != '\"' && string.charAt(string.length() - 1) != '\"') {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 1; i < string.length() - 1; ++i) {
            if (cArray[i] == '\\') {
                bl = true;
                continue;
            }
            if (bl) {
                bl = false;
                if (cArray[i] < '\u0080') {
                    stringBuilder.append(cArray[i]);
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(cArray[i]);
                continue;
            }
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    private static void parseCookieRfc6265(ByteBuffer byteBuffer, ServerCookies serverCookies) {
        boolean bl = true;
        while (bl) {
            Cookie.skipLWS(byteBuffer);
            int n = byteBuffer.position();
            ByteBuffer byteBuffer2 = Cookie.readToken(byteBuffer);
            ByteBuffer byteBuffer3 = null;
            Cookie.skipLWS(byteBuffer);
            SkipResult skipResult = Cookie.skipByte(byteBuffer, (byte)61);
            if (skipResult == SkipResult.FOUND) {
                Cookie.skipLWS(byteBuffer);
                byteBuffer3 = Cookie.readCookieValueRfc6265(byteBuffer);
                if (byteBuffer3 == null) {
                    Cookie.skipUntilSemiColon(byteBuffer);
                    Cookie.logInvalidHeader(n, byteBuffer);
                    continue;
                }
                Cookie.skipLWS(byteBuffer);
            }
            if ((skipResult = Cookie.skipByte(byteBuffer, (byte)59)) != SkipResult.FOUND) {
                if (skipResult == SkipResult.NOT_FOUND) {
                    Cookie.skipUntilSemiColon(byteBuffer);
                    Cookie.logInvalidHeader(n, byteBuffer);
                    continue;
                }
                bl = false;
            }
            if (!byteBuffer2.hasRemaining()) continue;
            ServerCookie serverCookie = serverCookies.addCookie();
            serverCookie.getName().setBytes(byteBuffer2.array(), byteBuffer2.position(), byteBuffer2.remaining());
            if (byteBuffer3 == null) {
                serverCookie.getValue().setBytes(EMPTY_BYTES, 0, EMPTY_BYTES.length);
                continue;
            }
            serverCookie.getValue().setBytes(byteBuffer3.array(), byteBuffer3.position(), byteBuffer3.remaining());
        }
    }

    private static void parseCookieRfc2109(ByteBuffer byteBuffer, ServerCookies serverCookies, int n) {
        boolean bl = true;
        while (bl) {
            Cookie.skipLWS(byteBuffer);
            boolean bl2 = true;
            int n2 = byteBuffer.position();
            ByteBuffer byteBuffer2 = Cookie.readToken(byteBuffer);
            ByteBuffer byteBuffer3 = null;
            ByteBuffer byteBuffer4 = null;
            ByteBuffer byteBuffer5 = null;
            Cookie.skipLWS(byteBuffer);
            SkipResult skipResult = Cookie.skipByte(byteBuffer, (byte)61);
            if (skipResult == SkipResult.FOUND) {
                Cookie.skipLWS(byteBuffer);
                byteBuffer3 = Cookie.readCookieValueRfc2109(byteBuffer, false);
                if (byteBuffer3 == null) {
                    Cookie.skipInvalidCookie(n2, byteBuffer);
                    continue;
                }
                Cookie.skipLWS(byteBuffer);
            }
            if ((skipResult = Cookie.skipByte(byteBuffer, (byte)44)) == SkipResult.FOUND) {
                bl2 = false;
            } else {
                skipResult = Cookie.skipByte(byteBuffer, (byte)59);
            }
            if (skipResult == SkipResult.EOF) {
                bl2 = false;
                bl = false;
            } else if (skipResult == SkipResult.NOT_FOUND) {
                Cookie.skipInvalidCookie(n2, byteBuffer);
                continue;
            }
            if (bl2) {
                Cookie.skipLWS(byteBuffer);
                skipResult = Cookie.skipBytes(byteBuffer, PATH_BYTES);
                if (skipResult == SkipResult.FOUND) {
                    Cookie.skipLWS(byteBuffer);
                    skipResult = Cookie.skipByte(byteBuffer, (byte)61);
                    if (skipResult != SkipResult.FOUND) {
                        Cookie.skipInvalidCookie(n2, byteBuffer);
                        continue;
                    }
                    Cookie.skipLWS(byteBuffer);
                    byteBuffer4 = Cookie.readCookieValueRfc2109(byteBuffer, true);
                    if (byteBuffer4 == null) {
                        Cookie.skipInvalidCookie(n2, byteBuffer);
                        continue;
                    }
                    Cookie.skipLWS(byteBuffer);
                    skipResult = Cookie.skipByte(byteBuffer, (byte)44);
                    if (skipResult == SkipResult.FOUND) {
                        bl2 = false;
                    } else {
                        skipResult = Cookie.skipByte(byteBuffer, (byte)59);
                    }
                    if (skipResult == SkipResult.EOF) {
                        bl2 = false;
                        bl = false;
                    } else if (skipResult == SkipResult.NOT_FOUND) {
                        Cookie.skipInvalidCookie(n2, byteBuffer);
                        continue;
                    }
                }
            }
            if (bl2) {
                Cookie.skipLWS(byteBuffer);
                skipResult = Cookie.skipBytes(byteBuffer, DOMAIN_BYTES);
                if (skipResult == SkipResult.FOUND) {
                    Cookie.skipLWS(byteBuffer);
                    skipResult = Cookie.skipByte(byteBuffer, (byte)61);
                    if (skipResult != SkipResult.FOUND) {
                        Cookie.skipInvalidCookie(n2, byteBuffer);
                        continue;
                    }
                    Cookie.skipLWS(byteBuffer);
                    byteBuffer5 = Cookie.readCookieValueRfc2109(byteBuffer, false);
                    if (byteBuffer5 == null) {
                        Cookie.skipInvalidCookie(n2, byteBuffer);
                        continue;
                    }
                    Cookie.skipLWS(byteBuffer);
                    skipResult = Cookie.skipByte(byteBuffer, (byte)44);
                    if (skipResult == SkipResult.FOUND) {
                        bl2 = false;
                    } else {
                        skipResult = Cookie.skipByte(byteBuffer, (byte)59);
                    }
                    if (skipResult == SkipResult.EOF) {
                        bl2 = false;
                        bl = false;
                    } else if (skipResult == SkipResult.NOT_FOUND) {
                        Cookie.skipInvalidCookie(n2, byteBuffer);
                        continue;
                    }
                }
            }
            if (!byteBuffer2.hasRemaining() || byteBuffer3 == null || !byteBuffer3.hasRemaining()) continue;
            ServerCookie serverCookie = serverCookies.addCookie();
            serverCookie.setVersion(n);
            serverCookie.getName().setBytes(byteBuffer2.array(), byteBuffer2.position(), byteBuffer2.remaining());
            serverCookie.getValue().setBytes(byteBuffer3.array(), byteBuffer3.position(), byteBuffer3.remaining());
            if (byteBuffer5 != null) {
                serverCookie.getDomain().setBytes(byteBuffer5.array(), byteBuffer5.position(), byteBuffer5.remaining());
            }
            if (byteBuffer4 == null) continue;
            serverCookie.getPath().setBytes(byteBuffer4.array(), byteBuffer4.position(), byteBuffer4.remaining());
        }
    }

    private static void skipInvalidCookie(int n, ByteBuffer byteBuffer) {
        Cookie.skipUntilSemiColonOrComma(byteBuffer);
        Cookie.logInvalidHeader(n, byteBuffer);
    }

    private static void skipLWS(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (by == 9 || by == 32) continue;
            byteBuffer.rewind();
            break;
        }
    }

    private static void skipUntilSemiColon(ByteBuffer byteBuffer) {
        while (byteBuffer.hasRemaining() && byteBuffer.get() != 59) {
        }
    }

    private static void skipUntilSemiColonOrComma(ByteBuffer byteBuffer) {
        byte by;
        while (byteBuffer.hasRemaining() && (by = byteBuffer.get()) != 59 && by != 44) {
        }
    }

    private static SkipResult skipByte(ByteBuffer byteBuffer, byte by) {
        if (!byteBuffer.hasRemaining()) {
            return SkipResult.EOF;
        }
        if (byteBuffer.get() == by) {
            return SkipResult.FOUND;
        }
        byteBuffer.rewind();
        return SkipResult.NOT_FOUND;
    }

    private static SkipResult skipBytes(ByteBuffer byteBuffer, byte[] byArray) {
        int n = byteBuffer.position();
        for (byte by : byArray) {
            if (!byteBuffer.hasRemaining()) {
                byteBuffer.position(n);
                return SkipResult.EOF;
            }
            if (byteBuffer.get() == by) continue;
            byteBuffer.position(n);
            return SkipResult.NOT_FOUND;
        }
        return SkipResult.FOUND;
    }

    private static ByteBuffer readCookieValue(ByteBuffer byteBuffer) {
        boolean bl = false;
        if (byteBuffer.hasRemaining()) {
            if (byteBuffer.get() == 34) {
                bl = true;
            } else {
                byteBuffer.rewind();
            }
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (isCookieOctet[by & 0xFF]) continue;
            if (by == 59 || by == 44 || by == 32 || by == 9) {
                n2 = byteBuffer.position() - 1;
                byteBuffer.position(n2);
                break;
            }
            if (bl && by == 34) {
                n2 = byteBuffer.position() - 1;
                break;
            }
            return null;
        }
        return new ByteBuffer(byteBuffer.bytes, n, n2 - n);
    }

    private static ByteBuffer readCookieValueRfc6265(ByteBuffer byteBuffer) {
        boolean bl = false;
        if (byteBuffer.hasRemaining()) {
            if (byteBuffer.get() == 34) {
                bl = true;
            } else {
                byteBuffer.rewind();
            }
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (isCookieOctet[by & 0xFF]) continue;
            if (by == 59 || by == 32 || by == 9) {
                n2 = byteBuffer.position() - 1;
                byteBuffer.position(n2);
                break;
            }
            if (bl && by == 34) {
                n2 = byteBuffer.position() - 1;
                break;
            }
            return null;
        }
        return new ByteBuffer(byteBuffer.bytes, n, n2 - n);
    }

    private static ByteBuffer readCookieValueRfc2109(ByteBuffer byteBuffer, boolean bl) {
        if (!byteBuffer.hasRemaining()) {
            return null;
        }
        if (byteBuffer.peek() == 34) {
            return Cookie.readQuotedString(byteBuffer);
        }
        if (bl) {
            return Cookie.readTokenAllowForwardSlash(byteBuffer);
        }
        return Cookie.readToken(byteBuffer);
    }

    private static ByteBuffer readToken(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            if (HttpParser.isToken(byteBuffer.get())) continue;
            n2 = byteBuffer.position() - 1;
            byteBuffer.position(n2);
            break;
        }
        return new ByteBuffer(byteBuffer.bytes, n, n2 - n);
    }

    private static ByteBuffer readTokenAllowForwardSlash(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (by == 47 || HttpParser.isToken(by)) continue;
            n2 = byteBuffer.position() - 1;
            byteBuffer.position(n2);
            break;
        }
        return new ByteBuffer(byteBuffer.bytes, n, n2 - n);
    }

    private static ByteBuffer readQuotedString(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.get();
        boolean bl = false;
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (by == 92) {
                bl = true;
                continue;
            }
            if (bl && by > -1) {
                bl = false;
                continue;
            }
            if (by == 34) {
                return new ByteBuffer(byteBuffer.bytes, n, byteBuffer.position() - n);
            }
            if (isText[by & 0xFF]) {
                bl = false;
                continue;
            }
            return null;
        }
        return null;
    }

    private static void logInvalidHeader(int n, ByteBuffer byteBuffer) {
        UserDataHelper.Mode mode = invalidCookieLog.getNextMode();
        if (mode != null) {
            String string = new String(byteBuffer.array(), n, byteBuffer.position() - n, StandardCharsets.UTF_8);
            String string2 = sm.getString("cookie.invalidCookieValue", new Object[]{string});
            switch (mode) {
                case INFO_THEN_DEBUG: {
                    string2 = string2 + sm.getString("cookie.fallToDebug");
                }
                case INFO: {
                    log.info((Object)string2);
                    break;
                }
                case DEBUG: {
                    log.debug((Object)string2);
                }
            }
        }
    }

    private static void logInvalidVersion(ByteBuffer byteBuffer) {
        UserDataHelper.Mode mode = invalidCookieVersionLog.getNextMode();
        if (mode != null) {
            String string = byteBuffer == null ? sm.getString("cookie.valueNotPresent") : new String(byteBuffer.bytes, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position(), StandardCharsets.UTF_8);
            String string2 = sm.getString("cookie.invalidCookieVersion", new Object[]{string});
            switch (mode) {
                case INFO_THEN_DEBUG: {
                    string2 = string2 + sm.getString("cookie.fallToDebug");
                }
                case INFO: {
                    log.info((Object)string2);
                    break;
                }
                case DEBUG: {
                    log.debug((Object)string2);
                }
            }
        }
    }

    static {
        int n;
        log = LogFactory.getLog(Cookie.class);
        invalidCookieVersionLog = new UserDataHelper(log);
        invalidCookieLog = new UserDataHelper(log);
        sm = StringManager.getManager((String)"org.apache.tomcat.util.http.parser");
        isCookieOctet = new boolean[256];
        isText = new boolean[256];
        VERSION_BYTES = "$Version".getBytes(StandardCharsets.ISO_8859_1);
        PATH_BYTES = "$Path".getBytes(StandardCharsets.ISO_8859_1);
        DOMAIN_BYTES = "$Domain".getBytes(StandardCharsets.ISO_8859_1);
        EMPTY_BYTES = new byte[0];
        for (n = 0; n < 256; ++n) {
            Cookie.isCookieOctet[n] = n >= 33 && n != 34 && n != 44 && n != 59 && n != 92 && n != 127;
        }
        for (n = 0; n < 256; ++n) {
            Cookie.isText[n] = n >= 9 && (n <= 9 || n >= 32) && n != 127;
        }
    }

    private static class ByteBuffer {
        private final byte[] bytes;
        private int limit;
        private int position = 0;

        ByteBuffer(byte[] byArray, int n, int n2) {
            this.bytes = byArray;
            this.position = n;
            this.limit = n + n2;
        }

        public int position() {
            return this.position;
        }

        public void position(int n) {
            this.position = n;
        }

        public int limit() {
            return this.limit;
        }

        public int remaining() {
            return this.limit - this.position;
        }

        public boolean hasRemaining() {
            return this.position < this.limit;
        }

        public byte get() {
            return this.bytes[this.position++];
        }

        public byte peek() {
            return this.bytes[this.position];
        }

        public void rewind() {
            --this.position;
        }

        public byte[] array() {
            return this.bytes;
        }

        public String toString() {
            return "position [" + this.position + "], limit [" + this.limit + "]";
        }
    }
}

